/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.conversion.ConversionTime;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.ProgressBarIndetermine;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class DialogLog
extends JDialog {
    private JPanel jContentPane = null;
    private Vector<String> list = null;
    private JList listeLog = null;
    private JPanel pnlBtn = null;
    private JButton btnQuit = null;
    private JButton btnSave = null;
    private JScrollPane jspList = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogLog.dispose()#");
        super.dispose();
    }

    public DialogLog(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogLog()#");
        this.initialize();
        this.setVisible(true);
    }

    public Vector getList() {
        if (this.list == null) {
            this.list = TimsLogger.getList();
        }
        return this.list;
    }

    private void initialize() {
        this.setTitle(LanguageTranslator.getString("generics.log"));
        this.setSize(200, 250);
        this.setLocationRelativeTo(this.getParent());
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            ((BorderLayout)this.jContentPane.getLayout()).setVgap(5);
            ((BorderLayout)this.jContentPane.getLayout()).setHgap(5);
            this.jContentPane.add((Component)this.getPnlBtn(), "South");
            this.jContentPane.add((Component)this.getJspList(), "Center");
        }
        return this.jContentPane;
    }

    private JList getListeLog() {
        if (this.listeLog == null) {
            this.listeLog = new JList(this.getList());
        }
        return this.listeLog;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.add((Component)this.getBtnQuit(), null);
            this.pnlBtn.add((Component)this.getBtnSave(), null);
        }
        return this.pnlBtn;
    }

    private JButton getBtnQuit() {
        if (this.btnQuit == null) {
            this.btnQuit = new JButton(LanguageTranslator.getString("button.quit"));
            this.btnQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogLog.this.dispose();
                }
            });
        }
        return this.btnQuit;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton(LanguageTranslator.getString("button.save"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                GetFile tmp = new GetFile();
                                SwingUtilities.invokeAndWait(tmp);
                                if (tmp.getCheminSave() != null) {
                                    ProgressBarIndetermine progres = new ProgressBarIndetermine((Frame)MainFrameTransport.getInstance(), LanguageTranslator.getString("download.copy"));
                                    progres.setVisible(true);
                                    String cheminSave = tmp.getCheminSave();
                                    DialogLog.this.saveFichier(String.valueOf(cheminSave) + "/");
                                    progres.dispose();
                                    JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("download.export.succeed"), LanguageTranslator.getString("message.done"), 1);
                                }
                            }
                            catch (InvocationTargetException ex) {
                                ex.printStackTrace();
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }.start();
                }
            });
        }
        return this.btnSave;
    }

    private JScrollPane getJspList() {
        if (this.jspList == null) {
            this.jspList = new JScrollPane();
            this.jspList.setViewportView(this.getListeLog());
        }
        return this.jspList;
    }

    private void saveFichier(String repertoireSauvegarde) {
        int[] ai = this.getListeLog().getSelectedIndices();
        int i = 0;
        int j = ai.length;
        while (i < j) {
            int x = ai[i];
            try {
                String fileName = "tims" + ConversionTime.dateStringToFormat(this.getListeLog().getModel().getElementAt(x).toString(), "dd/MM/yyyy HH'h'mm", "yyyyMMddHHmm") + ".log";
                Fonctions.copy(String.valueOf(Transport.savePath) + fileName, String.valueOf(repertoireSauvegarde) + fileName);
                this.getListeLog().getModel().getElementAt(x);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++i;
        }
    }

    class GetFile
    implements Runnable {
        private String cheminSave = null;

        GetFile() {
        }

        @Override
        public void run() {
            JFileChooser choix = new JFileChooser();
            choix.setApproveButtonText("Sauvegarder les fichiers dans");
            choix.setFileSelectionMode(1);
            if (choix.showSaveDialog(MainFrameTransport.getInstance()) == 0) {
                this.cheminSave = choix.getSelectedFile().getAbsolutePath();
            }
        }

        public String getCheminSave() {
            return this.cheminSave;
        }
    }
}

