/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.ClosePayPeriod;
import fr.pgh.data.bdd.PayPeriod;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import transpo.system.TimsLogger;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.modele.TMPayPeriod;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transpo.system.util.ExcelReading;
import transpo.system.util.Fonctions;

public class DialogPayPeriod
extends JDialog {
    private JPanel jContentPane = null;
    private JScrollPane jspTable = null;
    private JTable tblPayPeriod = null;
    private JPanel pnlBtn = null;
    private JButton btnQuit = null;
    private JButton btnImport = null;
    private JButton btnAdd = null;
    private ProgressBar pg = null;

    public DialogPayPeriod(JFrame pere) {
        super(pere);
        this.initialize();
    }

    private void initialize() {
        this.setSize(300, 400);
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(LanguageTranslator.getString("pay.period.title"));
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJspTable(), "Center");
            this.jContentPane.add((Component)this.getPnlBtn(), "South");
        }
        return this.jContentPane;
    }

    private JScrollPane getJspTable() {
        if (this.jspTable == null) {
            this.jspTable = new JScrollPane();
            this.jspTable.setViewportView(this.getTblPayPeriod());
        }
        return this.jspTable;
    }

    private JTable getTblPayPeriod() {
        if (this.tblPayPeriod == null) {
            this.tblPayPeriod = new JTable();
            this.loadTbl();
        }
        return this.tblPayPeriod;
    }

    private void loadTbl() {
        this.tblPayPeriod.setModel(new TMPayPeriod(PayPeriod.loadList(null)));
        this.tblPayPeriod.setRowHeight(22);
        Fonctions.centrerTable(this.tblPayPeriod);
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.add((Component)this.getBtnQuit(), null);
            if (ConnexionSettings.getInstance().isAjoutable("PAY_PERIOD")) {
                this.pnlBtn.add((Component)this.getBtnImport(), null);
            }
            if (ConnexionSettings.getInstance().isAjoutable("PAY_PERIOD")) {
                this.pnlBtn.add((Component)this.getBtnAdd(), null);
            }
        }
        return this.pnlBtn;
    }

    private JButton getBtnQuit() {
        if (this.btnQuit == null) {
            this.btnQuit = new JButton();
            this.btnQuit.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogPayPeriod.this.dispose();
                }
            });
        }
        return this.btnQuit;
    }

    private JButton getBtnAdd() {
        if (this.btnAdd == null) {
            this.btnAdd = new JButton();
            this.btnAdd.setText(LanguageTranslator.getString("button.add"));
            this.btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogPayPeriod.this.addLine();
                }
            });
        }
        return this.btnAdd;
    }

    private void addLine() {
        Vector<PayPeriod> existing = ((TMPayPeriod)this.getTblPayPeriod().getModel()).getData();
        PayPeriod last = null;
        if (existing.size() != 0) {
            last = existing.get(existing.size() - 1);
        }
        if (last == null) {
            Date begin = (Date)ConversionTime.getFirstDayOfMonth(new Date(), ConversionTime.DATE);
            Date end = (Date)ConversionTime.getLastDayOfMonth(new Date(), ConversionTime.DATE);
            String name = ConversionTime.dateToString(new Date(), "yyyyMM");
            PayPeriod toAdd = new PayPeriod(0, name, begin, end);
            toAdd.insert();
        } else {
            Date begin = ConversionTime.add(last.getEnd(), 5, 1);
            Date end = (Date)ConversionTime.getLastDayOfMonth(begin, ConversionTime.DATE);
            String name = ConversionTime.dateToString(end, "yyyyMM");
            PayPeriod toAdd = new PayPeriod(0, name, begin, end);
            toAdd.insert();
        }
        this.loadTbl();
    }

    private JButton getBtnImport() {
        if (this.btnImport == null) {
            this.btnImport = new JButton();
            this.btnImport.setText(LanguageTranslator.getString("button.import"));
            this.btnImport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Thread(){

                        @Override
                        public void run() {
                            DialogPayPeriod.this.getData();
                            DialogPayPeriod.this.getTblPayPeriod().setModel(new TMPayPeriod(PayPeriod.loadList(null)));
                        }
                    }.start();
                }
            });
        }
        return this.btnImport;
    }

    private void getData() {
        try {
            GetFile tmp = new GetFile();
            SwingUtilities.invokeAndWait(tmp);
            if (tmp.getPath() != null) {
                if (this.insertPayPeriod(tmp.getPath())) {
                    JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.done"));
                } else {
                    JOptionPane.showMessageDialog(this, LanguageTranslator.getString("payPeriod.importError"), LanguageTranslator.getString("generics.error"), 0);
                }
            }
        }
        catch (Exception ex) {
            TimsLogger.warn("#DialogPayPeriod.getData()# Erreur swingutilities");
            ex.printStackTrace();
        }
    }

    private boolean insertPayPeriod(File toInsert) {
        boolean toReturn = true;
        this.getPg().getBar().setString(LanguageTranslator.getString("generic.fileReading"));
        Vector<PayPeriod> existing = ((TMPayPeriod)this.getTblPayPeriod().getModel()).getData();
        Vector<String[]> toProcess = this.getDataFromFile(toInsert);
        Vector<Agence> agencies = null;
        this.getPg().getBar().setMinimum(0);
        this.getPg().getBar().setMaximum(toProcess.size());
        try {
            for (String[] line : toProcess) {
                TimsLogger.debug("#DPayPeriod.insertPayPeriod# line to insert : " + line[0] + "," + line[1] + "," + line[2] + "," + line[3]);
                this.getPg().getBar().setValue(this.getPg().getBar().getValue() + 1);
                this.getPg().getBar().setString(LanguageTranslator.getString("payPeriod.addPeriod", line[0]));
                if (line[0].equals("") || line[1].equals("") || line[2].equals("") || line[3].equals("")) {
                    TimsLogger.debug("#DPayPeriod.insertPayPeriod# pas d'informations, on saute...");
                    continue;
                }
                PayPeriod toAdd = new PayPeriod(0, line[0], ConversionTime.stringToDate(line[1].substring(0, 10), "dd MM yyyy"), ConversionTime.stringToDate(line[2].substring(0, 10), "dd MM yyyy"));
                if (!existing.contains(toAdd)) {
                    toAdd.insert();
                    if (!line[3].equals("1")) continue;
                    this.getPg().getBar().setString(LanguageTranslator.getString("payPeriod.closePeriod", line[0]));
                    if (agencies == null) {
                        agencies = Agence.getList();
                    }
                    for (Agence agency : agencies) {
                        ClosePayPeriod toClose = new ClosePayPeriod(0, toAdd.getId(), agency.getCleAgence(), ConnexionSettings.getInstance().getUserCle(), 1, 1, new Date(), 1);
                        toClose.insert();
                    }
                    continue;
                }
                TimsLogger.debug("P\u00e9riode " + toAdd.getName() + " d\u00e9j\u00e0 existante");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            toReturn = false;
        }
        PayPeriod.setList(null);
        this.getPg().dispose();
        return toReturn;
    }

    private Vector<String[]> getDataFromFile(File toInsert) {
        return ExcelReading.convertXlsToArray(toInsert, true);
    }

    private ProgressBar getPg() {
        if (this.pg == null) {
            this.pg = new ProgressBar(MainFrameTransport.getInstance(), LanguageTranslator.getString("payPeriod.import"));
            this.pg.setVisible(true);
        }
        return this.pg;
    }

    class GetFile
    implements Runnable {
        private File path = null;

        GetFile() {
        }

        @Override
        public void run() {
            JFileChooser choix = new JFileChooser();
            choix.setFileSelectionMode(0);
            choix.setMultiSelectionEnabled(false);
            choix.setDialogTitle(LanguageTranslator.getString("message.selectFile"));
            choix.setApproveButtonText(LanguageTranslator.getString("button.valid"));
            if (choix.showOpenDialog(MainFrameTransport.getInstance()) == 0) {
                this.path = choix.getSelectedFile();
            }
        }

        public File getPath() {
            return this.path;
        }
    }
}

