/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class DialogPopupMessage
extends JDialog {
    private String message = null;
    private JPanel pnlBtn = null;
    private JButton btnQuit = null;
    private JButton btnUnderstood = null;
    private boolean validated = false;
    private JEditorPane text = null;

    public DialogPopupMessage() {
        this.setModal(true);
        this.setSize(800, 600);
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(LanguageTranslator.getString("new.popupMessage"));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getPnlMsg(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 18, new Insets(5, 5, 5, 5)));
        this.add((Component)this.getPnlBtn(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 2, 18, new Insets(5, 5, 5, 5)));
    }

    private JComponent getPnlMsg() {
        JScrollPane content = new JScrollPane();
        content.setViewportView(this.getText());
        return content;
    }

    private JEditorPane getText() {
        if (this.text == null) {
            this.text = new JEditorPane();
            this.text.setContentType("text/html");
            this.text.setBackground(Color.white);
            this.text.setEditable(false);
            this.text.setText(this.message);
        }
        return this.text;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.add(this.getBtnQuit());
            this.pnlBtn.add(this.getBtnUnderstood());
        }
        return this.pnlBtn;
    }

    private JButton getBtnQuit() {
        if (this.btnQuit == null) {
            this.btnQuit = new JButton(LanguageTranslator.getString("button.quit"));
            this.btnQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogPopupMessage.this.dispose();
                }
            });
        }
        return this.btnQuit;
    }

    private JButton getBtnUnderstood() {
        if (this.btnUnderstood == null) {
            this.btnUnderstood = new JButton(LanguageTranslator.getString("button.understood"));
            this.btnUnderstood.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogPopupMessage.this.validated = true;
                    DialogPopupMessage.this.dispose();
                }
            });
        }
        return this.btnUnderstood;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void setMessage(String msg) {
        this.message = msg;
        this.getText().setText(this.message);
    }
}

