/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import com.hexidec.ekit.EkitCore;
import fr.pgh.data.bdd.UserMessage;
import fr.pgh.data.bdd.UserMessageActivation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.ui.modele.LMMessage;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class DialogPopupMessageCreation
extends JDialog {
    private String message = null;
    private JPanel pnlBtn = null;
    private JPanel pnlParameters = null;
    private JScrollPane jspList = null;
    private JList list = null;
    private JTextField txtName = null;
    private JButton btnQuit = null;
    private JButton btnSave = null;
    private JButton btnNew = null;
    private JButton btnTo = null;
    private JPanel htmlEditor = null;
    private EkitCore text = null;
    private UserMessage currentMessage = null;

    public DialogPopupMessageCreation() {
        this.setModal(true);
        this.setSize(800, 600);
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(LanguageTranslator.getString("new.popupMessageCreation"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.getJspList(), Fonctions.getGridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 1, 18, new Insets(5, 5, 5, 5)));
        this.getContentPane().add((Component)this.getPnlParamters(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 2, 18, new Insets(5, 5, 5, 5)));
        this.getContentPane().add((Component)this.getHtmlEditor(), Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 1, 18, new Insets(5, 5, 5, 5)));
        this.getContentPane().add((Component)this.getPnlBtn(), Fonctions.getGridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 2, 18, new Insets(5, 5, 5, 5)));
    }

    private JScrollPane getJspList() {
        if (this.jspList == null) {
            this.jspList = new JScrollPane();
            this.jspList.setViewportView(this.getList());
        }
        return this.jspList;
    }

    private JList getList() {
        if (this.list == null) {
            this.list = new JList();
            this.list.setModel(new LMMessage(UserMessage.loadList()));
            this.list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && DialogPopupMessageCreation.this.getList().getSelectedIndex() != -1) {
                        LMMessage tmp = (LMMessage)DialogPopupMessageCreation.this.getList().getModel();
                        DialogPopupMessageCreation.this.load(tmp.getMessageAt(DialogPopupMessageCreation.this.getList().getSelectedIndex()));
                    }
                }
            });
        }
        return this.list;
    }

    protected void load(UserMessage message) {
        this.currentMessage = message;
        this.getText().setDocumentText(message.getMessage());
        this.getTxtName().setText(this.currentMessage.getName());
        UserMessageActivation.loadList(this.currentMessage.getId());
    }

    private JPanel getPnlParamters() {
        if (this.pnlParameters == null) {
            this.pnlParameters = new JPanel();
            this.pnlParameters.setLayout(new GridBagLayout());
            this.pnlParameters.add((Component)new JLabel(LanguageTranslator.getString("generics.name")), Fonctions.getGridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 0, 18, new Insets(5, 5, 5, 5)));
            this.pnlParameters.add((Component)this.getTxtName(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 2, 18, new Insets(5, 5, 5, 5)));
        }
        return this.pnlParameters;
    }

    private JTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new JTextField();
        }
        return this.txtName;
    }

    private JPanel getHtmlEditor() {
        if (this.htmlEditor == null) {
            this.htmlEditor = new JPanel();
            this.htmlEditor.setLayout(new GridBagLayout());
            this.htmlEditor.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.content"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.htmlEditor.add((Component)this.getText().getToolBarMain(true), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 2, 18, new Insets(5, 5, 5, 5)));
            this.htmlEditor.add((Component)this.getText().getToolBarFormat(true), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 2, 18, new Insets(5, 5, 5, 5)));
            this.htmlEditor.add((Component)this.getText().getToolBarStyles(true), Fonctions.getGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 2, 18, new Insets(5, 5, 5, 5)));
            this.htmlEditor.add((Component)this.getText(), Fonctions.getGridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 1, 18, new Insets(5, 5, 5, 5)));
        }
        return this.htmlEditor;
    }

    private EkitCore getText() {
        if (this.text == null) {
            this.text = new EkitCore(false, null, null, null, null, null, true, false, true, true, null, null, false, false, false, true, "NW|NS|OP|SV|PR|SP|CT|CP|PS|SP|UN|RE|SP|FN|SP|UC|UM|SP|SR|*|BL|IT|UD|SP|SK|SU|SB|SP|AL|AC|AR|AJ|SP|UL|OL|SP|LK|*|ST|SP|FO", false);
        }
        return this.text;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.add(this.getBtnNew());
            this.pnlBtn.add(this.getBtnQuit());
            this.pnlBtn.add(this.getBtnAut());
            this.pnlBtn.add(this.getBtnSave());
        }
        return this.pnlBtn;
    }

    private JButton getBtnQuit() {
        if (this.btnQuit == null) {
            this.btnQuit = new JButton(LanguageTranslator.getString("button.quit"));
            this.btnQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogPopupMessageCreation.this.dispose();
                }
            });
        }
        return this.btnQuit;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton(LanguageTranslator.getString("button.save"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogPopupMessageCreation.this.save();
                }
            });
        }
        return this.btnSave;
    }

    public void save() {
        if (this.currentMessage == null) {
            this.currentMessage = new UserMessage();
        }
        if (!this.currentMessage.compareAndUpdate(this.getTxtName().getText(), this.getText().getDocumentBody()) || !UserMessageActivation.addActivation(this.currentMessage)) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("generics.saveError"), LanguageTranslator.getString("generics.error"), 0);
        } else {
            this.getList().setModel(new LMMessage(UserMessage.loadList()));
        }
    }

    private JButton getBtnAut() {
        if (this.btnTo == null) {
            this.btnTo = new JButton();
            this.btnTo.setEnabled(false);
            this.btnTo = new JButton(LanguageTranslator.getString("button.to"));
            this.btnTo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
        }
        return this.btnTo;
    }

    private JButton getBtnNew() {
        if (this.btnNew == null) {
            this.btnNew = new JButton();
            this.btnNew = new JButton(LanguageTranslator.getString("button.new"));
            this.btnNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogPopupMessageCreation.this.currentMessage = new UserMessage();
                    DialogPopupMessageCreation.this.load(DialogPopupMessageCreation.this.currentMessage);
                }
            });
        }
        return this.btnNew;
    }

    public void setMessage(UserMessage msg) {
        this.message = msg.getMessage();
        this.getText().setDocumentText(this.message);
    }
}

