/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.data.bdd.Rate;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.TMRate;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.ui.calendrier.JCalendrier;

public class DialogRate
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlChoix = null;
    private JButton btnEnregistrer = null;
    private JButton btnQuitter = null;
    private JPanel pnlCreation = null;
    private JButton btnNouveau = null;
    private JButton btnDelete = null;
    private JPanel pnlTable = null;
    private JScrollPane jspTable = null;
    private JTable tblRate = null;
    private Vector<Rate> rowToAdd = null;
    private Vector<Rate> rowToDel = null;
    private Vector<Rate> rowToUpdate = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogRate.dispose()#");
        super.dispose();
    }

    public DialogRate(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogRate()#");
        this.initialize();
    }

    private void initialize() {
        this.setSize(645, 190);
        this.setTitle(LanguageTranslator.getString("rate.title"));
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.fill = 1;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.weighty = 1.0;
            gridBagConstraints13.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlCreation(), gridBagConstraints13);
        }
        return this.jContentPane;
    }

    private JPanel getPnlChoix() {
        if (this.pnlChoix == null) {
            this.pnlChoix = new JPanel();
            this.pnlChoix.setLayout(new FlowLayout());
            this.pnlChoix.add((Component)this.getBtnEnregistrer(), null);
            this.pnlChoix.add((Component)this.getBtnQuitter(), null);
            this.pnlChoix.add((Component)this.getBtnDelete(), null);
            this.pnlChoix.add((Component)this.getBtnNouveau(), null);
        }
        return this.pnlChoix;
    }

    private Vector<Rate> getRowToAdd() {
        if (this.rowToAdd == null) {
            this.rowToAdd = new Vector();
        }
        return this.rowToAdd;
    }

    private Vector<Rate> getRowToDel() {
        if (this.rowToDel == null) {
            this.rowToDel = new Vector();
        }
        return this.rowToDel;
    }

    private Vector<Rate> getRowToUpdate() {
        if (this.rowToUpdate == null) {
            this.rowToUpdate = new Vector();
        }
        return this.rowToUpdate;
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogRate.this.enregistrer();
                    DialogRate.this.dispose();
                }
            });
        }
        return this.btnEnregistrer;
    }

    public boolean enregistrer() {
        this.commit();
        TimsLogger.debug("on doit ajouter " + this.getRowToAdd().size() + ", update " + this.getRowToUpdate().size() + " et supprimer " + this.getRowToDel().size());
        Iterator<Rate> iter = this.getRowToDel().iterator();
        while (iter.hasNext()) {
            iter.next().delete();
        }
        iter = this.getRowToAdd().iterator();
        while (iter.hasNext()) {
            iter.next().insert();
        }
        iter = this.getRowToUpdate().iterator();
        while (iter.hasNext()) {
            iter.next().update();
        }
        return true;
    }

    public void commit() {
        TimsLogger.verbose("#DialogTypeJournee# commit");
        int row = this.getTblRate().getSelectedRow();
        int column = this.getTblRate().getSelectedColumn();
        if (!this.getTblRate().isEditing()) {
            TimsLogger.verbose("not editing a cell");
        } else {
            TimsLogger.verbose("STOP EDITING " + row + " : " + column);
            this.getTblRate().getCellEditor(row, column).stopCellEditing();
        }
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogRate.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JPanel getPnlCreation() {
        if (this.pnlCreation == null) {
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = -1;
            gridBagConstraints14.fill = 1;
            gridBagConstraints14.weightx = 1.0;
            gridBagConstraints14.weighty = 1.0;
            gridBagConstraints14.gridy = -1;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.fill = 1;
            gridBagConstraints12.gridy = 1;
            gridBagConstraints12.weightx = 0.0;
            gridBagConstraints12.weighty = 0.0;
            gridBagConstraints12.gridx = 0;
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 0;
            gridBagConstraints31.weightx = 1.0;
            gridBagConstraints31.weighty = 1.0;
            gridBagConstraints31.gridy = 1;
            this.pnlCreation = new JPanel();
            this.pnlCreation.setLayout(new GridBagLayout());
            this.pnlCreation.add((Component)this.getPnlChoix(), gridBagConstraints12);
            this.pnlCreation.add((Component)this.getPnlTable(), gridBagConstraints14);
        }
        return this.pnlCreation;
    }

    private JButton getBtnNouveau() {
        if (this.btnNouveau == null) {
            this.btnNouveau = new JButton();
            this.btnNouveau.setText(LanguageTranslator.getString("button.new"));
            this.btnNouveau.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogRate.this.newLine();
                }
            });
        }
        return this.btnNouveau;
    }

    public void newLine() {
        Rate toAdd = new Rate();
        ((TMRate)this.getTblRate().getModel()).addRow(toAdd);
    }

    private JButton getBtnDelete() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton();
            this.btnDelete.setText(LanguageTranslator.getString("button.delete"));
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = DialogRate.this.getTblRate().getSelectedRow();
                    Rate toDel = ((TMRate)DialogRate.this.getTblRate().getModel()).removeRow(row);
                    if (toDel.getCle() != 0) {
                        DialogRate.this.getRowToDel().add(toDel);
                    } else {
                        DialogRate.this.getRowToAdd().remove(toDel);
                    }
                }
            });
        }
        return this.btnDelete;
    }

    private JPanel getPnlTable() {
        if (this.pnlTable == null) {
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.fill = 1;
            gridBagConstraints15.weighty = 1.0;
            gridBagConstraints15.weightx = 1.0;
            this.pnlTable = new JPanel();
            this.pnlTable.setLayout(new GridBagLayout());
            this.pnlTable.add((Component)this.getJspTable(), gridBagConstraints15);
        }
        return this.pnlTable;
    }

    private JScrollPane getJspTable() {
        if (this.jspTable == null) {
            this.jspTable = new JScrollPane();
            this.jspTable.setViewportView(this.getTblRate());
        }
        return this.jspTable;
    }

    private JTable getTblRate() {
        if (this.tblRate == null) {
            this.tblRate = new JTable();
            this.tblRate.setModel(new TMRate(Rate.load(), new ChangeTableListener()));
            this.tblRate.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    TimsLogger.verbose("#DialogRate.getTblRate().listener#");
                    int row = DialogRate.this.getTblRate().getSelectedRow();
                    int column = DialogRate.this.getTblRate().getSelectedColumn();
                    TimsLogger.debug("#DialogRate.getTblRate()# row " + row + " col " + column);
                    if (column == 6) {
                        Point toShow = DialogRate.this.getTblRate().getLocationOnScreen();
                        toShow.setLocation(toShow.getX() + (double)e.getX(), toShow.getY() + (double)e.getY());
                        JCalendrier.affiche(toShow);
                        if (JCalendrier.clicked()) {
                            DialogRate.this.getTblRate().setValueAt(JCalendrier.getDate(), row, column);
                        }
                    }
                }
            });
        }
        return this.tblRate;
    }

    class ChangeTableListener
    implements TableModelListener {
        @Override
        public void tableChanged(TableModelEvent e) {
            TimsLogger.verbose("#ChangeTableListener.tableChanged# on rentre");
            switch (e.getType()) {
                case -1: {
                    TimsLogger.verbose("#ChangeTableListener.tableChanged# suppression");
                    break;
                }
                case 1: {
                    TimsLogger.verbose("insertion " + e.getFirstRow());
                    DialogRate.this.getRowToAdd().add(((TMRate)DialogRate.this.getTblRate().getModel()).getRow(e.getFirstRow()));
                    break;
                }
                case 0: {
                    TimsLogger.verbose("#ChangeTableListener.tableChanged# changement " + e.getFirstRow());
                    Rate tmp = ((TMRate)DialogRate.this.getTblRate().getModel()).getRow(e.getFirstRow());
                    if (!DialogRate.this.getRowToUpdate().contains(tmp) && tmp.getCle() != 0) {
                        DialogRate.this.getRowToUpdate().add(tmp);
                    }
                    TimsLogger.verbose("#ChangeTableListener.tableChanged# taille du fichier de sauvegarde " + DialogRate.this.getRowToUpdate().size());
                }
            }
        }
    }
}

