/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.bdd.Pays;
import fr.pgh.data.bdd.Region;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.TMRegion;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class DialogRegion
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlChoix = null;
    private JButton btnEnregistrer = null;
    private JButton btnQuitter = null;
    private JPanel pnlCreation = null;
    private JButton btnNouveau = null;
    private JButton btnDelete = null;
    private JPanel pnlTable = null;
    private JScrollPane jspTable = null;
    private JTable tblRegion = null;
    private Vector<Region> rowToAdd = null;
    private Vector<Region> rowToDel = null;
    private Vector<Region> rowToUpdate = null;
    private JComboBox cbCountry = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogHardness.dispose()#");
        super.dispose();
    }

    public DialogRegion(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogHardness()#");
        this.initialize();
    }

    private void initialize() {
        this.setSize(400, 400);
        this.setTitle(LanguageTranslator.getString("generics.region"));
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.fill = 1;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.weighty = 1.0;
            gridBagConstraints13.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlCreation(), gridBagConstraints13);
        }
        return this.jContentPane;
    }

    private JPanel getPnlChoix() {
        if (this.pnlChoix == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(0, 1, 2, 1);
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 2;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.weighty = 1.0;
            gridBagConstraints9.insets = new Insets(0, 1, 2, 1);
            gridBagConstraints9.gridy = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.insets = new Insets(0, 2, 2, 1);
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.gridy = 1;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 3;
            gridBagConstraints10.insets = new Insets(0, 1, 2, 2);
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.weighty = 1.0;
            gridBagConstraints10.gridy = 1;
            this.pnlChoix = new JPanel();
            this.pnlChoix.setLayout(new GridBagLayout());
            if (ConnexionSettings.getInstance().isModifiable("REGION")) {
                this.pnlChoix.add((Component)this.getBtnEnregistrer(), gridBagConstraints10);
            }
            if (ConnexionSettings.getInstance().isAjoutable("REGION")) {
                this.pnlChoix.add((Component)this.getBtnNouveau(), gridBagConstraints);
            }
            if (ConnexionSettings.getInstance().isSupprimable("REGION")) {
                this.pnlChoix.add((Component)this.getBtnDelete(), gridBagConstraints9);
            }
            this.pnlChoix.add((Component)this.getBtnQuitter(), gridBagConstraints7);
        }
        return this.pnlChoix;
    }

    private Vector<Region> getRowToAdd() {
        if (this.rowToAdd == null) {
            this.rowToAdd = new Vector();
        }
        return this.rowToAdd;
    }

    private Vector<Region> getRowToDel() {
        if (this.rowToDel == null) {
            this.rowToDel = new Vector();
        }
        return this.rowToDel;
    }

    private Vector<Region> getRowToUpdate() {
        if (this.rowToUpdate == null) {
            this.rowToUpdate = new Vector();
        }
        return this.rowToUpdate;
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogRegion.this.enregistrer();
                    DialogRegion.this.dispose();
                }
            });
        }
        return this.btnEnregistrer;
    }

    public boolean enregistrer() {
        this.commit();
        TimsLogger.debug("#DialogHardness.enregistrer# on doit ajouter " + this.getRowToAdd().size() + ", update " + this.getRowToUpdate().size() + " et supprimer " + this.getRowToDel().size());
        for (Region toDel : this.getRowToDel()) {
            toDel.delete();
        }
        for (Region toAdd : this.getRowToAdd()) {
            toAdd.insert();
        }
        for (Region toUpdate : this.getRowToUpdate()) {
            toUpdate.update();
        }
        return true;
    }

    public void commit() {
        int row = this.getTblRegion().getSelectedRow();
        int column = this.getTblRegion().getSelectedColumn();
        if (this.getTblRegion().isEditing()) {
            TimsLogger.verbose("#DialogHardness# STOP EDITING " + row + " : " + column);
            this.getTblRegion().getCellEditor(row, column).stopCellEditing();
        }
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogRegion.this.confirm()) {
                        DialogRegion.this.dispose();
                    }
                }
            });
        }
        return this.btnQuitter;
    }

    public boolean confirm() {
        this.commit();
        if (this.getRowToDel().size() != 0 || this.getRowToDel().size() != 0 || this.getRowToDel().size() != 0) {
            return JOptionPane.showConfirmDialog(this, LanguageTranslator.getString("message.confirmQuit"), LanguageTranslator.getString("message.confirm"), 0, 2) == 0;
        }
        return true;
    }

    private JPanel getPnlCreation() {
        if (this.pnlCreation == null) {
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = -1;
            gridBagConstraints14.fill = 1;
            gridBagConstraints14.weightx = 1.0;
            gridBagConstraints14.weighty = 1.0;
            gridBagConstraints14.gridy = -1;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.fill = 1;
            gridBagConstraints12.gridy = 1;
            gridBagConstraints12.weightx = 0.0;
            gridBagConstraints12.weighty = 0.0;
            gridBagConstraints12.gridx = 0;
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 0;
            gridBagConstraints31.weightx = 1.0;
            gridBagConstraints31.weighty = 1.0;
            gridBagConstraints31.gridy = 1;
            this.pnlCreation = new JPanel();
            this.pnlCreation.setLayout(new GridBagLayout());
            this.pnlCreation.add((Component)this.getPnlChoix(), gridBagConstraints12);
            this.pnlCreation.add((Component)this.getPnlTable(), gridBagConstraints14);
        }
        return this.pnlCreation;
    }

    private JButton getBtnNouveau() {
        if (this.btnNouveau == null) {
            this.btnNouveau = new JButton();
            this.btnNouveau.setText(LanguageTranslator.getString("button.new"));
            this.btnNouveau.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogRegion.this.newLine();
                }
            });
        }
        return this.btnNouveau;
    }

    public void newLine() {
        Region toAdd = new Region();
        toAdd.setCode("INC");
        toAdd.setName("INCONNU");
        ((TMRegion)this.getTblRegion().getModel()).addRow(toAdd);
    }

    private JButton getBtnDelete() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton();
            this.btnDelete.setText(LanguageTranslator.getString("button.delete"));
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = DialogRegion.this.getTblRegion().getSelectedRow();
                    Region toDel = ((TMRegion)DialogRegion.this.getTblRegion().getModel()).removeRow(row);
                    if (toDel.getCle() != 0) {
                        DialogRegion.this.getRowToDel().add(toDel);
                    } else {
                        DialogRegion.this.getRowToAdd().remove(toDel);
                    }
                }
            });
        }
        return this.btnDelete;
    }

    private JPanel getPnlTable() {
        if (this.pnlTable == null) {
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.fill = 1;
            gridBagConstraints15.weighty = 1.0;
            gridBagConstraints15.insets = new Insets(0, 2, 0, 2);
            gridBagConstraints15.weightx = 1.0;
            this.pnlTable = new JPanel();
            this.pnlTable.setLayout(new GridBagLayout());
            this.pnlTable.add((Component)this.getJspTable(), gridBagConstraints15);
        }
        return this.pnlTable;
    }

    private JScrollPane getJspTable() {
        if (this.jspTable == null) {
            this.jspTable = new JScrollPane();
            this.jspTable.setViewportView(this.getTblRegion());
        }
        return this.jspTable;
    }

    private JTable getTblRegion() {
        if (this.tblRegion == null) {
            this.tblRegion = new JTable();
            this.tblRegion.setModel(new TMRegion(Region.loadList(0), new ChangeTableListener()));
            DefaultCellEditor dce = new DefaultCellEditor(this.getCbCountry());
            dce.setClickCountToStart(2);
            this.tblRegion.getColumnModel().getColumn(2).setCellEditor(dce);
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText(LanguageTranslator.getString("generics.doubleClick"));
            this.tblRegion.getColumnModel().getColumn(2).setCellRenderer(renderer);
        }
        return this.tblRegion;
    }

    private JComboBox getCbCountry() {
        if (this.cbCountry == null) {
            this.cbCountry = new JComboBox();
            this.cbCountry.setModel(new ComboBoxModel((Vector<?>)Pays.getVector()));
        }
        return this.cbCountry;
    }

    class ChangeTableListener
    implements TableModelListener {
        @Override
        public void tableChanged(TableModelEvent e) {
            switch (e.getType()) {
                case -1: {
                    break;
                }
                case 1: {
                    DialogRegion.this.getRowToAdd().add(((TMRegion)DialogRegion.this.getTblRegion().getModel()).getRow(e.getFirstRow()));
                    break;
                }
                case 0: {
                    Region tmp = ((TMRegion)DialogRegion.this.getTblRegion().getModel()).getRow(e.getFirstRow());
                    if (DialogRegion.this.getRowToUpdate().contains(tmp) || tmp.getCle() == 0) break;
                    DialogRegion.this.getRowToUpdate().add(tmp);
                }
            }
        }
    }
}

