/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.component.JTextHour;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.connexion.TimsSession;
import fr.pgh.data.bdd.RoundType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.LMRound;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class DialogRound
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlListe = null;
    private JPanel pnlDetail = null;
    private JScrollPane jpsListe = null;
    private JList list = null;
    private JCheckBox cbArchive = null;
    private JPanel pnlBtn = null;
    private JButton btnCreer = null;
    private JButton btnQuitter = null;
    private JButton btnArchive = null;
    private JButton btnEnregistrer = null;
    private JPanel pnlContent = null;
    private JLabel lblCode = null;
    private JTextField txtCode = null;
    private JLabel lblDescription = null;
    private JTextField txtDescription = null;
    private JLabel lblBeginTime = null;
    private JTextHour txtBeginTime = null;
    private JLabel lblLoadTime = null;
    private JTextHour txtLoadTime = null;
    private JLabel lblTotalCutTime = null;
    private JTextHour txtTotalCutTime = null;
    private JLabel lblReturnTime = null;
    private JTextHour txtReturnTime = null;
    private JLabel lblUnloadTime = null;
    private JTextHour txtUnloadTime = null;
    private JLabel lblTotalTime = null;
    private JTextHour txtTotalTime = null;
    private JLabel lblMaxServicePoint = null;
    private JTextField txtMaxServicePoint = null;
    private JLabel lblMaxParcel = null;
    private JTextField txtMaxParcel = null;
    private JLabel lblAvgDeliveryTime = null;
    private JTextHour txtAvgDeliveryTime = null;
    private JLabel lblKm = null;
    private JTextField txtKm = null;
    private RoundType current = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogRound.dispose()#");
        super.dispose();
    }

    public DialogRound(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogRound()#");
        this.initialize();
        TimsSession.getInstance().addVisit(this.getClass().getName());
    }

    private void initialize() {
        this.setSize(570, 340);
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(LanguageTranslator.getString("generics.round"));
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gcbList = Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 5, 5));
            GridBagConstraints gcbContent = Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 2, 11, new Insets(5, 0, 5, 5));
            GridBagConstraints gcbBtn = Fonctions.getGridBagConstraints(0, 1, 1, 2, 1.0, 0.0, 1, 15, new Insets(2, 2, 2, 2));
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlListe(), gcbList);
            this.jContentPane.add((Component)this.getPnlContent(), gcbContent);
            this.jContentPane.add((Component)this.getPnlBtn(), gcbBtn);
        }
        return this.jContentPane;
    }

    private JPanel getPnlListe() {
        if (this.pnlListe == null) {
            GridBagConstraints gcbListe = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(0, 0, 5, 0));
            GridBagConstraints gcbArchive = Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 1, -1, new Insets(0, 0, 5, 0));
            this.pnlListe = new JPanel();
            this.pnlListe.setLayout(new GridBagLayout());
            this.pnlListe.setPreferredSize(new Dimension(150, 0));
            this.pnlListe.add((Component)this.getJpsListe(), gcbListe);
            this.pnlListe.add((Component)this.getCbArchive(), gcbArchive);
        }
        return this.pnlListe;
    }

    private JScrollPane getJpsListe() {
        if (this.jpsListe == null) {
            this.jpsListe = new JScrollPane();
            this.jpsListe.setPreferredSize(new Dimension(0, 0));
            this.jpsListe.setViewportView(this.getList());
        }
        return this.jpsListe;
    }

    private JList getList() {
        if (this.list == null) {
            this.list = new JList();
            this.list.setModel(new LMRound(RoundType.getList()));
            this.list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && DialogRound.this.getList().getSelectedIndex() != -1) {
                        LMRound tmp = (LMRound)DialogRound.this.getList().getModel();
                        DialogRound.this.load(tmp.getSpecifiedObjectAt(DialogRound.this.getList().getSelectedIndex()));
                    }
                }
            });
        }
        return this.list;
    }

    private JButton getBtnCreer() {
        if (this.btnCreer == null) {
            this.btnCreer = new JButton();
            this.btnCreer.setText(LanguageTranslator.getString("button.new"));
            this.btnCreer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogRound.this.load(new RoundType());
                }
            });
        }
        return this.btnCreer;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.add(this.getBtnCreer());
            if (ConnexionSettings.getInstance().isSupprimable("TOURNEE")) {
                this.pnlBtn.add(this.getBtnArchive());
            }
            this.pnlBtn.add(this.getBtnQuitter());
            if (ConnexionSettings.getInstance().isModifiable("TOURNEE")) {
                this.pnlBtn.add(this.getBtnEnregistrer());
            }
        }
        return this.pnlBtn;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogRound.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JButton getBtnArchive() {
        if (this.btnArchive == null) {
            this.btnArchive = new JButton();
            this.btnArchive.setEnabled(false);
            this.btnArchive.setText(LanguageTranslator.getString("button.archive"));
            this.btnArchive.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogRound.this.archive();
                }
            });
        }
        return this.btnArchive;
    }

    public void archive() {
        if (this.current != null && JOptionPane.showConfirmDialog(this, LanguageTranslator.getString("generics.confirmArchive", this.current.getCode()), LanguageTranslator.getString("button.archive"), 0, 2) == 0) {
            this.current.setArchived(true);
            this.current.update();
            this.updateList();
        }
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogRound.this.current != null) {
                        DialogRound.this.save();
                        DialogRound.this.updateList();
                    }
                }
            });
        }
        return this.btnEnregistrer;
    }

    private JTextField getTxtCode() {
        if (this.txtCode == null) {
            this.txtCode = new JTextField();
        }
        return this.txtCode;
    }

    private JTextField getTxtDescription() {
        if (this.txtDescription == null) {
            this.txtDescription = new JTextField();
        }
        return this.txtDescription;
    }

    private JTextHour getTxtBeginTime() {
        if (this.txtBeginTime == null) {
            this.txtBeginTime = new JTextHour();
        }
        return this.txtBeginTime;
    }

    private JTextHour getTxtLoadTime() {
        if (this.txtLoadTime == null) {
            this.txtLoadTime = new JTextHour();
        }
        return this.txtLoadTime;
    }

    private JTextHour getTxtTotalCutTime() {
        if (this.txtTotalCutTime == null) {
            this.txtTotalCutTime = new JTextHour();
        }
        return this.txtTotalCutTime;
    }

    private JTextHour getTxtReturnTime() {
        if (this.txtReturnTime == null) {
            this.txtReturnTime = new JTextHour();
        }
        return this.txtReturnTime;
    }

    private JTextHour getTxtUnloadTime() {
        if (this.txtUnloadTime == null) {
            this.txtUnloadTime = new JTextHour();
        }
        return this.txtUnloadTime;
    }

    private JTextHour getTxtTotalTime() {
        if (this.txtTotalTime == null) {
            this.txtTotalTime = new JTextHour();
        }
        return this.txtTotalTime;
    }

    private JTextField getTxtMaxServicePoint() {
        if (this.txtMaxServicePoint == null) {
            this.txtMaxServicePoint = new JTextField();
        }
        return this.txtMaxServicePoint;
    }

    private JTextField getTxtMaxParcel() {
        if (this.txtMaxParcel == null) {
            this.txtMaxParcel = new JTextField();
        }
        return this.txtMaxParcel;
    }

    private JTextField getTxtKm() {
        if (this.txtKm == null) {
            this.txtKm = new JTextField();
        }
        return this.txtKm;
    }

    private JTextHour getTxtAvgDeliveryTime() {
        if (this.txtAvgDeliveryTime == null) {
            this.txtAvgDeliveryTime = new JTextHour();
        }
        return this.txtAvgDeliveryTime;
    }

    private JPanel getPnlContent() {
        if (this.pnlContent == null) {
            this.lblCode = new JLabel(LanguageTranslator.getString("generics.code"));
            this.lblDescription = new JLabel(LanguageTranslator.getString("generics.description"));
            this.lblBeginTime = new JLabel(LanguageTranslator.getString("round.beginTime"));
            this.lblLoadTime = new JLabel(LanguageTranslator.getString("round.loadDuration"));
            this.lblTotalCutTime = new JLabel(LanguageTranslator.getString("round.totalCutTime"));
            this.lblReturnTime = new JLabel(LanguageTranslator.getString("round.returnTime"));
            this.lblUnloadTime = new JLabel(LanguageTranslator.getString("round.unloadDuration"));
            this.lblTotalTime = new JLabel(LanguageTranslator.getString("round.totalTime"));
            this.lblMaxServicePoint = new JLabel(LanguageTranslator.getString("round.maxServicePoint"));
            this.lblMaxParcel = new JLabel(LanguageTranslator.getString("round.maxParcel"));
            this.lblAvgDeliveryTime = new JLabel(LanguageTranslator.getString("round.avgDeliveryTime"));
            this.lblKm = new JLabel(LanguageTranslator.getString("generics.km"));
            int line = 0;
            GridBagConstraints gcbLblCode = Fonctions.getGridBagConstraints(0, line, 1, 1, 0.0, 0.0, -1, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtCode = Fonctions.getGridBagConstraints(1, line, 1, 3, 1.0, 0.0, 2, 13, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblDescription = Fonctions.getGridBagConstraints(0, ++line, 1, 1, 0.0, 0.0, -1, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtDescription = Fonctions.getGridBagConstraints(1, line, 1, 3, 0.0, 0.0, 2, 13, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblBeginTime = Fonctions.getGridBagConstraints(0, ++line, 1, 1, 0.0, 0.0, -1, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtBeginTime = Fonctions.getGridBagConstraints(1, line, 1, 1, 0.0, 0.0, -1, 13, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblLoadTime = Fonctions.getGridBagConstraints(2, line, 1, 1, 0.0, 0.0, -1, 18, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtLoadTime = Fonctions.getGridBagConstraints(3, line, 1, 1, 0.0, 0.0, -1, 13, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblTotalCutTime = Fonctions.getGridBagConstraints(0, ++line, 1, 1, 0.0, 0.0, -1, 18, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtTotalCutTime = Fonctions.getGridBagConstraints(1, line, 1, 1, 0.0, 0.0, -1, 13, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblReturnTime = Fonctions.getGridBagConstraints(2, line, 1, 1, 0.0, 0.0, -1, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtReturnTime = Fonctions.getGridBagConstraints(3, line, 1, 1, 0.0, 0.0, -1, 13, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblUnloadTime = Fonctions.getGridBagConstraints(0, ++line, 1, 1, 0.0, 0.0, -1, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtUnloadTime = Fonctions.getGridBagConstraints(1, line, 1, 1, 0.0, 0.0, -1, 13, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblTotalTime = Fonctions.getGridBagConstraints(2, line, 1, 1, 0.0, 0.0, -1, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtTotalTime = Fonctions.getGridBagConstraints(3, line, 1, 1, 0.0, 0.0, -1, 13, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblAvg = Fonctions.getGridBagConstraints(0, ++line, 1, 1, 0.0, 0.0, -1, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtAvg = Fonctions.getGridBagConstraints(1, line, 1, 1, 0.0, 0.0, 2, 13, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblKm = Fonctions.getGridBagConstraints(2, line, 1, 1, 0.0, 0.0, -1, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtKm = Fonctions.getGridBagConstraints(3, line, 1, 1, 0.0, 0.0, 2, 13, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblMaxServicePt = Fonctions.getGridBagConstraints(0, ++line, 1, 1, 0.0, 0.0, -1, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtMaxServicePt = Fonctions.getGridBagConstraints(1, line, 1, 1, 0.0, 0.0, 2, 13, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblMaxParcel = Fonctions.getGridBagConstraints(2, line, 1, 1, 0.0, 0.0, -1, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtMaxParcel = Fonctions.getGridBagConstraints(3, line, 1, 1, 0.0, 0.0, 2, 13, new Insets(5, 0, 0, 5));
            ++line;
            this.pnlContent = new JPanel();
            this.pnlContent.setLayout(new GridBagLayout());
            this.pnlContent.add((Component)this.lblCode, gcbLblCode);
            this.pnlContent.add((Component)this.getTxtCode(), gcbTxtCode);
            this.pnlContent.add((Component)this.lblDescription, gcbLblDescription);
            this.pnlContent.add((Component)this.getTxtDescription(), gcbTxtDescription);
            this.pnlContent.add((Component)this.lblBeginTime, gcbLblBeginTime);
            this.pnlContent.add((Component)this.getTxtBeginTime(), gcbTxtBeginTime);
            this.pnlContent.add((Component)this.lblLoadTime, gcbLblLoadTime);
            this.pnlContent.add((Component)this.getTxtLoadTime(), gcbTxtLoadTime);
            this.pnlContent.add((Component)this.lblTotalCutTime, gcbLblTotalCutTime);
            this.pnlContent.add((Component)this.getTxtTotalCutTime(), gcbTxtTotalCutTime);
            this.pnlContent.add((Component)this.lblReturnTime, gcbLblReturnTime);
            this.pnlContent.add((Component)this.getTxtReturnTime(), gcbTxtReturnTime);
            this.pnlContent.add((Component)this.lblUnloadTime, gcbLblUnloadTime);
            this.pnlContent.add((Component)this.getTxtUnloadTime(), gcbTxtUnloadTime);
            this.pnlContent.add((Component)this.lblTotalTime, gcbLblTotalTime);
            this.pnlContent.add((Component)this.getTxtTotalTime(), gcbTxtTotalTime);
            this.pnlContent.add((Component)this.lblMaxServicePoint, gcbLblMaxServicePt);
            this.pnlContent.add((Component)this.getTxtMaxServicePoint(), gcbTxtMaxServicePt);
            this.pnlContent.add((Component)this.lblMaxParcel, gcbLblMaxParcel);
            this.pnlContent.add((Component)this.getTxtMaxParcel(), gcbTxtMaxParcel);
            this.pnlContent.add((Component)this.lblAvgDeliveryTime, gcbLblAvg);
            this.pnlContent.add((Component)this.getTxtAvgDeliveryTime(), gcbTxtAvg);
            this.pnlContent.add((Component)this.lblKm, gcbLblKm);
            this.pnlContent.add((Component)this.getTxtKm(), gcbTxtKm);
        }
        return this.pnlContent;
    }

    private JCheckBox getCbArchive() {
        if (this.cbArchive == null) {
            this.cbArchive = new JCheckBox();
            this.cbArchive.setText(LanguageTranslator.getString("generics.seeArchive"));
            this.cbArchive.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean enable = DialogRound.this.getCbArchive().isSelected();
                    DialogRound.this.current = null;
                    DialogRound.this.getList().setModel(new LMRound(enable ? RoundType.loadList("AND ARCHIVED = 1") : RoundType.getList()));
                    DialogRound.this.getBtnEnregistrer().setEnabled(!enable);
                    DialogRound.this.getBtnArchive().setEnabled(!enable);
                    DialogRound.this.getBtnCreer().setEnabled(!enable);
                }
            });
        }
        return this.cbArchive;
    }

    private void load(RoundType toLoad) {
        this.current = toLoad;
        this.getTxtCode().setText(this.current.getCode());
        this.getTxtDescription().setText(this.current.getDescription());
        this.getTxtBeginTime().setHourMinute(this.current.getBeginTime());
        this.getTxtLoadTime().setHourMinute(this.current.getLoadTime());
        this.getTxtTotalCutTime().setHourMinute(this.current.getTotalCutTime());
        this.getTxtReturnTime().setHourMinute(this.current.getReturnTime());
        this.getTxtUnloadTime().setHourMinute(this.current.getUnloadTime());
        this.getTxtTotalTime().setHourMinute(this.current.getTotalTime());
        this.getTxtMaxServicePoint().setText(String.valueOf(this.current.getMaxServicePoint()));
        this.getTxtMaxParcel().setText(String.valueOf(this.current.getMaxParcel()));
        this.getTxtAvgDeliveryTime().setHourMinute(this.current.getAvgDeliveryTime());
        this.getTxtKm().setText(String.valueOf(this.current.getKm()));
        this.getBtnArchive().setEnabled(!this.current.isArchived());
    }

    private void save() {
        if (!this.check()) {
            return;
        }
        if (this.current.compareAndUpdate(this.getTxtCode().getText(), this.getTxtDescription().getText(), this.getTxtBeginTime().getMinuteHour(), this.getTxtLoadTime().getMinuteHour(), this.getTxtTotalCutTime().getMinuteHour(), this.getTxtReturnTime().getMinuteHour(), this.getTxtUnloadTime().getMinuteHour(), this.getTxtTotalTime().getMinuteHour(), Integer.parseInt(this.getTxtMaxServicePoint().getText()), Integer.parseInt(this.getTxtMaxParcel().getText()), this.getTxtAvgDeliveryTime().getMinuteHour(), Integer.parseInt(this.getTxtKm().getText()), this.current.isArchived())) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.saveSucceed"), LanguageTranslator.getString("message.done"), 1);
        }
    }

    private boolean check() {
        boolean toReturn = true;
        if (this.getTxtCode().getText().equals("") || this.getTxtCode().getText().length() > 16 || this.current.getId() == 0 && ((LMRound)this.getList().getModel()).isExisting(this.getTxtCode().getText())) {
            this.getTxtCode().setBackground(new Color(255, 192, 203));
            if (this.getTxtCode().getText().equals("")) {
                this.getTxtCode().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            } else if (this.getTxtCode().getText().length() > 16) {
                this.getTxtCode().setToolTipText(LanguageTranslator.getString("generics.maxAuthorised", "16"));
            } else {
                this.getTxtCode().setToolTipText(LanguageTranslator.getString("generics.everExist", this.getTxtCode().getText()));
            }
            toReturn = false;
        } else {
            this.getTxtCode().setBackground(Color.white);
        }
        if (this.getTxtDescription().getText().equals("")) {
            this.getTxtDescription().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            this.getTxtDescription().setBackground(new Color(255, 192, 203));
            toReturn = false;
        } else {
            this.getTxtDescription().setBackground(Color.white);
        }
        if (!Fonctions.isInt(this.getTxtMaxServicePoint().getText())) {
            this.getTxtMaxServicePoint().setBackground(new Color(255, 192, 203));
            this.getTxtDescription().setToolTipText(LanguageTranslator.getString("generics.intRequired"));
            toReturn = false;
        } else {
            this.getTxtMaxServicePoint().setBackground(Color.white);
        }
        if (!Fonctions.isInt(this.getTxtMaxParcel().getText())) {
            this.getTxtMaxParcel().setBackground(new Color(255, 192, 203));
            this.getTxtDescription().setToolTipText(LanguageTranslator.getString("generics.intRequired"));
            toReturn = false;
        } else {
            this.getTxtMaxParcel().setBackground(Color.white);
        }
        if (!Fonctions.isInt(this.getTxtKm().getText())) {
            this.getTxtKm().setBackground(new Color(255, 192, 203));
            this.getTxtDescription().setToolTipText(LanguageTranslator.getString("generics.intRequired"));
            toReturn = false;
        } else {
            this.getTxtKm().setBackground(Color.white);
        }
        return toReturn;
    }

    public void updateList() {
        this.getList().setModel(new LMRound(this.getCbArchive().isSelected() ? RoundType.loadList("AND ARCHIVED = 1") : RoundType.getList()));
        if (this.current != null) {
            this.getList().setSelectedValue(this.current.getCode(), true);
        }
    }
}

