/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.component.JRoundButton;
import fr.pgh.component.ui.renderer.CellCheckBoxHeaderRenderer;
import fr.pgh.component.ui.renderer.CheckBoxHeader;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.TypeContrat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.LMContract;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class DialogTypeContrat
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JScrollPane jspListe = null;
    private JList listContract = null;
    private JPanel pnlBtn = null;
    private JRoundButton btnQuitter = null;
    private JTextField txtNom = null;
    private JPanel pnlDetail = null;
    private JRoundButton btnEnregistrer = null;
    private JLabel lblNom = null;
    private JRoundButton btnCreer = null;
    private TypeContrat selected = null;
    private JScrollPane jspSeuil = null;
    private JTable tblSe = null;
    private JPanel pnlTypeCalcul = null;
    private JTextField txtHeureContrat = null;
    private JLabel lblHeureContrat = null;
    private JCheckBox cbGarantie = null;
    private JTextField txtMaxHour = null;
    private JLabel lblHeureMax = null;
    private JTextField txtDailyValue = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogTypeContrat.dispose()#");
        super.dispose();
    }

    public DialogTypeContrat(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogTypeContrat()#");
        this.initialize();
    }

    public DialogTypeContrat(Dialog owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setSize(600, 300);
        this.setTitle(LanguageTranslator.getString("contract.title"));
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.insets = new Insets(10, 5, 10, 5);
            gridBagConstraints4.gridy = 2;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.ipadx = 0;
            gridBagConstraints1.gridwidth = 2;
            gridBagConstraints1.gridy = 3;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.weightx = 0.6;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(10, 5, 10, 5);
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJspListe(), gridBagConstraints);
            this.jContentPane.add((Component)this.getPnlBtn(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getPnlDetail(), gridBagConstraints4);
        }
        return this.jContentPane;
    }

    private JScrollPane getJspListe() {
        if (this.jspListe == null) {
            this.jspListe = new JScrollPane();
            this.jspListe.setViewportView(this.getListContract());
        }
        return this.jspListe;
    }

    private JList getListContract() {
        if (this.listContract == null) {
            this.listContract = new JList();
            this.listContract.setSelectionMode(0);
            this.listContract.setModel(new LMContract(TypeContrat.loadList()));
            this.listContract.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int selected = DialogTypeContrat.this.getListContract().getSelectedIndex();
                    if (!e.getValueIsAdjusting() && selected != -1) {
                        TypeContrat toSel = ((LMContract)DialogTypeContrat.this.getListContract().getModel()).getTypeContratAt(selected);
                        DialogTypeContrat.this.setSelected(toSel);
                    }
                }
            });
        }
        return this.listContract;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 1;
            gridBagConstraints13.insets = new Insets(0, 5, 5, 5);
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints12.gridy = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 2;
            gridBagConstraints5.insets = new Insets(0, 5, 5, 0);
            gridBagConstraints5.gridy = 0;
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.add((Component)this.getBtnQuitter(), gridBagConstraints13);
            if (ConnexionSettings.getInstance().isModifiable("TYPE_PAIE")) {
                this.pnlBtn.add((Component)this.getBtnEnregistrer(), gridBagConstraints5);
            }
            if (ConnexionSettings.getInstance().isAjoutable("TYPE_PAIE")) {
                this.pnlBtn.add((Component)this.getBtnCreer(), gridBagConstraints12);
            }
        }
        return this.pnlBtn;
    }

    private JRoundButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JRoundButton(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogTypeContrat.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JTextField getTxtNom() {
        if (this.txtNom == null) {
            this.txtNom = new JTextField();
        }
        return this.txtNom;
    }

    private JPanel getPnlDetail() {
        if (this.pnlDetail == null) {
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.fill = 2;
            gridBagConstraints19.gridy = 1;
            gridBagConstraints19.weightx = 0.0;
            gridBagConstraints19.insets = new Insets(2, 5, 2, 10);
            gridBagConstraints19.gridx = 2;
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.gridx = 0;
            gridBagConstraints18.anchor = 17;
            gridBagConstraints18.gridy = 2;
            this.lblHeureMax = new JLabel();
            this.lblHeureMax.setText(LanguageTranslator.getString("contract.maxHour"));
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.fill = 2;
            gridBagConstraints17.gridy = 2;
            gridBagConstraints17.weightx = 1.0;
            gridBagConstraints17.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints17.gridx = 1;
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridx = 2;
            gridBagConstraints16.gridy = 2;
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.anchor = 17;
            gridBagConstraints15.gridy = 1;
            this.lblHeureContrat = new JLabel();
            this.lblHeureContrat.setText(LanguageTranslator.getString("contract.contractHour"));
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.gridy = 1;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.insets = new Insets(2, 5, 2, 5);
            gridBagConstraints11.gridx = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.fill = 1;
            gridBagConstraints7.gridwidth = 3;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.weighty = 1.0;
            gridBagConstraints7.gridy = 3;
            gridBagConstraints7.insets = new Insets(10, 0, 10, 5);
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.gridy = 0;
            this.lblNom = new JLabel();
            this.lblNom.setText(LanguageTranslator.getString("generics.designation"));
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridx = -1;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(0, 5, 0, 10);
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.gridx = 1;
            this.pnlDetail = new JPanel();
            this.pnlDetail.setLayout(new GridBagLayout());
            this.pnlDetail.add((Component)this.getTxtNom(), gridBagConstraints3);
            this.pnlDetail.add((Component)this.lblNom, gridBagConstraints6);
            this.pnlDetail.add((Component)this.getPnlTypeCalcul(), gridBagConstraints7);
            this.pnlDetail.add((Component)this.getTxtHeureContrat(), gridBagConstraints11);
            this.pnlDetail.add((Component)this.lblHeureContrat, gridBagConstraints15);
            this.pnlDetail.add((Component)this.getCbGarantie(), gridBagConstraints16);
            this.pnlDetail.add((Component)this.getTxtMaxHour(), gridBagConstraints17);
            this.pnlDetail.add((Component)this.lblHeureMax, gridBagConstraints18);
            this.pnlDetail.add((Component)this.getTxtDailyValue(), gridBagConstraints19);
        }
        return this.pnlDetail;
    }

    private JRoundButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JRoundButton(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogTypeContrat.this.save();
                }
            });
        }
        return this.btnEnregistrer;
    }

    public void save() {
        this.commit();
        this.selected.setDesignation(this.getTxtNom().getText());
        this.selected.setContractHour(ConversionTime.heureStringToInt(this.getTxtHeureContrat().getText(), "h"));
        this.selected.setDailyValue(ConversionTime.heureStringToInt(this.getTxtDailyValue().getText(), "h"));
        this.selected.setMaximumHour(ConversionTime.heureStringToInt(this.getTxtMaxHour().getText(), "h"));
        this.selected.setGuaranteed(this.getCbGarantie().isSelected());
        this.selected.update();
        ((LMContract)this.getListContract().getModel()).setVector(TypeContrat.loadList());
    }

    public void commit() {
        if (this.getTblSe().isEditing()) {
            int row = this.getTblSe().getSelectedRow();
            int column = this.getTblSe().getSelectedColumn();
            this.getTblSe().getCellEditor(row, column).stopCellEditing();
        }
    }

    private JRoundButton getBtnCreer() {
        if (this.btnCreer == null) {
            this.btnCreer = new JRoundButton(LanguageTranslator.getString("button.new"));
            this.btnCreer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogTypeContrat.this.newLine();
                }
            });
        }
        return this.btnCreer;
    }

    public void newLine() {
        this.setSelected(new TypeContrat());
    }

    public void setSelected(TypeContrat toSelect) {
        this.selected = toSelect;
        this.getTxtNom().setText(this.selected.getDesignation());
        this.getTxtHeureContrat().setText(ConversionTime.heureIntToString(this.selected.getContractHour(), "h"));
        this.getTxtDailyValue().setText(ConversionTime.heureIntToString(this.selected.getDailyValue(), "h"));
        this.getTxtMaxHour().setText(ConversionTime.heureIntToString(this.selected.getMaximumHour(), "h"));
        this.getCbGarantie().setSelected(this.selected.isGuaranteed());
        ((CheckBoxHeader)this.getTblSe().getColumnModel().getColumn(this.selected.getCalculationType()).getHeaderRenderer()).setSelected(true);
        this.getTblSe().getTableHeader().repaint();
        ((TableModelSeuil)this.getTblSe().getModel()).setType(this.selected);
    }

    private JScrollPane getJspSeuil() {
        if (this.jspSeuil == null) {
            this.jspSeuil = new JScrollPane();
            this.jspSeuil.setViewportView(this.getTblSe());
        }
        return this.jspSeuil;
    }

    private JTable getTblSe() {
        if (this.tblSe == null) {
            this.tblSe = new JTable();
            this.tblSe.setModel(new TableModelSeuil(this.selected));
            ItemListener calculationTypeListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String state = e.getStateChange() == 1 ? "checked" : "unchecked";
                    int column = ((CheckBoxHeader)e.getItem()).getColumn();
                    TimsLogger.verbose(String.valueOf(column) + " - " + state);
                    if (DialogTypeContrat.this.selected != null) {
                        DialogTypeContrat.this.selected.setCalculationType(column);
                    }
                    DialogTypeContrat.this.getTblSe().repaint();
                }
            };
            ButtonGroup bg = new ButtonGroup();
            Enumeration<TableColumn> enumeration = this.tblSe.getColumnModel().getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn aColumn = enumeration.nextElement();
                CheckBoxHeader cbh = new CheckBoxHeader(calculationTypeListener);
                bg.add(cbh);
                if (aColumn.getModelIndex() != 0) {
                    aColumn.setHeaderRenderer(cbh);
                    aColumn.setCellRenderer(new CellCheckBoxHeaderRenderer());
                    continue;
                }
                aColumn.setCellRenderer(new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        this.setHorizontalAlignment(0);
                        this.setBackground(DialogTypeContrat.this.tblSe.getTableHeader().getBackground());
                        return this;
                    }
                });
            }
        }
        return this.tblSe;
    }

    private JPanel getPnlTypeCalcul() {
        if (this.pnlTypeCalcul == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.gridy = 0;
            gridBagConstraints9.fill = 1;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.weighty = 1.0;
            this.pnlTypeCalcul = new JPanel();
            this.pnlTypeCalcul.setLayout(new GridBagLayout());
            this.pnlTypeCalcul.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("contract.HScalculationType"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlTypeCalcul.add((Component)this.getJspSeuil(), gridBagConstraints9);
        }
        return this.pnlTypeCalcul;
    }

    private JTextField getTxtHeureContrat() {
        if (this.txtHeureContrat == null) {
            this.txtHeureContrat = new JTextField();
            this.txtHeureContrat.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent f) {
                    DialogTypeContrat.this.setDailyValue();
                }
            });
        }
        return this.txtHeureContrat;
    }

    public void setDailyValue() {
        int day = (int)((double)ConversionTime.heureStringToInt(this.getTxtHeureContrat().getText(), "h") / 21.65);
        int round = (day + 30) / 60;
        day = round * 60;
        this.getTxtDailyValue().setText(ConversionTime.heureIntToString(day, "h"));
    }

    private JCheckBox getCbGarantie() {
        if (this.cbGarantie == null) {
            this.cbGarantie = new JCheckBox();
            this.cbGarantie.setText(LanguageTranslator.getString("contract.guaranteed"));
        }
        return this.cbGarantie;
    }

    private JTextField getTxtMaxHour() {
        if (this.txtMaxHour == null) {
            this.txtMaxHour = new JTextField();
        }
        return this.txtMaxHour;
    }

    private JTextField getTxtDailyValue() {
        if (this.txtDailyValue == null) {
            this.txtDailyValue = new JTextField();
        }
        return this.txtDailyValue;
    }

    class TableModelSeuil
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private String[] columnNames = new String[]{LanguageTranslator.getString("contract.threshold"), LanguageTranslator.getString("contract.weekly"), LanguageTranslator.getString("contract.monthly"), LanguageTranslator.getString("contract.quarterly")};
        private TypeContrat data = null;

        public TableModelSeuil(TypeContrat data) {
            this.data = data;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return 3;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public TypeContrat getData() {
            return this.data;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                switch (row) {
                    case 0: {
                        return LanguageTranslator.getString("contract.normal");
                    }
                    case 1: {
                        return LanguageTranslator.getString("contract.equivalent");
                    }
                    case 2: {
                        return LanguageTranslator.getString("contract.additional");
                    }
                }
            }
            if (this.data == null) {
                return "";
            }
            if (col != this.data.getCalculationType()) {
                return "";
            }
            switch (row) {
                case 0: {
                    return ConversionTime.heureIntToString(this.data.getSeuilHN(-1), "h");
                }
                case 1: {
                    return ConversionTime.heureIntToString(this.data.getSeuilHE(-1), "h");
                }
                case 2: {
                    return ConversionTime.heureIntToString(this.data.getSeuilHS25(-1), "h");
                }
            }
            return "?";
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0 && this.data.getCalculationType() == col;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            int type = col;
            switch (row) {
                case 0: {
                    this.data.setSeuilHN(type, ConversionTime.heureStringToInt(value.toString(), "h"));
                    break;
                }
                case 1: {
                    this.data.setSeuilHE(type, ConversionTime.heureStringToInt(value.toString(), "h"));
                    break;
                }
                case 2: {
                    this.data.setSeuilHS25(type, ConversionTime.heureStringToInt(value.toString(), "h"));
                }
            }
            this.fireTableRowsUpdated(row, row);
        }

        public void setType(TypeContrat data) {
            this.data = data;
            this.fireTableDataChanged();
        }
    }
}

