/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.JourType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import transpo.system.TimsLogger;
import transpo.system.ui.editor.ColorEditor;
import transpo.system.ui.modele.TMDayType;
import transpo.system.ui.modele.TMFutureDayType;
import transpo.system.ui.renderer.ColorRenderer;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class DialogTypeJournee
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlChoix = null;
    private JButton btnEnregistrer = null;
    private JButton btnQuitter = null;
    private JButton btnNouveau = null;
    private JButton btnDelete = null;
    private JScrollPane jspTable = null;
    private JTable tblJour = null;
    private JTabbedPane pnlTbl;
    private JScrollPane jspFuture = null;
    private JTable tblFuture = null;
    private Vector<JourType> clone = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogTypeJournee.dispose()#");
        super.dispose();
    }

    public DialogTypeJournee(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogTypeJournee()#");
        this.initialize();
    }

    private void initialize() {
        this.setSize(850, 400);
        this.setTitle(LanguageTranslator.getString("dayType.title"));
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.weightx = 1.0;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.fill = 1;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.weighty = 1.0;
            gridBagConstraints13.gridy = 0;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.fill = 2;
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.weighty = 0.0;
            gridBagConstraints12.insets = new Insets(5, 0, 5, 0);
            gridBagConstraints12.gridy = 1;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlChoix(), gridBagConstraints12);
            this.jContentPane.add((Component)this.getPnlTbl(), gridBagConstraints1);
        }
        return this.jContentPane;
    }

    private JPanel getPnlChoix() {
        if (this.pnlChoix == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(0, 5, 5, 5);
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 2;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.weighty = 1.0;
            gridBagConstraints9.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints9.gridy = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.gridy = 1;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 3;
            gridBagConstraints10.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.weighty = 1.0;
            gridBagConstraints10.gridy = 1;
            this.pnlChoix = new JPanel();
            this.pnlChoix.setLayout(new GridBagLayout());
            if (ConnexionSettings.getInstance().isModifiable("DAY_TYPE")) {
                this.pnlChoix.add((Component)this.getBtnEnregistrer(), gridBagConstraints10);
            }
            if (ConnexionSettings.getInstance().isAjoutable("DAY_TYPE")) {
                this.pnlChoix.add((Component)this.getBtnNouveau(), gridBagConstraints);
            }
            if (ConnexionSettings.getInstance().isSupprimable("DAY_TYPE")) {
                this.pnlChoix.add((Component)this.getBtnDelete(), gridBagConstraints9);
            }
            this.pnlChoix.add((Component)this.getBtnQuitter(), gridBagConstraints7);
        }
        return this.pnlChoix;
    }

    private Vector<JourType> getClone() {
        if (this.clone == null) {
            this.clone = new Vector();
            Vector<JourType> original = JourType.getList();
            for (JourType originalta : original) {
                this.clone.add((JourType)originalta.clone());
            }
        }
        return this.clone;
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogTypeJournee.this.save()) {
                        DialogTypeJournee.this.dispose();
                    }
                }
            });
        }
        return this.btnEnregistrer;
    }

    public boolean check(JourType toCheck) {
        boolean toReturn = true;
        if (toCheck.getCode().length() > 6) {
            this.getTblJour().setBackground(new Color(255, 192, 203));
            this.getTblJour().setToolTipText(LanguageTranslator.getString("generics.maxAuthorised", "6"));
            toReturn = false;
        } else {
            this.getTblJour().setBackground(Color.white);
        }
        return toReturn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean save() {
        try {
            this.commit();
            BddTransport.getInstance().startTransaction();
            TMDayType tmp = (TMDayType)this.getTblJour().getModel();
            Vector<JourType> tmpJour = JourType.getList();
            int x = 0;
            int delx = 0;
            while (x < tmpJour.size()) {
                JourType typeJour;
                JourType jourType = typeJour = x - delx < tmp.getRowCount() ? tmp.getRow(x - delx) : null;
                if (typeJour == null || typeJour.getCle() != tmpJour.get(x).getCle()) {
                    tmpJour.get(x).delete();
                    ++delx;
                } else {
                    if (!this.check(typeJour)) {
                        BddTransport.getInstance().rollback();
                        return false;
                    }
                    tmpJour.get(x).compareAndUpdate(typeJour.getDesignation(), typeJour.getCode(), typeJour.getColor(), typeJour.getService(), typeJour.isPaid(), typeJour.isGenerateHS(), typeJour.isGenerateRC(), typeJour.isDelete(), typeJour.getFutureService(), typeJour.isWillBePaid(), typeJour.isWillGenerateHS(), typeJour.isWillGenerateRC(), typeJour.getExport(), typeJour.isServiceIncluded(), typeJour.isAvgValue(), typeJour.getSenority());
                }
                ++x;
            }
            while (x - delx < tmp.getRowCount()) {
                if (!this.check(tmp.getRow(x - delx))) {
                    BddTransport.getInstance().rollback();
                    return false;
                }
                tmp.getRow(x - delx).update();
                ++x;
            }
            BddTransport.getInstance().commit();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void commit() {
        TimsLogger.verbose("#DialogTypeJournee# commit");
        int row = this.getTblJour().getSelectedRow();
        int column = this.getTblJour().getSelectedColumn();
        if (!this.getTblJour().isEditing()) {
            TimsLogger.verbose("not editing a cell");
        } else {
            TimsLogger.verbose("STOP EDITING " + row + " : " + column);
            this.getTblJour().getCellEditor(row, column).stopCellEditing();
        }
        if (ConnexionSettings.getInstance().isConsultable("CAL_PREVISION")) {
            row = this.getTblFuture().getSelectedRow();
            column = this.getTblFuture().getSelectedColumn();
            if (!this.getTblFuture().isEditing()) {
                TimsLogger.verbose("not editing a cell");
            } else {
                TimsLogger.verbose("STOP EDITING " + row + " : " + column);
                this.getTblFuture().getCellEditor(row, column).stopCellEditing();
            }
        }
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogTypeJournee.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JButton getBtnNouveau() {
        if (this.btnNouveau == null) {
            this.btnNouveau = new JButton();
            this.btnNouveau.setText(LanguageTranslator.getString("button.new"));
            this.btnNouveau.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogTypeJournee.this.newLine();
                }
            });
        }
        return this.btnNouveau;
    }

    public void newLine() {
        JourType toAdd = new JourType();
        ((TMDayType)this.getTblJour().getModel()).addRow(toAdd);
    }

    private JButton getBtnDelete() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton();
            this.btnDelete.setText(LanguageTranslator.getString("button.delete"));
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = DialogTypeJournee.this.getTblJour().getSelectedRow();
                    ((TMDayType)DialogTypeJournee.this.getTblJour().getModel()).removeRow(row);
                }
            });
        }
        return this.btnDelete;
    }

    private JScrollPane getJspTable() {
        if (this.jspTable == null) {
            this.jspTable = new JScrollPane();
            this.jspTable.setViewportView(this.getTblJour());
        }
        return this.jspTable;
    }

    private JTable getTblJour() {
        if (this.tblJour == null) {
            this.tblJour = new JTable();
            this.tblJour.setModel(new TMDayType(this.getClone()));
            this.tblJour.setDefaultRenderer(Color.class, new ColorRenderer(true));
            this.tblJour.setDefaultEditor(Color.class, new ColorEditor());
        }
        return this.tblJour;
    }

    private JTabbedPane getPnlTbl() {
        if (this.pnlTbl == null) {
            this.pnlTbl = new JTabbedPane();
            this.pnlTbl.addTab(LanguageTranslator.getString("dayType.parameters"), this.getJspTable());
            if (ConnexionSettings.getInstance().isConsultable("CAL_PREVISION")) {
                this.pnlTbl.addTab(LanguageTranslator.getString("dayType.futureParameters"), this.getJspFuture());
            }
        }
        return this.pnlTbl;
    }

    private JScrollPane getJspFuture() {
        if (this.jspFuture == null) {
            this.jspFuture = new JScrollPane();
            this.jspFuture.setViewportView(this.getTblFuture());
        }
        return this.jspFuture;
    }

    private JTable getTblFuture() {
        if (this.tblFuture == null) {
            this.tblFuture = new JTable();
            this.tblFuture.setModel(new TMFutureDayType(this.getClone()));
            this.tblFuture.setDefaultRenderer(Color.class, new ColorRenderer(true));
            this.tblFuture.setDefaultEditor(Color.class, new ColorEditor());
        }
        return this.tblFuture;
    }
}

