/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.JourType;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.PopupCaller;

public class ListPopup
extends JPopupMenu
implements DataListener {
    JList list = null;
    JTextField txtTime = null;
    MouseListener lsl = null;
    Object selected = null;
    Vector<?> object = null;
    ActiviteConducteur focused = null;

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        BddEvent e;
        if (dataEvent instanceof BddEvent && (e = (BddEvent)dataEvent).getTable().equals(JourType.table)) {
            this.getList().setModel(new ComboBoxModel(JourType.getList(), true, LanguageTranslator.getString("generics.none")));
        }
    }

    public ListPopup(Vector<?> object) {
        this.object = object;
        this.initialize();
    }

    @Override
    public void show(Component invoker, int x, int y) {
        if (!(invoker instanceof PopupCaller)) {
            TimsLogger.debug("ListPopup must be invoked by a class which is implementing ListPopupCaller");
            return;
        }
        super.show(invoker, x, y);
    }

    public void initialize() {
        this.add(this.getTxtTime());
        this.add(this.getList());
    }

    public void setActivity(ActiviteConducteur focused) {
        this.focused = focused;
        this.getTxtTime().setText(ConversionTime.heureIntToString(focused.getHeureDebut(), "h"));
    }

    public int getHour() {
        return ConversionTime.heureStringToInt(this.getTxtTime().getText(), "h");
    }

    public JList getList() {
        if (this.list == null) {
            this.list = new JList(new ComboBoxModel(this.object, true, LanguageTranslator.getString("generics.none")));
        }
        return this.list;
    }

    public JTextField getTxtTime() {
        if (this.txtTime == null) {
            this.txtTime = new JTextField();
        }
        return this.txtTime;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            this.getList().removeMouseListener(this.getMouseListener());
        }
        if (visible) {
            this.getList().addMouseListener(this.getMouseListener());
        }
        super.setVisible(visible);
    }

    public void saveAndExit() {
        this.selected = ((ComboBoxModel)this.getList().getModel()).getObjectAt(this.getList().getSelectedIndex());
        if (this.getHour() < this.focused.getHeureDebut() || this.getHour() > this.focused.getHeureFin()) {
            this.getTxtTime().setBackground(new Color(255, 192, 203));
            this.getTxtTime().setText(ConversionTime.heureIntToString(this.focused.getHeureDebut(), "h"));
            this.getTxtTime().setToolTipText(LanguageTranslator.getString("generics.hourBetween", ConversionTime.heureIntToString(this.focused.getHeureDebut(), "h"), ConversionTime.heureIntToString(this.focused.getHeureFin(), "h")));
        } else {
            this.getTxtTime().setBackground(Color.white);
            this.setVisible(false);
            ((PopupCaller)((Object)this.getInvoker())).submitPopup();
        }
    }

    public MouseListener getMouseListener() {
        if (this.lsl == null) {
            this.lsl = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        ListPopup.this.saveAndExit();
                    }
                }
            };
        }
        return this.lsl;
    }

    public Object getSelected() {
        return this.selected;
    }
}

