/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.OffencePart;
import fr.pgh.data.bdd.OffenceThreshold;
import fr.pgh.data.bdd.OffenceType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class OffenceRules
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JScrollPane jspList = null;
    private JScrollPane jspDetail = null;
    private OffenceType currentOffence = null;
    private JList listOffences = null;
    private JPanel pnlBtn = null;
    private JButton btnSave = null;
    private JButton btnQuit = null;
    private JPanel pnlDetail = null;
    private ArrayList<ThresholdPnl> tresholdsPnl = null;
    private int memberStateFilter = 0;

    public OffenceRules(Frame owner, int memberStateFilter) {
        super(owner);
        this.memberStateFilter = memberStateFilter;
        this.initialize();
    }

    private void initialize() {
        this.setSize(600, 400);
        this.setTitle(LanguageTranslator.getString("offence.type"));
        this.setLocationRelativeTo(this.getParent());
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJspList(), "West");
            this.jContentPane.add((Component)this.getJspDetail(), "Center");
            this.jContentPane.add((Component)this.getPnlBtn(), "South");
        }
        return this.jContentPane;
    }

    private JScrollPane getJspList() {
        if (this.jspList == null) {
            this.jspList = new JScrollPane();
            this.jspList.setPreferredSize(new Dimension(200, 100));
            this.jspList.setViewportView(this.getListOffences());
        }
        return this.jspList;
    }

    private JScrollPane getJspDetail() {
        if (this.jspDetail == null) {
            this.jspDetail = new JScrollPane();
            this.jspDetail.setViewportView(this.getPnlDetail());
        }
        return this.jspDetail;
    }

    private JList getListOffences() {
        if (this.listOffences == null) {
            this.listOffences = new JList();
            this.listOffences.setModel(new ComboBoxModel(OffenceType.loadList(this.memberStateFilter), true, null));
            this.listOffences.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int index = OffenceRules.this.getListOffences().getSelectedIndex();
                    OffenceRules.this.currentOffence = (OffenceType)((ComboBoxModel)OffenceRules.this.getListOffences().getModel()).getObjectAt(index);
                    OffenceRules.this.load();
                }
            });
        }
        return this.listOffences;
    }

    public void load() {
        if (this.tresholdsPnl == null) {
            this.tresholdsPnl = new ArrayList();
        }
        this.tresholdsPnl.clear();
        this.getPnlDetail().removeAll();
        this.getPnlDetail().setLayout(new GridLayout(this.currentOffence.getParts().size(), 1));
        for (OffencePart part : this.currentOffence.getParts()) {
            this.getPnlDetail().add(this.buildPnl(part));
        }
        this.getPnlDetail().revalidate();
        this.getPnlDetail().repaint();
    }

    public JPanel buildPnl(OffencePart part) {
        JPanel toBuild = new JPanel();
        toBuild.setBorder(new TitledBorder(LanguageTranslator.getString(part.getName())));
        toBuild.setLayout(new GridLayout(part.getThresholds().size(), 1));
        for (OffenceThreshold threshold : part.getThresholds()) {
            ThresholdPnl toAdd = new ThresholdPnl(threshold);
            toBuild.add(toAdd);
            this.tresholdsPnl.add(toAdd);
        }
        return toBuild;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(5, 5, 5, 0);
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.gridx = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridx = 1;
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.add((Component)this.getBtnSave(), gridBagConstraints);
            this.pnlBtn.add((Component)this.getBtnQuit(), gridBagConstraints1);
        }
        return this.pnlBtn;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton();
            this.btnSave.setText(LanguageTranslator.getString("button.save"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OffenceRules.this.saveThresholds();
                }
            });
        }
        return this.btnSave;
    }

    public void saveThresholds() {
        boolean succeed = true;
        for (ThresholdPnl pnl : this.tresholdsPnl) {
            if (pnl.save()) continue;
            succeed = false;
        }
        if (succeed) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("offence.updated"), LanguageTranslator.getString("message.saveSucceed"), 1);
        }
    }

    private JButton getBtnQuit() {
        if (this.btnQuit == null) {
            this.btnQuit = new JButton();
            this.btnQuit.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OffenceRules.this.dispose();
                }
            });
        }
        return this.btnQuit;
    }

    private JPanel getPnlDetail() {
        if (this.pnlDetail == null) {
            this.pnlDetail = new JPanel();
        }
        return this.pnlDetail;
    }

    class ThresholdPnl
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private OffenceThreshold threshold = null;
        private JTextField value = null;

        public ThresholdPnl(OffenceThreshold threshold) {
            this.threshold = threshold;
            this.initialize();
        }

        public void initialize() {
            if (this.threshold == null) {
                return;
            }
            this.add(new JLabel(LanguageTranslator.getString(this.threshold.getName())));
            this.add(this.getValue());
            if (this.threshold.getInfrigement() != 0) {
                this.add(new JLabel(LanguageTranslator.getString("offence.cost", String.valueOf(this.threshold.getInfrigementClass()), String.valueOf(this.threshold.getInfrigement()), this.threshold.getReference())));
            }
        }

        public JTextField getValue() {
            if (this.value == null) {
                this.value = new JTextField();
                this.value.setPreferredSize(new Dimension(45, 20));
                if (this.threshold != null) {
                    if (this.threshold.getName().equals("offence.threshold.dayCount")) {
                        this.value.setText(String.valueOf(this.threshold.getThreshold()));
                    } else {
                        this.value.setText(ConversionTime.heureIntToString(this.threshold.getThreshold(), "h"));
                    }
                }
            }
            return this.value;
        }

        public boolean save() {
            boolean toReturn = true;
            int intVal = 0;
            intVal = this.threshold.getName().equals("offence.threshold.dayCount") ? Integer.parseInt(this.getValue().getText()) : ConversionTime.heureStringToInt(this.getValue().getText(), "h");
            if (!this.threshold.compareAndUpdate(this.threshold.getOffencePartId(), this.threshold.getName(), intVal)) {
                toReturn = false;
            }
            return toReturn;
        }
    }
}

