/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.bdd.MainPanelFault;
import fr.pgh.data.bdd.UserWidget;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import transpo.system.LicenceManager;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.ViewPanel;
import transpo.system.ui.modele.TMMainPanelFault;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.PopupCaller;
import transpo.system.ui.views.WidgetPopup;
import transpo.system.ui.views.widget.ConflictWidget;
import transpo.system.ui.views.widget.DriverCardExpirationWidget;
import transpo.system.ui.views.widget.DriverDownloadWidget;
import transpo.system.ui.views.widget.TimsWidget;
import transpo.system.ui.views.widget.VehicleDownloadWidget;
import transpo.system.ui.views.widget.WidgetFactory;

public class PnlAccueil
extends ViewPanel {
    private static final long serialVersionUID = 1L;
    private static String STRING_NO_DL = "1970-01-01 00:00:00.0";
    private JButton boutonDepassement = null;
    private JButton boutonAbsences = null;
    private JPanel panelDepassement = null;
    private JPanel panelAbsences = null;
    private JPanel pnlFault = null;
    private JScrollPane jspFault = null;
    private JTable tblFault = null;
    JButton[] btnEdit = new JButton[4];
    ArrayList<TimsWidget> timsWidget = null;
    private WidgetPopup widgetChanger = null;

    private void initialize() {
        TimsWidget tt;
        this.removeAll();
        this.timsWidget = new ArrayList();
        GridLayout gridLayout = new GridLayout();
        gridLayout.setRows(2);
        gridLayout.setColumns(2);
        this.setLayout(gridLayout);
        this.timsWidget.add(new DriverDownloadWidget());
        if (LicenceManager.isExploitationLevel()) {
            tt = new ConflictWidget();
            tt.setBtnEdit(new JButton("ee"));
            this.timsWidget.add(tt);
        }
        tt = new VehicleDownloadWidget();
        tt.setBtnEdit(new JButton("ee"));
        this.timsWidget.add(tt);
        if (LicenceManager.isExploitationLevel()) {
            this.timsWidget.add(new DriverCardExpirationWidget());
        }
        ArrayList<UserWidget> widgets = UserWidget.getList(ConnexionSettings.getInstance().getUserCle());
        for (UserWidget widget : widgets) {
            if (widget.getWidgetId() == 0) continue;
            this.timsWidget.set(widget.getPosition() - 1, WidgetFactory.getWidget(widget.getWidgetId()));
        }
        int x = 0;
        for (TimsWidget toAdd : this.timsWidget) {
            this.btnEdit[x] = new BtnChange(x + 1);
            toAdd.setBtnEdit(this.btnEdit[x]);
            this.add((Component)toAdd.build(), null);
            ++x;
        }
        this.validate();
    }

    public void addWidget(TimsWidget widget) {
        this.add(widget.build());
    }

    @Override
    public String getViewName() {
        return LanguageTranslator.getString("dashboard.title");
    }

    @Override
    public void refresh() {
    }

    @Override
    public String getMnemo() {
        return "";
    }

    @Override
    public void close() {
    }

    @Override
    public void loadData() {
        if (!this.load) {
            this.load = true;
        }
    }

    public PnlAccueil() {
        this.initialize();
    }

    public void reload() {
        for (TimsWidget toAdd : this.timsWidget) {
            toAdd.load();
        }
    }

    private JButton getBoutonDepassement() {
        if (this.boutonDepassement == null) {
            this.boutonDepassement = new JButton();
            this.boutonDepassement.setText("Depassement d'heures");
            this.boutonDepassement.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
        }
        return this.boutonDepassement;
    }

    private JButton getBoutonAbsences() {
        if (this.boutonAbsences == null) {
            this.boutonAbsences = new JButton();
            this.boutonAbsences.setText("Absences injustifi\u00e9es");
            this.boutonAbsences.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
        }
        return this.boutonAbsences;
    }

    private JPanel getPanelDepassement() {
        if (this.panelDepassement == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.anchor = 15;
            gridBagConstraints6.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.weighty = 1.0;
            gridBagConstraints6.gridy = 1;
            this.panelDepassement = new JPanel();
            this.panelDepassement.setBorder(BorderFactory.createTitledBorder("Depassement de contrat"));
            this.panelDepassement.setLayout(new GridBagLayout());
            this.panelDepassement.add((Component)this.getBoutonDepassement(), gridBagConstraints6);
        }
        return this.panelDepassement;
    }

    private JPanel getPanelAbsences() {
        if (this.panelAbsences == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 14;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.anchor = 15;
            gridBagConstraints3.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.gridy = 2;
            this.panelAbsences = new JPanel();
            this.panelAbsences.setBorder(BorderFactory.createTitledBorder("Absences non renseign\u00e9es"));
            this.panelAbsences.setLayout(new GridBagLayout());
            this.panelAbsences.add((Component)this.getBoutonAbsences(), gridBagConstraints3);
        }
        return this.panelAbsences;
    }

    private JPanel getPnlFault() {
        if (this.pnlFault == null) {
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.fill = 1;
            gridBagConstraints13.gridy = 0;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.weighty = 1.0;
            gridBagConstraints13.gridx = 0;
            this.pnlFault = new JPanel();
            this.pnlFault.setBorder(BorderFactory.createTitledBorder(LanguageTranslator.getString("dashboard.driverFault")));
            this.pnlFault.setLayout(new GridBagLayout());
            this.pnlFault.setPreferredSize(new Dimension(284, 83));
            this.pnlFault.add((Component)this.getJspFault(), gridBagConstraints13);
        }
        return this.pnlFault;
    }

    private JScrollPane getJspFault() {
        if (this.jspFault == null) {
            this.jspFault = new JScrollPane();
            this.jspFault.setViewportView(this.getTblFault());
        }
        return this.jspFault;
    }

    private JTable getTblFault() {
        if (this.tblFault == null) {
            this.tblFault = new JTable();
            this.tblFault.setModel(new TMMainPanelFault(MainPanelFault.loadList(0, null, null)));
        }
        return this.tblFault;
    }

    private WidgetPopup getWidgetChanger() {
        if (this.widgetChanger == null) {
            this.widgetChanger = new WidgetPopup();
        }
        return this.widgetChanger;
    }

    class BtnChange
    extends JButton
    implements PopupCaller {
        private int index = 1;

        public BtnChange(int index) {
            this.index = index;
            this.setPreferredSize(new Dimension(25, 25));
            this.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_refresh"))));
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setToolTipText(LanguageTranslator.getString("button.show"));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    BtnChange.this.callPopup(e);
                }
            });
        }

        @Override
        public void callPopup(MouseEvent e) {
            TimsLogger.debug("callPopup" + e.getX() + " " + e.getY());
            PnlAccueil.this.getWidgetChanger().show((Component)e.getSource(), MouseInfo.getPointerInfo().getLocation().x, MouseInfo.getPointerInfo().getLocation().y);
        }

        @Override
        public void submitPopup() {
            boolean exist = false;
            TimsLogger.debug("submitPopup" + PnlAccueil.this.getWidgetChanger().getSelected() + " selected for " + this.index);
            ArrayList<UserWidget> widgets = UserWidget.getList(ConnexionSettings.getInstance().getUserCle());
            for (UserWidget widget : widgets) {
                if (widget.getPosition() != this.index) continue;
                TimsLogger.debug("PnlAccueil.BtnChange.submit # Replace " + this.index);
                exist = true;
                if (PnlAccueil.this.getWidgetChanger().getSelected() == 0) {
                    widget.delete();
                    continue;
                }
                widget.setWidgetId(PnlAccueil.this.getWidgetChanger().getSelected());
                widget.update();
            }
            if (!exist) {
                new UserWidget(0, PnlAccueil.this.getWidgetChanger().getSelected(), ConnexionSettings.getInstance().getUserCle(), this.index).insert();
                TimsLogger.debug("PnlAccueil.BtnChange.submit # Creat " + this.index);
            }
            PnlAccueil.this.initialize();
        }
    }
}

