/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.connexion.ConnexionSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public abstract class PnlAttachment
extends JPanel {
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 2;
    private int buttonStyle = 1;
    private JScrollPane jspAttachment = null;
    private JList listAttachment = null;
    private JButton btnLoadAttachment = null;
    private JButton btnAddAttachment = null;
    private JButton btnExportAttachment = null;
    private JButton btnShowAttachment = null;
    private JButton btnDeleteAttachment = null;

    public PnlAttachment() {
        this.initialize();
    }

    public PnlAttachment(int buttonStyle) {
        this.buttonStyle = buttonStyle;
        this.initialize();
    }

    private void initialize() {
        int x = 1;
        int y = 0;
        int gridx = 5;
        int gridy = 1;
        boolean weightXBtn = false;
        boolean weightYBtn = true;
        if (this.buttonStyle == 2) {
            x = 0;
            y = 1;
            gridx = 1;
            gridy = 5;
            weightXBtn = true;
            weightYBtn = false;
        }
        GridBagConstraints l0c0 = Fonctions.getGridBagConstraints(0, 0, gridx, gridy, 1.0, 1.0, 1, -1, new Insets(0, 2, 0, 2));
        GridBagConstraints l0c1 = Fonctions.getGridBagConstraints(x, y, 1, 1, (double)weightXBtn, 0.0, 0, 13, new Insets(1, 2, 1, 2));
        if (this.buttonStyle == 2) {
            ++x;
        } else {
            ++y;
        }
        GridBagConstraints l1c1 = Fonctions.getGridBagConstraints(x, y, 1, 1, 0.0, 0.0, 0, -1, new Insets(1, 2, 1, 2));
        if (this.buttonStyle == 2) {
            ++x;
        } else {
            ++y;
        }
        GridBagConstraints l2c1 = Fonctions.getGridBagConstraints(x, y, 1, 1, 0.0, 0.0, 0, -1, new Insets(1, 2, 1, 2));
        if (this.buttonStyle == 2) {
            ++x;
        } else {
            ++y;
        }
        GridBagConstraints l3c1 = Fonctions.getGridBagConstraints(x, y, 1, 1, 0.0, 0.0, 0, -1, new Insets(1, 0, 1, 2));
        if (this.buttonStyle == 2) {
            ++x;
        } else {
            ++y;
        }
        GridBagConstraints l4c1 = Fonctions.getGridBagConstraints(x, y, 1, 1, 0.0, (double)weightYBtn, 0, 15, new Insets(1, 2, 1, 2));
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.attachment"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        this.add((Component)this.getJspAttachment(), l0c0);
        this.add((Component)this.getBtnLoadAttachment(), l0c1);
        this.add((Component)this.getBtnShowAttachment(), l2c1);
        if (ConnexionSettings.getInstance().isModifiable("VEHICLE_ATTACHMENT")) {
            this.add((Component)this.getBtnExportAttachment(), l1c1);
        }
        if (ConnexionSettings.getInstance().isSupprimable("ATTACHMENT")) {
            this.add((Component)this.getBtnDeleteAttachment(), l3c1);
        }
        if (ConnexionSettings.getInstance().isAjoutable("ATTACHMENT")) {
            this.add((Component)this.getBtnAddAttachment(), l4c1);
        }
    }

    private JScrollPane getJspAttachment() {
        if (this.jspAttachment == null) {
            this.jspAttachment = new JScrollPane();
            this.jspAttachment.setViewportView(this.getListAttachment());
        }
        return this.jspAttachment;
    }

    public JList getListAttachment() {
        if (this.listAttachment == null) {
            this.listAttachment = new JList();
        }
        return this.listAttachment;
    }

    public JButton getBtnLoadAttachment() {
        if (this.btnLoadAttachment == null) {
            this.btnLoadAttachment = new JButton();
            this.btnLoadAttachment.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_refresh"))));
            this.btnLoadAttachment.setPreferredSize(new Dimension(25, 25));
            this.btnLoadAttachment.setMinimumSize(new Dimension(25, 25));
            this.btnLoadAttachment.setToolTipText(LanguageTranslator.getString("button.load"));
            this.btnLoadAttachment.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlAttachment.this.loadAttachment();
                }
            });
        }
        return this.btnLoadAttachment;
    }

    public JButton getBtnShowAttachment() {
        if (this.btnShowAttachment == null) {
            this.btnShowAttachment = new JButton();
            this.btnShowAttachment.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_loupe"))));
            this.btnShowAttachment.setPreferredSize(new Dimension(25, 25));
            this.btnShowAttachment.setMinimumSize(new Dimension(25, 25));
            this.btnShowAttachment.setToolTipText(LanguageTranslator.getString("button.show"));
        }
        return this.btnShowAttachment;
    }

    public JButton getBtnExportAttachment() {
        if (this.btnExportAttachment == null) {
            this.btnExportAttachment = new JButton();
            this.btnExportAttachment.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_save"))));
            this.btnExportAttachment.setPreferredSize(new Dimension(25, 25));
            this.btnExportAttachment.setMinimumSize(new Dimension(25, 25));
            this.btnExportAttachment.setToolTipText(LanguageTranslator.getString("button.export"));
        }
        return this.btnExportAttachment;
    }

    public JButton getBtnAddAttachment() {
        if (this.btnAddAttachment == null) {
            this.btnAddAttachment = new JButton();
            this.btnAddAttachment.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_cliq"))));
            this.btnAddAttachment.setPreferredSize(new Dimension(25, 25));
            this.btnAddAttachment.setMinimumSize(new Dimension(25, 25));
            this.btnAddAttachment.setToolTipText(LanguageTranslator.getString("button.add"));
            this.btnAddAttachment.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlAttachment.this.addAttachment();
                }
            });
        }
        return this.btnAddAttachment;
    }

    public JButton getBtnDeleteAttachment() {
        if (this.btnDeleteAttachment == null) {
            this.btnDeleteAttachment = new JButton();
            this.btnDeleteAttachment.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_sup"))));
            this.btnDeleteAttachment.setPreferredSize(new Dimension(25, 25));
            this.btnDeleteAttachment.setMinimumSize(new Dimension(25, 25));
            this.btnDeleteAttachment.setToolTipText(LanguageTranslator.getString("button.delete"));
            this.btnDeleteAttachment.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlAttachment.this.deleteAttachment();
                }
            });
        }
        return this.btnDeleteAttachment;
    }

    public abstract void loadAttachment();

    public abstract void addAttachment();

    public abstract void deleteAttachment();
}

