/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Region;
import fr.pgh.data.bdd.Societe;
import fr.pgh.data.bdd.Utilisateur;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.modele.LMAgency;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class PnlRestrictionAgence
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton btnSupprimer = null;
    private JButton btnAjouter = null;
    private JPanel pnlRes = null;
    private JPanel pnlDispo = null;
    private JScrollPane jspDispo = null;
    private JScrollPane jspRes = null;
    private JList listAgencies = null;
    private JList lisrRestrictions = null;
    public boolean change = false;

    public PnlRestrictionAgence() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 1;
        gridBagConstraints12.weighty = 1.0;
        gridBagConstraints12.insets = new Insets(0, 2, 5, 2);
        gridBagConstraints12.anchor = 15;
        gridBagConstraints12.gridy = 0;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridwidth = 3;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints1.gridy = 0;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.gridheight = 2;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.gridy = 0;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridheight = 2;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.gridy = 0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = new Insets(5, 2, 0, 2);
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.gridy = 1;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getBtnAjouter(), gridBagConstraints2);
        this.add((Component)this.getPnlRes(), gridBagConstraints3);
        this.add((Component)this.getPnlDispo(), gridBagConstraints4);
        this.add((Component)this.getBtnSupprimer(), gridBagConstraints12);
    }

    private JButton getBtnSupprimer() {
        if (this.btnSupprimer == null) {
            this.btnSupprimer = new JButton();
            this.btnSupprimer.setPreferredSize(new Dimension(32, 32));
            this.btnSupprimer.setFocusable(false);
            this.btnSupprimer.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_right"))));
            this.btnSupprimer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int indexSelected = PnlRestrictionAgence.this.getLisrRestrictions().getSelectedIndex();
                    if (indexSelected != -1) {
                        PnlRestrictionAgence.this.getVisibleAgenciesModel().remove(indexSelected);
                        PnlRestrictionAgence.this.change = true;
                    }
                }
            });
        }
        return this.btnSupprimer;
    }

    private JButton getBtnAjouter() {
        if (this.btnAjouter == null) {
            this.btnAjouter = new JButton();
            this.btnAjouter.setPreferredSize(new Dimension(32, 32));
            this.btnAjouter.setFocusable(false);
            this.btnAjouter.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_left"))));
            this.btnAjouter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int indexSelected = PnlRestrictionAgence.this.getListAgencies().getSelectedIndex();
                    if (indexSelected != -1) {
                        Object test2 = PnlRestrictionAgence.this.getAgenciesModel().getElementAt(indexSelected);
                        if (test2 instanceof Agence) {
                            if (!PnlRestrictionAgence.this.getVisibleAgenciesModel().contains(test2)) {
                                PnlRestrictionAgence.this.getVisibleAgenciesModel().addElement(test2);
                            }
                        } else if (test2 instanceof Region) {
                            test2 = PnlRestrictionAgence.this.getAgenciesModel().getElementAt(++indexSelected);
                            while (test2 != null && test2 instanceof Agence) {
                                if (!PnlRestrictionAgence.this.getVisibleAgenciesModel().contains(test2)) {
                                    PnlRestrictionAgence.this.getVisibleAgenciesModel().addElement(test2);
                                }
                                test2 = ++indexSelected < PnlRestrictionAgence.this.getAgenciesModel().getSize() ? PnlRestrictionAgence.this.getAgenciesModel().getElementAt(indexSelected) : null;
                            }
                        }
                        PnlRestrictionAgence.this.change = true;
                    }
                }
            });
        }
        return this.btnAjouter;
    }

    private JPanel getPnlRes() {
        if (this.pnlRes == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.weighty = 1.0;
            gridBagConstraints6.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints6.gridx = 0;
            this.pnlRes = new JPanel();
            this.pnlRes.setLayout(new GridBagLayout());
            this.pnlRes.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("agency.visible"), 2, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlRes.add((Component)this.getJspRes(), gridBagConstraints6);
        }
        return this.pnlRes;
    }

    private JPanel getPnlDispo() {
        if (this.pnlDispo == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints5.gridx = 0;
            this.pnlDispo = new JPanel();
            this.pnlDispo.setLayout(new GridBagLayout());
            this.pnlDispo.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.agency"), 2, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlDispo.add((Component)this.getJspDispo(), gridBagConstraints5);
        }
        return this.pnlDispo;
    }

    private JScrollPane getJspDispo() {
        if (this.jspDispo == null) {
            this.jspDispo = new JScrollPane();
            this.jspDispo.setViewportView(this.getListAgencies());
        }
        return this.jspDispo;
    }

    private JScrollPane getJspRes() {
        if (this.jspRes == null) {
            this.jspRes = new JScrollPane();
            this.jspRes.setViewportView(this.getLisrRestrictions());
        }
        return this.jspRes;
    }

    private JList getListAgencies() {
        if (this.listAgencies == null) {
            this.listAgencies = new JList();
            this.listAgencies.setSize(new Dimension(154, 80));
            this.listAgencies.setCellRenderer(new ListRestrictionRenderer());
        }
        return this.listAgencies;
    }

    private JList getLisrRestrictions() {
        if (this.lisrRestrictions == null) {
            this.lisrRestrictions = new JList();
            this.lisrRestrictions.setSize(new Dimension(154, 80));
            this.lisrRestrictions.setCellRenderer(new ListRestrictionRenderer());
            this.lisrRestrictions.setModel(new LMAgency(new Vector<Agence>()));
        }
        return this.lisrRestrictions;
    }

    public void load(Societe soc, Utilisateur user) {
        this.change = false;
        Vector<Agence> listeDispo = Agence.loadListByRegion(soc.getNomBase());
        this.getListAgencies().setModel(new LMAgency(listeDispo));
        this.getLisrRestrictions().setModel(new LMAgency(new Vector<Agence>()));
        if (user != null && user.isRestreintAgence()) {
            int x = 0;
            while (x < user.getResAgence().size()) {
                Agence tmp = this.getAgenciesModel().getAgenceWithCle(user.getResAgence().get(x));
                if (tmp != null) {
                    this.getVisibleAgenciesModel().addElement(tmp);
                } else {
                    TimsLogger.warn("#PnlRectrictionAgence.load# unable to find restricted agency " + user.getResAgence().get(x) + " on " + soc.getNomSociete());
                }
                ++x;
            }
        }
    }

    public Vector<Integer> getVectorRestreint() {
        Vector<Integer> result = new Vector<Integer>();
        Vector<Agence> tmpRes = this.getVisibleAgenciesModel().getVector();
        int x = 0;
        while (x < tmpRes.size()) {
            result.add(tmpRes.get(x).getCleAgence());
            ++x;
        }
        return result;
    }

    public boolean hasChanged() {
        return this.change;
    }

    private LMAgency getAgenciesModel() {
        return (LMAgency)this.getListAgencies().getModel();
    }

    private LMAgency getVisibleAgenciesModel() {
        return (LMAgency)this.getLisrRestrictions().getModel();
    }

    public class ListRestrictionRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setBackground(list.getBackground());
            }
            if (value instanceof Agence) {
                this.setFont(new Font("Arial", 0, 10));
                this.setText(value.toString());
                this.setForeground(Color.BLACK);
            }
            if (value instanceof Region) {
                this.setFont(new Font("Arial", 0, 11).deriveFont(3));
                this.setText("   " + value.toString());
                this.setForeground(Color.GRAY);
            }
            return this;
        }
    }
}

