/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.admin;

import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.AutomaticWarning;
import fr.pgh.data.bdd.CompanyWarningActivation;
import fr.pgh.data.bdd.Configuration;
import fr.pgh.data.dao.factory.DAOFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.TMCompanyAlert;
import transpo.system.ui.modele.TMConfiguration;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class CompanyAdministration
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlCompany = null;
    private JPanel pnlSettings = null;
    private JButton btnSave = null;
    private JButton btnQuit = null;
    private JScrollPane jsp = null;
    private JButton btnExport = null;
    private JPanel pnlBtn = null;
    private JScrollPane jspTable = null;
    private JTable tblParameters = null;
    private JPanel pnlAutomaticWarning = null;
    private JScrollPane jsp2 = null;
    private JTable tblAuto = null;

    public CompanyAdministration(Frame owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(LanguageTranslator.getString("user.admin.title"));
        this.setBounds(new Rectangle(0, 0, 800, 500));
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gcbAuto = Fonctions.getGridBagConstraints(2, 0, 1, 1, 2.0, 1.0, 1, -1, new Insets(10, 5, 10, 10));
            GridBagConstraints gcbBtn = Fonctions.getGridBagConstraints(0, 1, 1, 3, 0.0, 0.0, -1, -1, null);
            GridBagConstraints gcbSettings = Fonctions.getGridBagConstraints(1, 0, 1, 1, 4.0, 1.0, 1, -1, new Insets(10, 10, 10, 5));
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlSettings(), gcbSettings);
            this.jContentPane.add((Component)this.getPnlBtn(), gcbBtn);
            if (System.getProperty("URL") != null) {
                this.jContentPane.add((Component)this.getPnlAutomaticWarning(), gcbAuto);
            }
        }
        return this.jContentPane;
    }

    private JPanel getPnlSettings() {
        if (this.pnlSettings == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.gridx = 0;
            this.pnlSettings = new JPanel();
            this.pnlSettings.setLayout(new GridBagLayout());
            this.pnlSettings.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("company.config", BddTransport.getInstance().societeCourante.getNomSociete()), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlSettings.setPreferredSize(new Dimension(0, 0));
            this.pnlSettings.add((Component)this.getJspTable(), gridBagConstraints3);
        }
        return this.pnlSettings;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton();
            this.btnSave.setText(LanguageTranslator.getString("button.save"));
            this.btnSave.setMnemonic(0);
            this.btnSave.setPreferredSize(new Dimension(98, 26));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CompanyAdministration.this.save();
                }
            });
        }
        return this.btnSave;
    }

    public void save() {
        this.commit();
        ArrayList<CompanyWarningActivation> activation = ((TMCompanyAlert)this.getTblAuto().getModel()).getActivation();
        for (CompanyWarningActivation toActive : activation) {
            if (toActive.getId() != 0) continue;
            toActive.setCompanyId(BddTransport.getInstance().societeCourante.getCleSociete());
            toActive.insert();
        }
        this.dispose();
    }

    public void commit() {
        TimsLogger.verbose("#CompanyAdministration# commit");
        int row = this.getTblParameters().getSelectedRow();
        int column = this.getTblParameters().getSelectedColumn();
        if (this.getTblParameters().isEditing()) {
            this.getTblParameters().getCellEditor(row, column).stopCellEditing();
        }
    }

    private JButton getBtnQuit() {
        if (this.btnQuit == null) {
            this.btnQuit = new JButton();
            this.btnQuit.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CompanyAdministration.this.dispose();
                }
            });
        }
        return this.btnQuit;
    }

    private JButton getBtnExport() {
        if (this.btnExport == null) {
            this.btnExport = new JButton(LanguageTranslator.getString("button.export"));
            this.btnExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
        }
        return this.btnExport;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new FlowLayout());
            this.pnlBtn.add((Component)this.getBtnQuit(), null);
            this.pnlBtn.add((Component)this.getBtnExport(), null);
            this.pnlBtn.add((Component)this.getBtnSave(), null);
        }
        return this.pnlBtn;
    }

    private JScrollPane getJspTable() {
        if (this.jspTable == null) {
            this.jspTable = new JScrollPane();
            this.jspTable.setViewportView(this.getTblParameters());
        }
        return this.jspTable;
    }

    private JTable getTblParameters() {
        if (this.tblParameters == null) {
            this.tblParameters = new JTable();
            this.tblParameters.setModel(new TMConfiguration(this.editableFilter(Configuration.loadList(null, false))));
            this.tblParameters.getColumnModel().getColumn(1).setPreferredWidth(25);
        }
        return this.tblParameters;
    }

    private Vector<Configuration> editableFilter(Vector<Configuration> toFilter) {
        int x = 0;
        while (x < toFilter.size()) {
            if (!toFilter.get(x).isEditable()) {
                toFilter.remove(x);
                --x;
            }
            ++x;
        }
        return toFilter;
    }

    private JPanel getPnlAutomaticWarning() {
        if (this.pnlAutomaticWarning == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.gridx = 0;
            this.pnlAutomaticWarning = new JPanel();
            this.pnlAutomaticWarning.setLayout(new GridBagLayout());
            this.pnlAutomaticWarning.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("automatic"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlAutomaticWarning.add((Component)this.getJsp2(), gridBagConstraints4);
        }
        return this.pnlAutomaticWarning;
    }

    private JScrollPane getJsp2() {
        if (this.jsp2 == null) {
            this.jsp2 = new JScrollPane();
            this.jsp2.setViewportView(this.getTblAuto());
        }
        return this.jsp2;
    }

    private JTable getTblAuto() {
        if (this.tblAuto == null) {
            this.tblAuto = new JTable();
            this.tblAuto.setModel(new TMCompanyAlert(DAOFactory.getDAOAutomaticWarning().list()));
            this.tblAuto.getColumnModel().getColumn(1).setPreferredWidth(10);
            Fonctions.setCbEditor(this.tblAuto.getColumnModel().getColumn(2), AutomaticWarning.LIBELLE);
        }
        return this.tblAuto;
    }
}

