/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.admin;

import fr.pgh.component.JFittedComboBox;
import fr.pgh.connexion.TimsSession;
import fr.pgh.data.bdd.ContractState;
import fr.pgh.data.bdd.IcontactCompany;
import fr.pgh.data.bdd.IcontactRegion;
import fr.pgh.data.bdd.Utilisateur;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class DialogAdminCompany
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlListe = null;
    private JPanel pnlDetail = null;
    private JPanel pnlGeneral = null;
    private JScrollPane jpsListe = null;
    private JList listCompany = null;
    private JPanel pnlBtn = null;
    private JButton btnCreer = null;
    private JButton btnQuitter = null;
    private JButton btnEnregistrer = null;
    private JCheckBox cbClient = null;
    private JTextField txtName = null;
    private JTextField txtAddress = null;
    private JTextField txtPostal = null;
    private JTextField txtCity = null;
    private JTextField txtPhone = null;
    private JTextField txtFax = null;
    private JFittedComboBox cbRegion = null;
    private JTextField txtWeb = null;
    private JFittedComboBox cbManager = null;
    private JTextField txtContract = null;
    private JFittedComboBox cbContractState = null;
    private JTextField txtContractCost = null;
    private JScrollPane jspComm = null;
    private JTextArea txtComm = null;
    private JCheckBox cbFilterClient = null;
    private IcontactCompany current = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogAdminCompany.dispose()#");
        super.dispose();
    }

    public DialogAdminCompany(Frame owner) {
        super(owner);
        this.initialize();
        this.setModal(true);
        TimsSession.getInstance().addVisit(this.getClass().getName());
    }

    private void initialize() {
        this.setSize(750, 600);
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(LanguageTranslator.getString("generics.company"));
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.insets = new Insets(5, 0, 5, 5);
            gridBagConstraints1.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlListe(), gridBagConstraints);
            this.jContentPane.add((Component)this.getPnlDetail(), gridBagConstraints1);
        }
        return this.jContentPane;
    }

    private JPanel getPnlListe() {
        if (this.pnlListe == null) {
            this.pnlListe = new JPanel();
            this.pnlListe.setLayout(new GridBagLayout());
            this.pnlListe.setPreferredSize(new Dimension(120, 0));
            this.pnlListe.add((Component)this.getCbFilterClient(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 2, -1, null));
            this.pnlListe.add((Component)this.getJpsListe(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, -1, new Insets(0, 0, 5, 0)));
            this.pnlListe.add((Component)this.getBtnCreer(), Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 2, -1, null));
        }
        return this.pnlListe;
    }

    private JPanel getPnlDetail() {
        if (this.pnlDetail == null) {
            GridBagConstraints gridBagConstraints42 = new GridBagConstraints();
            gridBagConstraints42.gridx = 0;
            gridBagConstraints42.fill = 1;
            gridBagConstraints42.insets = new Insets(5, 0, 5, 0);
            gridBagConstraints42.weightx = 1.0;
            gridBagConstraints42.weighty = 1.0;
            gridBagConstraints42.gridwidth = 2;
            gridBagConstraints42.gridy = 2;
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            gridBagConstraints24.gridx = 0;
            gridBagConstraints24.weightx = 1.0;
            gridBagConstraints24.weighty = 0.0;
            gridBagConstraints24.fill = 1;
            gridBagConstraints24.gridwidth = 2;
            gridBagConstraints24.insets = new Insets(2, 0, 0, 0);
            gridBagConstraints24.anchor = 15;
            gridBagConstraints24.gridy = 15;
            this.pnlDetail = new JPanel();
            this.pnlDetail.setLayout(new GridBagLayout());
            this.pnlDetail.add((Component)this.getPnlBtn(), gridBagConstraints24);
            this.pnlDetail.add((Component)this.getPnlGeneral(), gridBagConstraints42);
        }
        return this.pnlDetail;
    }

    private JScrollPane getJpsListe() {
        if (this.jpsListe == null) {
            this.jpsListe = new JScrollPane();
            this.jpsListe.setPreferredSize(new Dimension(0, 0));
            this.jpsListe.setViewportView(this.getListCompany());
        }
        return this.jpsListe;
    }

    private JList getListCompany() {
        if (this.listCompany == null) {
            this.listCompany = new JList();
            this.listCompany.setModel(new ComboBoxModel(IcontactCompany.getList(this.getCbFilterClient().isSelected()), true, null));
            this.listCompany.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && DialogAdminCompany.this.getListCompany().getSelectedIndex() != -1) {
                        IcontactCompany selected = (IcontactCompany)((ComboBoxModel)DialogAdminCompany.this.getListCompany().getModel()).getObjectAt(DialogAdminCompany.this.getListCompany().getSelectedIndex());
                        DialogAdminCompany.this.load(selected);
                    }
                }
            });
        }
        return this.listCompany;
    }

    private JButton getBtnCreer() {
        if (this.btnCreer == null) {
            this.btnCreer = new JButton();
            this.btnCreer.setText(LanguageTranslator.getString("button.new"));
            this.btnCreer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAdminCompany.this.load(new IcontactCompany());
                }
            });
        }
        return this.btnCreer;
    }

    private JTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new JTextField();
        }
        return this.txtName;
    }

    private JTextField getTxtAddress() {
        if (this.txtAddress == null) {
            this.txtAddress = new JTextField();
            this.txtAddress.setPreferredSize(new Dimension(70, 20));
        }
        return this.txtAddress;
    }

    private JTextField getTxtPostal() {
        if (this.txtPostal == null) {
            this.txtPostal = new JTextField();
            this.txtPostal.setPreferredSize(new Dimension(70, 20));
        }
        return this.txtPostal;
    }

    private JTextField getTxtCity() {
        if (this.txtCity == null) {
            this.txtCity = new JTextField();
        }
        return this.txtCity;
    }

    private JTextField getTxtPhone() {
        if (this.txtPhone == null) {
            this.txtPhone = new JTextField();
            this.txtPhone.setPreferredSize(new Dimension(45, 20));
        }
        return this.txtPhone;
    }

    private JTextField getTxtFax() {
        if (this.txtFax == null) {
            this.txtFax = new JTextField();
        }
        return this.txtFax;
    }

    private JTextField getTxtWeb() {
        if (this.txtWeb == null) {
            this.txtWeb = new JTextField();
        }
        return this.txtWeb;
    }

    private JTextField getTxtContract() {
        if (this.txtContract == null) {
            this.txtContract = new JTextField();
        }
        return this.txtContract;
    }

    private JTextField getTxtContractCost() {
        if (this.txtContractCost == null) {
            this.txtContractCost = new JTextField();
        }
        return this.txtContractCost;
    }

    private JFittedComboBox getCbRegion() {
        if (this.cbRegion == null) {
            this.cbRegion = new JFittedComboBox();
            this.cbRegion.setMaxWidth(125);
            this.cbRegion.setModel(new ComboBoxModel(IcontactRegion.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbRegion;
    }

    private JFittedComboBox getCbManager() {
        if (this.cbManager == null) {
            this.cbManager = new JFittedComboBox();
            this.cbManager.setMaxWidth(125);
            this.cbManager.setModel(new ComboBoxModel(Utilisateur.list("PGH"), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbManager;
    }

    private JFittedComboBox getCbContractState() {
        if (this.cbContractState == null) {
            this.cbContractState = new JFittedComboBox();
            this.cbContractState.setMaxWidth(125);
            this.cbContractState.setModel(new ComboBoxModel(ContractState.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbContractState;
    }

    private JTextArea getTxtComm() {
        if (this.txtComm == null) {
            this.txtComm = new JTextArea();
            this.txtComm.setLineWrap(true);
            this.txtComm.setWrapStyleWord(true);
        }
        return this.txtComm;
    }

    private JScrollPane getJspComm() {
        if (this.jspComm == null) {
            this.jspComm = new JScrollPane();
            this.jspComm.setViewportView(this.getTxtComm());
        }
        return this.jspComm;
    }

    private JCheckBox getCbClient() {
        if (this.cbClient == null) {
            this.cbClient = new JCheckBox(LanguageTranslator.getString("generics.client"));
        }
        return this.cbClient;
    }

    private JCheckBox getCbFilterClient() {
        if (this.cbFilterClient == null) {
            this.cbFilterClient = new JCheckBox(LanguageTranslator.getString("generics.client.filter"));
            this.cbFilterClient.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DialogAdminCompany.this.updateList();
                }
            });
        }
        return this.cbFilterClient;
    }

    private void load(IcontactCompany toLoad) {
        this.current = toLoad;
        if (this.current == null) {
            this.getTxtComm().setText("");
            this.getTxtName().setText("");
            this.getTxtAddress().setText("");
            this.getTxtPostal().setText("");
            this.getTxtCity().setText("");
            this.getTxtPhone().setText("");
            this.getTxtFax().setText("");
            this.getTxtWeb().setText("");
            this.getTxtContract().setText("");
            this.getTxtContractCost().setText("0");
            this.getCbRegion().setSelectedItem(LanguageTranslator.getString("generics.none"));
            this.getCbManager().setSelectedItem(LanguageTranslator.getString("generics.none"));
            this.getCbContractState().setSelectedItem(LanguageTranslator.getString("generics.none"));
            this.getCbClient().setSelected(false);
        } else {
            this.getTxtComm().setText(toLoad.getComm());
            this.getTxtName().setText(toLoad.getName());
            this.getTxtAddress().setText(toLoad.getAddress());
            this.getTxtPostal().setText(toLoad.getPostal());
            this.getTxtCity().setText(toLoad.getCity());
            this.getTxtPhone().setText(toLoad.getPhone());
            this.getTxtFax().setText(toLoad.getFax());
            this.getTxtWeb().setText(toLoad.getWeb());
            this.getTxtContract().setText(toLoad.getContract());
            this.getTxtContractCost().setText(String.valueOf(toLoad.getContractCost()));
            this.getCbRegion().setSelectedItem(((ComboBoxModel)this.getCbRegion().getModel()).getLabel(this.current.getRegionId()));
            this.getCbManager().setSelectedItem(((ComboBoxModel)this.getCbManager().getModel()).getLabel(this.current.getManagerId()));
            this.getCbContractState().setSelectedItem(((ComboBoxModel)this.getCbContractState().getModel()).getLabel(this.current.getContractStateId()));
            this.getCbClient().setSelected(toLoad.isClient());
        }
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
            gridBagConstraints25.gridx = 2;
            gridBagConstraints25.anchor = 15;
            gridBagConstraints25.weighty = 1.0;
            gridBagConstraints25.weightx = 1.0;
            gridBagConstraints25.gridy = 0;
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.add((Component)this.getBtnQuitter(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 0, -1, new Insets(5, 0, 0, 5)));
            this.pnlBtn.add((Component)this.getBtnEnregistrer(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 0, -1, new Insets(5, 0, 0, 5)));
        }
        return this.pnlBtn;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAdminCompany.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogAdminCompany.this.current != null) {
                        DialogAdminCompany.this.save();
                        IcontactCompany.setList(null);
                        DialogAdminCompany.this.updateList();
                    }
                }
            });
        }
        return this.btnEnregistrer;
    }

    private JPanel getPnlGeneral() {
        if (this.pnlGeneral == null) {
            this.pnlGeneral = new JPanel();
            this.pnlGeneral.setLayout(new GridBagLayout());
            this.pnlGeneral.add((Component)new JLabel(LanguageTranslator.getString("generics.name")), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 2, 17, new Insets(5, 5, 0, 5)));
            this.pnlGeneral.add((Component)this.getTxtName(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 1, 10, new Insets(5, 0, 0, 5)));
            this.pnlGeneral.add((Component)new JLabel(LanguageTranslator.getString("generics.address")), Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 2, 17, new Insets(5, 5, 0, 5)));
            this.pnlGeneral.add((Component)this.getTxtAddress(), Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 1, 10, new Insets(5, 0, 0, 5)));
            this.pnlGeneral.add((Component)new JLabel(LanguageTranslator.getString("generics.cp")), Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 2, 17, new Insets(5, 5, 0, 5)));
            this.pnlGeneral.add((Component)this.getTxtPostal(), Fonctions.getGridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 1, 10, new Insets(5, 0, 0, 5)));
            this.pnlGeneral.add((Component)new JLabel(LanguageTranslator.getString("generics.city")), Fonctions.getGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 2, 17, new Insets(5, 5, 0, 5)));
            this.pnlGeneral.add((Component)this.getTxtCity(), Fonctions.getGridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 1, 10, new Insets(5, 0, 0, 5)));
            this.pnlGeneral.add((Component)new JLabel(LanguageTranslator.getString("generics.phone")), Fonctions.getGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 2, 17, new Insets(5, 5, 0, 5)));
            this.pnlGeneral.add((Component)this.getTxtPhone(), Fonctions.getGridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 1, 10, new Insets(5, 0, 0, 5)));
            this.pnlGeneral.add((Component)new JLabel(LanguageTranslator.getString("generics.fax")), Fonctions.getGridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 2, 17, new Insets(5, 5, 0, 5)));
            this.pnlGeneral.add((Component)this.getTxtFax(), Fonctions.getGridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 1, 10, new Insets(5, 0, 0, 5)));
            this.pnlGeneral.add((Component)new JLabel(LanguageTranslator.getString("generics.web")), Fonctions.getGridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 2, 17, new Insets(5, 5, 0, 5)));
            this.pnlGeneral.add((Component)this.getTxtWeb(), Fonctions.getGridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 1, 10, new Insets(5, 0, 0, 5)));
            this.pnlGeneral.add((Component)new JLabel(LanguageTranslator.getString("generics.contract")), Fonctions.getGridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 2, 17, new Insets(5, 5, 0, 5)));
            this.pnlGeneral.add((Component)this.getTxtContract(), Fonctions.getGridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 1, 10, new Insets(5, 0, 0, 5)));
            this.pnlGeneral.add((Component)new JLabel(LanguageTranslator.getString("generics.contractCost")), Fonctions.getGridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 2, 17, new Insets(5, 5, 0, 5)));
            this.pnlGeneral.add((Component)this.getTxtContractCost(), Fonctions.getGridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 1, 10, new Insets(5, 0, 0, 5)));
            this.pnlGeneral.add((Component)new JLabel(LanguageTranslator.getString("generics.region")), Fonctions.getGridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 2, 17, new Insets(5, 5, 0, 5)));
            this.pnlGeneral.add((Component)this.getCbRegion(), Fonctions.getGridBagConstraints(1, 9, 1, 1, 1.0, 0.0, 1, 10, new Insets(5, 0, 0, 5)));
            this.pnlGeneral.add((Component)new JLabel(LanguageTranslator.getString("generics.responsible")), Fonctions.getGridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 2, 17, new Insets(5, 5, 0, 5)));
            this.pnlGeneral.add((Component)this.getCbManager(), Fonctions.getGridBagConstraints(1, 10, 1, 1, 1.0, 0.0, 1, 10, new Insets(5, 0, 0, 5)));
            this.pnlGeneral.add((Component)new JLabel(LanguageTranslator.getString("generics.contractState")), Fonctions.getGridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 2, 17, new Insets(5, 5, 0, 5)));
            this.pnlGeneral.add((Component)this.getCbContractState(), Fonctions.getGridBagConstraints(1, 11, 1, 1, 1.0, 0.0, 1, 10, new Insets(5, 0, 0, 5)));
            this.pnlGeneral.add((Component)this.getCbClient(), Fonctions.getGridBagConstraints(0, 12, 1, 2, 1.0, 0.0, 2, 10, new Insets(5, 0, 0, 5)));
            JPanel pnlSolve = new JPanel();
            pnlSolve.setLayout(new GridBagLayout());
            pnlSolve.add((Component)this.getJspComm(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, null));
            pnlSolve.setBorder(new TitledBorder(LanguageTranslator.getString("generics.detail")));
            this.pnlGeneral.add((Component)pnlSolve, Fonctions.getGridBagConstraints(0, 13, 1, 2, 1.0, 1.0, 1, -1, new Insets(5, 2, 0, 2)));
        }
        return this.pnlGeneral;
    }

    private void save() {
        if (this.check()) {
            if (this.current == null) {
                this.current = new IcontactCompany();
            }
            int regionId = ((ComboBoxModel)this.getCbRegion().getModel()).getSelectedCle();
            int managerId = ((ComboBoxModel)this.getCbManager().getModel()).getSelectedCle();
            int contractStateId = ((ComboBoxModel)this.getCbContractState().getModel()).getSelectedCle();
            if (this.current.compareAndUpdate(this.getTxtName().getText(), this.getTxtAddress().getText(), this.getTxtPostal().getText(), this.getTxtCity().getText(), this.getTxtPhone().getText(), this.getTxtFax().getText(), regionId, this.getTxtWeb().getText(), managerId, this.getTxtContract().getText(), contractStateId, Float.parseFloat(this.getTxtContractCost().getText()), this.getTxtComm().getText(), this.getCbClient().isSelected())) {
                Fonctions.showSuccessMessage(null, null);
            } else {
                Fonctions.showErrorMessage(null, null);
            }
        }
    }

    private boolean check() {
        boolean toReturn = true;
        if (this.getTxtName().getText().equals("")) {
            this.getTxtName().setBackground(new Color(255, 192, 203));
            this.getTxtName().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtName().setBackground(Color.white);
        }
        return toReturn;
    }

    public void updateList() {
        this.getListCompany().setModel(new ComboBoxModel(IcontactCompany.getList(this.getCbFilterClient().isSelected()), true, null));
        if (this.current != null) {
            this.getListCompany().setSelectedValue(String.valueOf(this.current.getName()) + " - " + this.current.getPhone(), true);
        }
    }

    public void setSelectedCompany(int companyId) {
        this.getListCompany().setSelectedValue(((ComboBoxModel)this.getListCompany().getModel()).getLabel(companyId), true);
        this.updateList();
    }

    public int getSelectedCompanyId() {
        int companyId = ((ComboBoxModel)this.getListCompany().getModel()).getSelectedCle();
        return companyId;
    }
}

