/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.admin;

import fr.pgh.component.JFittedComboBox;
import fr.pgh.component.JTextDate;
import fr.pgh.component.JTextHour;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActionPriority;
import fr.pgh.data.bdd.DevAction;
import fr.pgh.data.bdd.DevCategory;
import fr.pgh.data.bdd.DevProduct;
import fr.pgh.data.bdd.DevState;
import fr.pgh.data.bdd.DevType;
import fr.pgh.data.bdd.Utilisateur;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.TMDevAction;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class DialogAdminDev
extends JDialog {
    public static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JButton btnQuit = null;
    private JButton btnCreate = null;
    private JButton btnSave = null;
    private JPanel pnlBtn = null;
    private JPanel pnlFilter = null;
    private JTextDate txtFilterDate = null;
    private JFittedComboBox cbFilterCategory = null;
    private JFittedComboBox cbFilterManager = null;
    private JFittedComboBox cbFilterDetectionVersion = null;
    private JFittedComboBox cbFilterCorrectionVersion = null;
    private JFittedComboBox cbFilterType = null;
    private JFittedComboBox cbFilterPriority = null;
    private JFittedComboBox cbFilterState = null;
    private JTextField txtFilterKeywords = null;
    private JPanel pnlCompanyAction = null;
    private JPanel pnlTbl = null;
    private JScrollPane jspTbl = null;
    private JTable tblAction = null;
    private JPanel pnlContentTechnical = null;
    private JTextDate txtDateTechnical = null;
    private JTextHour txtHourTechnical = null;
    private JComboBox<String> cbViewLevel = null;
    private JComboBox<DevState> cbState = null;
    private JComboBox<DevCategory> cbCategory = null;
    private JComboBox<Utilisateur> cbManager = null;
    private JComboBox<DevProduct> cbDetectionVersion = null;
    private JComboBox<DevProduct> cbCorrectionVersion = null;
    private JComboBox<DevType> cbType = null;
    private JComboBox<ActionPriority> cbPriority = null;
    private JScrollPane jspPb = null;
    private JTextArea txtPbTechnical = null;
    private JScrollPane jspSolve = null;
    private JTextArea txtSolveTechnical = null;
    private JTextHour txtLengthIntervTechnical = null;
    private JTextField txtKeywords = null;
    private JTextField txtShortDescription = null;
    private DevAction selected = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogCompany.dispose()#");
        super.dispose();
    }

    public DialogAdminDev(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogCompanyAction()#");
        this.initialize();
        this.reload();
    }

    private void initialize() {
        this.setBounds(new Rectangle(0, 0, 1400, 900));
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(LanguageTranslator.getString("dev.action"));
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlTbl(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 5)));
            this.jContentPane.add((Component)this.getPnlCompanyAction(), Fonctions.getGridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 5)));
            this.jContentPane.add((Component)this.getPnlBtn(), Fonctions.getGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 2, -1, new Insets(5, 5, 5, 5)));
        }
        return this.jContentPane;
    }

    private JButton getBtnQuit() {
        if (this.btnQuit == null) {
            this.btnQuit = new JButton();
            this.btnQuit.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAdminDev.this.dispose();
                }
            });
        }
        return this.btnQuit;
    }

    private JButton getBtnCreate() {
        if (this.btnCreate == null) {
            this.btnCreate = new JButton();
            this.btnCreate.setText(LanguageTranslator.getString("button.new"));
            this.btnCreate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAdminDev.this.load(null);
                }
            });
        }
        return this.btnCreate;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton();
            this.btnSave.setText(LanguageTranslator.getString("button.save"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogAdminDev.this.check()) {
                        DialogAdminDev.this.save();
                    }
                }
            });
        }
        return this.btnSave;
    }

    private boolean check() {
        boolean validation = true;
        if (this.getTxtDateTechnical().getText().equals("")) {
            this.getTxtDateTechnical().setBackground(new Color(255, 192, 203));
            validation = false;
        } else {
            this.getTxtDateTechnical().setBackground(Color.white);
        }
        if (this.getTxtKeywords().getText().equals("")) {
            this.getTxtKeywords().setBackground(new Color(255, 192, 203));
            validation = false;
        } else {
            this.getTxtKeywords().setBackground(Color.white);
        }
        if (this.getTxtPbTechnical().getText().equals("")) {
            this.getTxtPbTechnical().setBackground(new Color(255, 192, 203));
            validation = false;
        } else {
            this.getTxtPbTechnical().setBackground(Color.white);
        }
        return validation;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.add((Component)this.getBtnQuit(), null);
            this.pnlBtn.add((Component)this.getBtnSave(), null);
            this.pnlBtn.add((Component)this.getBtnCreate(), null);
        }
        return this.pnlBtn;
    }

    private JPanel getPnlFilter() {
        if (this.pnlFilter == null) {
            this.pnlFilter = new JPanel();
            this.pnlFilter.setLayout(new GridBagLayout());
            this.pnlFilter.add((Component)new JLabel(LanguageTranslator.getString("generics.date")), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 2, -1, new Insets(2, 0, 2, 2)));
            this.pnlFilter.add((Component)new JLabel(LanguageTranslator.getString("generics.responsible")), Fonctions.getGridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 2, -1, new Insets(2, 0, 2, 2)));
            this.pnlFilter.add((Component)new JLabel(LanguageTranslator.getString("generics.category")), Fonctions.getGridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 2, -1, new Insets(2, 0, 2, 2)));
            this.pnlFilter.add((Component)new JLabel(LanguageTranslator.getString("generics.action")), Fonctions.getGridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 2, -1, new Insets(2, 0, 2, 2)));
            this.pnlFilter.add((Component)new JLabel(LanguageTranslator.getString("generics.priority")), Fonctions.getGridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 2, -1, new Insets(2, 0, 2, 2)));
            this.pnlFilter.add((Component)new JLabel(LanguageTranslator.getString("generics.state")), Fonctions.getGridBagConstraints(6, 0, 1, 1, 1.0, 0.0, 2, -1, new Insets(2, 0, 2, 2)));
            this.pnlFilter.add((Component)this.getTxtFilterDate(), Fonctions.getGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 2, -1, new Insets(2, 0, 2, 2)));
            this.pnlFilter.add((Component)this.getCbFilterManager(), Fonctions.getGridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 2, -1, new Insets(2, 0, 2, 2)));
            this.pnlFilter.add((Component)this.getCbFilterCategory(), Fonctions.getGridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 2, -1, new Insets(2, 0, 2, 2)));
            this.pnlFilter.add((Component)this.getCbFilterType(), Fonctions.getGridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 2, -1, new Insets(2, 0, 2, 2)));
            this.pnlFilter.add((Component)this.getCbFilterPriority(), Fonctions.getGridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 2, -1, new Insets(2, 0, 2, 2)));
            this.pnlFilter.add((Component)this.getCbFilterState(), Fonctions.getGridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 2, -1, new Insets(2, 0, 2, 2)));
        }
        return this.pnlFilter;
    }

    private JTextDate getTxtFilterDate() {
        if (this.txtFilterDate == null) {
            this.txtFilterDate = new JTextDate();
        }
        return this.txtFilterDate;
    }

    private JFittedComboBox getCbFilterManager() {
        if (this.cbFilterManager == null) {
            this.cbFilterManager = new JFittedComboBox();
            this.cbFilterManager.setMaxWidth(125);
            this.cbFilterManager.setModel(new ComboBoxModel(Utilisateur.listAdmin(), false, LanguageTranslator.getString("generics.none")));
            this.cbFilterManager.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        DialogAdminDev.this.reload();
                    }
                }
            });
        }
        return this.cbFilterManager;
    }

    private JFittedComboBox getCbFilterCategory() {
        if (this.cbFilterCategory == null) {
            this.cbFilterCategory = new JFittedComboBox();
            this.cbFilterCategory.setMaxWidth(125);
            this.cbFilterCategory.setModel(new ComboBoxModel(DevCategory.getList(), false, LanguageTranslator.getString("generics.none")));
            this.cbFilterCategory.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        DialogAdminDev.this.reload();
                    }
                }
            });
        }
        return this.cbFilterCategory;
    }

    private JFittedComboBox getCbFilterType() {
        if (this.cbFilterType == null) {
            this.cbFilterType = new JFittedComboBox();
            this.cbFilterType.setMaxWidth(125);
            this.cbFilterType.setModel(new ComboBoxModel(DevType.getList(), false, LanguageTranslator.getString("generics.none")));
            this.cbFilterType.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        DialogAdminDev.this.reload();
                    }
                }
            });
        }
        return this.cbFilterType;
    }

    private JFittedComboBox getCbFilterPriority() {
        if (this.cbFilterPriority == null) {
            this.cbFilterPriority = new JFittedComboBox();
            this.cbFilterPriority.setMaxWidth(125);
            this.cbFilterPriority.setModel(new ComboBoxModel(ActionPriority.getList(), false, LanguageTranslator.getString("generics.none")));
            this.cbFilterPriority.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        DialogAdminDev.this.reload();
                    }
                }
            });
        }
        return this.cbFilterPriority;
    }

    private JFittedComboBox getCbFilterDetectionVersion() {
        if (this.cbFilterDetectionVersion == null) {
            this.cbFilterDetectionVersion = new JFittedComboBox();
            this.cbFilterDetectionVersion.setMaxWidth(125);
            this.cbFilterDetectionVersion.setModel(new ComboBoxModel(DevProduct.getList(), false, LanguageTranslator.getString("generics.none")));
            this.cbFilterDetectionVersion.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        DialogAdminDev.this.reload();
                    }
                }
            });
        }
        return this.cbFilterDetectionVersion;
    }

    private JFittedComboBox getCbFilterCorrectionVersion() {
        if (this.cbFilterCorrectionVersion == null) {
            this.cbFilterCorrectionVersion = new JFittedComboBox();
            this.cbFilterCorrectionVersion.setMaxWidth(125);
            this.cbFilterCorrectionVersion.setModel(new ComboBoxModel(DevProduct.getList(), false, LanguageTranslator.getString("generics.none")));
            this.cbFilterCorrectionVersion.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        DialogAdminDev.this.reload();
                    }
                }
            });
        }
        return this.cbFilterCorrectionVersion;
    }

    private JFittedComboBox getCbFilterState() {
        if (this.cbFilterState == null) {
            this.cbFilterState = new JFittedComboBox();
            this.cbFilterState.setMaxWidth(125);
            this.cbFilterState.setModel(new ComboBoxModel(DevState.getList(), false, LanguageTranslator.getString("generics.none")));
            this.cbFilterState.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        DialogAdminDev.this.reload();
                    }
                }
            });
        }
        return this.cbFilterState;
    }

    private JPanel getPnlCompanyAction() {
        if (this.pnlCompanyAction == null) {
            this.pnlCompanyAction = new JPanel();
            this.pnlCompanyAction.setLayout(new GridBagLayout());
            this.pnlCompanyAction.add((Component)this.getPnlContentTechnical(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlCompanyAction.add((Component)this.getPnlBtn(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
        }
        return this.pnlCompanyAction;
    }

    private JPanel getPnlTbl() {
        if (this.pnlTbl == null) {
            this.pnlTbl = new JPanel();
            this.pnlTbl.setBorder(new TitledBorder(LanguageTranslator.getString("company.action")));
            this.pnlTbl.setLayout(new GridBagLayout());
            this.pnlTbl.add((Component)this.getPnlFilter(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 2, -1, new Insets(5, 5, 0, 5)));
            this.pnlTbl.add((Component)this.getJspTbl(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, -1, new Insets(0, 5, 5, 5)));
        }
        return this.pnlTbl;
    }

    private JScrollPane getJspTbl() {
        if (this.jspTbl == null) {
            this.jspTbl = new JScrollPane();
            this.jspTbl.setViewportView(this.getTableAction());
        }
        return this.jspTbl;
    }

    private JTable getTableAction() {
        if (this.tblAction == null) {
            this.tblAction = new JTable();
            this.tblAction.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && DialogAdminDev.this.getTableAction().getSelectedRow() != -1) {
                        TMDevAction tmp = (TMDevAction)DialogAdminDev.this.getTableAction().getModel();
                        DialogAdminDev.this.load(tmp.getData().get(DialogAdminDev.this.getTableAction().getSelectedRow()));
                    }
                }
            });
        }
        return this.tblAction;
    }

    private void reload() {
        Date day = this.getTxtFilterDate().getText().equals("") ? null : this.getTxtFilterDate().getDate();
        int managerId = ((ComboBoxModel)this.getCbFilterManager().getModel()).getSelectedCle();
        int categoryId = ((ComboBoxModel)this.getCbFilterCategory().getModel()).getSelectedCle();
        int typeId = ((ComboBoxModel)this.getCbFilterType().getModel()).getSelectedCle();
        int detectionVersionId = ((ComboBoxModel)this.getCbFilterDetectionVersion().getModel()).getSelectedCle();
        int correctionVersionId = ((ComboBoxModel)this.getCbFilterCorrectionVersion().getModel()).getSelectedCle();
        int priorityId = ((ComboBoxModel)this.getCbFilterPriority().getModel()).getSelectedCle();
        int stateId = ((ComboBoxModel)this.getCbFilterState().getModel()).getSelectedCle();
        this.getTableAction().setModel(new TMDevAction(DevAction.loadList(categoryId, managerId, stateId, detectionVersionId, correctionVersionId, typeId, priorityId, day, null)));
        this.load(null);
    }

    private void load(DevAction toLoad) {
        this.selected = toLoad;
        this.getTxtDateTechnical().setText(this.selected == null ? ConversionTime.dateToString(new Date(), "dd/MM/yyyy") : ConversionTime.dateToString(this.selected.getDate(), "dd/MM/yyyy"));
        this.getTxtHourTechnical().setHourMinute(this.selected == null ? ConversionTime.heureStringToInt(ConversionTime.dateToString(new Date(), "HH'h'mm"), "h") : ConversionTime.heureStringToInt(ConversionTime.dateToString(this.selected.getDate(), "HH'h'mm"), "h"));
        if (this.selected == null) {
            this.getCbState().setSelectedItem(LanguageTranslator.getString("generics.none"));
            this.getCbManager().setSelectedItem(ConnexionSettings.getInstance().user.toString());
            this.getCbDetectionVersion().setSelectedItem(LanguageTranslator.getString("generics.none"));
            this.getCbCorrectionVersion().setSelectedItem(LanguageTranslator.getString("generics.none"));
            this.getCbType().setSelectedItem(LanguageTranslator.getString("generics.none"));
            this.getCbPriority().setSelectedItem(LanguageTranslator.getString("generics.none"));
            this.getCbCategory().setSelectedItem(LanguageTranslator.getString("generics.none"));
            this.getCbViewLevel().setSelectedIndex(0);
            this.getTxtKeywords().setText("");
            this.getTxtShortDescription().setText("");
        } else {
            this.getCbState().setSelectedItem(((ComboBoxModel)this.getCbState().getModel()).getLabel(this.selected.getStateId()));
            this.getCbManager().setSelectedItem(((ComboBoxModel)this.getCbManager().getModel()).getLabel(this.selected.getManagerId()));
            this.getCbCategory().setSelectedItem(((ComboBoxModel)this.getCbCategory().getModel()).getLabel(this.selected.getCategoryId()));
            this.getCbDetectionVersion().setSelectedItem(((ComboBoxModel)this.getCbDetectionVersion().getModel()).getLabel(this.selected.getDetectionVersionId()));
            this.getCbCorrectionVersion().setSelectedItem(((ComboBoxModel)this.getCbCorrectionVersion().getModel()).getLabel(this.selected.getCorrectionVersionId()));
            this.getCbType().setSelectedItem(((ComboBoxModel)this.getCbType().getModel()).getLabel(this.selected.getTypeId()));
            this.getCbPriority().setSelectedItem(((ComboBoxModel)this.getCbPriority().getModel()).getLabel(this.selected.getPriorityId()));
            this.getCbViewLevel().setSelectedIndex(this.selected.getViewLevel());
            this.getTxtKeywords().setText(this.selected.getKeywords());
            this.getTxtShortDescription().setText(this.selected.getDescription());
        }
        this.getTxtLengthIntervTechnical().setHourMinute(this.selected == null ? 0 : this.selected.getLengthInterv());
        this.getTxtPbTechnical().setText(this.selected == null ? "" : this.selected.getProblem());
        this.getTxtSolveTechnical().setText(this.selected == null ? "" : this.selected.getSolve());
    }

    private void save() {
        String sDate = String.valueOf(this.getTxtDateTechnical().getText()) + " " + this.getTxtHourTechnical().getText();
        Date date = ConversionTime.stringToDate(sDate, "dd/MM/yyyy hh'h'mm");
        int stateId = ((ComboBoxModel)this.getCbState().getModel()).getSelectedCle();
        int managerId = ((ComboBoxModel)this.getCbManager().getModel()).getSelectedCle();
        int categoryId = ((ComboBoxModel)this.getCbCategory().getModel()).getSelectedCle();
        int detectionVersionId = ((ComboBoxModel)this.getCbDetectionVersion().getModel()).getSelectedCle();
        int correctionVersionId = ((ComboBoxModel)this.getCbCorrectionVersion().getModel()).getSelectedCle();
        int typeId = ((ComboBoxModel)this.getCbType().getModel()).getSelectedCle();
        int priorityId = ((ComboBoxModel)this.getCbPriority().getModel()).getSelectedCle();
        int lengthInterv = ConversionTime.heureStringToInt(this.getTxtLengthIntervTechnical().getText(), "h");
        int viewLevel = this.getCbViewLevel().getSelectedIndex();
        if (this.selected == null) {
            this.selected = new DevAction();
        }
        if (this.selected.compareAndUpdate(date, this.getTxtShortDescription().getText(), stateId, managerId, categoryId, detectionVersionId, correctionVersionId, typeId, priorityId, this.getTxtPbTechnical().getText(), this.getTxtSolveTechnical().getText(), lengthInterv, this.getTxtKeywords().getText(), viewLevel)) {
            Fonctions.showSuccessMessage(null, null);
        } else {
            Fonctions.showErrorMessage(null, null);
        }
        this.reload();
    }

    private JPanel getPnlContentTechnical() {
        if (this.pnlContentTechnical == null) {
            this.pnlContentTechnical = new JPanel();
            this.pnlContentTechnical.setLayout(new GridBagLayout());
            this.pnlContentTechnical.setBorder(new TitledBorder(LanguageTranslator.getString("generics.detail")));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.date")), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)this.getTxtDateTechnical(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)this.getTxtHourTechnical(), Fonctions.getGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.responsible")), Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add(this.getCbManager(), Fonctions.getGridBagConstraints(1, 1, 1, 2, 1.0, 0.0, 2, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.detection")), Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add(this.getCbDetectionVersion(), Fonctions.getGridBagConstraints(1, 2, 1, 2, 0.0, 0.0, 2, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.correction")), Fonctions.getGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add(this.getCbCorrectionVersion(), Fonctions.getGridBagConstraints(1, 3, 1, 2, 0.0, 0.0, 2, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.keywords")), Fonctions.getGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)this.getTxtKeywords(), Fonctions.getGridBagConstraints(1, 4, 1, 2, 0.0, 0.0, 2, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.category")), Fonctions.getGridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add(this.getCbCategory(), Fonctions.getGridBagConstraints(4, 0, 1, 2, 1.0, 0.0, 2, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.state")), Fonctions.getGridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add(this.getCbState(), Fonctions.getGridBagConstraints(4, 1, 1, 2, 0.0, 0.0, 2, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.action")), Fonctions.getGridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add(this.getCbType(), Fonctions.getGridBagConstraints(4, 2, 1, 2, 0.0, 0.0, 2, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.priority")), Fonctions.getGridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add(this.getCbPriority(), Fonctions.getGridBagConstraints(4, 3, 1, 2, 0.0, 0.0, 2, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("dev.view.level")), Fonctions.getGridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 2, 0, 2)));
            this.pnlContentTechnical.add(this.getCbViewLevel(), Fonctions.getGridBagConstraints(4, 4, 1, 2, 0.0, 0.0, 2, -1, new Insets(5, 2, 0, 2)));
            JPanel pnlPb = new JPanel();
            pnlPb.setLayout(new GridBagLayout());
            pnlPb.add((Component)new JLabel(LanguageTranslator.getString("generics.description")), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 1, -1, null));
            pnlPb.add((Component)this.getTxtShortDescription(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 1, -1, new Insets(0, 2, 5, 0)));
            pnlPb.add((Component)this.getJspPb(), Fonctions.getGridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 1, -1, null));
            pnlPb.setBorder(new TitledBorder(LanguageTranslator.getString("generics.problem")));
            this.pnlContentTechnical.add((Component)pnlPb, Fonctions.getGridBagConstraints(0, 6, 1, 3, 1.0, 1.0, 1, -1, new Insets(5, 2, 0, 2)));
            JPanel pnlSolve = new JPanel();
            pnlSolve.setLayout(new GridBagLayout());
            pnlSolve.add((Component)new JLabel(LanguageTranslator.getString("dev.length")), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 1, -1, null));
            pnlSolve.add((Component)this.getTxtLengthIntervTechnical(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 1, -1, new Insets(0, 2, 5, 0)));
            pnlSolve.add((Component)this.getJspSolve(), Fonctions.getGridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 1, -1, null));
            pnlSolve.setBorder(new TitledBorder(LanguageTranslator.getString("generics.solve")));
            this.pnlContentTechnical.add((Component)pnlSolve, Fonctions.getGridBagConstraints(3, 6, 1, 3, 1.0, 1.0, 1, -1, new Insets(5, 2, 0, 2)));
        }
        return this.pnlContentTechnical;
    }

    private JTextDate getTxtDateTechnical() {
        if (this.txtDateTechnical == null) {
            this.txtDateTechnical = new JTextDate();
        }
        return this.txtDateTechnical;
    }

    private JTextHour getTxtHourTechnical() {
        if (this.txtHourTechnical == null) {
            this.txtHourTechnical = new JTextHour();
        }
        return this.txtHourTechnical;
    }

    private JComboBox<DevState> getCbState() {
        if (this.cbState == null) {
            this.cbState = new JComboBox();
            this.cbState.setModel(new ComboBoxModel(DevState.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbState;
    }

    private JComboBox<Utilisateur> getCbManager() {
        if (this.cbManager == null) {
            this.cbManager = new JComboBox();
            this.cbManager.setModel(new ComboBoxModel(Utilisateur.listAdmin(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbManager;
    }

    private JComboBox<DevType> getCbType() {
        if (this.cbType == null) {
            this.cbType = new JComboBox();
            this.cbType.setModel(new ComboBoxModel(DevType.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbType;
    }

    private JComboBox<DevProduct> getCbDetectionVersion() {
        if (this.cbDetectionVersion == null) {
            this.cbDetectionVersion = new JComboBox();
            this.cbDetectionVersion.setModel(new ComboBoxModel(DevProduct.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbDetectionVersion;
    }

    private JComboBox<DevProduct> getCbCorrectionVersion() {
        if (this.cbCorrectionVersion == null) {
            this.cbCorrectionVersion = new JComboBox();
            this.cbCorrectionVersion.setModel(new ComboBoxModel(DevProduct.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbCorrectionVersion;
    }

    private JComboBox<DevCategory> getCbCategory() {
        if (this.cbCategory == null) {
            this.cbCategory = new JComboBox();
            this.cbCategory.setModel(new ComboBoxModel(DevCategory.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbCategory;
    }

    private JComboBox<ActionPriority> getCbPriority() {
        if (this.cbPriority == null) {
            this.cbPriority = new JComboBox();
            this.cbPriority.setModel(new ComboBoxModel(ActionPriority.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbPriority;
    }

    private JComboBox<String> getCbViewLevel() {
        if (this.cbViewLevel == null) {
            this.cbViewLevel = new JComboBox();
            this.cbViewLevel.addItem(LanguageTranslator.getString("dev.view.noShow"));
            this.cbViewLevel.addItem(LanguageTranslator.getString("dev.view.admin"));
            this.cbViewLevel.addItem(LanguageTranslator.getString("dev.view.client"));
        }
        return this.cbViewLevel;
    }

    private JTextField getTxtKeywords() {
        if (this.txtKeywords == null) {
            this.txtKeywords = new JTextField();
        }
        return this.txtKeywords;
    }

    private JTextField getTxtShortDescription() {
        if (this.txtShortDescription == null) {
            this.txtShortDescription = new JTextField();
        }
        return this.txtShortDescription;
    }

    private JScrollPane getJspPb() {
        if (this.jspPb == null) {
            this.jspPb = new JScrollPane();
            this.jspPb.setViewportView(this.getTxtPbTechnical());
        }
        return this.jspPb;
    }

    private JTextArea getTxtPbTechnical() {
        if (this.txtPbTechnical == null) {
            this.txtPbTechnical = new JTextArea();
            this.txtPbTechnical.setLineWrap(true);
            this.txtPbTechnical.setWrapStyleWord(true);
        }
        return this.txtPbTechnical;
    }

    private JScrollPane getJspSolve() {
        if (this.jspSolve == null) {
            this.jspSolve = new JScrollPane();
            this.jspSolve.setViewportView(this.getTxtSolveTechnical());
        }
        return this.jspSolve;
    }

    private JTextArea getTxtSolveTechnical() {
        if (this.txtSolveTechnical == null) {
            this.txtSolveTechnical = new JTextArea();
            this.txtSolveTechnical.setLineWrap(true);
            this.txtSolveTechnical.setWrapStyleWord(true);
        }
        return this.txtSolveTechnical;
    }

    private JTextHour getTxtLengthIntervTechnical() {
        if (this.txtLengthIntervTechnical == null) {
            this.txtLengthIntervTechnical = new JTextHour();
        }
        return this.txtLengthIntervTechnical;
    }
}

