/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.admin;

import fr.pgh.data.bdd.Profil;
import fr.pgh.data.bdd.ReportAccess;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.modele.LMProfil;
import transpo.system.ui.modele.TMFiche;
import transpo.system.ui.modele.TMReportAccess;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transport.report.ProfilDetail;

public class DialogAdministrationProfil
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JList listeProfil = null;
    private JPanel pDetail = null;
    private JButton btnNouveau = null;
    private JScrollPane jspTable = null;
    private JTable tblFiche = null;
    private JButton btnEnregistrer = null;
    private JLabel lblNomProfil = null;
    private JTextField txtNomProfil = null;
    private JPanel pProfil = null;
    private LMProfil modeleListe = null;
    private Profil current = null;
    private int cleProfilSelectionne = 0;
    private JButton btnQuitter = null;
    private JScrollPane jspListe = null;
    private JButton btnSupprimer = null;
    private JScrollPane jspRapport = null;
    private JTable tblRapport = null;
    private JPanel pnlProfil = null;
    private JLabel lblDefault = null;
    private JCheckBox cbDefault = null;
    private JPanel pnlBtn = null;
    private JButton btnExport = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogAdministrationProfil.dispose()#");
        super.dispose();
    }

    public DialogAdministrationProfil(JFrame owner) {
        super(owner);
        TimsLogger.verbose("#DialogAdministrationProfil()#");
        this.initialize();
    }

    private void initialize() {
        this.setSize(750, 400);
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(LanguageTranslator.getString("profil.title"));
        this.setModal(true);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.fill = 1;
            gridBagConstraints11.insets = new Insets(10, 10, 10, 5);
            gridBagConstraints11.weightx = 0.3;
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.gridy = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridheight = 1;
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.insets = new Insets(10, 5, 10, 10);
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.jContentPane.setPreferredSize(new Dimension(0, 0));
            this.jContentPane.add((Component)this.getPDetail(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getPProfil(), gridBagConstraints11);
        }
        return this.jContentPane;
    }

    private JList getListeProfil() {
        if (this.listeProfil == null) {
            this.listeProfil = new JList();
            this.listeProfil.setSelectionMode(0);
            this.listeProfil.setAutoscrolls(true);
            Vector<Profil> liste = new Vector();
            liste = Profil.list();
            this.modeleListe = new LMProfil(liste);
            this.listeProfil.setModel(this.modeleListe);
            this.listeProfil.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && DialogAdministrationProfil.this.listeProfil.getSelectedIndex() != -1) {
                        DialogAdministrationProfil.this.current = (Profil)DialogAdministrationProfil.this.modeleListe.get(DialogAdministrationProfil.this.listeProfil.getSelectedIndex());
                        DialogAdministrationProfil.this.setDetailProfil(DialogAdministrationProfil.this.cleProfilSelectionne);
                    }
                }
            });
        }
        return this.listeProfil;
    }

    private void setDetailProfil(int cleProfil) {
        this.current.loadRight();
        this.current.loadReportAccess();
        this.tblFiche.setModel(new TMFiche(this.current.getDroit()));
        this.tblFiche.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.txtNomProfil.setText(this.current.getNomProfil());
        this.getCbDefault().setSelected(this.current.isDefault());
        this.getTblRapport().setModel(new TMReportAccess(this.current.getReport()));
    }

    private JPanel getPDetail() {
        if (this.pDetail == null) {
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.gridwidth = 2;
            gridBagConstraints14.fill = 2;
            gridBagConstraints14.gridy = 3;
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            gridBagConstraints41.gridx = 0;
            gridBagConstraints41.gridwidth = 2;
            gridBagConstraints41.fill = 2;
            gridBagConstraints41.gridy = 1;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.fill = 1;
            gridBagConstraints13.gridy = 2;
            gridBagConstraints13.weightx = 0.5;
            gridBagConstraints13.weighty = 1.0;
            gridBagConstraints13.insets = new Insets(10, 5, 10, 5);
            gridBagConstraints13.gridx = 1;
            this.lblNomProfil = new JLabel();
            this.lblNomProfil.setText(LanguageTranslator.getString("profil.name"));
            this.lblNomProfil.setHorizontalAlignment(0);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.insets = new Insets(10, 5, 10, 5);
            gridBagConstraints3.gridx = 0;
            this.pDetail = new JPanel();
            this.pDetail.setLayout(new GridBagLayout());
            this.pDetail.setPreferredSize(new Dimension(0, 0));
            this.pDetail.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("profil.detail"), 1, 2, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pDetail.add((Component)this.getJspTable(), gridBagConstraints3);
            this.pDetail.add((Component)this.getJspRapport(), gridBagConstraints13);
            this.pDetail.add((Component)this.getPnlProfil(), gridBagConstraints41);
            this.pDetail.add((Component)this.getPnlBtn(), gridBagConstraints14);
        }
        return this.pDetail;
    }

    private JButton getBtnNouveau() {
        if (this.btnNouveau == null) {
            this.btnNouveau = new JButton();
            this.btnNouveau.setText(LanguageTranslator.getString("button.new"));
            this.btnNouveau.setPreferredSize(new Dimension(90, 26));
            this.btnNouveau.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAdministrationProfil.this.listeProfil.clearSelection();
                    DialogAdministrationProfil.this.nouveauProfil();
                }
            });
        }
        return this.btnNouveau;
    }

    private void nouveauProfil() {
        this.current = new Profil();
        this.initialiseTable();
    }

    private void initialiseTable() {
        this.current.setDroit(Transport.bdd.loadProfileDefaultAccess(0));
        this.current.setReport(ReportAccess.loadDefaultAccess());
        this.getTblFiche().setModel(new TMFiche(this.current.getDroit()));
        this.getTblRapport().setModel(new TMReportAccess(this.current.getReport()));
    }

    private JScrollPane getJspTable() {
        if (this.jspTable == null) {
            this.jspTable = new JScrollPane();
            this.jspTable.setViewportView(this.getTblFiche());
        }
        return this.jspTable;
    }

    private JTable getTblFiche() {
        if (this.tblFiche == null) {
            this.tblFiche = new JTable();
            this.tblFiche.setGridColor(Color.lightGray);
            this.tblFiche.setRowHeight(18);
            this.tblFiche.setRowSelectionAllowed(false);
            this.tblFiche.setSelectionMode(0);
            this.tblFiche.setBackground(new Color(238, 238, 238));
            this.tblFiche.setColumnSelectionAllowed(false);
            this.tblFiche.setShowVerticalLines(false);
        }
        return this.tblFiche;
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogAdministrationProfil.this.current == null) {
                        TimsLogger.debug("pas d'infos saisie");
                        return;
                    }
                    if (DialogAdministrationProfil.this.current.getCle() == 0) {
                        Vector<Profil> existant = DialogAdministrationProfil.this.modeleListe.getListe();
                        Iterator<Profil> iter = existant.iterator();
                        while (iter.hasNext()) {
                            if (!iter.next().getNomProfil().equals(DialogAdministrationProfil.this.txtNomProfil.getText())) continue;
                            TimsLogger.debug("deja existant");
                            return;
                        }
                    }
                    DialogAdministrationProfil.this.updateProfil();
                    DialogAdministrationProfil.this.refreshListe();
                }
            });
        }
        return this.btnEnregistrer;
    }

    private void updateProfil() {
        if (this.current.getNomProfil().equals("ADMIN")) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("profil.adminUpdate"), LanguageTranslator.getString("message.saveError"), 0);
        } else {
            this.current.setNomProfil(this.getTxtNomProfil().getText());
            this.current.setDefault(this.getCbDefault().isSelected());
            this.current.setDroit(((TMFiche)this.getTblFiche().getModel()).getTableau());
            this.current.setReport(((TMReportAccess)this.getTblRapport().getModel()).getTableau());
            Transport.bdd.startTransaction();
            if (!this.current.update()) {
                Transport.bdd.rollback();
                JOptionPane.showMessageDialog(this.getParent(), LanguageTranslator.getString("message.saveError"), LanguageTranslator.getString("message.saveError"), 0);
            } else {
                Transport.bdd.commit();
                JOptionPane.showMessageDialog(this.getParent(), LanguageTranslator.getString("message.saveSucceed"), LanguageTranslator.getString("message.done"), 1);
            }
        }
    }

    private void deleteProfil() {
        this.current.delete();
    }

    private void refreshListe() {
        this.modeleListe = null;
        Vector<Profil> liste = new Vector();
        liste = Transport.bdd.getProfil();
        this.modeleListe = new LMProfil(liste);
        this.listeProfil.setModel(this.modeleListe);
    }

    private JTextField getTxtNomProfil() {
        if (this.txtNomProfil == null) {
            this.txtNomProfil = new JTextField();
            this.txtNomProfil.setHorizontalAlignment(2);
        }
        return this.txtNomProfil;
    }

    private JPanel getPProfil() {
        if (this.pProfil == null) {
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.fill = 1;
            gridBagConstraints12.gridy = 0;
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.weighty = 1.0;
            gridBagConstraints12.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 0.0;
            gridBagConstraints2.gridy = 1;
            this.pProfil = new JPanel();
            this.pProfil.setLayout(new GridBagLayout());
            this.pProfil.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("profil"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pProfil.setPreferredSize(new Dimension(0, 0));
            this.pProfil.add((Component)this.getBtnNouveau(), gridBagConstraints2);
            this.pProfil.add((Component)this.getJspListe(), gridBagConstraints12);
        }
        return this.pProfil;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setPreferredSize(new Dimension(98, 26));
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.setMnemonic(0);
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAdministrationProfil.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JScrollPane getJspListe() {
        if (this.jspListe == null) {
            this.jspListe = new JScrollPane();
            this.jspListe.setViewportView(this.getListeProfil());
        }
        return this.jspListe;
    }

    private JButton getBtnSupprimer() {
        if (this.btnSupprimer == null) {
            this.btnSupprimer = new JButton();
            this.btnSupprimer.setText(LanguageTranslator.getString("button.delete"));
            this.btnSupprimer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (((Profil)DialogAdministrationProfil.this.modeleListe.get(DialogAdministrationProfil.this.listeProfil.getSelectedIndex())).getNomProfil().equals("ADMIN")) {
                        JOptionPane.showMessageDialog(DialogAdministrationProfil.this.getParent(), LanguageTranslator.getString("profil.adminDeletion"), "", 0);
                    } else {
                        DialogAdministrationProfil.this.deleteProfil();
                        DialogAdministrationProfil.this.refreshListe();
                    }
                }
            });
        }
        return this.btnSupprimer;
    }

    private JScrollPane getJspRapport() {
        if (this.jspRapport == null) {
            this.jspRapport = new JScrollPane();
            this.jspRapport.setViewportView(this.getTblRapport());
        }
        return this.jspRapport;
    }

    private JTable getTblRapport() {
        if (this.tblRapport == null) {
            this.tblRapport = new JTable();
            this.tblRapport.setGridColor(Color.lightGray);
            this.tblRapport.setRowHeight(18);
            this.tblRapport.setRowSelectionAllowed(false);
            this.tblRapport.setSelectionMode(0);
            this.tblRapport.setBackground(new Color(238, 238, 238));
            this.tblRapport.setColumnSelectionAllowed(false);
            this.tblRapport.setShowVerticalLines(false);
        }
        return this.tblRapport;
    }

    private JPanel getPnlProfil() {
        if (this.pnlProfil == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 4;
            gridBagConstraints9.gridy = 0;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 3;
            gridBagConstraints7.gridy = 0;
            this.lblDefault = new JLabel();
            this.lblDefault.setText(LanguageTranslator.getString("generics.default"));
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.gridwidth = 2;
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.insets = new Insets(5, 1, 5, 15);
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.weightx = 0.0;
            gridBagConstraints6.insets = new Insets(5, 10, 5, 0);
            this.pnlProfil = new JPanel();
            this.pnlProfil.setLayout(new GridBagLayout());
            this.pnlProfil.add((Component)this.lblNomProfil, gridBagConstraints6);
            this.pnlProfil.add((Component)this.getTxtNomProfil(), gridBagConstraints5);
            this.pnlProfil.add((Component)this.lblDefault, gridBagConstraints7);
            this.pnlProfil.add((Component)this.getCbDefault(), gridBagConstraints9);
        }
        return this.pnlProfil;
    }

    private JCheckBox getCbDefault() {
        if (this.cbDefault == null) {
            this.cbDefault = new JCheckBox();
        }
        return this.cbDefault;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new FlowLayout());
            this.pnlBtn.add((Component)this.getBtnQuitter(), null);
            this.pnlBtn.add((Component)this.getBtnSupprimer(), null);
            this.pnlBtn.add((Component)this.getBtnExport(), null);
            this.pnlBtn.add((Component)this.getBtnEnregistrer(), null);
        }
        return this.pnlBtn;
    }

    private JButton getBtnExport() {
        if (this.btnExport == null) {
            this.btnExport = new JButton(LanguageTranslator.getString("button.export"));
            this.btnExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new ProfilDetail().generate();
                }
            });
        }
        return this.btnExport;
    }
}

