/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.admin;

import fr.pgh.data.BddEvent;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.Report;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.TMReport;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class DialogAdministrationRapport
extends JDialog
implements DataListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JScrollPane jspTable = null;
    private JTable tblRapport = null;
    private JPanel pnlBtn = null;
    private JButton btnQuitter = null;
    private JButton btnEnregistrer = null;

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        BddEvent e;
        if (dataEvent instanceof BddEvent && (e = (BddEvent)dataEvent).getTable().equals(Report.table)) {
            this.getTblRapport().setModel(new TMReport(Report.load()));
        }
    }

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogAdministrationRapport.dispose()#");
        super.dispose();
    }

    public DialogAdministrationRapport(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogAdministrationRapport()#");
        this.initialize();
    }

    private void initialize() {
        this.setSize(500, 500);
        this.setTitle(LanguageTranslator.getString("report.title"));
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridx = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJspTable(), gridBagConstraints);
            this.jContentPane.add((Component)this.getPnlBtn(), gridBagConstraints1);
        }
        return this.jContentPane;
    }

    private JScrollPane getJspTable() {
        if (this.jspTable == null) {
            this.jspTable = new JScrollPane();
            this.jspTable.setViewportView(this.getTblRapport());
        }
        return this.jspTable;
    }

    private JTable getTblRapport() {
        if (this.tblRapport == null) {
            this.tblRapport = new JTable();
            this.tblRapport.setModel(new TMReport(Report.load()));
        }
        return this.tblRapport;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.add((Component)this.getBtnQuitter(), new GridBagConstraints());
            this.pnlBtn.add((Component)this.getBtnEnregistrer(), new GridBagConstraints());
        }
        return this.pnlBtn;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAdministrationRapport.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAdministrationRapport.this.commit();
                    Vector<Report> toUpdate = ((TMReport)DialogAdministrationRapport.this.getTblRapport().getModel()).getTableau();
                    for (Report iter : toUpdate) {
                        iter.update();
                    }
                    DialogAdministrationRapport.this.dispose();
                }
            });
        }
        return this.btnEnregistrer;
    }

    public void commit() {
        TimsLogger.verbose("#DialogAdministrationRapport# commit");
        int row = this.getTblRapport().getSelectedRow();
        int column = this.getTblRapport().getSelectedColumn();
        if (this.getTblRapport().isEditing()) {
            TimsLogger.verbose("STOP EDITING " + row + " : " + column);
            this.getTblRapport().getCellEditor(row, column).stopCellEditing();
        }
    }
}

