/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.agence;

import fr.pgh.component.TableSorter;
import fr.pgh.connexion.TimsSession;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.CustomReportColumn;
import fr.pgh.data.bdd.Offence;
import fr.pgh.data.bdd.OffencePart;
import fr.pgh.data.bdd.OffenceType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import transpo.system.TimsLogger;
import transpo.system.ui.ViewPanel;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.TMAgencyOffence;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.user.UserPreferences;
import transpo.system.util.Fonctions;
import transport.report.CustomReportFactory;

public class PanelInfractionAgence
extends ViewPanel {
    private static final long serialVersionUID = 1L;
    private JScrollPane jspInfraction = null;
    private JTable tblOffence = null;
    private JTextField txtDateDebut = null;
    private JComboBox cbDesign = null;
    private TableSorter modeleTable = null;
    private Vector<Offence> offences = null;
    private Vector<Conducteur> drivers = null;
    private JLabel lblConducteur = null;
    private JComboBox cbConducteur = null;
    private Agence detailAgence = null;
    private JCheckBox cbBrute = null;
    private JCheckBox cbHideInfo = null;
    private JPanel pnlFilter = null;
    private JLabel lblDateDebut = null;
    private JLabel lblDesign = null;
    private JLabel lblDateFin = null;
    private JTextField txtDateFin = null;
    private JPanel pnlStat = null;
    private JScrollPane jspTblStat = null;
    private JTable tblStat = null;
    private JButton btnPrint = null;
    private JButton btnDriversPrint = null;
    private JPanel pnlBtn = null;
    private JButton btnExport = null;

    public PanelInfractionAgence() {
        this.initialize();
    }

    public PanelInfractionAgence(Agence detail) {
        this.detailAgence = detail;
        this.initialize();
        TimsSession.getInstance().addVisit(this.getClass().getName());
        this.reloadData();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 0;
        gridBagConstraints21.fill = 1;
        gridBagConstraints21.gridwidth = 2;
        gridBagConstraints21.gridy = 4;
        GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
        gridBagConstraints32.gridx = 1;
        gridBagConstraints32.fill = 1;
        gridBagConstraints32.insets = new Insets(5, 5, 5, 10);
        gridBagConstraints32.gridy = 0;
        GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
        gridBagConstraints31.gridx = 0;
        gridBagConstraints31.gridy = 0;
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.insets = new Insets(5, 10, 5, 5);
        gridBagConstraints12.fill = 3;
        gridBagConstraints12.weightx = 0.0;
        gridBagConstraints12.weighty = 0.0;
        gridBagConstraints12.gridy = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(500, 500));
        this.setBounds(new Rectangle(0, 0, 600, 500));
        this.add((Component)this.getJspInfraction(), gridBagConstraints);
        this.add((Component)this.getPnlFilter(), gridBagConstraints12);
        this.add((Component)this.getPnlStat(), gridBagConstraints32);
        this.add((Component)this.getPnlBtn(), gridBagConstraints21);
    }

    @Override
    public void close() {
    }

    @Override
    public String getMnemo() {
        return "I";
    }

    @Override
    public String getViewName() {
        return LanguageTranslator.getString("offence.title");
    }

    @Override
    public void refresh() {
    }

    private JScrollPane getJspInfraction() {
        if (this.jspInfraction == null) {
            this.jspInfraction = new JScrollPane();
            this.jspInfraction.setViewportView(this.getTblOffence());
        }
        return this.jspInfraction;
    }

    private JTable getTblOffence() {
        if (this.tblOffence == null) {
            this.tblOffence = new JTable();
        }
        return this.tblOffence;
    }

    private JTextField getTxtDateDebut() {
        if (this.txtDateDebut == null) {
            SimpleDateFormat tmp = new SimpleDateFormat("dd/MM/yyyy");
            GregorianCalendar date = new GregorianCalendar();
            date.setTime(new Date());
            date.set(5, 1);
            this.txtDateDebut = new JTextField(tmp.format(date.getTime()));
            this.txtDateDebut.setMinimumSize(new Dimension(70, 20));
            this.txtDateDebut.setPreferredSize(new Dimension(70, 20));
            this.txtDateDebut.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!Fonctions.afficheCalendrier(PanelInfractionAgence.this.getTxtDateDebut())) {
                        PanelInfractionAgence.this.getTxtDateDebut().setText("");
                    }
                    PanelInfractionAgence.this.reloadData();
                }
            });
        }
        return this.txtDateDebut;
    }

    private JComboBox getCbDesign() {
        if (this.cbDesign == null) {
            this.cbDesign = new JComboBox();
            this.cbDesign.setModel(new ComboBoxModel(OffenceType.getList(), true, LanguageTranslator.getString("generics.all")));
            this.cbDesign.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PanelInfractionAgence.this.reloadData();
                }
            });
        }
        return this.cbDesign;
    }

    @Override
    public void loadData() {
        if (!this.load) {
            this.reloadData();
            this.load = true;
        }
    }

    public void setAgence(Agence current) {
        this.load = false;
        this.detailAgence = current;
    }

    private void reloadData() {
        String dateDebut = null;
        String dateFin = null;
        if (!this.getTxtDateDebut().getText().equals("")) {
            dateDebut = ConversionTime.dateFromFranceToBDD(this.getTxtDateDebut().getText(), false);
        }
        if (!this.getTxtDateFin().getText().equals("")) {
            dateFin = ConversionTime.dateFromFranceToBDD(this.getTxtDateFin().getText(), false);
        }
        int designation = ((ComboBoxModel)this.getCbDesign().getModel()).getSelectedCle();
        int driverId = ((ComboBoxModel)this.getCbConducteur().getModel()).getSelectedCle();
        this.offences = Offence.loadList(this.detailAgence.getCleAgence(), 0, dateDebut, dateFin, this.getCbBrute().isSelected(), false);
        Collections.reverse(this.offences);
        TimsLogger.debug("agence = " + this.detailAgence.getCleAgence() + ", dateDebut = " + dateDebut + ", dateFin = " + dateFin + " = offences.size = " + this.offences.size());
        Vector<Offence> filtered = this.filtrerDonnees(dateDebut, dateFin, designation, driverId, this.getCbHideInfo().isSelected());
        this.modeleTable = new TableSorter(new TMAgencyOffence(filtered, this.getDrivers()));
        this.getTblOffence().setModel(this.modeleTable);
        this.modeleTable.setTableHeader(this.getTblOffence().getTableHeader());
        this.getTblStat().setModel(new OffenceSynthesisTM(filtered));
        this.centrerTable(this.getTblOffence());
        this.centrerTable(this.getTblStat());
    }

    private Vector<Offence> filtrerDonnees(String filtreDateDebut, String filtreDateFin, int filteredOffenceType, int filteredDriverId, boolean hideInformation) {
        TimsLogger.debug("on filtre driverId = " + filteredDriverId + ", offenceType = " + filteredOffenceType);
        boolean debut = true;
        boolean fin = true;
        boolean driver = true;
        boolean offence = true;
        Vector<Offence> retour = new Vector<Offence>();
        for (Offence inf : this.offences) {
            if (inf.getType() == 0 && hideInformation) continue;
            offence = filteredOffenceType == 0 || filteredOffenceType == OffencePart.getOffencePart(inf.getOffencePartId()).getOffenceTypeId();
            driver = filteredDriverId == 0 || filteredDriverId == inf.getDriverId();
            debut = filtreDateDebut.equals("") || filtreDateDebut.compareTo(ConversionTime.dateToString(inf.getDate(), "yyyy-MM-dd")) <= 0;
            boolean bl = fin = filtreDateFin.equals("") || filtreDateFin.compareTo(ConversionTime.dateToString(inf.getDate(), "yyyy-MM-dd")) >= 0;
            if (!offence || !driver || !debut || !fin) continue;
            retour.add(inf);
        }
        TimsLogger.debug("retour = " + retour.size());
        return retour;
    }

    private void centrerTable(JTable table) {
        DefaultTableCellRenderer custom = new DefaultTableCellRenderer();
        custom.setHorizontalAlignment(0);
        int i = 0;
        while (i < table.getColumnCount()) {
            table.getColumnModel().getColumn(i).setCellRenderer(custom);
            ++i;
        }
    }

    private JLabel getLblConducteur() {
        if (this.lblConducteur == null) {
            this.lblConducteur = new JLabel();
            this.lblConducteur.setText(LanguageTranslator.getString("generics.driver"));
        }
        return this.lblConducteur;
    }

    private JComboBox getCbConducteur() {
        if (this.cbConducteur == null) {
            this.cbConducteur = new JComboBox();
            this.cbConducteur.setModel(new ComboBoxModel(this.getDrivers(), true, LanguageTranslator.getString("generics.all")));
            this.cbConducteur.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PanelInfractionAgence.this.reloadData();
                }
            });
        }
        return this.cbConducteur;
    }

    private Vector<Conducteur> getDrivers() {
        if (this.drivers == null) {
            this.drivers = Conducteur.loadList(this.detailAgence.getCleAgence());
        }
        return this.drivers;
    }

    private JCheckBox getCbBrute() {
        if (this.cbBrute == null) {
            this.cbBrute = new JCheckBox();
            this.cbBrute.setText(LanguageTranslator.getString("generics.original"));
            String modified = UserPreferences.getPreferences("preference.offence.type");
            if (modified != null && Integer.valueOf(modified) == 1) {
                this.cbBrute.setSelected(true);
            }
            this.cbBrute.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    int pref = e.getStateChange() == 1 ? 1 : 0;
                    UserPreferences.setPreferences("preference.offence.type", String.valueOf(pref));
                    PanelInfractionAgence.this.reloadData();
                }
            });
        }
        return this.cbBrute;
    }

    private JCheckBox getCbHideInfo() {
        if (this.cbHideInfo == null) {
            this.cbHideInfo = new JCheckBox();
            this.cbHideInfo.setText(LanguageTranslator.getString("offence.hideInfo"));
            this.cbHideInfo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PanelInfractionAgence.this.reloadData();
                }
            });
        }
        return this.cbHideInfo;
    }

    private JPanel getPnlFilter() {
        if (this.pnlFilter == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints2.gridy = 5;
            gridBagConstraints2.gridwidth = 4;
            gridBagConstraints2.gridx = 0;
            this.lblDateDebut = new JLabel();
            this.lblDateDebut.setText(LanguageTranslator.getString("generics.begin"));
            this.lblDesign = new JLabel();
            this.lblDesign.setText(LanguageTranslator.getString("generics.designation"));
            this.lblDateFin = new JLabel();
            this.lblDateFin.setText(LanguageTranslator.getString("generics.end"));
            this.pnlFilter = new JPanel();
            this.pnlFilter.setLayout(new GridBagLayout());
            this.pnlFilter.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.filter"), 0, 0, null, null));
            this.pnlFilter.add((Component)this.lblDateDebut, Fonctions.getGridBagConstraints(0, 0));
            this.pnlFilter.add((Component)this.getTxtDateDebut(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 3, -1, null));
            this.pnlFilter.add((Component)this.lblDateFin, Fonctions.getGridBagConstraints(2, 0));
            this.pnlFilter.add((Component)this.getTxtDateFin(), Fonctions.getGridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 3, -1, null));
            this.pnlFilter.add((Component)this.getLblConducteur(), Fonctions.getGridBagConstraints(0, 1, 1, 4, 1.0, 0.0, 3, -1, null));
            this.pnlFilter.add((Component)this.getCbConducteur(), Fonctions.getGridBagConstraints(0, 2, 1, 4, 1.0, 0.0, 1, -1, new Insets(5, 0, 5, 0)));
            this.pnlFilter.add((Component)this.lblDesign, Fonctions.getGridBagConstraints(0, 3, 1, 4, 1.0, 0.0, 3, -1, null));
            this.pnlFilter.add((Component)this.getCbDesign(), Fonctions.getGridBagConstraints(0, 4, 1, 4, 1.0, 0.0, 1, -1, new Insets(5, 0, 5, 0)));
            this.pnlFilter.add((Component)this.getCbBrute(), Fonctions.getGridBagConstraints(0, 5, 1, 2, 1.0, 0.0, 1, -1, new Insets(5, 0, 5, 0)));
            this.pnlFilter.add((Component)this.getCbHideInfo(), Fonctions.getGridBagConstraints(2, 5, 1, 2, 1.0, 0.0, 1, -1, new Insets(5, 0, 5, 0)));
        }
        return this.pnlFilter;
    }

    private JTextField getTxtDateFin() {
        if (this.txtDateFin == null) {
            SimpleDateFormat tmp = new SimpleDateFormat("dd/MM/yyyy");
            GregorianCalendar date = new GregorianCalendar();
            date.setTime(new Date());
            date.set(5, 1);
            date.add(2, 1);
            this.txtDateFin = new JTextField(tmp.format(date.getTime()));
            this.txtDateFin.setMinimumSize(new Dimension(70, 20));
            this.txtDateFin.setPreferredSize(new Dimension(68, 20));
            this.txtDateFin.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!Fonctions.afficheCalendrier(PanelInfractionAgence.this.getTxtDateFin())) {
                        PanelInfractionAgence.this.getTxtDateFin().setText("");
                    }
                    PanelInfractionAgence.this.reloadData();
                }
            });
        }
        return this.txtDateFin;
    }

    private JPanel getPnlStat() {
        if (this.pnlStat == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.anchor = 13;
            gridBagConstraints11.gridy = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.gridx = 0;
            this.pnlStat = new JPanel();
            this.pnlStat.setLayout(new GridBagLayout());
            this.pnlStat.setBorder(BorderFactory.createTitledBorder(null, "synth\u00e8se", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlStat.add((Component)this.getJspTblStat(), gridBagConstraints1);
            this.pnlStat.add((Component)this.getBtnPrint(), gridBagConstraints11);
        }
        return this.pnlStat;
    }

    private JScrollPane getJspTblStat() {
        if (this.jspTblStat == null) {
            this.jspTblStat = new JScrollPane();
            this.jspTblStat.setViewportView(this.getTblStat());
        }
        return this.jspTblStat;
    }

    private JTable getTblStat() {
        if (this.tblStat == null) {
            this.tblStat = new JTable();
        }
        return this.tblStat;
    }

    private JButton getBtnPrint() {
        if (this.btnPrint == null) {
            this.btnPrint = new JButton(LanguageTranslator.getString("button.print"));
            this.btnPrint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanelInfractionAgence.this.print();
                }
            });
        }
        return this.btnPrint;
    }

    private void print() {
        CustomReport cr = CustomReportFactory.getGeneric(LanguageTranslator.getString("generics.agencyOffence"));
        Vector<CustomReportColumn> columns = CustomReportFactory.getAgencySynthesisOffenceColumn();
        cr.setColumn(columns);
        cr.updateProperty("DEBUT", ConversionTime.stringToDate(this.getTxtDateDebut().getText(), "dd/MM/yyyy"));
        cr.updateProperty("FIN", ConversionTime.stringToDate(this.getTxtDateFin().getText(), "dd/MM/yyyy"));
        cr.updateProperty("AGENCE", this.detailAgence.getDescription());
        cr.updateProperty("NOM_CONDUCTEUR", LanguageTranslator.getString("generics.all"));
        cr.updateProperty("PRENOM_CONDUCTEUR", " ");
        cr.updateProperty("FOOTER", " ");
        Fonctions.tblToReport(cr, null, (ArrayList)((OffenceSynthesisTM)this.getTblStat().getModel()).getData().clone());
    }

    private JButton getBtnDriversPrint() {
        if (this.btnDriversPrint == null) {
            this.btnDriversPrint = new JButton(LanguageTranslator.getString("button.print"));
            this.btnDriversPrint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanelInfractionAgence.this.printDrivers("imprimer");
                }
            });
        }
        return this.btnDriversPrint;
    }

    private void printDrivers(String out) {
        CustomReport cr = CustomReportFactory.getGeneric(LanguageTranslator.getString("generics.agencyOffence"));
        Vector<CustomReportColumn> columns = CustomReportFactory.getAgencyOffenceColumn();
        cr.setColumn(columns);
        cr.updateProperty("DEBUT", ConversionTime.stringToDate(this.getTxtDateDebut().getText(), "dd/MM/yyyy"));
        cr.updateProperty("FIN", ConversionTime.stringToDate(this.getTxtDateFin().getText(), "dd/MM/yyyy"));
        cr.updateProperty("AGENCE", this.detailAgence.getDescription());
        cr.updateProperty("NOM_CONDUCTEUR", LanguageTranslator.getString("generics.all"));
        cr.updateProperty("PRENOM_CONDUCTEUR", " ");
        cr.updateProperty("FOOTER", " ");
        Fonctions.tblToReport(cr, null, this.modeleTable.getData(), out);
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 2;
            gridBagConstraints14.gridy = 0;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 1;
            gridBagConstraints13.anchor = 13;
            gridBagConstraints13.weightx = 0.0;
            gridBagConstraints13.weighty = 1.0;
            gridBagConstraints13.insets = new Insets(0, 0, 0, 2);
            gridBagConstraints13.gridy = 0;
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.add((Component)this.getBtnDriversPrint(), gridBagConstraints13);
            this.pnlBtn.add((Component)this.getBtnExport(), gridBagConstraints14);
        }
        return this.pnlBtn;
    }

    private JButton getBtnExport() {
        if (this.btnExport == null) {
            this.btnExport = new JButton();
            this.btnExport.setText(LanguageTranslator.getString("button.export"));
            this.btnExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanelInfractionAgence.this.printDrivers("xls");
                }
            });
        }
        return this.btnExport;
    }

    class OffenceSynthesisTM
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        ArrayList<Map<String, ?>> data = null;
        String[] titres = new String[]{LanguageTranslator.getString("generics.driver"), LanguageTranslator.getString("offence.minor"), LanguageTranslator.getString("offence.serious"), LanguageTranslator.getString("offence.verySerious"), LanguageTranslator.getString("generics.total"), LanguageTranslator.getString("offence.maxCost")};

        public OffenceSynthesisTM(Vector<Offence> offences) {
            this.sum(offences);
        }

        public void sum(Vector<Offence> offences) {
            if (this.data == null) {
                this.data = new ArrayList();
            } else {
                this.data.clear();
            }
            int driverId = -1;
            int minor = 0;
            int serious = 0;
            int verySerious = 0;
            int cost = 0;
            int sumMinor = 0;
            int sumSerious = 0;
            int sumVerySerious = 0;
            for (Offence off : offences) {
                if (driverId != off.getDriverId()) {
                    if (driverId != -1) {
                        try {
                            Conducteur currentDriver = Conducteur.getDriver((Vector<Conducteur>)PanelInfractionAgence.this.drivers, driverId);
                            HashMap<String, Object> current = new HashMap<String, Object>();
                            this.data.add(current);
                            current.put(LanguageTranslator.getString("generics.driver"), String.valueOf(currentDriver.getNom()) + " " + currentDriver.getPrenom());
                            current.put(LanguageTranslator.getString("offence.minor"), minor);
                            current.put(LanguageTranslator.getString("offence.serious"), serious);
                            current.put(LanguageTranslator.getString("offence.verySerious"), verySerious);
                            current.put(LanguageTranslator.getString("generics.total"), minor + serious + verySerious);
                            current.put(LanguageTranslator.getString("offence.maxCost"), String.valueOf(cost) + " \u20ac");
                            minor = 0;
                            serious = 0;
                            verySerious = 0;
                            cost = 0;
                        }
                        catch (Exception ex) {
                            TimsLogger.warn("#agencyOffence.tablmodel# driver unknown (archived ?) " + driverId);
                            ex.printStackTrace();
                        }
                    }
                    driverId = off.getDriverId();
                }
                cost += off.getCost();
                switch (off.getType()) {
                    case 1: {
                        ++minor;
                        ++sumMinor;
                        break;
                    }
                    case 2: {
                        ++serious;
                        ++sumSerious;
                        break;
                    }
                    case 3: {
                        ++verySerious;
                        ++sumVerySerious;
                    }
                }
            }
            if (driverId != -1) {
                try {
                    Conducteur currentDriver = Conducteur.getDriver((Vector<Conducteur>)PanelInfractionAgence.this.drivers, driverId);
                    HashMap<String, Object> current = new HashMap<String, Object>();
                    this.data.add(current);
                    current.put(LanguageTranslator.getString("generics.driver"), String.valueOf(currentDriver.getNom()) + " " + currentDriver.getPrenom());
                    current.put(LanguageTranslator.getString("offence.minor"), minor);
                    current.put(LanguageTranslator.getString("offence.serious"), serious);
                    current.put(LanguageTranslator.getString("offence.verySerious"), verySerious);
                    current.put(LanguageTranslator.getString("generics.total"), minor + serious + verySerious);
                    current.put(LanguageTranslator.getString("offence.maxCost"), String.valueOf(cost) + " \u20ac");
                    minor = 0;
                    serious = 0;
                    verySerious = 0;
                }
                catch (Exception ex) {
                    TimsLogger.warn("#agencyOffence.tablmodel# driver unknown" + driverId);
                    ex.printStackTrace();
                }
            }
        }

        @Override
        public int getColumnCount() {
            return this.titres.length;
        }

        @Override
        public Object getValueAt(int parm1, int parm2) {
            Map<String, ?> current = this.data.get(parm1);
            return current.get(this.getColumnName(parm2));
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.titres[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public ArrayList<Map<String, ?>> getData() {
            return this.data;
        }
    }
}

