/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.agence;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.FuelConsumption;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleAnchor;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.ViewPanel;
import transpo.system.ui.resources.Fmresources;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class PnlAgencyConsumption
extends ViewPanel
implements Observer,
DataListener {
    private static final long serialVersionUID = 1L;
    private JPanel pnlTarget = null;
    private JPanel pnlFilter = null;
    private JPanel pnlConsumption = null;
    private Agence current = null;
    private JButton btnPrevMonth = null;
    private JButton btnPrevYear = null;
    private JLabel lblMonth = null;
    private JButton btnNextMonth = null;
    private JButton btnNextYear = null;
    private JButton btnUpdate = null;
    private ChartPanel pnlConso = null;
    private JFreeChart chartConso = null;
    private DefaultCategoryDataset chartData;
    private JComboBox cbGroup = null;
    private Date currentDate = (Date)ConversionTime.getFirstDayOfMonth(new Date(), ConversionTime.DATE);
    private JLabel lblTarget = null;
    private JTextField txtTarget = null;
    private JButton btnSave = null;
    private static final Fmresources res = new Fmresources();
    ClassLoader cl = this.getClass().getClassLoader();

    @Override
    public String getViewName() {
        return LanguageTranslator.getString("generics.consumption");
    }

    @Override
    public void refresh() {
    }

    @Override
    public void close() {
    }

    @Override
    public String getMnemo() {
        return "";
    }

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        if (dataEvent instanceof BddEvent) {
            BddEvent e = (BddEvent)dataEvent;
            e.getTable().equals("t_conducteur");
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        TimsLogger.debug("#" + this.getClass() + ".update# a faire");
    }

    public PnlAgencyConsumption() {
        LanguageTranslator.getInstance().addObserver(this);
        this.initialize();
        Transport.bdd.addDataListener(this);
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.lblTarget = new JLabel(LanguageTranslator.getString("consumption.target"));
        this.add((Component)this.getPnlTarget(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(10, 5, 10, 5)));
        this.add((Component)this.getPnlConsumption(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 0, 18, null));
    }

    private JPanel getPnlTarget() {
        if (this.pnlTarget == null) {
            this.lblMonth = new JLabel(ConversionTime.dateToString(this.currentDate, "MMM yyyy"), 0);
            this.lblMonth.setPreferredSize(new Dimension(100, 30));
            this.lblMonth.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            GridBagConstraints l0c0 = Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 10, new Insets(0, 3, 0, 3));
            GridBagConstraints l0c1 = Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 10, new Insets(0, 5, 0, 0));
            GridBagConstraints l0c2 = Fonctions.getGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 0, 10, new Insets(0, 5, 0, 0));
            this.pnlTarget = new JPanel();
            this.pnlTarget.setLayout(new GridBagLayout());
            this.pnlTarget.add((Component)this.lblTarget, l0c0);
            this.pnlTarget.add((Component)this.getTxtTarget(), l0c1);
            this.pnlTarget.add((Component)this.getBtnSave(), l0c2);
        }
        return this.pnlTarget;
    }

    private JPanel getPnlConsumption() {
        if (this.pnlConsumption == null) {
            GridBagConstraints l0c0 = Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 5, 0, 0));
            GridBagConstraints l1c0 = Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 2, 18, new Insets(0, 3, 0, 3));
            this.pnlConsumption = new JPanel();
            this.pnlConsumption.setLayout(new GridBagLayout());
            this.pnlConsumption.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("consumption.synthesis"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlConsumption.add((Component)this.getPnlFilter(), l0c0);
            this.pnlConsumption.add((Component)this.getJspChart(), l1c0);
        }
        return this.pnlConsumption;
    }

    private JPanel getPnlFilter() {
        if (this.pnlFilter == null) {
            this.lblMonth = new JLabel(ConversionTime.dateToString(this.currentDate, "MMM yyyy"), 0);
            this.lblMonth.setPreferredSize(new Dimension(100, 30));
            this.lblMonth.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            GridBagConstraints l0c0 = Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 10, new Insets(0, 3, 0, 3));
            GridBagConstraints l0c1 = Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 10, new Insets(0, 5, 0, 0));
            GridBagConstraints l0c2 = Fonctions.getGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 0, 10, new Insets(5, 5, 5, 0));
            GridBagConstraints l0c3 = Fonctions.getGridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 0, 10, new Insets(0, 5, 0, 0));
            GridBagConstraints l0c4 = Fonctions.getGridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 0, 10, new Insets(0, 5, 0, 30));
            GridBagConstraints l0c5 = Fonctions.getGridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 0, 10, new Insets(0, 5, 0, 0));
            GridBagConstraints l0c6 = Fonctions.getGridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 0, 10, new Insets(0, 5, 0, 30));
            GridBagConstraints l0c7 = Fonctions.getGridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 0, 10, new Insets(0, 5, 0, 0));
            this.pnlFilter = new JPanel();
            this.pnlFilter.setLayout(new GridBagLayout());
            this.pnlFilter.add((Component)this.getBtnPrevYear(), l0c0);
            this.pnlFilter.add((Component)this.getBtnPrevMonth(), l0c1);
            this.pnlFilter.add((Component)this.lblMonth, l0c2);
            this.pnlFilter.add((Component)this.getBtnNextMonth(), l0c3);
            this.pnlFilter.add((Component)this.getBtnNextYear(), l0c4);
            this.pnlFilter.add((Component)new JLabel(LanguageTranslator.getString("generics.orderBy")), l0c5);
            this.pnlFilter.add((Component)this.getCbGroup(), l0c6);
            this.pnlFilter.add((Component)this.getBtnUpdate(), l0c7);
        }
        return this.pnlFilter;
    }

    private JButton getBtnUpdate() {
        if (this.btnUpdate == null) {
            this.btnUpdate = new JButton();
            this.btnUpdate.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_refresh"))));
            this.btnUpdate.setPreferredSize(new Dimension(25, 25));
            this.btnUpdate.setToolTipText(LanguageTranslator.getString("button.update"));
            this.btnUpdate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlAgencyConsumption.this.reloadConso();
                }
            });
        }
        return this.btnUpdate;
    }

    private JScrollPane getJspChart() {
        JScrollPane jsp = new JScrollPane();
        jsp.setViewportView(this.getPnlConso());
        return jsp;
    }

    private JPanel getPnlConso() {
        if (this.pnlConso == null) {
            this.pnlConso = new ChartPanel(this.getChartConso());
        }
        return this.pnlConso;
    }

    private JComboBox getCbGroup() {
        if (this.cbGroup == null) {
            this.cbGroup = Fonctions.getCustomizedCB();
            this.cbGroup.addItem(LanguageTranslator.getString("generics.driver"));
            this.cbGroup.addItem(LanguageTranslator.getString("generics.vehicle"));
        }
        return this.cbGroup;
    }

    private JFreeChart getChartConso() {
        if (this.chartConso == null) {
            ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
            this.chartConso = ChartFactory.createStackedBarChart((String)LanguageTranslator.getString("fuel.consumption"), (String)"", (String)LanguageTranslator.getString("fuel.consumptionPer100"), (CategoryDataset)this.getChartData(), (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)true, (boolean)false);
        }
        return this.chartConso;
    }

    private DefaultCategoryDataset getChartData() {
        if (this.chartData == null) {
            this.chartData = new DefaultCategoryDataset();
        }
        return this.chartData;
    }

    @Override
    public void loadData() {
        if (!this.load) {
            this.reloadConso();
            this.load = true;
        }
    }

    private void reloadConso() {
        this.getChartData().clear();
        Date lastDay = (Date)ConversionTime.getLastDayOfMonth(this.currentDate, ConversionTime.DATE);
        int avgTarget = this.getCbGroup().getSelectedItem().equals(LanguageTranslator.getString("generics.driver")) ? 1 : 2;
        Vector<FuelConsumption> list = FuelConsumption.loadTotal(this.current.getCleAgence(), 0, 0, this.currentDate, lastDay, avgTarget, -1);
        float totalKmAgency = 0.0f;
        float totalLitersAgency = 0.0f;
        if (list != null) {
            for (FuelConsumption tmp : list) {
                try {
                    if (avgTarget == 1) {
                        Conducteur driver = Conducteur.getDriver(null, tmp.getDriverId());
                        String label = String.valueOf(driver.getNom()) + " " + driver.getPrenom();
                        if (driver.getTargetConsumption() != 0.0f && tmp.getConsumption() > driver.getTargetConsumption()) {
                            this.getChartData().addValue((double)driver.getTargetConsumption(), (Comparable)((Object)LanguageTranslator.getString("fuel.consumption")), (Comparable)((Object)label));
                            this.getChartData().addValue((double)(tmp.getConsumption() - driver.getTargetConsumption()), (Comparable)((Object)LanguageTranslator.getString("fuel.overconsumption")), (Comparable)((Object)label));
                        } else {
                            this.getChartData().addValue((double)tmp.getConsumption(), (Comparable)((Object)LanguageTranslator.getString("fuel.consumption")), (Comparable)((Object)label));
                        }
                    } else {
                        Vehicule vehicle = Vehicule.getVehicule(null, tmp.getVehicleId());
                        this.getChartData().addValue((double)tmp.getConsumption(), (Comparable)((Object)LanguageTranslator.getString("fuel.consumption")), (Comparable)((Object)(String.valueOf(vehicle.getRegistrationNumber()) + " - " + vehicle.getCode())));
                    }
                    totalKmAgency += tmp.getKm();
                    totalLitersAgency += tmp.getLiters();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.getChartData().addValue((double)(totalLitersAgency / totalKmAgency * 100.0f), (Comparable)((Object)LanguageTranslator.getString("fuel.consumption")), (Comparable)((Object)LanguageTranslator.getString("fuel.agencyCons")));
            if (list.size() > 14) {
                TimsLogger.debug("Size = " + list.size() * 30 + " : " + this.getPnlConso().getPreferredSize());
                this.getPnlConso().setMinimumSize(new Dimension(680, list.size() * 30));
                this.getPnlConsumption().repaint();
            } else {
                this.getPnlConso().setMinimumSize(new Dimension(680, 420));
            }
        }
        CategoryPlot plot = this.getChartConso().getCategoryPlot();
        plot.getRenderer(0).setSeriesPaint(0, (Paint)new Color(97, 170, 78));
        plot.getRenderer(0).setSeriesPaint(1, (Paint)new Color(255, 70, 78));
        ValueMarker marker = new ValueMarker((double)this.current.getTargetConsumption());
        marker.setLabel(LanguageTranslator.getString("consumption.target"));
        marker.setAlpha(0.8f);
        marker.setPaint((Paint)Color.RED);
        marker.setLabelPaint((Paint)Color.RED);
        marker.setLabelAnchor(RectangleAnchor.BOTTOM);
        plot.clearRangeMarkers();
        plot.addRangeMarker((Marker)marker);
    }

    public void set(Agence current) {
        this.current = current;
        this.getTxtTarget().setText(String.valueOf(current.getTargetConsumption()));
        this.load = false;
    }

    private JButton getBtnPrevMonth() {
        if (this.btnPrevMonth == null) {
            this.btnPrevMonth = new JButton();
            this.btnPrevMonth.setBorder(null);
            this.btnPrevMonth.setToolTipText(LanguageTranslator.getString("calendar.previousMonth"));
            this.btnPrevMonth.setBorderPainted(false);
            this.btnPrevMonth.setContentAreaFilled(false);
            this.btnPrevMonth.setFocusPainted(false);
            this.btnPrevMonth.setHorizontalTextPosition(0);
            this.btnPrevMonth.setIcon(this.getLeft());
            this.btnPrevMonth.setBounds(new Rectangle(1, 33, 25, 27));
            this.btnPrevMonth.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlAgencyConsumption.this.addMonth(-1);
                }
            });
        }
        return this.btnPrevMonth;
    }

    private JButton getBtnNextMonth() {
        if (this.btnNextMonth == null) {
            this.btnNextMonth = new JButton();
            this.btnNextMonth.setBorder(null);
            this.btnNextMonth.setToolTipText(LanguageTranslator.getString("calendar.nextMonth"));
            this.btnNextMonth.setBorderPainted(false);
            this.btnNextMonth.setContentAreaFilled(false);
            this.btnNextMonth.setFocusPainted(false);
            this.btnNextMonth.setHorizontalTextPosition(0);
            this.btnNextMonth.setIcon(this.getRight());
            this.btnNextMonth.setBounds(new Rectangle(151, 33, 25, 27));
            this.btnNextMonth.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlAgencyConsumption.this.addMonth(1);
                }
            });
        }
        return this.btnNextMonth;
    }

    private JButton getBtnPrevYear() {
        if (this.btnPrevYear == null) {
            this.btnPrevYear = new JButton();
            this.btnPrevYear.setBorder(null);
            this.btnPrevYear.setToolTipText(LanguageTranslator.getString("calendar.previousYear"));
            this.btnPrevYear.setBorderPainted(false);
            this.btnPrevYear.setContentAreaFilled(false);
            this.btnPrevYear.setFocusPainted(false);
            this.btnPrevYear.setHorizontalTextPosition(0);
            this.btnPrevYear.setIcon(this.getDLeft());
            this.btnPrevYear.setBounds(new Rectangle(25, 2, 25, 27));
            this.btnPrevYear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlAgencyConsumption.this.addMonth(-12);
                }
            });
        }
        return this.btnPrevYear;
    }

    private JButton getBtnNextYear() {
        if (this.btnNextYear == null) {
            this.btnNextYear = new JButton();
            this.btnNextYear.setBorder(null);
            this.btnNextYear.setToolTipText(LanguageTranslator.getString("calendar.nextYear"));
            this.btnNextYear.setBorderPainted(false);
            this.btnNextYear.setContentAreaFilled(false);
            this.btnNextYear.setFocusPainted(false);
            this.btnNextYear.setHorizontalTextPosition(0);
            this.btnNextYear.setIcon(this.getDRight());
            this.btnNextYear.setBounds(new Rectangle(129, 2, 25, 27));
            this.btnNextYear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlAgencyConsumption.this.addMonth(12);
                }
            });
        }
        return this.btnNextYear;
    }

    private JTextField getTxtTarget() {
        if (this.txtTarget == null) {
            this.txtTarget = new JTextField();
            this.txtTarget.setMinimumSize(new Dimension(70, 20));
            this.txtTarget.setPreferredSize(new Dimension(80, 20));
            this.txtTarget.setText("");
        }
        return this.txtTarget;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton();
            this.btnSave.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_save"))));
            this.btnSave.setPreferredSize(new Dimension(25, 25));
            this.btnSave.setToolTipText(LanguageTranslator.getString("button.save"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlAgencyConsumption.this.save();
                }
            });
        }
        return this.btnSave;
    }

    public void save() {
        if (!this.check()) {
            return;
        }
        if (!this.current.compareAndUpdateConsumption(Fonctions.parseFloat(this.getTxtTarget().getText()).floatValue())) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.saveError"), LanguageTranslator.getString("message.error"), 0);
        }
    }

    public boolean check() {
        boolean toReturn = true;
        if (!Fonctions.isFloat(this.getTxtTarget().getText())) {
            this.getTxtTarget().setBackground(new Color(255, 192, 203));
            this.getTxtTarget().setToolTipText(LanguageTranslator.getString("generics.incorrectValue"));
            toReturn = false;
        }
        return toReturn;
    }

    private ImageIcon getRight() {
        return new ImageIcon(this.cl.getResource(res.getResourceString("icone_right")));
    }

    private ImageIcon getLeft() {
        return new ImageIcon(this.cl.getResource(res.getResourceString("icone_left")));
    }

    private ImageIcon getDRight() {
        return new ImageIcon(this.cl.getResource(res.getResourceString("icone_dright")));
    }

    private ImageIcon getDLeft() {
        return new ImageIcon(this.cl.getResource(res.getResourceString("icone_dleft")));
    }

    private void addMonth(int i) {
        this.currentDate = ConversionTime.add(this.currentDate, 2, i);
        this.lblMonth.setText(ConversionTime.dateToString(this.currentDate, "MMM yyyy"));
    }
}

