/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.agence;

import fr.pgh.component.FriendlyLoad;
import fr.pgh.component.JFriendlyLoadTable;
import fr.pgh.component.ui.WaiterLayerUI;
import fr.pgh.connexion.TimsSession;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.CustomReportColumn;
import fr.pgh.data.bdd.GlobalCalendarDay;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.TypeContrat;
import fr.pgh.exception.DayTypeNotFoundException;
import fr.pgh.exception.TypeContratNotFoundException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.ViewPanel;
import transpo.system.ui.modele.TMPrintable2;
import transpo.system.ui.renderer.DriverTableHeaderRenderer;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.agence.GlobalScrollPane;
import transpo.system.util.Fonctions;
import transpo.system.util.messaging.MessageSystemManager;
import transport.report.CustomReportFactory;
import transport.report.generator.DJAgencySynthesis;
import transport.report.generator.DJGenerator;

public class PnlConducteurAgence
extends ViewPanel {
    private static final long serialVersionUID = 1L;
    private Agence agence = null;
    private GlobalScrollPane jspTable = null;
    private JFriendlyLoadTable tblData = null;
    private JTextField txtDebut = null;
    private JTextField txtFin = null;
    private static final String VIEW_NAME = LanguageTranslator.getString("generics.driver");
    Vector<String> date = null;
    Vector<Conducteur> drivers = null;
    private ArrayList<Map<String, ?>> data = null;
    private JButton btnImprimer = null;
    private JButton btnExport = null;
    private JPanel pnlFilter = null;
    private JButton btnRefresh = null;
    private JPanel pnlBtn = null;
    final WaiterLayerUI layerUI = new WaiterLayerUI();

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void close() {
    }

    @Override
    public String getMnemo() {
        return "";
    }

    public PnlConducteurAgence(Agence agence) {
        this.agence = agence;
        this.initialize();
        TimsSession.getInstance().addVisit(this.getClass().getName());
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.fill = 1;
        gridBagConstraints11.weightx = 1.0;
        gridBagConstraints11.gridy = 3;
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 0;
        gridBagConstraints21.insets = new Insets(10, 0, 5, 0);
        gridBagConstraints21.gridy = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        this.setSize(600, 400);
        this.setLayout(new GridBagLayout());
        JPanel pnlGlobal = new JPanel();
        pnlGlobal.setLayout(new GridBagLayout());
        pnlGlobal.add((Component)this.getJspTable(), gridBagConstraints);
        pnlGlobal.add((Component)this.getPnlFilter(), gridBagConstraints21);
        pnlGlobal.add((Component)this.getPnlBtn(), gridBagConstraints11);
        JLayer<JPanel> jlayer = new JLayer<JPanel>(pnlGlobal, this.layerUI);
        this.add(jlayer, Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, null));
    }

    private GlobalScrollPane getJspTable() {
        if (this.jspTable == null) {
            this.jspTable = new GlobalScrollPane(0);
        }
        return this.jspTable;
    }

    private JFriendlyLoadTable getTblData() {
        if (this.tblData == null) {
            this.tblData = new JFriendlyLoadTable();
            this.tblData.setRowHeight(22);
            this.tblData.setAutoResizeMode(0);
            this.tblData.getTableHeader().setDefaultRenderer(new DriverTableHeaderRenderer());
        }
        return this.tblData;
    }

    private JTextField getTxtDebut() {
        if (this.txtDebut == null) {
            this.txtDebut = new JTextField();
            this.txtDebut.setPreferredSize(new Dimension(70, 20));
            this.txtDebut.setText(ConversionTime.getFirstDayOfMonth(new Date(), ConversionTime.STRING).toString());
            this.txtDebut.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(PnlConducteurAgence.this.getTxtDebut());
                }
            });
        }
        return this.txtDebut;
    }

    private JTextField getTxtFin() {
        if (this.txtFin == null) {
            this.txtFin = new JTextField();
            this.txtFin.setPreferredSize(new Dimension(70, 20));
            this.txtFin.setText(ConversionTime.dateToString(new Date(), "dd/MM/yyyy"));
            this.txtFin.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(PnlConducteurAgence.this.getTxtFin());
                }
            });
        }
        return this.txtFin;
    }

    @Override
    public void loadData() {
        if (!this.load) {
            this.refreshTable();
            this.load = true;
        }
    }

    private void refreshTable() {
        Thread t = new Thread(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        (this).PnlConducteurAgence.this.layerUI.start();
                    }
                });
                PnlConducteurAgence.this.loadTable(PnlConducteurAgence.this.getTblData());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PnlConducteurAgence.this.getJspTable().defineTable(PnlConducteurAgence.this.getTblData(), (this).PnlConducteurAgence.this.drivers, (this).PnlConducteurAgence.this.date, PnlConducteurAgence.this.data);
                    }
                });
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        (this).PnlConducteurAgence.this.layerUI.stop();
                    }
                });
            }
        };
        t.start();
    }

    /*
     * Unable to fully structure code
     */
    private void loadTable(FriendlyLoad toUpdate) {
        Transport.ps.startOperation();
        begin = ConversionTime.stringToDate(this.getTxtDebut().getText(), "dd/MM/yyyy");
        end = ConversionTime.stringToDate(this.getTxtFin().getText(), "dd/MM/yyyy");
        if (begin.after(end)) {
            MessageSystemManager.error((Component)MainFrameTransport.getInstance(), LanguageTranslator.getString("monitoring.dateError"), LanguageTranslator.getString("message.inputError"));
            return;
        }
        this.date = this.getDateVector(this.getTxtDebut().getText(), this.getTxtFin().getText());
        this.drivers = Conducteur.loadList(new Integer[]{this.agence.getCleAgence()});
        this.data = new ArrayList<E>();
        tmpS = Service.getService(this.agence.getCleAgence(), 0, begin, end);
        tmpL = LienJourConducteur.loadList(this.agence.getCleAgence(), 0, begin, end);
        TimsLogger.debug("#PCA.loadTable()# " + this.drivers.size() + " conducteurs, " + tmpS.size() + " services, " + tmpL.size() + " jours");
        defaultDayLength = 0;
        currentContract = null;
        ljc = new Vector<LienJourConducteur>();
        x = 0;
        while (x < this.drivers.size()) {
            block22: {
                total = 0;
                currentDriver = this.drivers.get(x);
                driverData = new HashMap<String, Object>();
                this.data.add(driverData);
                driverData.put(LanguageTranslator.getString("generics.driver"), String.valueOf(currentDriver.getNom()) + " " + currentDriver.getPrenom());
                requirements = true;
                try {
                    TimsLogger.debug("#PCA.loadTable()# C'est le d\u00e9but du conducteur " + currentDriver.getNom() + " (" + currentDriver.getCleConducteur() + ")");
                    currentContract = TypeContrat.getTypeContrat(currentDriver.getCleTypeContrat());
                }
                catch (TypeContratNotFoundException ex) {
                    requirements = false;
                    TimsLogger.debug("#PCA.loadTable()# unable to retrieve contract type " + currentDriver.getCleTypeContrat() + " driver " + currentDriver.getNom());
                    if (Transport.debug < 1) break block22;
                    ex.printStackTrace();
                }
            }
            if (System.getProperty("contract_day_length_reference", "0").equals("1")) {
                defaultDayLength = currentContract != null ? currentContract.getDailyValue() : 0;
            }
            tmpC = null;
            if (currentDriver.getCalendarId() != 0) {
                tmpC = GlobalCalendarDay.loadList(currentDriver.getCalendarId(), begin, end);
            }
            serviceLeft = true;
            ljcLeft = true;
            day = begin;
            while (day.compareTo(end) <= 0) {
                block23: {
                    if (Transport.debug >= 2) {
                        TimsLogger.debug("#PCA.loadTable()# (" + currentDriver.getCleConducteur() + ") " + ConversionTime.dateToString(day, "dd/MM/yyyy"));
                    }
                    s = null;
                    second = null;
                    ljc.clear();
                    if (serviceLeft && tmpS.size() != 0) {
                        if (tmpS.get(0).getDriverId() != currentDriver.getCleConducteur()) {
                            serviceLeft = false;
                            if (Transport.debug >= 2) {
                                TimsLogger.debug("#PCA.loadTable()# endOfService (no more service)");
                            }
                            tmpS.get(0).affiche();
                        } else if (day.equals(ConversionTime.stringToDate(tmpS.get(0).getBeginDate().substring(0, 10), "yyyy-MM-dd"))) {
                            s = tmpS.get(0);
                            tmpS.remove(0);
                            if (tmpS.size() != 0 && day.equals(ConversionTime.stringToDate(tmpS.get(0).getBeginDate().substring(0, 10), "yyyy-MM-dd")) && tmpS.get(0).getDriverId() == currentDriver.getCleConducteur()) {
                                if (Transport.debug >= 2) {
                                    TimsLogger.debug("#aac.process# 2 services sur le m\u00eame jour ");
                                }
                                tmpS.get(0).affiche();
                                second = tmpS.get(0);
                                tmpS.remove(0);
                            }
                        }
                    }
                    if (!ljcLeft || tmpL.size() == 0) break block23;
                    if (tmpL.get(0).getCleConducteur() == currentDriver.getCleConducteur()) ** GOTO lbl77
                    ljcLeft = false;
                    TimsLogger.debug("#PCA.loadTable()# endOfLjc (" + tmpL.get(0).getCleConducteur() + ")");
                    break block23;
lbl-1000:
                    // 1 sources

                    {
                        ljc.add(tmpL.get(0));
                        tmpL.remove(0);
lbl77:
                        // 2 sources

                        ** while (tmpL.size() != 0 && day.equals((Object)tmpL.get((int)0).getDateJour()) && tmpL.get((int)0).getCleConducteur() == currentDriver.getCleConducteur())
                    }
                }
                if (tmpC != null) {
                    y = 0;
                    while (y < tmpC.size()) {
                        if (day.equals(tmpC.get(y).getDate())) {
                            toAdd = new LienJourConducteur();
                            toAdd.setValues(-1, currentDriver.getCleConducteur(), tmpC.get(y).getDayTypeId(), 0, day, 0, 0, 2);
                            if (Transport.debug >= 2) {
                                TimsLogger.debug("from calendar : ");
                            }
                            toAdd.affiche();
                            ljc.add(toAdd);
                            tmpC.remove(y);
                            break;
                        }
                        ++y;
                    }
                }
                if (s == null && (ljc == null || ljc.size() == 0)) {
                    TimsLogger.debug("#PCA.loadTable()# aucune donn\u00e9es");
                } else {
                    total += this.fillMap(currentDriver, driverData, day, s, second, ljc, defaultDayLength);
                }
                day = ConversionTime.addDay(day, 1);
            }
            TimsLogger.debug("#PCA.loadTable()# C'est la fin du conducteur " + currentDriver.getNom());
            driverData.put(LanguageTranslator.getString("generics.total"), total);
            ++x;
        }
        TimsLogger.info("#PnlConducteurAgence.loadTable# data contient " + this.data.size() + " entr\u00e9es");
        Transport.ps.endOperation(PerformanceScanner.READING, "driver table");
    }

    public void setAgence(Agence current) {
        this.agence = current;
        this.load = false;
    }

    public int fillMap(Conducteur driver, HashMap<String, Object> toFill, Date toAdd, Service s, Service second, Vector<LienJourConducteur> l, int defaultDayLength) {
        TimsLogger.debug("#ServiceSynthese.process()# on ajoute ");
        if (s != null) {
            s.affiche();
        }
        if (l != null && l.size() != 0) {
            l.get(0).affiche();
        }
        int remuneration = s != null ? s.getService() : 0;
        remuneration += second != null ? second.getService() : 0;
        int color = 0;
        String designation = "";
        try {
            if (l != null && l.size() != 0) {
                for (LienJourConducteur ljc : l) {
                    JourType dayType = JourType.getDayType(ljc.getCleJourType());
                    int length = 0;
                    if (dayType.shouldPay(driver, ljc.getDateJour())) {
                        length = ljc.getDuree(defaultDayLength);
                        boolean serviceIncluded = dayType.isServiceIncluded() && (ljc.getType() == 2 || System.getProperty("company", "PGH").equals("salvesen") && ljc.getDuree(defaultDayLength) >= 420);
                        dayType.isPaid();
                        if (dayType.isGenerateHS()) {
                            remuneration = serviceIncluded ? length : (remuneration += length);
                        }
                    }
                    designation = String.valueOf(designation) + ", " + dayType.getCode();
                    color = dayType.getColor();
                }
            }
        }
        catch (DayTypeNotFoundException ex) {
            TimsLogger.warn("#PCA.fillMap# DayType " + l.get(0).getCleJourType() + " not found");
        }
        String date = ConversionTime.dateToString(toAdd, "dd/MM/yyyy");
        toFill.put(date, remuneration);
        if (!designation.equals("")) {
            toFill.put(String.valueOf(date) + "_ABS", designation.substring(2));
            toFill.put(String.valueOf(date) + "_COL", color);
        }
        return remuneration;
    }

    private Vector<String> getDateVector(String dateDebut, String dateFin) {
        Vector<String> tmp = new Vector<String>();
        tmp.add(dateDebut);
        while (!dateDebut.equals(dateFin)) {
            dateDebut = ConversionTime.addDay(dateDebut, "dd/MM/yyyy", 1);
            tmp.add(dateDebut);
        }
        return tmp;
    }

    private void printTbl(String out) {
        CustomReport cr = CustomReportFactory.getGeneric(LanguageTranslator.getString("agency.synthesis"));
        Vector<CustomReportColumn> columns = CustomReportFactory.getDefaultAgencySynthesisColumn(this.date);
        cr.setColumn(columns);
        cr.updateProperty("OUT", out);
        cr.updateProperty("TEMPLATE", DJGenerator.LANDSCAPE_TEMPLATE);
        if (out.equals("xls")) {
            cr.updateProperty("RESOLUTION", String.valueOf(0));
        } else {
            cr.updateProperty("RESOLUTION", String.valueOf(1));
        }
        cr.updateProperty("AGENCE", this.agence.getDescription());
        Fonctions.tblToReport(cr, new DJAgencySynthesis(), ((TMPrintable2)this.getTblData().getModel()).getData(), out);
    }

    private JButton getBtnImprimer() {
        if (this.btnImprimer == null) {
            this.btnImprimer = new JButton();
            this.btnImprimer.setText(LanguageTranslator.getString("button.print"));
            this.btnImprimer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlConducteurAgence.this.printTbl("imprimer");
                    PnlConducteurAgence.this.refreshTable();
                }
            });
        }
        return this.btnImprimer;
    }

    private JButton getBtnExport() {
        if (this.btnExport == null) {
            this.btnExport = new JButton();
            this.btnExport.setText(LanguageTranslator.getString("button.export"));
            this.btnExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlConducteurAgence.this.printTbl("xls");
                    PnlConducteurAgence.this.refreshTable();
                }
            });
        }
        return this.btnExport;
    }

    private JPanel getPnlFilter() {
        if (this.pnlFilter == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 3;
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.insets = new Insets(0, 5, 0, 5);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridx = -1;
            gridBagConstraints1.gridy = -1;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
            this.pnlFilter = new JPanel();
            this.pnlFilter.setLayout(new GridBagLayout());
            this.pnlFilter.add((Component)this.getTxtDebut(), gridBagConstraints1);
            this.pnlFilter.add((Component)this.getTxtFin(), gridBagConstraints2);
            this.pnlFilter.add((Component)this.getBtnRefresh(), gridBagConstraints3);
        }
        return this.pnlFilter;
    }

    private JButton getBtnRefresh() {
        if (this.btnRefresh == null) {
            this.btnRefresh = new JButton();
            this.btnRefresh.setText(LanguageTranslator.getString("button.load"));
            this.btnRefresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlConducteurAgence.this.refreshTable();
                }
            });
        }
        return this.btnRefresh;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.insets = new Insets(0, 0, 5, 0);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(0, 0, 5, 5);
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.add((Component)this.getBtnImprimer(), gridBagConstraints4);
            this.pnlBtn.add((Component)this.getBtnExport(), gridBagConstraints5);
        }
        return this.pnlBtn;
    }
}

