/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.agence;

import fr.pgh.component.JMultiListBox;
import fr.pgh.component.model.MultiListBoxModel;
import fr.pgh.connexion.TimsSession;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.RoundAffectation;
import fr.pgh.data.bdd.RoundType;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.listener.RoundTabListener;
import transpo.system.ui.ViewPanel;
import transpo.system.ui.modele.ModelRoundTab;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.agence.RoundGraphic;
import transpo.system.util.Fonctions;

public class PnlRoundAgency
extends ViewPanel
implements RoundTabListener {
    private static final long serialVersionUID = 1L;
    private static final String VIEW_NAME = LanguageTranslator.getString("generics.round");
    private Agence agence = null;
    private JTextField txtBegin = null;
    private JTextField txtEnd = null;
    private JButton btnLoad = null;
    private JMultiListBox cbDrivers = null;
    private JMultiListBox cbRounds = null;
    private JMultiListBox cbVehicles = null;
    private JMultiListBox mbDays = null;
    private JPanel pnlPpl = null;
    private JPanel pnlBtn = null;
    private JPanel pnlFiltersGraph = null;
    private JScrollPane jspGraph = null;
    private RoundGraphic graph = null;
    private JButton btnImprimer = null;
    private JButton btnExport = null;
    private Date begin = null;
    private Date end = null;
    private JPanel pnlFilter = null;
    private JPanel pnlHeader = null;
    private JPanel pnlStatistics = null;
    private JScrollPane jspStat = null;
    private JTable tblStat = null;
    private ModelRoundTab model = null;

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void close() {
    }

    @Override
    public String getMnemo() {
        return "";
    }

    public PnlRoundAgency(Agence agence) {
        this.agence = agence;
        this.initialize();
    }

    private void initialize() {
        this.setSize(600, 400);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gcbPnlHeader = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 2, -1, null);
        GridBagConstraints gcbPnlPpl = Fonctions.getGridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 1, -1, null);
        this.add((Component)this.getPnlHeader(), gcbPnlHeader);
        this.add((Component)this.getPnlPpl(), gcbPnlPpl);
        this.getModel().addDataListener(this);
        TimsSession.getInstance().addVisit(this.getClass().getName());
    }

    private ModelRoundTab getModel() {
        if (this.model == null) {
            this.model = new ModelRoundTab();
        }
        return this.model;
    }

    private JPanel getPnlHeader() {
        if (this.pnlHeader == null) {
            this.pnlHeader = new JPanel();
            this.pnlHeader.setLayout(new GridBagLayout());
            GridBagConstraints gcbPnlFilter = Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 1, -1, null);
            GridBagConstraints gcbPnlStatistic = Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 1, -1, null);
            this.pnlHeader.add((Component)this.getPnlFilter(), gcbPnlFilter);
            this.pnlHeader.add((Component)this.getPnlStatistics(), gcbPnlStatistic);
        }
        return this.pnlHeader;
    }

    private JPanel getPnlFilter() {
        if (this.pnlFilter == null) {
            GridBagConstraints gcbLblFrom = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 0, -1, new Insets(5, 5, 0, 0));
            GridBagConstraints gcbTxtBegin = Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 2, -1, new Insets(5, 2, 0, 2));
            GridBagConstraints gcbLblTo = Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 0, -1, new Insets(5, 2, 0, 2));
            GridBagConstraints gcbTxtEnd = Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 2, -1, new Insets(5, 2, 0, 2));
            GridBagConstraints gcbBtnLoad = Fonctions.getGridBagConstraints(0, 2, 1, 2, 1.0, 0.0, 2, -1, new Insets(5, 2, 0, 2));
            JLabel lblFrom = new JLabel(LanguageTranslator.getString("generics.from"));
            JLabel lblTo = new JLabel(LanguageTranslator.getString("generics.to"));
            this.pnlFilter = new JPanel();
            this.pnlFilter.setLayout(new GridBagLayout());
            this.pnlFilter.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.filter"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlFilter.add((Component)lblFrom, gcbLblFrom);
            this.pnlFilter.add((Component)this.getTxtBegin(), gcbTxtBegin);
            this.pnlFilter.add((Component)lblTo, gcbLblTo);
            this.pnlFilter.add((Component)this.getTxtEnd(), gcbTxtEnd);
            this.pnlFilter.add((Component)this.getBtnLoad(), gcbBtnLoad);
        }
        return this.pnlFilter;
    }

    private JPanel getPnlStatistics() {
        if (this.pnlStatistics == null) {
            GridBagConstraints gcbJspStat = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 2, -1, new Insets(5, 0, 0, 0));
            this.pnlStatistics = new JPanel();
            this.pnlStatistics.setLayout(new GridBagLayout());
            this.pnlStatistics.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.synthesis"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlStatistics.add((Component)this.getJspStat(), gcbJspStat);
        }
        return this.pnlStatistics;
    }

    private JScrollPane getJspStat() {
        if (this.jspStat == null) {
            this.jspStat = new JScrollPane();
            this.jspStat.setPreferredSize(new Dimension(0, 150));
            this.jspStat.setViewportView(this.getTblStat());
        }
        return this.jspStat;
    }

    private JTable getTblStat() {
        if (this.tblStat == null) {
            this.tblStat = new JTable();
            this.tblStat.setModel(this.getModel());
            this.getModel().addTableModelListener(this.tblStat);
        }
        return this.tblStat;
    }

    private JTextField getTxtBegin() {
        if (this.txtBegin == null) {
            this.txtBegin = new JTextField(){
                private static final long serialVersionUID = 1L;

                @Override
                public void setText(String t) {
                    PnlRoundAgency.this.begin = ConversionTime.stringToDate(t, "dd/MM/yyyy");
                    super.setText(t);
                }
            };
            this.txtBegin.setPreferredSize(new Dimension(70, 20));
            this.txtBegin.setText(ConversionTime.getFirstDayOfMonth(new Date(), ConversionTime.STRING).toString());
            this.txtBegin.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(PnlRoundAgency.this.txtBegin);
                }
            });
        }
        return this.txtBegin;
    }

    private JTextField getTxtEnd() {
        if (this.txtEnd == null) {
            this.txtEnd = new JTextField(){
                private static final long serialVersionUID = 1L;

                @Override
                public void setText(String t) {
                    PnlRoundAgency.this.end = ConversionTime.stringToDate(t, "dd/MM/yyyy");
                    super.setText(t);
                }
            };
            this.txtEnd.setPreferredSize(new Dimension(70, 20));
            this.txtEnd.setText(ConversionTime.addDay(this.getTxtBegin().getText(), "dd/MM/yyyy", 7));
            this.txtEnd.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(PnlRoundAgency.this.txtEnd);
                }
            });
        }
        return this.txtEnd;
    }

    private JButton getBtnLoad() {
        if (this.btnLoad == null) {
            this.btnLoad = new JButton();
            this.btnLoad.setText(LanguageTranslator.getString("button.load"));
            this.btnLoad.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlRoundAgency.this.load();
                }
            });
        }
        return this.btnLoad;
    }

    @Override
    public void loadData() {
        if (!this.load) {
            this.load();
            this.load = true;
        }
    }

    public void setAgence(Agence agence) {
        this.agence = agence;
        this.load = false;
    }

    private void load() {
        Transport.ps.startOperation();
        if (this.begin.after(this.end)) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("monitoring.dateError"), LanguageTranslator.getString("message.inputError"), 0);
            return;
        }
        this.getMbDays().setModel(new MultiListBoxModel<Date>(this.getDays(), true));
        this.getMbDays().getModel().clearSelection();
        this.getMbDays().getModel().addSelectedIndex(1);
        this.model.setData(RoundAffectation.loadList(this.agence.getCleAgence(), 0, 0, this.begin, this.end, "ROUND_DATE"), this.begin, this.end);
        Transport.ps.endOperation(PerformanceScanner.READING, "round agency");
    }

    private JPanel getPnlPpl() {
        if (this.pnlPpl == null) {
            this.pnlPpl = new JPanel();
            this.pnlPpl.setLayout(new GridBagLayout());
            this.pnlPpl.add((Component)this.getPnlFiltersGraph(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 1, 11, null));
            this.pnlPpl.add((Component)this.getJspGraph(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, 11, null));
            this.pnlPpl.add((Component)this.getPnlBtn(), Fonctions.getGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 2, 11, null));
        }
        return this.pnlPpl;
    }

    private JPanel getPnlFiltersGraph() {
        if (this.pnlFiltersGraph == null) {
            this.pnlFiltersGraph = new JPanel();
            this.pnlFiltersGraph.setLayout(new GridBagLayout());
            this.pnlFiltersGraph.add((Component)this.getMbDays(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 1, 11, null));
            this.pnlFiltersGraph.add((Component)this.getCbDrivers(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 1, 11, null));
            this.pnlFiltersGraph.add((Component)this.getCbRound(), Fonctions.getGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 1, 11, null));
            this.pnlFiltersGraph.add((Component)this.getCbVehicles(), Fonctions.getGridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 1, 11, null));
        }
        return this.pnlFiltersGraph;
    }

    private Vector<Date> getDays() {
        Vector<Date> toReturn = new Vector<Date>();
        Date tmpBegin = new Date(this.begin.getTime());
        while (tmpBegin.before(this.end)) {
            toReturn.add(tmpBegin);
            tmpBegin = ConversionTime.addDay(tmpBegin, 1);
        }
        return toReturn;
    }

    private JMultiListBox getMbDays() {
        if (this.mbDays == null) {
            this.mbDays = new JMultiListBox();
            this.mbDays.setModel(new MultiListBoxModel<Date>(this.getDays(), true));
            this.mbDays.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    TimsLogger.verbose("#PnlRoundAgency.getMbDays()# popup will be shadowed");
                    PnlRoundAgency.this.applyFilters();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
        return this.mbDays;
    }

    private JMultiListBox getCbDrivers() {
        if (this.cbDrivers == null) {
            this.cbDrivers = new JMultiListBox();
            this.cbDrivers.setModel(new MultiListBoxModel<Conducteur>(Conducteur.loadList(this.agence.getCleAgence()), true));
            this.cbDrivers.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    TimsLogger.verbose("#PnlRoundAgency.getCbDrivers()# popup will be shadowed");
                    PnlRoundAgency.this.applyFilters();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
        return this.cbDrivers;
    }

    private JMultiListBox getCbRound() {
        if (this.cbRounds == null) {
            this.cbRounds = new JMultiListBox();
            this.cbRounds.setModel(new MultiListBoxModel<RoundType>(RoundType.loadList(null), true));
            this.cbRounds.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    TimsLogger.verbose("#PnlRoundAgency.getCbRound()# popup will be shadowed");
                    PnlRoundAgency.this.applyFilters();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
        return this.cbRounds;
    }

    private JMultiListBox getCbVehicles() {
        if (this.cbVehicles == null) {
            this.cbVehicles = new JMultiListBox();
            this.cbVehicles.setModel(new MultiListBoxModel<Vehicule>(Vehicule.loadList(this.agence.getCleAgence()), true));
            this.cbVehicles.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    TimsLogger.verbose("#PnlRoundAgency.getCbVehicles()# popup will be shadowed");
                    PnlRoundAgency.this.applyFilters();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
        return this.cbVehicles;
    }

    private JScrollPane getJspGraph() {
        if (this.jspGraph == null) {
            this.jspGraph = new JScrollPane();
            this.jspGraph.setViewportView(this.getGraph());
        }
        return this.jspGraph;
    }

    private RoundGraphic getGraph() {
        if (this.graph == null) {
            this.graph = new RoundGraphic();
        }
        return this.graph;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.insets = new Insets(0, 0, 5, 0);
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            gridBagConstraints41.insets = new Insets(0, 0, 5, 5);
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
        }
        return this.pnlBtn;
    }

    private JButton getBtnImprimer() {
        if (this.btnImprimer == null) {
            this.btnImprimer = new JButton();
            this.btnImprimer.setText(LanguageTranslator.getString("button.print"));
        }
        return this.btnImprimer;
    }

    private JButton getBtnExport() {
        if (this.btnExport == null) {
            this.btnExport = new JButton();
            this.btnExport.setText(LanguageTranslator.getString("button.export"));
        }
        return this.btnExport;
    }

    @Override
    public void selectionChanged(Vector<RoundAffectation> newSelection) {
        this.getGraph().initialiser(newSelection, null);
    }

    @Override
    public void dataChanged(Vector<RoundAffectation> newData) {
        this.applyFilters();
    }

    public void applyFilters() {
        Vector<Integer> vehicle = this.getCbVehicles().getModel().getSelectedId(true);
        Vector<Integer> driver = this.getCbDrivers().getModel().getSelectedId(true);
        Vector<Integer> roundType = this.getCbRound().getModel().getSelectedId(true);
        Vector<Date> days = this.getMbDays().getModel().getSelectedItems();
        this.model.selectionFilters(days, roundType, driver, vehicle);
    }
}

