/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.conducteur;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.ExpensesType;
import fr.pgh.data.bdd.ExpensesValidation;
import fr.pgh.data.bdd.Fault;
import fr.pgh.data.bdd.Jour;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.Service;
import fr.pgh.exception.DayTypeNotFoundException;
import fr.pgh.exception.ExpensesNotFoundException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.MouseInfo;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.TMDay;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.DialogCreerJour;
import transpo.system.ui.views.DialogDetailJourSupprime;
import transpo.system.ui.views.conducteur.DialogDetailJournee;
import transpo.system.ui.views.conducteur.NewPnlCalendrier;
import transpo.system.ui.views.conducteur.PnlFraisConducteur;
import transpo.system.util.Fonctions;

public class CalendarDayZoom
extends JDialog
implements MouseMotionListener {
    private static final int EXPENSES_HEIGHT = 140;
    private static final int DAY_HEIGHT = 75;
    private JPanel graphic = null;
    private String date = "";
    private Vector<LienJourConducteur> otherTime = null;
    private Vector<Service> days = null;
    private Vector<DriverExpenses> expenses = null;
    private Conducteur driver = null;
    private LienJourConducteur ljcToAdd = null;
    private ExpensesValidation expValid = null;
    private int defaultDayLength = 0;
    private int y = 0;
    private int currentYMousePosition = 0;
    private Rectangle rectToDraw = null;
    private Rectangle previousRectDrawn = new Rectangle();
    private Rectangle lineToDraw = null;
    private int heightString = 14;
    private JPanel pnlCompleteLJC = null;
    private JScrollPane jsp = null;
    private JTable tblJour = null;
    private JComboBox cbJourType = null;
    private JButton btnValid = null;
    private JPanel pnlBtn = null;
    private JButton btnCancel = null;
    private JButton btnDelete = null;
    private JPanel pnlExpenses = null;
    private JPanel pnlBtnExp = null;
    private PnlFraisConducteur pnlDriverExpenses = null;
    private JButton btnValidExp = null;
    private JButton btnCancelExp = null;
    NewPnlCalendrier.DayPicture pere = null;

    public CalendarDayZoom(NewPnlCalendrier.DayPicture pere, String date, Vector<LienJourConducteur> otherTime, Vector<Service> days, Vector<DriverExpenses> expenses, Conducteur driver, int defaultDayLength, ExpensesValidation expValid) {
        this.pere = pere;
        this.date = date;
        this.otherTime = otherTime;
        this.days = days;
        this.driver = driver;
        this.expenses = expenses;
        this.defaultDayLength = defaultDayLength;
        this.expValid = expValid;
        this.setTitle(String.valueOf(driver.getNom()) + " " + driver.getPrenom() + " - " + ConversionTime.dateFromBDDToFrance(date, false, true));
        this.initialize();
    }

    public void refreshParent() {
        this.pere.updateValues(this);
    }

    public void initialize() {
        PointerInfo info = MouseInfo.getPointerInfo();
        this.setLocation((int)info.getLocation().getX() - 200, (int)info.getLocation().getY() - 50);
        this.setSize(550, 130);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getGraphic(), "North");
        this.add((Component)this.getPnlExpenses(), "Center");
        this.add((Component)this.getPnlCompleteLJC(), "South");
        TimsLogger.verbose("#CDZ.initialize() windows listener : " + this.getWindowListeners().length);
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                TimsLogger.verbose("perte de focus");
                CalendarDayZoom.this.refreshParent();
                CalendarDayZoom.this.dispose();
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }
        });
        this.getGraphic().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                float horizontalStep = (float)(CalendarDayZoom.this.getGraphic().getHeight() - CalendarDayZoom.this.heightString) / 3.0f;
                CalendarDayZoom.this.y = (int)(((float)e.getY() - (float)CalendarDayZoom.this.heightString) / horizontalStep);
                int x = CalendarDayZoom.this.getTime(true, e.getX()) * ((CalendarDayZoom)CalendarDayZoom.this).getGraphic().getSize().width / 1440;
                if (CalendarDayZoom.this.y == 1) {
                    CalendarDayZoom.this.ljcToAdd = CalendarDayZoom.this.getOther(CalendarDayZoom.this.getTime(true, e.getX()));
                    if (CalendarDayZoom.this.ljcToAdd == null) {
                        CalendarDayZoom.this.rectToDraw = new Rectangle(x, CalendarDayZoom.this.getGraphic().getHeight() / 4 * 2, 0, CalendarDayZoom.this.getGraphic().getHeight() / 4);
                        CalendarDayZoom.this.ljcToAdd = new LienJourConducteur();
                        CalendarDayZoom.this.ljcToAdd.setCleUser(ConnexionSettings.getInstance().getUserCle());
                        CalendarDayZoom.this.ljcToAdd.setCleConducteur(CalendarDayZoom.this.driver.getCleConducteur());
                        CalendarDayZoom.this.ljcToAdd.setDateJour(ConversionTime.stringToDate(CalendarDayZoom.this.date, "yyyy-MM-dd"));
                        CalendarDayZoom.this.ljcToAdd.setHeureDebut(CalendarDayZoom.this.getTime(true, e.getX()));
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                float horizontalStep = (float)(CalendarDayZoom.this.getGraphic().getHeight() - CalendarDayZoom.this.heightString) / 3.0f;
                int y2 = (int)(((float)e.getY() - (float)CalendarDayZoom.this.heightString) / horizontalStep);
                if (y2 != CalendarDayZoom.this.y) {
                    TimsLogger.debug("CDZ.mouseReleased = mouse not released at same y position than pressed");
                }
                if (CalendarDayZoom.this.y == 0) {
                    int etatJour = Transport.bdd.getEtatJour(CalendarDayZoom.this.driver.getCleConducteur(), CalendarDayZoom.this.date);
                    TimsLogger.debug("afficher le d\u00e9tail pour " + CalendarDayZoom.this.driver.getNom() + " le " + CalendarDayZoom.this.date + " etat jour = " + etatJour);
                    if (etatJour == 0) {
                        Jour toPrint = new Jour();
                        toPrint.loadCurrent(CalendarDayZoom.this.driver.getCleConducteur(), CalendarDayZoom.this.date);
                        DialogDetailJournee toShow = DialogDetailJournee.getInstance();
                        toShow.setDetail(CalendarDayZoom.this.driver, ConversionTime.dateFromBDDToFrance(CalendarDayZoom.this.date, false, false), false, toPrint);
                        toShow.setVisible(true);
                    } else if (etatJour == 1) {
                        Vector<String> nb = Transport.bdd.getCleJourSup(CalendarDayZoom.this.driver.getCleConducteur(), CalendarDayZoom.this.date);
                        new DialogDetailJourSupprime((Frame)MainFrameTransport.getInstance(), CalendarDayZoom.this.driver, CalendarDayZoom.this.date, nb).setVisible(true);
                    } else if (etatJour == 2 && ConnexionSettings.getInstance().isAjoutable("ACTIVITE") && JOptionPane.showConfirmDialog(CalendarDayZoom.this.getParent(), LanguageTranslator.getString("activity.empty", CalendarDayZoom.this.date), "", 0) == 0) {
                        new DialogCreerJour((Frame)MainFrameTransport.getInstance(), CalendarDayZoom.this.driver, ConversionTime.dateFromBDDToFrance(CalendarDayZoom.this.date, false, false)).setVisible(true);
                    }
                }
                if (CalendarDayZoom.this.y == 1) {
                    if (CalendarDayZoom.this.ljcToAdd != null && CalendarDayZoom.this.ljcToAdd.getCle() == 0) {
                        CalendarDayZoom.this.lineToDraw = null;
                        int heureFin = CalendarDayZoom.this.getTime(true, e.getPoint().getX());
                        if (heureFin == CalendarDayZoom.this.ljcToAdd.getHeureDebut() || heureFin < CalendarDayZoom.this.ljcToAdd.getHeureDebut()) {
                            CalendarDayZoom.this.ljcToAdd.setHeureDebut(LienJourConducteur.DEFAULT_BEGIN_VALUE);
                            CalendarDayZoom.this.ljcToAdd.setType(2);
                        } else {
                            CalendarDayZoom.this.ljcToAdd.setDuree(heureFin - CalendarDayZoom.this.ljcToAdd.getHeureDebut());
                        }
                    }
                    CalendarDayZoom.this.showLJC();
                }
                if (CalendarDayZoom.this.y == 2 && ConnexionSettings.getInstance().isModifiable("FRAIS") && (CalendarDayZoom.this.expValid == null || CalendarDayZoom.this.expValid.getUserUnvalid() != -1)) {
                    CalendarDayZoom.this.showExpenses();
                }
            }
        });
        this.getGraphic().addMouseMotionListener(this);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int timePoint = this.getTime(true, e.getPoint().getX()) * this.getGraphic().getSize().width / 1440;
        if (this.lineToDraw == null || this.lineToDraw.x != timePoint) {
            Rectangle previous = this.lineToDraw;
            this.lineToDraw = new Rectangle(timePoint, 12, 0, this.getGraphic().getHeight());
            Rectangle totalRepaint = previous != null ? this.lineToDraw.union(previous) : this.lineToDraw;
            this.repaint();
        } else {
            this.getGraphic().setToolTipText(null);
            float horizontalStep = (float)(this.getGraphic().getHeight() - this.heightString) / 3.0f;
            this.currentYMousePosition = (int)(((float)e.getY() - (float)this.heightString) / horizontalStep);
            int x = this.getTime(true, e.getX()) * this.getGraphic().getSize().width / 1440;
            switch (this.currentYMousePosition) {
                case 0: {
                    this.getGraphic().setToolTipText("<html>partie service.<br>En cliquant dans cette partie, vous pouvez acc\u00e9der directement au d\u00e9tails de l'activit\u00e9 du conducteur pour cette journ\u00e9e<html>");
                    break;
                }
                case 1: {
                    this.getGraphic().setToolTipText("<html>partie absence.<br>En cliquant dans cette partie, vous pouvez ajouter une journ\u00e9e d'absence.<br>Vous pouvez d\u00e9finir une p\u00e9riode en restant appuyer sur le bouton gauche de la souris et en vous d\u00e9placant sur le graphe.<br>Il vous suffit de cliquer \u00e0 l'heure de d\u00e9but de l'absence puis de relacher le bouton \u00e0 l'heure de fin de l'absence<html>");
                    break;
                }
                case 2: {
                    if (this.expValid != null && this.expValid.getUserUnvalid() == -1) {
                        this.getGraphic().setToolTipText("<html>partie frais<br>Les frais sont valid\u00e9s sur cette journ\u00e9e, vous ne pouvez plus les modifier</html>");
                        break;
                    }
                    this.getGraphic().setToolTipText("<html>partie frais<br>Vous pouvez ajouter des frais en cliquant dans cette partie</html>");
                    break;
                }
                default: {
                    TimsLogger.debug("#CalendarDayZoom.mouseMoved# y = " + this.y);
                }
            }
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int timePoint = this.getTime(true, e.getX()) * this.getGraphic().getSize().width / 1440;
        if (this.ljcToAdd != null && this.ljcToAdd.getCle() == 0 && timePoint != this.rectToDraw.x) {
            this.previousRectDrawn.setBounds(this.rectToDraw);
            this.rectToDraw.setSize(timePoint - this.rectToDraw.x, this.rectToDraw.height);
            this.updateDrawableRect(this.getWidth(), this.getHeight());
            Rectangle rectangle = this.rectToDraw.union(this.previousRectDrawn);
        }
        if (this.lineToDraw == null || this.lineToDraw.x != timePoint) {
            Rectangle previous = this.lineToDraw;
            this.lineToDraw = new Rectangle(timePoint, 12, 0, this.getGraphic().getHeight());
            Rectangle rectangle = previous != null ? this.lineToDraw.union(previous) : this.lineToDraw;
        }
        this.repaint();
    }

    private void updateDrawableRect(int compWidth, int compHeight) {
        int x = this.rectToDraw.x;
        int y = this.rectToDraw.y;
        int width = this.rectToDraw.width;
        int height = this.rectToDraw.height;
        if (width < 0) {
            width = 0;
        }
        if (height < 0) {
            height = 0;
        }
        if (x + width > compWidth) {
            width = compWidth - x;
        }
        if (y + height > compHeight) {
            height = compHeight - y;
        }
        this.rectToDraw.setBounds(x, y, width, height);
    }

    private JPanel getGraphic() {
        if (this.graphic == null) {
            this.graphic = new JPanel(){

                @Override
                public void paint(Graphics g) {
                    int duree;
                    float horizontalStep = (float)(this.getHeight() - CalendarDayZoom.this.heightString) / 3.0f;
                    float verticalStep = (float)this.getWidth() / 24.0f;
                    String toolTip = "";
                    g.setColor(new Color(160, 160, 160));
                    if (CalendarDayZoom.this.expValid != null && CalendarDayZoom.this.expValid.getUserUnvalid() == -1) {
                        int h = (int)(2.0f * horizontalStep);
                        g.fillRect(0, h + CalendarDayZoom.this.heightString, this.getWidth(), (int)horizontalStep);
                    }
                    g.setColor(Color.BLACK);
                    int i = 0;
                    while (i < 3) {
                        int h = (int)((float)i * horizontalStep);
                        if (CalendarDayZoom.this.currentYMousePosition == i && (i != 2 || CalendarDayZoom.this.expValid == null || CalendarDayZoom.this.expValid.getUserUnvalid() != -1)) {
                            g.setColor(new Color(215, 240, 255));
                            g.fillRect(0, h + CalendarDayZoom.this.heightString, this.getWidth() - 1, (int)horizontalStep);
                            g.setColor(Color.BLACK);
                        }
                        g.drawLine(0, h + CalendarDayZoom.this.heightString - 1, this.getWidth(), h + CalendarDayZoom.this.heightString - 1);
                        ++i;
                    }
                    i = 0;
                    while (i < 24) {
                        if (i == 0) {
                            g.setColor(Color.BLACK);
                        }
                        int v = (int)((float)i * verticalStep);
                        g.drawString(String.valueOf(i), v - 4, CalendarDayZoom.this.heightString - 3);
                        g.drawLine(v, CalendarDayZoom.this.heightString, v, this.getHeight());
                        if (i == 0) {
                            g.setColor(Color.LIGHT_GRAY);
                        }
                        ++i;
                    }
                    if (CalendarDayZoom.this.days != null) {
                        Color c = g.getColor();
                        g.setColor(Color.RED);
                        for (Service day : CalendarDayZoom.this.days) {
                            int height = (int)horizontalStep - 6;
                            int horizontalPosition = CalendarDayZoom.this.heightString + 3;
                            int debut = day.getBeginTime() * this.getSize().width / 1440;
                            if (!day.getBeginDate().startsWith(CalendarDayZoom.this.date)) {
                                debut = 0;
                            }
                            int fin = day.getEndTime() * this.getSize().width / 1440;
                            if (!day.getEndDate().startsWith(CalendarDayZoom.this.date)) {
                                fin = this.getSize().width;
                            }
                            duree = fin - debut;
                            g.fillRect(debut, horizontalPosition, duree, height);
                            toolTip = String.valueOf(toolTip) + "<br>" + ConversionTime.heureIntToString(day.getService(), "h") + " de service de " + ConversionTime.heureIntToString(day.getBeginTime(), "h") + " \u00e0 " + ConversionTime.heureIntToString(day.getEndTime(), "h");
                        }
                        g.setColor(c);
                    }
                    if (CalendarDayZoom.this.otherTime != null) {
                        Color c = g.getColor();
                        int height = (int)horizontalStep - 6;
                        int horizontalPosition = CalendarDayZoom.this.heightString + (int)horizontalStep + 3;
                        for (LienJourConducteur ljc : CalendarDayZoom.this.otherTime) {
                            try {
                                JourType tmp = JourType.getDayType(ljc.getCleJourType());
                                g.setColor(new Color(tmp.getColor()));
                                int debut = ljc.getHeureDebut() * this.getSize().width / 1440;
                                duree = ljc.getPrintLength(CalendarDayZoom.this.defaultDayLength) * this.getSize().width / 1440;
                                g.fillRect(debut, horizontalPosition, duree, height);
                                toolTip = String.valueOf(toolTip) + "<br>" + tmp.getDesignation() + " (" + ConversionTime.heureIntToString(ljc.getDuree(CalendarDayZoom.this.defaultDayLength), "h") + ")";
                            }
                            catch (DayTypeNotFoundException ex) {
                                TimsLogger.warn("Unable to find a day for idDayType " + ljc.getCleJourType());
                            }
                        }
                        g.setColor(c);
                    }
                    if (CalendarDayZoom.this.expenses != null) {
                        Color c = g.getColor();
                        g.setColor(Color.BLUE);
                        int unhoured = 0;
                        int x = 0;
                        while (x < CalendarDayZoom.this.expenses.size()) {
                            DriverExpenses de = (DriverExpenses)CalendarDayZoom.this.expenses.get(x);
                            int height = (int)horizontalStep - 12;
                            int horizontalPosition = CalendarDayZoom.this.heightString + (int)horizontalStep * 2 + 6;
                            try {
                                ExpensesType tmp = ExpensesType.getExpenses(de.getExpensesId());
                                if (tmp.getHour() == 0) {
                                    g.fillRect(15 * unhoured, horizontalPosition, 10, height);
                                    ++unhoured;
                                } else {
                                    int hour = tmp.getHour() * this.getSize().width / 1440;
                                    g.fillRect(hour, horizontalPosition, 10, height);
                                }
                                float amount = tmp.getMontant(de.getDate(), de.isOutside() ? 1 : 0);
                                toolTip = String.valueOf(toolTip) + "<br>" + tmp.getDesignation() + " : " + amount;
                            }
                            catch (ExpensesNotFoundException ex) {
                                TimsLogger.warn("Unable to find a day for idDayType " + de.getExpensesId());
                            }
                            ++x;
                        }
                        g.setColor(c);
                    }
                    if (CalendarDayZoom.this.rectToDraw != null) {
                        g.setColor(Color.BLUE);
                        g.fillRect(((CalendarDayZoom)CalendarDayZoom.this).rectToDraw.x, ((CalendarDayZoom)CalendarDayZoom.this).rectToDraw.y, ((CalendarDayZoom)CalendarDayZoom.this).rectToDraw.width - 1, ((CalendarDayZoom)CalendarDayZoom.this).rectToDraw.height - 1);
                    }
                    if (CalendarDayZoom.this.lineToDraw != null) {
                        g.setColor(Color.RED);
                        g.drawLine(((CalendarDayZoom)CalendarDayZoom.this).lineToDraw.x, ((CalendarDayZoom)CalendarDayZoom.this).lineToDraw.y, ((CalendarDayZoom)CalendarDayZoom.this).lineToDraw.x + ((CalendarDayZoom)CalendarDayZoom.this).lineToDraw.width, ((CalendarDayZoom)CalendarDayZoom.this).lineToDraw.y + ((CalendarDayZoom)CalendarDayZoom.this).lineToDraw.height);
                    }
                    g.setColor(Color.BLACK);
                }
            };
            this.graphic.setPreferredSize(new Dimension(400, 80));
        }
        return this.graphic;
    }

    public int getTime(boolean round, double position) {
        float pasV = (float)this.getGraphic().getWidth() / 24.0f;
        float toReturn = (float)(position / (double)pasV);
        if (round) {
            return (int)((double)toReturn + 0.5) * 60;
        }
        return 0;
    }

    private void showLJC() {
        this.setSize(this.getWidth(), this.getHeight() + 75 + 4);
        this.initLJCTbl();
        this.getBtnDeleteAbs().setEnabled(this.ljcToAdd != null && this.ljcToAdd.getCle() != 0 && this.ljcToAdd.getCle() != -1);
        this.getBtnValidAbs().setEnabled(this.ljcToAdd.getCle() != -1);
        this.getPnlCompleteLJC().setVisible(true);
        this.pack();
        this.repaint();
    }

    public void hideLJC() {
        this.setSize(this.getWidth(), this.getHeight() - 75 + 4);
        this.getPnlCompleteLJC().setVisible(false);
        this.repaint();
    }

    private void initLJCTbl() {
        Vector<LienJourConducteur> others = new Vector<LienJourConducteur>();
        others.add(this.ljcToAdd);
        this.getTblJour().setModel(new TMDay(others));
        this.cbAbsEditor(this.tblJour.getColumnModel().getColumn(0));
    }

    private void showExpenses() {
        this.setSize(this.getWidth(), this.getHeight() + 140 + 4);
        this.getPnlExpenses().setVisible(true);
        this.pack();
        this.repaint();
    }

    public void hideExpenses() {
        this.setSize(this.getWidth(), this.getHeight() - 140 + 4);
        this.getPnlExpenses().setVisible(false);
        this.repaint();
    }

    public Vector<LienJourConducteur> getOtherTime() {
        return this.otherTime;
    }

    public Vector<DriverExpenses> getDriverExpenses() {
        return this.expenses;
    }

    public LienJourConducteur getOther(int x) {
        for (LienJourConducteur day : this.getOtherTime()) {
            if ((day.getHeureDebut() >= x || x >= day.getPrintEnd()) && day.getType() != 2) continue;
            return day;
        }
        return null;
    }

    private JPanel getPnlCompleteLJC() {
        if (this.pnlCompleteLJC == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 0.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            this.pnlCompleteLJC = new JPanel();
            this.pnlCompleteLJC.setPreferredSize(new Dimension(400, 75));
            this.pnlCompleteLJC.setLayout(new GridBagLayout());
            this.pnlCompleteLJC.add((Component)this.getJsp(), gridBagConstraints);
            this.pnlCompleteLJC.add((Component)this.getPnlBtnAbs(), gridBagConstraints2);
            this.pnlCompleteLJC.setVisible(false);
        }
        return this.pnlCompleteLJC;
    }

    private JPanel getPnlExpenses() {
        if (this.pnlExpenses == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.fill = 1;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 0.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 1;
            this.pnlExpenses = new JPanel();
            this.pnlExpenses.setPreferredSize(new Dimension(400, 140));
            this.pnlExpenses.setLayout(new GridBagLayout());
            this.pnlExpenses.add((Component)this.getPnlBtn(), gridBagConstraints2);
            this.pnlExpenses.add((Component)this.getPnlDriverExpenses(), gridBagConstraints11);
            this.pnlExpenses.setVisible(false);
        }
        return this.pnlExpenses;
    }

    private JScrollPane getJsp() {
        if (this.jsp == null) {
            this.jsp = new JScrollPane();
            this.jsp.setViewportView(this.getTblJour());
        }
        return this.jsp;
    }

    private JTable getTblJour() {
        if (this.tblJour == null) {
            this.tblJour = new JTable();
        }
        return this.tblJour;
    }

    private void cbAbsEditor(TableColumn col) {
        col.setCellEditor(new DefaultCellEditor(this.getCbJourType()));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText("Cliquer pour modifier");
        col.setCellRenderer(renderer);
    }

    private JComboBox getCbJourType() {
        if (this.cbJourType == null) {
            this.cbJourType = Fonctions.getCustomizedCB();
            this.cbJourType.setModel(new ComboBoxModel(JourType.getList(), true, null));
        }
        return this.cbJourType;
    }

    private JButton getBtnValidAbs() {
        if (this.btnValid == null) {
            this.btnValid = new JButton();
            this.btnValid.setText(LanguageTranslator.getString("button.save"));
            this.btnValid.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CalendarDayZoom.this.saveAbs();
                }
            });
        }
        return this.btnValid;
    }

    private JPanel getPnlBtnAbs() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.add((Component)this.getBtnCancelAbs(), null);
            if (ConnexionSettings.getInstance().isSupprimable("CALENDRIER")) {
                this.pnlBtn.add((Component)this.getBtnDeleteAbs(), null);
            }
            if (ConnexionSettings.getInstance().isModifiable("CALENDRIER")) {
                this.pnlBtn.add((Component)this.getBtnValidAbs(), null);
            }
        }
        return this.pnlBtn;
    }

    private JButton getBtnCancelAbs() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText(LanguageTranslator.getString("button.quit"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CalendarDayZoom.this.hideLJC();
                }
            });
        }
        return this.btnCancel;
    }

    public void saveAbs() {
        this.commitTblAbs();
        Vector<LienJourConducteur> toSave = ((TMDay)this.getTblJour().getModel()).getData();
        for (LienJourConducteur iter : toSave) {
            if (iter.getCleJourType() != 0) continue;
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("calendar.emptyDayType"), LanguageTranslator.getString("message.inputError"), 0);
            return;
        }
        for (LienJourConducteur iter : toSave) {
            iter.update();
            if (iter.getCle() != 0 || iter.getType() != 2) continue;
            if (this.days != null && this.days.size() != 0) {
                for (Service day : this.days) {
                    if (ConversionTime.stringToDate(day.getBeginDate(), "yyyy-MM-dd HH:mm:ss").before(iter.getDateJour())) continue;
                    Fault fault = new Fault(0, iter.getCleConducteur(), iter.getDateJour(), ConnexionSettings.getInstance().getUserCle(), 4);
                    fault.insert();
                    break;
                }
            }
            if (this.expenses == null || this.expenses.size() == 0) continue;
            Fault fault = new Fault(0, iter.getCleConducteur(), iter.getDateJour(), ConnexionSettings.getInstance().getUserCle(), 2);
            fault.insert();
        }
        this.otherTime = LienJourConducteur.loadList(0, this.driver.getCleConducteur(), ConversionTime.stringToDate(this.date, "yyyy-MM-dd"), null);
        this.lineToDraw = null;
        this.rectToDraw = null;
        this.hideLJC();
        this.repaint();
    }

    public void commitTblAbs() {
        TimsLogger.verbose("#DialogCalendrier# commit");
        int row = this.getTblJour().getSelectedRow();
        int column = this.getTblJour().getSelectedColumn();
        if (!this.getTblJour().isEditing()) {
            TimsLogger.verbose("not editing a cell");
        } else {
            TimsLogger.verbose("STOP EDITING " + row + " : " + column);
            this.getTblJour().getCellEditor(row, column).stopCellEditing();
        }
    }

    public Vector<LienJourConducteur> getOthers() {
        return ((TMDay)this.getTblJour().getModel()).getData();
    }

    private JButton getBtnDeleteAbs() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton();
            this.btnDelete.setText(LanguageTranslator.getString("button.delete"));
            this.btnDelete.setEnabled(this.ljcToAdd != null && this.ljcToAdd.getCle() != 0 && this.ljcToAdd.getCle() != -1);
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CalendarDayZoom.this.deleteAbs();
                }
            });
        }
        return this.btnDelete;
    }

    public void deleteAbs() {
        Vector<LienJourConducteur> toSave = ((TMDay)this.getTblJour().getModel()).getData();
        for (LienJourConducteur iter : toSave) {
            iter.delete();
        }
        if (this.ljcToAdd.getCle() != 0 && this.ljcToAdd.getType() == 2) {
            for (Fault toCheck : Fault.loadList(this.driver.getCleConducteur(), this.ljcToAdd.getDateJour(), null)) {
                if (toCheck.getType() != 2 && toCheck.getType() != 1 && toCheck.getType() != 3 && toCheck.getType() != 4) continue;
                toCheck.delete();
            }
        }
        this.otherTime.remove(this.ljcToAdd);
        toSave.clear();
        this.hideLJC();
        this.repaint();
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtnExp == null) {
            this.pnlBtnExp = new JPanel();
            this.pnlBtnExp.add((Component)this.getBtnCancelExp(), null);
            this.pnlBtnExp.add((Component)this.getBtnValidExp(), null);
        }
        return this.pnlBtnExp;
    }

    public void enregistrerExp() {
        this.getPnlDriverExpenses().sauvegarde();
        this.expenses = this.getPnlDriverExpenses().getListeFraisConducteur();
        Date day = ConversionTime.stringToDate(this.date, "yyyy-MM-dd");
        if (this.expenses != null && this.expenses.size() != 0) {
            if (this.otherTime != null && this.otherTime.size() != 0) {
                Fault fault = new Fault(0, this.driver.getCleConducteur(), day, ConnexionSettings.getInstance().getUserCle(), 1);
                fault.insert();
            }
        } else {
            for (Fault toCheck : Fault.loadList(this.driver.getCleConducteur(), day, null)) {
                if (toCheck.getType() != 2 && toCheck.getType() != 1) continue;
                toCheck.delete();
            }
        }
        this.hideExpenses();
    }

    private PnlFraisConducteur getPnlDriverExpenses() {
        if (this.pnlDriverExpenses == null) {
            this.pnlDriverExpenses = new PnlFraisConducteur(ConversionTime.dateFromBDDToFrance(this.date, false, false), this.driver);
        }
        return this.pnlDriverExpenses;
    }

    private JButton getBtnValidExp() {
        if (this.btnValidExp == null) {
            this.btnValidExp = new JButton();
            this.btnValidExp.setText(LanguageTranslator.getString("button.save"));
            this.btnValidExp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CalendarDayZoom.this.enregistrerExp();
                }
            });
        }
        return this.btnValidExp;
    }

    private JButton getBtnCancelExp() {
        if (this.btnCancelExp == null) {
            this.btnCancelExp = new JButton();
            this.btnCancelExp.setText(LanguageTranslator.getString("button.quit"));
            this.btnCancelExp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CalendarDayZoom.this.hideExpenses();
                }
            });
        }
        return this.btnCancelExp;
    }
}

