/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.conducteur;

import fr.pgh.data.bdd.SavedComment;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.PointerInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.modele.LMComment;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class DialogComment
extends JDialog
implements Observer {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JScrollPane jspList = null;
    private JList listComment = null;
    private JTextField txtComment = null;
    private JButton btnAdd = null;
    private JButton btnDelete = null;
    private JButton btnOk = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogComment.dispose()#");
        super.dispose();
    }

    @Override
    public void update(Observable o, Object arg) {
        TimsLogger.verbose("#" + this.getClass() + ".update# a faire");
    }

    public DialogComment(JDialog owner) {
        super(owner);
        TimsLogger.verbose("#DialogComment()#");
        LanguageTranslator.getInstance().addObserver(this);
        this.initialize();
    }

    private void initialize() {
        PointerInfo info = MouseInfo.getPointerInfo();
        this.setLocation(info.getLocation());
        this.setSize(300, 200);
        this.setUndecorated(true);
        this.setContentPane(this.getJContentPane());
        this.setModal(true);
        this.initValues();
        this.setVisible(true);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 3;
            gridBagConstraints21.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints21.gridy = 1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 2;
            gridBagConstraints11.insets = new Insets(0, 0, 4, 1);
            gridBagConstraints11.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.insets = new Insets(0, 0, 5, 1);
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints1.gridx = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.gridx = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJspList(), gridBagConstraints);
            this.jContentPane.add((Component)this.getTxtComment(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getBtnAdd(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getBtnDelete(), gridBagConstraints11);
            this.jContentPane.add((Component)this.getBtnOk(), gridBagConstraints21);
        }
        return this.jContentPane;
    }

    private JScrollPane getJspList() {
        if (this.jspList == null) {
            this.jspList = new JScrollPane();
            this.jspList.setViewportView(this.getListComment());
        }
        return this.jspList;
    }

    private JList getListComment() {
        if (this.listComment == null) {
            this.listComment = new JList();
            this.listComment.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        DialogComment.this.dispose();
                    }
                }
            });
        }
        return this.listComment;
    }

    private JTextField getTxtComment() {
        if (this.txtComment == null) {
            this.txtComment = new JTextField();
        }
        return this.txtComment;
    }

    private JButton getBtnAdd() {
        if (this.btnAdd == null) {
            this.btnAdd = new JButton();
            this.btnAdd.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_cliq"))));
            this.btnAdd.setPreferredSize(new Dimension(25, 25));
            this.btnAdd.setToolTipText(LanguageTranslator.getString("button.save"));
            this.btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!DialogComment.this.txtComment.getText().equals("")) {
                        new SavedComment(0, DialogComment.this.txtComment.getText()).insert();
                    }
                    DialogComment.this.initValues();
                }
            });
        }
        return this.btnAdd;
    }

    private JButton getBtnDelete() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton();
            this.btnDelete.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_sup"))));
            this.btnDelete.setPreferredSize(new Dimension(25, 25));
            this.btnDelete.setToolTipText(LanguageTranslator.getString("button.delete"));
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int selected = DialogComment.this.listComment.getSelectedIndex();
                    ((LMComment)DialogComment.this.listComment.getModel()).getCommentAt(selected).delete();
                    DialogComment.this.initValues();
                }
            });
        }
        return this.btnDelete;
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton();
            this.btnOk.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_valid"))));
            this.btnOk.setPreferredSize(new Dimension(25, 25));
            this.btnOk.setToolTipText(LanguageTranslator.getString("button.valid"));
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogComment.this.dispose();
                }
            });
        }
        return this.btnOk;
    }

    public String getSelected() {
        return this.getListComment().getSelectedValue() == null ? "" : this.getListComment().getSelectedValue().toString();
    }

    public void initValues() {
        this.txtComment.setText("");
        this.getListComment().setModel(new LMComment(SavedComment.loadList()));
    }
}

