/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.conducteur;

import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.TMDay;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class DialogCompleteLJC
extends JDialog {
    private JPanel jContentPane = null;
    private JPanel pnlCompleteLJC = null;
    private JScrollPane jsp = null;
    private JTable tblJour = null;
    private JComboBox cbJourType = null;
    private JButton btnValid = null;
    private JPanel pnlBtn = null;
    private JButton btnCancel = null;
    private LienJourConducteur other = null;
    private JButton btnDelete = null;

    public DialogCompleteLJC(JDialog owner, LienJourConducteur other) {
        super(owner);
        this.other = other;
        this.initialize();
    }

    private void initialize() {
        this.setModal(true);
        this.setUndecorated(true);
        this.setSize(400, 71);
        this.setLocation(this.getParent().getLocation().x, this.getParent().getLocation().y + this.getParent().getHeight());
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJPnlCompleteLJC(), gridBagConstraints1);
        }
        return this.jContentPane;
    }

    private JPanel getJPnlCompleteLJC() {
        if (this.pnlCompleteLJC == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 0.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            this.pnlCompleteLJC = new JPanel();
            this.pnlCompleteLJC.setLayout(new GridBagLayout());
            this.pnlCompleteLJC.add((Component)this.getJsp(), gridBagConstraints);
            this.pnlCompleteLJC.add((Component)this.getPnlBtn(), gridBagConstraints2);
        }
        return this.pnlCompleteLJC;
    }

    private JScrollPane getJsp() {
        if (this.jsp == null) {
            this.jsp = new JScrollPane();
            this.jsp.setViewportView(this.getTblJour());
        }
        return this.jsp;
    }

    private JTable getTblJour() {
        if (this.tblJour == null) {
            this.tblJour = new JTable();
            Vector<LienJourConducteur> others = new Vector<LienJourConducteur>();
            others.add(this.other);
            this.tblJour.setModel(new TMDay(others));
            this.cbEditor(this.tblJour.getColumnModel().getColumn(0));
        }
        return this.tblJour;
    }

    private void cbEditor(TableColumn col) {
        col.setCellEditor(new DefaultCellEditor(this.getCbJourType()));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText("Cliquer pour modifier");
        col.setCellRenderer(renderer);
    }

    private JComboBox getCbJourType() {
        if (this.cbJourType == null) {
            this.cbJourType = Fonctions.getCustomizedCB();
            this.cbJourType.setModel(new ComboBoxModel(JourType.getList(), true, null));
        }
        return this.cbJourType;
    }

    private JButton getBtnValid() {
        if (this.btnValid == null) {
            this.btnValid = new JButton();
            this.btnValid.setText(LanguageTranslator.getString("button.save"));
            this.btnValid.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogCompleteLJC.this.enregistrer();
                }
            });
        }
        return this.btnValid;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.add((Component)this.getBtnCancel(), null);
            this.pnlBtn.add((Component)this.getBtnDelete(), null);
            this.pnlBtn.add((Component)this.getBtnValid(), null);
        }
        return this.pnlBtn;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText(LanguageTranslator.getString("button.quit"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogCompleteLJC.this.dispose();
                }
            });
        }
        return this.btnCancel;
    }

    public void enregistrer() {
        this.commit();
        Vector<LienJourConducteur> toSave = ((TMDay)this.getTblJour().getModel()).getData();
        for (LienJourConducteur iter : toSave) {
            if (iter.getCleJourType() != 0) continue;
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("calendar.emptyDayType"), LanguageTranslator.getString("message.inputError"), 0);
            return;
        }
        for (LienJourConducteur iter : toSave) {
            iter.update();
        }
        this.dispose();
    }

    public void commit() {
        TimsLogger.verbose("#DialogCalendrier# commit");
        int row = this.getTblJour().getSelectedRow();
        int column = this.getTblJour().getSelectedColumn();
        if (!this.getTblJour().isEditing()) {
            TimsLogger.verbose("not editing a cell");
        } else {
            TimsLogger.verbose("STOP EDITING " + row + " : " + column);
            this.getTblJour().getCellEditor(row, column).stopCellEditing();
        }
    }

    public Vector<LienJourConducteur> getOthers() {
        return ((TMDay)this.getTblJour().getModel()).getData();
    }

    private JButton getBtnDelete() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton();
            this.btnDelete.setText(LanguageTranslator.getString("button.delete"));
            this.btnDelete.setEnabled(this.other != null && this.other.getCle() != 0);
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogCompleteLJC.this.delete();
                }
            });
        }
        return this.btnDelete;
    }

    public void delete() {
        Vector<LienJourConducteur> toSave = ((TMDay)this.getTblJour().getModel()).getData();
        for (LienJourConducteur iter : toSave) {
            iter.delete();
        }
        toSave.clear();
        this.dispose();
    }
}

