/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.conducteur;

import fr.pgh.component.JFittedComboBox;
import fr.pgh.component.JTextDate;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.connexion.TimsSession;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.DriverAnalyticCode;
import fr.pgh.data.bdd.EmployeeType;
import fr.pgh.data.bdd.GlobalCalendar;
import fr.pgh.data.bdd.TypeContrat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import transpo.system.LicenceManager;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.Fmresources;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.DialogTypeContrat;
import transpo.system.util.Fonctions;

public class DialogCreationConducteur
extends JDialog
implements Observer,
DataListener {
    private static final long serialVersionUID = 1L;
    private JPanel pnlPpl = null;
    private JPanel pnlRH = null;
    private JPanel pnlConducteur = null;
    private JLabel lblNom = null;
    private JLabel lblPrenom = null;
    private JTextField txtNom = null;
    private JTextField txtPrenom = null;
    private JPanel pnlAdresse = null;
    private JLabel lblRue = null;
    private JLabel lblCP = null;
    private JTextField txtCP = null;
    private JLabel lblVille = null;
    private JTextField txtVille = null;
    private JTextPane txtAdresse = null;
    private JPanel pblInfosComplementaires = null;
    private JLabel lblTel1 = null;
    private JTextField txtDomicile = null;
    private JLabel lblTel2 = null;
    private JTextField txtMobile = null;
    private JLabel lblNaissance = null;
    private JTextField txtNaissance = null;
    private JLabel lblSecuriteSociale = null;
    private JTextField txtSecuriteSociale = null;
    private JPanel pnlSociete = null;
    private JLabel lblAgence = null;
    private JLabel lblMatricule = null;
    private JTextField txtMatricule = null;
    private JLabel lblCode = null;
    private JTextField txtCode = null;
    private JPanel pnlDateSoc = null;
    private JTextField txtDateEntree = null;
    private JLabel lblDateSortie = null;
    private JTextField txtDateSortie = null;
    private JLabel lblDateVisiteMedicale = null;
    private JTextField txtVisiteMedicale = null;
    private JLabel lblDateFimoFco = null;
    private JLabel lblTaux = null;
    private JLabel lblDateEntree = null;
    private JLabel lblTypePersonnel = null;
    private JLabel lblTypePaie = null;
    private JLabel lblCalendrier = null;
    private JLabel lblTypeCond = null;
    private JButton btnAddTypePersonnel = null;
    private JButton btnAddTypePaie = null;
    private JButton btnAddCalendrier = null;
    private JPanel pnlBtn = null;
    private JButton btnEnregistrer = null;
    private ImageIcon imgAdd = null;
    private Fmresources res = null;
    private JButton btnAnnuler = null;
    private JFittedComboBox cbAgence = null;
    private JComboBox cbTypePersonnel = null;
    private JComboBox cbTypeContrat = null;
    private JComboBox cbCalendrier = null;
    private JComboBox cbTypeCond = null;
    private JComboBox cbNightDay = null;
    private JPanel pnlPermis = null;
    private JLabel lblNumero = null;
    private JTextField txtNumero = null;
    private JLabel lblDateVisiste = null;
    private JTextField txtVisite = null;
    private JTextDate txtB = null;
    private JTextDate txtC = null;
    private JTextDate txtCE = null;
    private JTextDate txtD = null;
    private JTextDate txtDE = null;
    private Conducteur current = null;
    public boolean enregistrement = false;
    private JTextField txtFimoFco = null;
    private JTextField txtKey = null;
    private JLabel lblKey = null;
    private JPanel jPanel = null;
    private JLabel jLabel3 = null;
    private JTextField txtTx = null;
    private JCheckBox cbTravailNuit = null;
    private JLabel lblTypeCond2 = null;
    private JTextField txtAdr = null;
    private JTextField txtCaces = null;
    private JLabel lblAdr = null;
    private JLabel lblCaces = null;
    private JLabel lblQuaCard = null;
    private JTextField txtQuaCardNumber = null;
    private JLabel lblAnalyticCode = null;
    private JFittedComboBox cbAnalyticCode = null;
    private JButton btnAddAnalyticCode = null;
    private JCheckBox cbMonthPaid = null;
    private JCheckBox cbExpensesAllowance = null;
    private JLabel lblTel3 = null;
    private JTextField txtTel3 = null;
    private JLabel lblMail = null;
    private JTextField txtMail = null;
    private JLabel lblBirthPlace = null;
    private JTextField txtBirthPlace = null;

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        if (dataEvent instanceof BddEvent) {
            BddEvent e = (BddEvent)dataEvent;
            if (e.getTable().equals("type_contrat")) {
                this.getCbTypeContrat().setModel(new ComboBoxModel(TypeContrat.loadList(), false, LanguageTranslator.getString("generics.none")));
            }
            if (e.getTable().equals("EMPLOYEE_TYPE")) {
                this.getCbTypePersonnel().setModel(new ComboBoxModel(EmployeeType.getList(), false, LanguageTranslator.getString("generics.none")));
            }
            if (e.getTable().equals("t_agence")) {
                this.getCbAgence().setModel(new ComboBoxModel(Agence.getList(), true, null));
            }
            if (e.getTable().equals("CALENDAR")) {
                this.getCbCalendrier().setModel(new ComboBoxModel(GlobalCalendar.loadList(), false, LanguageTranslator.getString("generics.none")));
            }
            if (e.getTable().equals("DRIVER_ANALYTIC_CODE")) {
                this.getCbAnalyticCode().setModel(new ComboBoxModel(DriverAnalyticCode.getList(), false, LanguageTranslator.getString("generics.none")));
            }
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        TimsLogger.verbose("#DialogCreationConducteur.update# a faire");
    }

    public DialogCreationConducteur(Frame owner, Conducteur current) {
        super(owner);
        this.current = current;
        LanguageTranslator.getInstance().addObserver(this);
        this.initialize();
        TimsSession.getInstance().addVisit(this.getClass().getName());
        Transport.bdd.addDataListener(this);
    }

    private void initialize() {
        this.setSize(new Dimension(610, 630));
        this.setModal(true);
        this.setTitle(LanguageTranslator.getString("driver.create"));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getPnlPpl(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, -1, 18, null));
        this.setLocationRelativeTo(this.getParent());
        if (this.current != null) {
            this.load();
        }
    }

    private void load() {
        this.getTxtNaissance().setText(ConversionTime.dateFromBDDToFrance(this.current.getDateNaissance(), false, true));
        if (this.current.getCleAgence() != 0) {
            this.getCbAgence().setSelectedItem(((ComboBoxModel)this.getCbAgence().getModel()).getLabel(this.current.getCleAgence()));
        }
        this.getCbTypePersonnel().setSelectedItem(((ComboBoxModel)this.getCbTypePersonnel().getModel()).getLabel(this.current.getCleTypePersonnel()));
        if (this.current.getCleTypeContrat() != 0) {
            this.getCbTypeContrat().setSelectedItem(((ComboBoxModel)this.getCbTypeContrat().getModel()).getLabel(this.current.getCleTypeContrat()));
        }
        this.getCbCalendrier().setSelectedItem(((ComboBoxModel)this.getCbCalendrier().getModel()).getLabel(this.current.getCalendarId()));
        this.getCbTypeCond().setSelectedIndex(this.current.getCleTypeConducteur());
        this.getTxtNom().setText(this.current.getNom());
        this.getTxtPrenom().setText(this.current.getPrenom());
        this.getTxtMatricule().setText(this.current.getMatricule());
        this.getTxtKey().setText(this.current.getKey());
        this.getTxtCode().setText(this.current.getNumeroImport());
        this.getTxtAdresse().setText(this.current.getAdresse());
        this.getTxtCP().setText(this.current.getCodePostal());
        this.getTxtVille().setText(this.current.getVille());
        this.getTxtDomicile().setText(this.current.getTel1());
        this.getTxtMobile().setText(this.current.getTel2());
        this.getTxtDateEntree().setText(ConversionTime.dateFromBDDToFrance(this.current.getDateEntree(), false, true));
        this.getTxtDateSortie().setText(ConversionTime.dateFromBDDToFrance(this.current.getDateSortie(), false, true));
        this.getTxtVisiteMedicale().setText(ConversionTime.dateFromBDDToFrance(this.current.getDateVisite(), false, true));
        this.getTxtSecuriteSociale().setText(this.current.getNumSecuriteSociale());
        this.getTxtTx().setText(String.valueOf(this.current.getTaux()));
        this.getCbTravailNuit().setSelected(this.current.isNightWorker());
        this.getCbMonthPaid().setSelected(this.current.getPayPeriodType() == 1);
        this.getTxtFimoFco().setText(ConversionTime.dateFromBDDToFrance(this.current.getFimoFco(), false, true));
        this.getTxtQuaCardNumber().setText(this.current.getQuaCardNumber());
        this.getCbNightDay().setSelectedIndex(this.current.getNightDay());
        this.getTxtNumero().setText(this.current.getNumeroPermis());
        this.getTxtVisite().setText(ConversionTime.dateFromBDDToFrance(this.current.getDateVisitePermis(), false, true));
        this.getTxtAdr().setText(ConversionTime.dateFromBDDToFrance(this.current.getAdr(), false, true));
        this.getTxtCaces().setText(ConversionTime.dateFromBDDToFrance(this.current.getCaces(), false, true));
        this.getCbAnalyticCode().setSelectedItem(((ComboBoxModel)this.getCbAnalyticCode().getModel()).getLabel(this.current.getAnalyticCodeId()));
        this.getTxtB().setText(ConversionTime.dateFromBDDToFrance(this.current.getBDelivery()));
        this.getTxtC().setText(ConversionTime.dateFromBDDToFrance(this.current.getCDelivery()));
        this.getTxtCE().setText(ConversionTime.dateFromBDDToFrance(this.current.getCEDelivery()));
        this.getTxtD().setText(ConversionTime.dateFromBDDToFrance(this.current.getDDelivery()));
        this.getTxtDE().setText(ConversionTime.dateFromBDDToFrance(this.current.getDEDelivery()));
    }

    private JPanel getPnlConducteur() {
        if (this.pnlConducteur == null) {
            this.lblPrenom = new JLabel(LanguageTranslator.getString("user.firstName"));
            this.lblNom = new JLabel(LanguageTranslator.getString("user.lastName"));
            this.lblMail = new JLabel(LanguageTranslator.getString("generics.mail"));
            this.pnlConducteur = new JPanel();
            this.pnlConducteur.setLayout(new GridBagLayout());
            this.pnlConducteur.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("driver.personalInformation"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlConducteur.setMinimumSize(new Dimension(580, 185));
            this.pnlConducteur.setPreferredSize(new Dimension(580, 185));
            this.pnlConducteur.add((Component)this.lblNom, Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, -1, 17, new Insets(0, 3, 0, 3)));
            this.pnlConducteur.add((Component)this.getTxtNom(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 2, -1, new Insets(0, 5, 0, 0)));
            this.pnlConducteur.add((Component)this.lblPrenom, Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, -1, 17, new Insets(0, 3, 0, 3)));
            this.pnlConducteur.add((Component)this.getTxtPrenom(), Fonctions.getGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 2, -1, new Insets(0, 5, 0, 0)));
            this.pnlConducteur.add((Component)this.lblMail, Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, -1, 17, new Insets(0, 3, 0, 3)));
            this.pnlConducteur.add((Component)this.getTxtMail(), Fonctions.getGridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 2, -1, new Insets(0, 5, 0, 0)));
            this.pnlConducteur.add((Component)this.getPblInfosComplementaires(), Fonctions.getGridBagConstraints(2, 0, 4, 1, 0.0, 0.0, 1, 11, new Insets(0, 5, 0, 0)));
            this.pnlConducteur.add((Component)this.getPnlAdresse(), Fonctions.getGridBagConstraints(0, 3, 1, 2, 1.0, 1.0, 1, 17, new Insets(0, 3, 0, 3)));
        }
        return this.pnlConducteur;
    }

    private JPanel getPnlAdresse() {
        if (this.pnlAdresse == null) {
            GridBagConstraints l0c0 = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, -1, 17, new Insets(0, 3, 0, 3));
            GridBagConstraints l0c1 = Fonctions.getGridBagConstraints(1, 0, 1, 3, 1.0, 1.0, 1, -1, new Insets(0, 5, 0, 0));
            GridBagConstraints l1c0 = Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 1.0, -1, 17, new Insets(0, 3, 0, 3));
            GridBagConstraints l1c1 = Fonctions.getGridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 2, -1, new Insets(0, 5, 0, 0));
            GridBagConstraints l1c2 = Fonctions.getGridBagConstraints(2, 1, 1, 1, 0.0, 1.0, -1, 17, new Insets(0, 3, 0, 3));
            GridBagConstraints l1c3 = Fonctions.getGridBagConstraints(3, 1, 1, 1, 0.0, 1.0, 2, -1, new Insets(0, 5, 0, 0));
            this.lblVille = new JLabel(LanguageTranslator.getString("generics.city"));
            this.lblCP = new JLabel(LanguageTranslator.getString("generics.cp"));
            this.lblRue = new JLabel(LanguageTranslator.getString("generics.street"));
            this.pnlAdresse = new JPanel();
            this.pnlAdresse.setLayout(new GridBagLayout());
            this.pnlAdresse.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.address"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlAdresse.setPreferredSize(new Dimension(330, 68));
            this.pnlAdresse.add((Component)this.lblRue, l0c0);
            this.pnlAdresse.add((Component)this.getTxtAdresse(), l0c1);
            this.pnlAdresse.add((Component)this.lblCP, l1c0);
            this.pnlAdresse.add((Component)this.getTxtCP(), l1c1);
            this.pnlAdresse.add((Component)this.lblVille, l1c2);
            this.pnlAdresse.add((Component)this.getTxtVille(), l1c3);
        }
        return this.pnlAdresse;
    }

    private JPanel getPblInfosComplementaires() {
        if (this.pblInfosComplementaires == null) {
            this.lblSecuriteSociale = new JLabel(LanguageTranslator.getString("user.ss"));
            this.lblNaissance = new JLabel(LanguageTranslator.getString("user.birthday"));
            this.lblTel2 = new JLabel(LanguageTranslator.getString("generics.mobile"));
            this.lblTel1 = new JLabel(LanguageTranslator.getString("generics.phone"));
            this.lblBirthPlace = new JLabel(LanguageTranslator.getString("user.birth.place"));
            this.lblTel3 = new JLabel(LanguageTranslator.getString("user.personal.phone"));
            this.pblInfosComplementaires = new JPanel();
            this.pblInfosComplementaires.setLayout(new GridBagLayout());
            this.pblInfosComplementaires.setPreferredSize(new Dimension(200, 80));
            this.pblInfosComplementaires.add((Component)this.lblTel1, Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, -1, 17, new Insets(0, 3, 0, 3)));
            this.pblInfosComplementaires.add((Component)this.getTxtDomicile(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 2, -1, new Insets(0, 5, 0, 0)));
            this.pblInfosComplementaires.add((Component)this.lblTel2, Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, -1, 17, new Insets(0, 3, 0, 3)));
            this.pblInfosComplementaires.add((Component)this.getTxtMobile(), Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 2, -1, new Insets(0, 5, 0, 0)));
            this.pblInfosComplementaires.add((Component)this.lblTel3, Fonctions.getGridBagConstraints(0, 2, 1, 1, 1.0, 1.0, -1, 17, new Insets(0, 3, 0, 3)));
            this.pblInfosComplementaires.add((Component)this.getTxtTel3(), Fonctions.getGridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 2, -1, new Insets(0, 5, 0, 0)));
            this.pblInfosComplementaires.add((Component)this.lblSecuriteSociale, Fonctions.getGridBagConstraints(0, 3, 1, 1, 1.0, 1.0, -1, 17, new Insets(0, 3, 0, 3)));
            this.pblInfosComplementaires.add((Component)this.getTxtSecuriteSociale(), Fonctions.getGridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 2, -1, new Insets(0, 5, 0, 0)));
            this.pblInfosComplementaires.add((Component)this.lblNaissance, Fonctions.getGridBagConstraints(0, 4, 1, 1, 1.0, 1.0, -1, 17, new Insets(0, 3, 0, 3)));
            this.pblInfosComplementaires.add((Component)this.getTxtNaissance(), Fonctions.getGridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 2, -1, new Insets(0, 5, 0, 0)));
            this.pblInfosComplementaires.add((Component)this.lblBirthPlace, Fonctions.getGridBagConstraints(0, 5, 1, 1, 1.0, 1.0, -1, 17, new Insets(0, 3, 0, 3)));
            this.pblInfosComplementaires.add((Component)this.getTxtBirthPlace(), Fonctions.getGridBagConstraints(1, 5, 1, 1, 1.0, 1.0, 2, -1, new Insets(0, 5, 0, 0)));
            this.pblInfosComplementaires.add((Component)this.lblSecuriteSociale, Fonctions.getGridBagConstraints(0, 6, 1, 1, 1.0, 1.0, -1, 17, new Insets(0, 3, 0, 3)));
            this.pblInfosComplementaires.add((Component)this.getTxtSecuriteSociale(), Fonctions.getGridBagConstraints(1, 6, 1, 1, 1.0, 1.0, 2, -1, new Insets(0, 5, 0, 0)));
        }
        return this.pblInfosComplementaires;
    }

    private JPanel getPnlSociete() {
        if (this.pnlSociete == null) {
            this.lblTypeCond2 = new JLabel(LanguageTranslator.getString("driver.title"));
            this.lblTypeCond = new JLabel(LanguageTranslator.getString("driver.title"));
            this.lblCalendrier = new JLabel(LanguageTranslator.getString("generics.calendar"));
            this.lblTypePaie = new JLabel(LanguageTranslator.getString("driver.pay.title"));
            this.lblTypePersonnel = new JLabel(LanguageTranslator.getString("driver.type.title"));
            this.lblCode = new JLabel(LanguageTranslator.getString("generics.code"));
            this.lblMatricule = new JLabel(LanguageTranslator.getString("user.registration"));
            this.lblKey = new JLabel(LanguageTranslator.getString("generics.key"));
            this.lblAgence = new JLabel(LanguageTranslator.getString("generics.agency"));
            this.lblAnalyticCode = new JLabel(LanguageTranslator.getString("generics.analyticCode"));
            this.lblQuaCard = new JLabel(LanguageTranslator.getString("driver.quaCardNumber"));
            GridBagConstraints gcbLblMatricule = Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, -1, 17, new Insets(0, 5, 0, 0));
            GridBagConstraints gcbTxtMatricule = Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 1.0, -1, 13, null);
            GridBagConstraints gcbLblAgence = Fonctions.getGridBagConstraints(2, 0, 1, 1, 0.0, 1.0, -1, 17, new Insets(0, 5, 0, 0));
            GridBagConstraints gcbCbAgence = Fonctions.getGridBagConstraints(3, 0, 1, 2, 1.0, 0.0, 2, -1, null);
            GridBagConstraints gcbLblCode = Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 1.0, -1, 17, new Insets(0, 5, 0, 0));
            GridBagConstraints gcbTxtCode = Fonctions.getGridBagConstraints(1, 1, 1, 1, 0.0, 1.0, -1, 13, null);
            GridBagConstraints gcbLblKey = Fonctions.getGridBagConstraints(2, 1, 1, 1, 0.0, 1.0, -1, 17, new Insets(0, 5, 0, 0));
            GridBagConstraints gcbTxtKey = Fonctions.getGridBagConstraints(3, 1, 1, 2, 0.0, 0.0, 2, -1, new Insets(5, 0, 5, 0));
            GridBagConstraints gcbPnlDateSoc = Fonctions.getGridBagConstraints(0, 2, 6, 2, 0.0, 1.0, 1, -1, null);
            GridBagConstraints gcbLblTypePers = Fonctions.getGridBagConstraints(2, 2, 1, 1, 0.0, 1.0, -1, 17, new Insets(0, 5, 0, 0));
            GridBagConstraints gcbCbTypePers = Fonctions.getGridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 2, -1, null);
            GridBagConstraints gcbBtnAddTypePers = Fonctions.getGridBagConstraints(4, 2, 1, 1, 0.0, 0.0, -1, -1, new Insets(0, 2, 0, 0));
            GridBagConstraints gcbLblTypePaie = Fonctions.getGridBagConstraints(2, 3, 1, 1, 0.0, 1.0, -1, 17, new Insets(0, 5, 0, 0));
            GridBagConstraints gcbCbContrat = Fonctions.getGridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 2, -1, null);
            GridBagConstraints gcbBtnAddPaie = Fonctions.getGridBagConstraints(4, 3, 1, 1, 0.0, 0.0, -1, -1, new Insets(0, 2, 0, 0));
            GridBagConstraints gcbLblCal = Fonctions.getGridBagConstraints(2, 4, 1, 1, 0.0, 1.0, -1, 17, new Insets(0, 5, 0, 0));
            GridBagConstraints gcbCbCal = Fonctions.getGridBagConstraints(3, 4, 1, 1, 1.0, 0.0, 2, -1, null);
            GridBagConstraints gcbBtnAddCal = Fonctions.getGridBagConstraints(4, 4, 1, 1, 0.0, 0.0, -1, -1, new Insets(0, 2, 0, 0));
            GridBagConstraints gcbLblCond = Fonctions.getGridBagConstraints(2, 5, 1, 1, 0.0, 1.0, -1, 17, new Insets(0, 5, 0, 0));
            GridBagConstraints gcbCbCond = Fonctions.getGridBagConstraints(3, 5, 1, 2, 1.0, 0.0, 2, -1, null);
            GridBagConstraints gridBagConstraints83 = Fonctions.getGridBagConstraints(2, 6, 1, 1, 1.0, 0.0, -1, 17, new Insets(0, 5, 0, 0));
            GridBagConstraints gcbCbNightDay = Fonctions.getGridBagConstraints(3, 6, 1, 2, 1.0, 0.0, 2, -1, null);
            GridBagConstraints gcbLblAnalytic = Fonctions.getGridBagConstraints(2, 7, 1, 1, 1.0, 0.0, -1, 17, new Insets(0, 5, 0, 0));
            GridBagConstraints gcbCbAnalytic = Fonctions.getGridBagConstraints(3, 7, 1, 1, 1.0, 0.0, 2, -1, null);
            GridBagConstraints gcbBtnAddAnalytic = Fonctions.getGridBagConstraints(4, 7, 1, 1, 0.0, 0.0, -1, -1, null);
            GridBagConstraints line8col0 = Fonctions.getGridBagConstraints(0, 8, 1, 1, 0.0, 0.0, -1, 17, new Insets(0, 5, 0, 0));
            GridBagConstraints line8col1 = Fonctions.getGridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 2, -1, null);
            GridBagConstraints gcbPnlRH = Fonctions.getGridBagConstraints(2, 8, 1, 3, 0.0, 0.0, -1, -1, new Insets(0, 5, 0, 0));
            this.pnlSociete = new JPanel();
            this.pnlSociete.setLayout(new GridBagLayout());
            this.pnlSociete.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("driver.companyInformation"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlSociete.add((Component)this.lblAgence, gcbLblAgence);
            this.pnlSociete.add((Component)this.getCbAgence(), gcbCbAgence);
            this.pnlSociete.add((Component)this.lblKey, gcbLblKey);
            this.pnlSociete.add((Component)this.getTxtKey(), gcbTxtKey);
            this.pnlSociete.add((Component)this.lblMatricule, gcbLblMatricule);
            this.pnlSociete.add((Component)this.getTxtMatricule(), gcbTxtMatricule);
            this.pnlSociete.add((Component)this.lblCode, gcbLblCode);
            this.pnlSociete.add((Component)this.getTxtCode(), gcbTxtCode);
            this.pnlSociete.add((Component)this.getPnlDateSoc(), gcbPnlDateSoc);
            this.pnlSociete.add((Component)this.lblQuaCard, line8col0);
            this.pnlSociete.add((Component)this.getTxtQuaCardNumber(), line8col1);
            boolean personnel = ConnexionSettings.getInstance().isAjoutable("TYPE_PERSONNEL");
            boolean paie = ConnexionSettings.getInstance().isConsultable("TYPE_PAIE");
            boolean cal = ConnexionSettings.getInstance().isConsultable("CALENDRIER");
            boolean analyticCode = ConnexionSettings.getInstance().isAjoutable("DRIVER_ANALYTIC_CODE");
            this.pnlSociete.add((Component)this.lblTypePersonnel, gcbLblTypePers);
            this.pnlSociete.add((Component)this.getCbTypePersonnel(), gcbCbTypePers);
            if (personnel && LicenceManager.isHRLevel()) {
                this.pnlSociete.add((Component)this.getBtnAddTypePersonnel(), gcbBtnAddTypePers);
            }
            this.pnlSociete.add((Component)this.lblTypePaie, gcbLblTypePaie);
            this.pnlSociete.add((Component)this.getCbTypeContrat(), gcbCbContrat);
            if (paie && LicenceManager.isHRLevel()) {
                this.pnlSociete.add((Component)this.getBtnAddTypePaie(), gcbBtnAddPaie);
            }
            this.pnlSociete.add((Component)this.lblCalendrier, gcbLblCal);
            this.pnlSociete.add((Component)this.getCbCalendrier(), gcbCbCal);
            if (cal && LicenceManager.isHRLevel()) {
                this.pnlSociete.add((Component)this.getBtnAddCalendrier(), gcbBtnAddCal);
            }
            this.pnlSociete.add((Component)this.lblTypeCond, gcbLblCond);
            this.pnlSociete.add((Component)this.getCbTypeCond(), gcbCbCond);
            this.pnlSociete.add((Component)this.lblTypeCond2, gridBagConstraints83);
            this.pnlSociete.add((Component)this.getCbNightDay(), gcbCbNightDay);
            this.pnlSociete.add((Component)this.lblAnalyticCode, gcbLblAnalytic);
            this.pnlSociete.add((Component)this.getCbAnalyticCode(), gcbCbAnalytic);
            if (analyticCode) {
                this.pnlSociete.add((Component)this.getBtnAddAnalyticCode(), gcbBtnAddAnalytic);
            }
            this.pnlSociete.add((Component)this.getPnlRH(), gcbPnlRH);
        }
        return this.pnlSociete;
    }

    private JPanel getPnlRH() {
        if (this.pnlRH == null) {
            this.lblTaux = new JLabel(LanguageTranslator.getString("generics.rate"));
            this.pnlRH = new JPanel();
            this.pnlRH.setLayout(new GridBagLayout());
            this.pnlRH.add((Component)this.lblTaux, Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, -1, 17, null));
            this.pnlRH.add((Component)this.getTxtTx(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, -1, 17, null));
            this.pnlRH.add((Component)this.getCbTravailNuit(), Fonctions.getGridBagConstraints(0, 1, 1, 2, 0.0, 0.0, -1, 17, null));
            this.pnlRH.add((Component)this.getCbMonthPaid(), Fonctions.getGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, -1, 17, null));
            this.pnlRH.add((Component)this.getCbExpensesAllowance(), Fonctions.getGridBagConstraints(2, 1, 1, 1, 0.0, 0.0, -1, 17, null));
        }
        return this.pnlRH;
    }

    private JPanel getPnlDateSoc() {
        if (this.pnlDateSoc == null) {
            this.lblDateVisiteMedicale = new JLabel(LanguageTranslator.getString("user.medicalExam"));
            this.lblDateFimoFco = new JLabel(LanguageTranslator.getString("driver.fimoFco"));
            this.lblDateSortie = new JLabel(LanguageTranslator.getString("user.exitDate"));
            this.lblDateEntree = new JLabel(LanguageTranslator.getString("user.enterDate"));
            this.lblCaces = new JLabel(LanguageTranslator.getString("driver.caces"));
            this.lblAdr = new JLabel(LanguageTranslator.getString("driver.adr"));
            GridBagConstraints line0col0 = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, -1, 17, new Insets(0, 5, 0, 0));
            GridBagConstraints line0col1 = Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, -1, -1, null);
            GridBagConstraints line1col0 = Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, -1, 17, new Insets(0, 5, 0, 0));
            GridBagConstraints line1col1 = Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, -1, -1, null);
            GridBagConstraints line2col0 = Fonctions.getGridBagConstraints(0, 2, 1, 1, 1.0, 1.0, -1, 17, new Insets(0, 5, 0, 0));
            GridBagConstraints line2col1 = Fonctions.getGridBagConstraints(1, 2, 1, 1, 1.0, 1.0, -1, -1, null);
            GridBagConstraints line3col0 = Fonctions.getGridBagConstraints(0, 3, 1, 1, 1.0, 1.0, -1, 17, new Insets(0, 5, 0, 0));
            GridBagConstraints line3col1 = Fonctions.getGridBagConstraints(1, 3, 1, 1, 1.0, 1.0, -1, -1, null);
            GridBagConstraints line4col0 = Fonctions.getGridBagConstraints(0, 4, 1, 1, 1.0, 1.0, -1, 17, new Insets(0, 5, 0, 0));
            GridBagConstraints line4col1 = Fonctions.getGridBagConstraints(1, 4, 1, 1, 1.0, 1.0, -1, -1, null);
            GridBagConstraints line5col0 = Fonctions.getGridBagConstraints(0, 5, 1, 1, 1.0, 1.0, -1, 17, new Insets(0, 5, 0, 0));
            GridBagConstraints line5col1 = Fonctions.getGridBagConstraints(1, 5, 1, 1, 1.0, 1.0, -1, -1, null);
            this.pnlDateSoc = new JPanel();
            this.pnlDateSoc.setLayout(new GridBagLayout());
            this.pnlDateSoc.add((Component)this.lblDateEntree, line0col0);
            this.pnlDateSoc.add((Component)this.getTxtDateEntree(), line0col1);
            this.pnlDateSoc.add((Component)this.lblDateSortie, line1col0);
            this.pnlDateSoc.add((Component)this.getTxtDateSortie(), line1col1);
            this.pnlDateSoc.add((Component)this.lblDateVisiteMedicale, line2col0);
            this.pnlDateSoc.add((Component)this.getTxtVisiteMedicale(), line2col1);
            this.pnlDateSoc.add((Component)this.lblDateFimoFco, line3col0);
            this.pnlDateSoc.add((Component)this.getTxtFimoFco(), line3col1);
            this.pnlDateSoc.add((Component)this.lblAdr, line4col0);
            this.pnlDateSoc.add((Component)this.getTxtAdr(), line4col1);
            this.pnlDateSoc.add((Component)this.lblCaces, line5col0);
            this.pnlDateSoc.add((Component)this.getTxtCaces(), line5col1);
        }
        return this.pnlDateSoc;
    }

    private JPanel getPnlPpl() {
        if (this.pnlPpl == null) {
            GridBagConstraints gcbDriver = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 1, -1, null);
            GridBagConstraints gcbSociete = Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 1, 18, new Insets(0, 0, 5, 0));
            GridBagConstraints gcbPermis = Fonctions.getGridBagConstraints(0, 2, 1, 2, 0.0, 0.0, 2, -1, null);
            GridBagConstraints gcbBtn = Fonctions.getGridBagConstraints(0, 4, 1, 2, 1.0, 1.0, 1, 10, null);
            this.pnlPpl = new JPanel();
            this.pnlPpl.setLayout(new GridBagLayout());
            this.pnlPpl.add((Component)this.getPnlConducteur(), gcbDriver);
            this.pnlPpl.add((Component)this.getPnlSociete(), gcbSociete);
            if (ConnexionSettings.getInstance().isConsultable("PERMIS")) {
                this.pnlPpl.add((Component)this.getPnlPermis(), gcbPermis);
            }
            this.pnlPpl.add((Component)this.getPnlBtn(), gcbBtn);
        }
        return this.pnlPpl;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            if (ConnexionSettings.getInstance().isAjoutable("CONDUCTEUR")) {
                this.pnlBtn.add(this.getBtnEnregistrer());
            }
            this.pnlBtn.add(this.getBtnAnnuler());
        }
        return this.pnlBtn;
    }

    private JPanel getPnlPermis() {
        if (this.pnlPermis == null) {
            this.lblDateVisiste = new JLabel(LanguageTranslator.getString("driver.licenceMedicalExam"));
            this.lblNumero = new JLabel(LanguageTranslator.getString("driver.licence.number"));
            this.pnlPermis = new JPanel();
            this.pnlPermis.setLayout(new GridBagLayout());
            this.pnlPermis.setPreferredSize(new Dimension(0, 80));
            this.pnlPermis.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("driver.licenseInformation"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlPermis.add((Component)this.lblNumero, Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, -1, -1, null));
            this.pnlPermis.add((Component)this.getTxtNumero(), Fonctions.getGridBagConstraints(1, 0, 1, 5, 1.0, 0.0, 2, -1, null));
            this.pnlPermis.add((Component)new JLabel("B"), Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, -1, -1, null));
            this.pnlPermis.add((Component)new JLabel("C"), Fonctions.getGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, -1, -1, null));
            this.pnlPermis.add((Component)new JLabel("CE"), Fonctions.getGridBagConstraints(2, 1, 1, 1, 0.0, 0.0, -1, -1, null));
            this.pnlPermis.add((Component)new JLabel("D"), Fonctions.getGridBagConstraints(3, 1, 1, 1, 0.0, 0.0, -1, -1, null));
            this.pnlPermis.add((Component)new JLabel("DE"), Fonctions.getGridBagConstraints(4, 1, 1, 1, 0.0, 0.0, -1, -1, null));
            this.pnlPermis.add((Component)this.lblDateVisiste, Fonctions.getGridBagConstraints(5, 1, 1, 1, 0.0, 0.0, -1, -1, null));
            this.pnlPermis.add((Component)this.getTxtB(), Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, -1, -1, null));
            this.pnlPermis.add((Component)this.getTxtC(), Fonctions.getGridBagConstraints(1, 2, 1, 1, 0.0, 0.0, -1, -1, null));
            this.pnlPermis.add((Component)this.getTxtCE(), Fonctions.getGridBagConstraints(2, 2, 1, 1, 0.0, 0.0, -1, -1, null));
            this.pnlPermis.add((Component)this.getTxtD(), Fonctions.getGridBagConstraints(3, 2, 1, 1, 0.0, 0.0, -1, -1, null));
            this.pnlPermis.add((Component)this.getTxtDE(), Fonctions.getGridBagConstraints(4, 2, 1, 1, 0.0, 0.0, -1, -1, null));
            this.pnlPermis.add((Component)this.getTxtVisite(), Fonctions.getGridBagConstraints(5, 2, 1, 1, 0.0, 0.0, -1, -1, null));
        }
        return this.pnlPermis;
    }

    private JTextField getTxtNom() {
        if (this.txtNom == null) {
            this.txtNom = new JTextField();
            this.txtNom.setPreferredSize(new Dimension(110, 20));
        }
        return this.txtNom;
    }

    private JTextField getTxtPrenom() {
        if (this.txtPrenom == null) {
            this.txtPrenom = new JTextField();
            this.txtPrenom.setPreferredSize(new Dimension(110, 20));
        }
        return this.txtPrenom;
    }

    private JTextField getTxtMail() {
        if (this.txtMail == null) {
            this.txtMail = new JTextField();
            this.txtMail.setPreferredSize(new Dimension(110, 20));
        }
        return this.txtMail;
    }

    private JTextField getTxtDomicile() {
        if (this.txtDomicile == null) {
            this.txtDomicile = new JTextField();
            this.txtDomicile.setMinimumSize(new Dimension(80, 20));
            this.txtDomicile.setPreferredSize(new Dimension(80, 20));
        }
        return this.txtDomicile;
    }

    private JTextField getTxtMobile() {
        if (this.txtMobile == null) {
            this.txtMobile = new JTextField();
            this.txtMobile.setMinimumSize(new Dimension(80, 20));
            this.txtMobile.setPreferredSize(new Dimension(80, 20));
            this.txtMobile.setText("");
        }
        return this.txtMobile;
    }

    private JTextField getTxtTel3() {
        if (this.txtTel3 == null) {
            this.txtTel3 = new JTextField();
            this.txtTel3.setMinimumSize(new Dimension(80, 20));
            this.txtTel3.setPreferredSize(new Dimension(80, 20));
        }
        return this.txtTel3;
    }

    private JTextField getTxtNaissance() {
        if (this.txtNaissance == null) {
            this.txtNaissance = new JTextField();
            this.txtNaissance.setMinimumSize(new Dimension(70, 20));
            this.txtNaissance.setPreferredSize(new Dimension(80, 20));
            this.txtNaissance.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogCreationConducteur.this.getTxtNaissance());
                }
            });
        }
        return this.txtNaissance;
    }

    private JTextField getTxtBirthPlace() {
        if (this.txtBirthPlace == null) {
            this.txtBirthPlace = new JTextField();
            this.txtBirthPlace.setMinimumSize(new Dimension(70, 20));
            this.txtBirthPlace.setPreferredSize(new Dimension(80, 20));
        }
        return this.txtBirthPlace;
    }

    private JTextField getTxtCP() {
        if (this.txtCP == null) {
            this.txtCP = new JTextField();
            this.txtCP.setMinimumSize(new Dimension(40, 20));
            this.txtCP.setPreferredSize(new Dimension(40, 20));
            this.txtCP.setText("");
        }
        return this.txtCP;
    }

    private JTextField getTxtVille() {
        if (this.txtVille == null) {
            this.txtVille = new JTextField();
            this.txtVille.setPreferredSize(new Dimension(100, 20));
        }
        return this.txtVille;
    }

    private JComboBox getCbAgence() {
        if (this.cbAgence == null) {
            this.cbAgence = new JFittedComboBox();
            this.cbAgence.setPreferredSize(new Dimension(100, 25));
            this.cbAgence.setModel(new ComboBoxModel(Agence.getList(), true, null));
            this.cbAgence.getComponentCount();
            this.cbAgence.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Agence selected = (Agence)((ComboBoxModel)DialogCreationConducteur.this.getCbAgence().getModel()).getObjectAt(DialogCreationConducteur.this.getCbAgence().getSelectedIndex());
                    if (selected == null) {
                        return;
                    }
                    int defaultCalendarId = selected.getDefaultCalendarId();
                    DialogCreationConducteur.this.getCbCalendrier().setSelectedItem(((ComboBoxModel)DialogCreationConducteur.this.getCbCalendrier().getModel()).getLabel(defaultCalendarId));
                }
            });
        }
        return this.cbAgence;
    }

    private JTextField getTxtMatricule() {
        if (this.txtMatricule == null) {
            this.txtMatricule = new JTextField();
            this.txtMatricule.setPreferredSize(new Dimension(80, 20));
        }
        return this.txtMatricule;
    }

    private JTextField getTxtCode() {
        if (this.txtCode == null) {
            this.txtCode = new JTextField();
            this.txtCode.setPreferredSize(new Dimension(80, 20));
        }
        return this.txtCode;
    }

    private JTextField getTxtDateEntree() {
        if (this.txtDateEntree == null) {
            this.txtDateEntree = new JTextField();
            this.txtDateEntree.setPreferredSize(new Dimension(70, 20));
            this.txtDateEntree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogCreationConducteur.this.getTxtDateEntree());
                }
            });
        }
        return this.txtDateEntree;
    }

    private JTextField getTxtDateSortie() {
        if (this.txtDateSortie == null) {
            this.txtDateSortie = new JTextField();
            this.txtDateSortie.setPreferredSize(new Dimension(70, 20));
            this.txtDateSortie.setText("");
            this.txtDateSortie.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogCreationConducteur.this.getTxtDateSortie());
                }
            });
        }
        return this.txtDateSortie;
    }

    private JTextField getTxtVisiteMedicale() {
        if (this.txtVisiteMedicale == null) {
            this.txtVisiteMedicale = new JTextField();
            this.txtVisiteMedicale.setPreferredSize(new Dimension(70, 20));
            this.txtVisiteMedicale.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogCreationConducteur.this.getTxtVisiteMedicale());
                }
            });
        }
        return this.txtVisiteMedicale;
    }

    private JTextField getTxtFimoFco() {
        if (this.txtFimoFco == null) {
            this.txtFimoFco = new JTextField();
            this.txtFimoFco.setPreferredSize(new Dimension(70, 20));
            this.txtFimoFco.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogCreationConducteur.this.getTxtFimoFco());
                }
            });
        }
        return this.txtFimoFco;
    }

    private JComboBox getCbTypePersonnel() {
        if (this.cbTypePersonnel == null) {
            this.cbTypePersonnel = new JComboBox();
            this.cbTypePersonnel.setModel(new ComboBoxModel(EmployeeType.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbTypePersonnel;
    }

    private JComboBox getCbTypeContrat() {
        if (this.cbTypeContrat == null) {
            this.cbTypeContrat = new JComboBox();
            this.cbTypeContrat.setModel(new ComboBoxModel(TypeContrat.loadList(), false, null));
        }
        return this.cbTypeContrat;
    }

    private JComboBox getCbCalendrier() {
        if (this.cbCalendrier == null) {
            this.cbCalendrier = new JComboBox();
            this.cbCalendrier.setModel(new ComboBoxModel(GlobalCalendar.loadList(), false, LanguageTranslator.getString("generics.none")));
            Agence selected = (Agence)((ComboBoxModel)this.getCbAgence().getModel()).getObjectAt(this.getCbAgence().getSelectedIndex());
            if (selected != null) {
                this.cbCalendrier.setSelectedItem(((ComboBoxModel)this.getCbCalendrier().getModel()).getLabel(selected.getDefaultCalendarId()));
            }
        }
        return this.cbCalendrier;
    }

    private JComboBox getCbTypeCond() {
        if (this.cbTypeCond == null) {
            this.cbTypeCond = new JComboBox();
            this.cbTypeCond.addItem("");
            this.cbTypeCond.addItem("Grands routiers");
            this.cbTypeCond.addItem("Zones courtes");
            this.cbTypeCond.addItem("Messagerie");
        }
        return this.cbTypeCond;
    }

    private JFittedComboBox getCbAnalyticCode() {
        if (this.cbAnalyticCode == null) {
            this.cbAnalyticCode = new JFittedComboBox();
            this.cbAnalyticCode.setModel(new ComboBoxModel(DriverAnalyticCode.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbAnalyticCode;
    }

    private JButton getBtnAddAnalyticCode() {
        if (this.btnAddAnalyticCode == null) {
            this.btnAddAnalyticCode = new JButton();
            this.btnAddAnalyticCode.setIcon(this.getImgAdd());
            this.btnAddAnalyticCode.setPreferredSize(new Dimension(25, 25));
            this.btnAddAnalyticCode.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Fonctions.define(DriverAnalyticCode.class);
                }
            });
        }
        return this.btnAddAnalyticCode;
    }

    private ImageIcon getImgAdd() {
        if (this.imgAdd == null) {
            ClassLoader cl = this.getClass().getClassLoader();
            this.imgAdd = new ImageIcon(cl.getResource(this.getRes().getResourceString("icone_cliq")));
        }
        return this.imgAdd;
    }

    private Fmresources getRes() {
        if (this.res == null) {
            this.res = Transport.res;
        }
        return this.res;
    }

    private JButton getBtnAnnuler() {
        if (this.btnAnnuler == null) {
            this.btnAnnuler = new JButton();
            this.btnAnnuler.setText(LanguageTranslator.getString("button.quit"));
            this.btnAnnuler.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogCreationConducteur.this.dispose();
                }
            });
        }
        return this.btnAnnuler;
    }

    private JTextPane getTxtAdresse() {
        if (this.txtAdresse == null) {
            this.txtAdresse = new JTextPane();
            this.txtAdresse.setBorder(this.getTxtCP().getBorder());
        }
        return this.txtAdresse;
    }

    private JTextField getTxtKey() {
        if (this.txtKey == null) {
            this.txtKey = new JTextField();
        }
        return this.txtKey;
    }

    private JTextField getTxtTx() {
        if (this.txtTx == null) {
            this.txtTx = new JTextField();
            this.txtTx.setPreferredSize(new Dimension(80, 20));
        }
        return this.txtTx;
    }

    private JCheckBox getCbTravailNuit() {
        if (this.cbTravailNuit == null) {
            this.cbTravailNuit = new JCheckBox();
            this.cbTravailNuit.setText(LanguageTranslator.getString("driver.night"));
        }
        return this.cbTravailNuit;
    }

    private JComboBox getCbNightDay() {
        if (this.cbNightDay == null) {
            this.cbNightDay = new JComboBox();
            this.cbNightDay.addItem(LanguageTranslator.getString("generics.none"));
            this.cbNightDay.addItem(LanguageTranslator.getString("generics.distribution"));
            this.cbNightDay.addItem(LanguageTranslator.getString("generics.traction"));
            this.cbNightDay.addItem(LanguageTranslator.getString("generics.location"));
        }
        return this.cbNightDay;
    }

    private JTextField getTxtAdr() {
        if (this.txtAdr == null) {
            this.txtAdr = new JTextField();
            this.txtAdr.setPreferredSize(new Dimension(70, 20));
            this.txtAdr.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogCreationConducteur.this.txtAdr);
                }
            });
        }
        return this.txtAdr;
    }

    private JTextField getTxtCaces() {
        if (this.txtCaces == null) {
            this.txtCaces = new JTextField();
            this.txtCaces.setPreferredSize(new Dimension(70, 20));
            this.txtCaces.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogCreationConducteur.this.txtCaces);
                }
            });
        }
        return this.txtCaces;
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogCreationConducteur.this.add()) {
                        DialogCreationConducteur.this.dispose();
                    }
                }
            });
        }
        return this.btnEnregistrer;
    }

    private JTextField getTxtSecuriteSociale() {
        if (this.txtSecuriteSociale == null) {
            this.txtSecuriteSociale = new JTextField();
            this.txtSecuriteSociale.setPreferredSize(new Dimension(80, 20));
        }
        return this.txtSecuriteSociale;
    }

    private JButton getBtnAddTypePersonnel() {
        if (this.btnAddTypePersonnel == null) {
            this.btnAddTypePersonnel = new JButton();
            this.btnAddTypePersonnel.setPreferredSize(new Dimension(25, 25));
            this.btnAddTypePersonnel.setIcon(this.getImgAdd());
            this.btnAddTypePersonnel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Fonctions.define(EmployeeType.class);
                }
            });
        }
        return this.btnAddTypePersonnel;
    }

    private JButton getBtnAddTypePaie() {
        if (this.btnAddTypePaie == null) {
            this.btnAddTypePaie = new JButton();
            this.btnAddTypePaie.setIcon(this.getImgAdd());
            this.btnAddTypePaie.setPreferredSize(new Dimension(25, 25));
            this.btnAddTypePaie.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogTypeContrat pnl = new DialogTypeContrat(MainFrameTransport.getInstance());
                    pnl.setVisible(true);
                }
            });
        }
        return this.btnAddTypePaie;
    }

    private JButton getBtnAddCalendrier() {
        if (this.btnAddCalendrier == null) {
            this.btnAddCalendrier = new JButton();
            this.btnAddCalendrier.setIcon(this.getImgAdd());
            this.btnAddCalendrier.setPreferredSize(new Dimension(25, 25));
            this.btnAddCalendrier.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
        }
        return this.btnAddCalendrier;
    }

    private JTextDate getTxtB() {
        if (this.txtB == null) {
            this.txtB = new JTextDate();
            if (!ConnexionSettings.getInstance().isModifiable("PERMIS")) {
                this.txtB.setEnabled(false);
            }
        }
        return this.txtB;
    }

    private JTextDate getTxtC() {
        if (this.txtC == null) {
            this.txtC = new JTextDate();
            if (!ConnexionSettings.getInstance().isModifiable("PERMIS")) {
                this.txtC.setEnabled(false);
            }
        }
        return this.txtC;
    }

    private JTextDate getTxtCE() {
        if (this.txtCE == null) {
            this.txtCE = new JTextDate();
            if (!ConnexionSettings.getInstance().isModifiable("PERMIS")) {
                this.txtCE.setEnabled(false);
            }
        }
        return this.txtCE;
    }

    private JTextDate getTxtD() {
        if (this.txtD == null) {
            this.txtD = new JTextDate();
            if (!ConnexionSettings.getInstance().isModifiable("PERMIS")) {
                this.txtD.setEnabled(false);
            }
        }
        return this.txtD;
    }

    private JTextDate getTxtDE() {
        if (this.txtDE == null) {
            this.txtDE = new JTextDate();
            if (!ConnexionSettings.getInstance().isModifiable("PERMIS")) {
                this.txtDE.setEnabled(false);
            }
        }
        return this.txtDE;
    }

    private JCheckBox getCbMonthPaid() {
        if (this.cbMonthPaid == null) {
            this.cbMonthPaid = new JCheckBox();
            this.cbMonthPaid.setText(LanguageTranslator.getString("driver.monthPaid"));
        }
        return this.cbMonthPaid;
    }

    private JCheckBox getCbExpensesAllowance() {
        if (this.cbExpensesAllowance == null) {
            this.cbExpensesAllowance = new JCheckBox();
            this.cbExpensesAllowance.setText(LanguageTranslator.getString("driver.expensesAllowance"));
        }
        return this.cbExpensesAllowance;
    }

    private JTextField getTxtNumero() {
        if (this.txtNumero == null) {
            this.txtNumero = new JTextField();
            if (!ConnexionSettings.getInstance().isModifiable("PERMIS")) {
                this.txtNumero.setEnabled(false);
            }
        }
        return this.txtNumero;
    }

    private JTextField getTxtVisite() {
        if (this.txtVisite == null) {
            this.txtVisite = new JTextField();
            this.txtVisite.setPreferredSize(new Dimension(70, 20));
            if (!ConnexionSettings.getInstance().isModifiable("PERMIS")) {
                this.txtVisite.setEnabled(false);
            } else {
                this.txtVisite.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        Fonctions.afficheCalendrier(DialogCreationConducteur.this.getTxtVisite());
                    }
                });
            }
        }
        return this.txtVisite;
    }

    private JTextField getTxtQuaCardNumber() {
        if (this.txtQuaCardNumber == null) {
            this.txtQuaCardNumber = new JTextField();
        }
        return this.txtQuaCardNumber;
    }

    public boolean add() {
        if (!this.check()) {
            return false;
        }
        if (this.current == null) {
            this.current = new Conducteur();
        }
        this.current.setDateNaissance(ConversionTime.dateFromFranceToBDD(this.getTxtNaissance().getText(), false));
        this.current.setLieuNaissance(this.getTxtBirthPlace().getText());
        this.current.setCleAgence(((ComboBoxModel)this.getCbAgence().getModel()).getSelectedCle());
        this.current.setCleTypeContrat(((ComboBoxModel)this.getCbTypeContrat().getModel()).getSelectedCle());
        this.current.setCleTypePersonnel(((ComboBoxModel)this.getCbTypePersonnel().getModel()).getSelectedCle());
        this.current.setCleTypeConducteur(this.getCbTypeCond().getSelectedIndex());
        this.current.setCalendarId(((ComboBoxModel)this.getCbCalendrier().getModel()).getSelectedCle());
        this.current.setNom(this.getTxtNom().getText());
        this.current.setPrenom(this.getTxtPrenom().getText());
        this.current.setMatricule(this.getTxtMatricule().getText());
        this.current.setNumeroImport(this.getTxtCode().getText());
        this.current.setAdresse(this.getTxtAdresse().getText());
        this.current.setCodePostal(this.getTxtCP().getText());
        this.current.setVille(this.getTxtVille().getText());
        this.current.setTel1(this.getTxtDomicile().getText());
        this.current.setTel2(this.getTxtMobile().getText());
        this.current.setDateVisite(ConversionTime.dateFromFranceToBDD(this.getTxtVisiteMedicale().getText(), false));
        this.current.setDateEntree(ConversionTime.dateFromFranceToBDD(this.getTxtDateEntree().getText(), false));
        this.current.setDateSortie(ConversionTime.dateFromFranceToBDD(this.getTxtDateSortie().getText(), false));
        if (!this.getTxtDateSortie().getText().equals("")) {
            this.current.setArchive(ConversionTime.stringToDate(this.getTxtDateSortie().getText(), "dd/MM/yyyy").before(new Date()) ? 1 : 0);
        }
        this.current.setNumSecuriteSociale(this.getTxtSecuriteSociale().getText());
        this.current.setQuaCardNumber(this.getTxtQuaCardNumber().getText());
        this.current.setFimoFco(ConversionTime.dateFromFranceToBDD(this.getTxtFimoFco().getText(), false));
        this.current.setNightDay(this.getCbNightDay().getSelectedIndex());
        this.current.setTaux(Float.parseFloat(this.getTxtTx().getText().equals("") ? "0" : this.getTxtTx().getText()));
        this.current.setNightWorker(this.getCbTravailNuit().isSelected());
        this.current.setAdr(ConversionTime.dateFromFranceToBDD(this.getTxtAdr().getText(), false));
        this.current.setCaces(ConversionTime.dateFromFranceToBDD(this.getTxtCaces().getText(), false));
        this.current.setKey(this.getTxtKey().getText());
        this.current.setNumeroPermis(this.getTxtNumero().getText());
        this.current.setDateVisitePermis(ConversionTime.dateFromFranceToBDD(this.getTxtVisite().getText(), false));
        this.current.setPayPeriodType(this.getCbMonthPaid().isSelected() ? 1 : 0);
        this.current.setExpensesAllowance(this.getCbExpensesAllowance().isSelected());
        this.current.setBDelivery(this.getTxtB().getDateString("yyyy-MM-dd"));
        this.current.setCDelivery(this.getTxtC().getDateString("yyyy-MM-dd"));
        this.current.setCEDelivery(this.getTxtCE().getDateString("yyyy-MM-dd"));
        this.current.setDDelivery(this.getTxtD().getDateString("yyyy-MM-dd"));
        this.current.setDEDelivery(this.getTxtDE().getDateString("yyyy-MM-dd"));
        this.current.setTel3(this.getTxtTel3().getText());
        this.current.setEmail(this.getTxtMail().getText());
        try {
            float[] position;
            String fullAddress = String.valueOf(this.getTxtAdresse().getText()) + " " + this.getTxtCP().getText() + " " + this.getTxtVille().getText();
            if (!fullAddress.trim().equals("") && (position = Fonctions.getCoordinates(fullAddress)) != null) {
                this.current.setLongitude(position[0]);
                this.current.setLatitude(position[1]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TimsLogger.error("#DCC.add# erreur getPosition");
        }
        if (this.current.insert()) {
            this.enregistrement = true;
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.saveSucceed"), LanguageTranslator.getString("message.done"), 1);
            return true;
        }
        JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.saveError"), LanguageTranslator.getString("message.saveError"), 0);
        return true;
    }

    public boolean check() {
        boolean toReturn = true;
        if (this.getTxtNom().getText().equals("")) {
            this.getTxtNom().setBackground(new Color(255, 192, 203));
            this.getTxtNom().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtNom().setBackground(Color.white);
        }
        if (this.getTxtPrenom().getText().equals("")) {
            this.getTxtPrenom().setBackground(new Color(255, 192, 203));
            this.getTxtPrenom().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtPrenom().setBackground(Color.white);
        }
        if (!this.getTxtTx().getText().equals("") && !Fonctions.isFloat(this.getTxtTx().getText())) {
            this.getTxtTx().setBackground(new Color(255, 192, 203));
            this.getTxtTx().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtTx().setBackground(Color.white);
        }
        if (((ComboBoxModel)this.getCbTypeContrat().getModel()).getSelectedCle() == 0) {
            this.getCbTypeContrat().setBackground(new Color(255, 192, 203));
            this.getCbTypeContrat().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getCbTypeContrat().setBackground(UIManager.getColor("ComboBox.background"));
        }
        return toReturn;
    }
}

