/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.conducteur;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.connexion.TimsSession;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.ClosePayPeriod;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.CustomReportColumn;
import fr.pgh.data.bdd.Jour;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.TypeActivite;
import fr.pgh.data.bdd.Utilisateur;
import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.exception.ActivityTypeNotFoundException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Date;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.EventListenerList;
import transpo.system.LicenceManager;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.listener.ActivityChangeListener;
import transpo.system.traitement.TraitementTempsService;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.modele.TMActivity;
import transpo.system.ui.modele.TMPrintable;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.GraphJour;
import transpo.system.ui.views.conducteur.DeleteActivite;
import transpo.system.ui.views.conducteur.DialogComment;
import transpo.system.ui.views.conducteur.DialogModification;
import transpo.system.ui.views.conducteur.DialogSelectionActivite;
import transpo.system.ui.views.conducteur.PnlFraisConducteur;
import transpo.system.ui.views.conducteur.PnlVehiculeConducteur;
import transpo.system.util.Fonctions;
import transport.report.CustomReportFactory;
import transport.report.generator.DJGeneratorWithLineIdStyle;

public class DialogDetailJournee
extends JDialog
implements Observer {
    private static final long serialVersionUID = 1L;
    private static final int MODIFICATION_OK = 0;
    private static final int BRUTE_ACTIVITY = 1;
    private static final int PERMISSION_DENIED = 2;
    private static final int CLOSED_PERIOD = 3;
    private ConnexionSettings conn = ConnexionSettings.getInstance();
    private boolean commentSet = false;
    private Conducteur detailConducteur = null;
    private String dateJour = null;
    private String dateJourBDD = null;
    private Vector<ActiviteConducteur> activiteJour = null;
    public boolean update = false;
    public boolean brut = false;
    public Jour day = null;
    public TMActivity modeleListe = null;
    public ActiviteConducteur courant = null;
    private int modificationLevel = -1;
    private JPanel jContentPane = null;
    private JPanel pnlGraph = null;
    private JPanel pnlTableau = null;
    private JPanel pnlDetail = null;
    private JScrollPane jspGraph = null;
    private GraphJour graphJour = null;
    private JScrollPane jspActivite = null;
    private JTable tblActivite = null;
    private JTabbedPane tbdDetail = null;
    private JPanel pnlBtn = null;
    private JButton btnEnregistrer = null;
    private JButton btnAnnuler = null;
    private PnlFraisConducteur pnlFrais = null;
    private PnlVehiculeConducteur pnlVehiculeJour = null;
    private JPanel pnlComm = null;
    private JTextArea textComm = null;
    private JPanel pnlPresentation = null;
    private JLabel lblRight = null;
    private JButton btnImprimer = null;
    private JLabel lblAuthor = null;
    private int expIndex = 0;
    private final EventListenerList listeners = new EventListenerList();
    private static DialogDetailJournee instance = null;

    public static DialogDetailJournee getInstance() {
        if (instance == null) {
            instance = new DialogDetailJournee(MainFrameTransport.getInstance());
        }
        return instance;
    }

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogDetailJournee.dispose()#");
        super.dispose();
    }

    @Override
    public void update(Observable o, Object arg) {
        TimsLogger.verbose("#" + this.getClass() + ".update# a faire");
        LanguageTranslator.getInstance().addObserver(this);
    }

    public void addActivityChangeListener(ActivityChangeListener toAdd) {
        this.listeners.add(ActivityChangeListener.class, toAdd);
    }

    public void removeActivityChangeListener(ActivityChangeListener toAdd) {
        this.listeners.remove(ActivityChangeListener.class, toAdd);
    }

    protected void fireActivityChanged() {
        ActivityChangeListener[] activityChangeListenerArray = (ActivityChangeListener[])this.listeners.getListeners(ActivityChangeListener.class);
        int n = activityChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityChangeListener list = activityChangeListenerArray[n2];
            list.activityChanged();
            ++n2;
        }
    }

    public DialogDetailJournee(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogDetailJournee()#");
        try {
            LanguageTranslator.getInstance().addObserver(this);
            this.initialize();
            TimsSession.getInstance().addVisit(this.getClass().getName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setDetail(Conducteur detailConducteur, String dateJour, boolean brut, Jour day) {
        Utilisateur tmp;
        this.update = false;
        this.day = day;
        if (this.day == null) {
            this.day = new Jour();
            this.day.loadCurrent(detailConducteur.getCleConducteur(), ConversionTime.dateFromFranceToBDD(dateJour, false));
        }
        this.activiteJour = this.day.getActivity();
        this.detailConducteur = detailConducteur;
        this.dateJour = dateJour;
        this.brut = brut;
        this.modificationLevel = -1;
        this.dateJourBDD = ConversionTime.dateFromFranceToBDD(dateJour, false);
        this.setTitle("Activit\u00e9 de " + detailConducteur.getNom() + " " + detailConducteur.getPrenom() + " du " + dateJour);
        this.getGraphJour().initialiser(this.activiteJour, day.getKm(), day.getDriving());
        this.modeleListe = new TMActivity(this.activiteJour);
        this.getTblActivite().setModel(this.modeleListe);
        Fonctions.hideColumn(this.tblActivite.getColumnModel().getColumn(7));
        this.getTextComm().setEditable(true);
        if (ConnexionSettings.getInstance().isConsultable("COMMENTAIRE") || ConnexionSettings.getInstance().isModifiable("COMMENTAIRE") || ConnexionSettings.getInstance().isAjoutable("COMMENTAIRE")) {
            this.getTextComm().setText(BddTransport.getInstance().getCommentJour(detailConducteur.getCleConducteur(), this.dateJourBDD));
        }
        boolean bl = this.commentSet = !this.getTextComm().getText().equals("");
        if (!ConnexionSettings.getInstance().isModifiable("COMMENTAIRE") && this.commentSet || brut) {
            this.getTextComm().setEditable(false);
        }
        if (!ConnexionSettings.getInstance().isAjoutable("COMMENTAIRE") && !this.commentSet) {
            this.getTextComm().setEditable(false);
        }
        if ((tmp = BddTransport.getInstance().getAuteurModification(this.dateJourBDD, detailConducteur.getCleConducteur())) != null) {
            this.getLblAuthor().setText(LanguageTranslator.getString("activity.updatedBy", tmp.getNom(), tmp.getPrenom()));
        } else {
            tmp = BddTransport.getInstance().getAuteurLecture(this.dateJourBDD, detailConducteur.getCleConducteur());
            this.getLblAuthor().setText(LanguageTranslator.getString("activity.insertedBy", tmp.getNom(), tmp.getPrenom()));
        }
        this.getPnlVehiculeJour().setModification(day.getUpdate());
        this.getPnlVehiculeJour().initialise(null, VehicleUsed.loadListDriver(detailConducteur.getCleConducteur(), 0, ConversionTime.dateFromFranceToBDD(dateJour, false), null), detailConducteur, this.dateJour);
        if (this.conn.isConsultable("FRAIS") && LicenceManager.isHRLevel()) {
            if (this.pnlFrais != null) {
                this.tbdDetail.removeTabAt(this.expIndex);
                this.pnlFrais = null;
            }
            this.tbdDetail.insertTab(LanguageTranslator.getString("generics.expenses"), null, this.getPnlFrais(), null, this.expIndex);
        }
        if (this.getModificationLevel() != 0) {
            this.getBtnEnregistrer().setEnabled(false);
        } else {
            this.getBtnEnregistrer().setEnabled(true);
        }
        switch (this.getModificationLevel()) {
            case 0: {
                this.getLblRight().setText(LanguageTranslator.getString("activity.updateGranted"));
                break;
            }
            case 1: {
                this.getLblRight().setText(LanguageTranslator.getString("activity.updateBrute"));
                break;
            }
            case 2: {
                this.getLblRight().setText(LanguageTranslator.getString("activity.updateDenied"));
                break;
            }
            case 3: {
                this.getLblRight().setText(LanguageTranslator.getString("activity.updateClosed"));
            }
        }
        this.repaint();
    }

    private void initialize() {
        this.setSize(new Dimension(750, 500));
        this.setLocationRelativeTo(this.getParent());
        this.setModal(false);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.fill = 2;
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.weighty = 0.0;
            gridBagConstraints12.insets = new Insets(5, 10, 5, 10);
            gridBagConstraints12.gridy = 0;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 0;
            gridBagConstraints21.anchor = 13;
            gridBagConstraints21.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints21.gridy = 4;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.fill = 1;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.insets = new Insets(10, 10, 10, 10);
            gridBagConstraints11.gridy = 3;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.insets = new Insets(5, 10, 5, 10);
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridy = 2;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(5, 10, 5, 10);
            gridBagConstraints.gridy = 1;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlGraph(), gridBagConstraints);
            this.jContentPane.add((Component)this.getPnlTableau(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getPnlDetail(), gridBagConstraints11);
            this.jContentPane.add((Component)this.getPnlBtn(), gridBagConstraints21);
            this.jContentPane.add((Component)this.getPnlPresentation(), gridBagConstraints12);
        }
        return this.jContentPane;
    }

    private JPanel getPnlGraph() {
        if (this.pnlGraph == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.weightx = 1.0;
            this.pnlGraph = new JPanel();
            this.pnlGraph.setLayout(new GridBagLayout());
            this.pnlGraph.setMinimumSize(new Dimension(750, 60));
            this.pnlGraph.add((Component)this.getJspGraph(), gridBagConstraints4);
        }
        return this.pnlGraph;
    }

    private JPanel getPnlTableau() {
        if (this.pnlTableau == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.gridx = 0;
            this.pnlTableau = new JPanel();
            this.pnlTableau.setLayout(new GridBagLayout());
            this.pnlTableau.setPreferredSize(new Dimension(750, 200));
            this.pnlTableau.add((Component)this.getJspActivite(), gridBagConstraints2);
        }
        return this.pnlTableau;
    }

    private JPanel getPnlDetail() {
        if (this.pnlDetail == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.gridx = 0;
            this.pnlDetail = new JPanel();
            this.pnlDetail.setLayout(new GridBagLayout());
            this.pnlDetail.add((Component)this.getTbdDetail(), gridBagConstraints3);
        }
        return this.pnlDetail;
    }

    private JScrollPane getJspGraph() {
        if (this.jspGraph == null) {
            this.jspGraph = new JScrollPane();
            this.jspGraph.setPreferredSize(new Dimension(0, 0));
            this.jspGraph.setHorizontalScrollBarPolicy(32);
            this.jspGraph.setVerticalScrollBarPolicy(21);
            this.jspGraph.setViewportView(this.getGraphJour());
        }
        return this.jspGraph;
    }

    private GraphJour getGraphJour() {
        if (this.graphJour == null) {
            this.graphJour = new GraphJour();
            this.graphJour.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    DialogDetailJournee.this.courant = DialogDetailJournee.this.getGraphJour().getActivite(e.getX());
                    boolean canUpdate = true;
                    try {
                        int updateLevel = TypeActivite.getActivityType(DialogDetailJournee.this.courant.getCleType()).getModificationLevel();
                        if (updateLevel == 0) {
                            canUpdate = false;
                        }
                    }
                    catch (ActivityTypeNotFoundException ex) {
                        ex.printStackTrace();
                    }
                    if (DialogDetailJournee.this.getModificationLevel() == 0 && canUpdate) {
                        DialogDetailJournee.this.doUpdate(e.getX(), e.getButton());
                    }
                }
            });
        }
        return this.graphJour;
    }

    public void doUpdate(int position, int action) {
        if (action == 1) {
            this.getDialogSelectionActivite(this.getGraphJour().getMinute(position));
        } else if (action == 3) {
            this.getDialogDeleteActivite(this.getGraphJour().getMinute(position));
        } else {
            ActiviteConducteur tmp = this.getGraphJour().getActivite(position);
            if (tmp != null) {
                this.getDialogModification(tmp);
            }
        }
    }

    public int getModificationLevel() {
        if (this.modificationLevel == -1) {
            this.modificationLevel = 0;
            if (this.brut) {
                this.modificationLevel = 1;
            } else if (!ConnexionSettings.getInstance().isModifiable("ACTIVITE")) {
                this.modificationLevel = 2;
            } else if (ClosePayPeriod.isClosed(this.detailConducteur.getCleAgence(), ConversionTime.stringToDate(this.dateJour, "dd/MM/yyyy"))) {
                this.modificationLevel = 3;
            }
        }
        return this.modificationLevel;
    }

    private void getDialogModification(ActiviteConducteur tmp) {
        DialogModification dialog = new DialogModification(this, this.activiteJour, tmp);
        dialog.setVisible(true);
        if (dialog.update) {
            this.update = true;
            this.activiteJour = dialog.activiteJour;
            this.getTblActivite().setModel(new TMActivity(this.activiteJour));
            Fonctions.hideColumn(this.tblActivite.getColumnModel().getColumn(7));
            this.getGraphJour().initialiser(this.activiteJour, this.day.getDriving(), this.day.getKm());
        }
    }

    private void getDialogSelectionActivite(int heure) {
        if (System.getProperty("magnetism", "true").equals("true")) {
            heure = this.roundHour(heure);
        }
        DialogSelectionActivite dialog = new DialogSelectionActivite(this, this.activiteJour, heure);
        dialog.setVisible(true);
        if (dialog.update) {
            this.update = true;
            this.activiteJour = dialog.activiteJour;
            this.getTblActivite().setModel(new TMActivity(this.activiteJour));
            Fonctions.hideColumn(this.tblActivite.getColumnModel().getColumn(7));
            this.getGraphJour().initialiser(this.activiteJour, this.day.getDriving(), this.day.getKm());
        }
    }

    private int roundHour(int hour) {
        int hourModulo = hour % 60;
        if (hourModulo < 5) {
            return hour / 60 * 60;
        }
        if (hourModulo > 55) {
            return (hour / 60 + 1) * 60;
        }
        int halfModulo = (hour + 30) % 60;
        if (halfModulo < 5 || halfModulo > 55) {
            int fullHour = hour / 60 * 60;
            return fullHour + 30;
        }
        return hour;
    }

    private void getDialogDeleteActivite(int heure) {
        this.update = true;
        DeleteActivite tmp = new DeleteActivite(this, this.activiteJour, heure);
        this.activiteJour = tmp.activiteJour;
        this.getTblActivite().setModel(new TMActivity(this.activiteJour));
        Fonctions.hideColumn(this.tblActivite.getColumnModel().getColumn(7));
        this.getGraphJour().initialiser(this.activiteJour, this.day.getDriving(), this.day.getKm());
    }

    private JScrollPane getJspActivite() {
        if (this.jspActivite == null) {
            this.jspActivite = new JScrollPane();
            this.jspActivite.setPreferredSize(new Dimension(750, 200));
            this.jspActivite.setViewportView(this.getTblActivite());
        }
        return this.jspActivite;
    }

    private JTable getTblActivite() {
        if (this.tblActivite == null) {
            this.tblActivite = new JTable();
            this.tblActivite.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    DialogDetailJournee.this.updateActivity();
                }
            });
        }
        return this.tblActivite;
    }

    public void updateActivity() {
        ActiviteConducteur tmp = this.modeleListe.getObjectAt(this.getTblActivite().getSelectedRow());
        if (tmp == null) {
            return;
        }
        try {
            if (this.getModificationLevel() == 0 && TypeActivite.getActivityType(tmp.getCleType()).getModificationLevel() != 0) {
                this.getDialogModification(tmp);
            } else {
                JOptionPane.showMessageDialog(this, LanguageTranslator.getString("activity.activityUpdateError"), LanguageTranslator.getString("message.unauthorized"), 0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("activity.activityUpdateError"), LanguageTranslator.getString("message.unauthorized"), 0);
        }
    }

    private JTabbedPane getTbdDetail() {
        if (this.tbdDetail == null) {
            this.tbdDetail = new JTabbedPane();
            this.tbdDetail.setPreferredSize(new Dimension(650, 80));
            if (this.conn.isConsultable("COMMENTAIRE")) {
                this.tbdDetail.addTab(LanguageTranslator.getString("generics.comment"), null, this.getPnlComm(), null);
                ++this.expIndex;
            }
            if (this.conn.isConsultable("VEHICULE") && LicenceManager.isExploitationLevel()) {
                this.tbdDetail.addTab(LanguageTranslator.getString("generics.vehicle"), null, this.getPnlVehiculeJour(), null);
            }
        }
        return this.tbdDetail;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 1;
            gridBagConstraints9.gridy = 0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.anchor = 13;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints6.gridy = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 2;
            gridBagConstraints5.anchor = 13;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints5.gridy = 0;
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.setMinimumSize(new Dimension(300, 30));
            this.pnlBtn.add((Component)this.getBtnEnregistrer(), gridBagConstraints5);
            this.pnlBtn.add((Component)this.getBtnAnnuler(), gridBagConstraints6);
            this.pnlBtn.add((Component)this.getBtnImprimer(), gridBagConstraints9);
        }
        return this.pnlBtn;
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogDetailJournee.this.save();
                }
            });
        }
        return this.btnEnregistrer;
    }

    public void save() {
        Transport.bdd.startTransaction();
        if (this.update) {
            if (this.getTextComm().getText().equals("")) {
                this.emptyComment();
                Transport.bdd.rollback();
                return;
            }
            if (!this.saveUpdate()) {
                Transport.bdd.rollback();
                JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.saveError"), LanguageTranslator.getString("message.saveError"), 0);
                return;
            }
        }
        if (this.conn.isConsultable("FRAIS") && LicenceManager.isHRLevel() && !this.getPnlFrais().sauvegarde()) {
            Transport.bdd.rollback();
            return;
        }
        if (this.conn.isModifiable("VEHICULE") && LicenceManager.isExploitationLevel()) {
            String tableToUpdate = "t_jour";
            if (this.update || this.day.getUpdate() != 0) {
                tableToUpdate = "t_jour_modifie";
            }
            BddTransport.getInstance().updateKm(this.getPnlVehiculeJour().getKm(), this.dateJourBDD, this.detailConducteur.getCleConducteur(), this.day.getUpdate(), tableToUpdate);
            Service.updateKm(this.detailConducteur.getCleConducteur(), this.dateJourBDD, this.getPnlVehiculeJour().getKm());
            if (!this.getPnlVehiculeJour().sauvegarde()) {
                Transport.bdd.rollback();
                return;
            }
        }
        this.updateComment();
        Transport.bdd.commit();
        Fonctions.showSuccessMessage(null, LanguageTranslator.getString("activity.updated", this.dateJour, String.valueOf(this.detailConducteur.getNom()) + " " + this.detailConducteur.getPrenom()));
        this.fireActivityChanged();
        this.dispose();
    }

    public void emptyComment() {
        JOptionPane.showMessageDialog(this, LanguageTranslator.getString("activity.update.emptyComment"), LanguageTranslator.getString("message.inputError"), 0);
    }

    public boolean saveUpdate() {
        if (System.getProperty("horoquartz", "0").equals("1")) {
            Date lastExport = BddTransport.getInstance().getLastExport(this.detailConducteur.getCleConducteur());
            Date jour = ConversionTime.stringToDate(this.dateJourBDD, "yyyy-MM-dd");
            if (lastExport != null && (jour.before(lastExport) || jour.equals(lastExport))) {
                BddTransport.getInstance().updateExportHoroquartz(this.detailConducteur.getCleConducteur(), this.dateJourBDD);
            }
        }
        if (!this.updateJour()) {
            if (Transport.debug >= 1) {
                System.err.println("#DialogDetailJournee.saveUpdate# updateJour a retourn\u00e9 false");
            }
            return false;
        }
        try {
            TraitementTempsService tts = new TraitementTempsService(this.detailConducteur, this.dateJourBDD, this.dateJourBDD, false);
            tts.loadActivite();
            tts.calculService();
            tts.saveListe();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public void updateComment() {
        String commentaire = this.getTextComm().getText();
        if (this.commentSet) {
            if (commentaire.equals("")) {
                BddTransport.getInstance().delComment(this.detailConducteur.getCleConducteur(), this.dateJourBDD);
            } else {
                BddTransport.getInstance().updateComment(this.detailConducteur.getCleConducteur(), this.dateJourBDD, commentaire);
            }
        } else if (!commentaire.equals("")) {
            BddTransport.getInstance().addComment(this.detailConducteur.getCleConducteur(), this.dateJourBDD, commentaire);
        }
    }

    public boolean updateJour() {
        Fonctions.sortActivitiesList(this.activiteJour);
        boolean retour = false;
        try {
            int cleCond = this.detailConducteur.getCleConducteur();
            int cumulC = 0;
            int cumulD = 0;
            int cumulT = 0;
            int cumulDE = 0;
            int cumulR = 0;
            int cumulI = 0;
            int cumulA = 0;
            int heureNuit = 0;
            int i = 0;
            while (i < this.activiteJour.size()) {
                ActiviteConducteur activ = this.activiteJour.get(i);
                TimsLogger.debug("#Fonctions.updateDay# pour " + activ.getHeureDebut() + " " + activ.getHeureFin() + " : " + Fonctions.getTimeBetween(activ, 1260, 360) + " " + Fonctions.getTempsNuit(activ) + " " + Fonctions.getTempsCumul(activ.getHeureDebut(), activ.getHeureFin(), 1260, 360));
                switch (activ.getCleType()) {
                    case 1: {
                        cumulC += activ.getDuree();
                        heureNuit += Fonctions.getTempsNuit(activ);
                        break;
                    }
                    case 2: {
                        cumulT += activ.getDuree();
                        heureNuit += Fonctions.getTempsNuit(activ);
                        break;
                    }
                    case 3: {
                        cumulD += activ.getDuree();
                        heureNuit += Fonctions.getTempsNuit(activ);
                        break;
                    }
                    case 4: {
                        cumulR += activ.getDuree();
                        break;
                    }
                    case 5: {
                        cumulDE += activ.getDuree();
                        heureNuit += Fonctions.getTempsNuit(activ);
                        break;
                    }
                    case 6: {
                        cumulA += activ.getDuree();
                        break;
                    }
                    case 7: {
                        cumulI += activ.getDuree();
                        break;
                    }
                    default: {
                        cumulA += activ.getDuree();
                    }
                }
                ++i;
            }
            int cumul = cumulC + cumulT + cumulD + cumulDE;
            int heureDebut = Integer.parseInt(Fonctions.getHeureDebut(this.activiteJour));
            int heureFin = Integer.parseInt(Fonctions.getHeureFin(this.activiteJour));
            int km = -1;
            if (this.conn.isConsultable("VEHICULE") && LicenceManager.isExploitationLevel()) {
                km = this.getPnlVehiculeJour().getKm();
            }
            BddTransport.getInstance().prepareUpdateJour(this.conn.getUserCle(), cleCond, this.dateJourBDD);
            Jour newDay = new Jour(0, cleCond, this.dateJourBDD, cumulC, cumulT, cumulD, cumulR, cumulDE, cumulI, 0, cumul, heureDebut, heureFin, heureNuit, km, this.day.getUpdate() + 1, false, this.activiteJour, "", this.conn.getUserCle(), this.day.getSourceName(), false);
            return newDay.insert();
        }
        catch (Exception ex) {
            retour = false;
            TimsLogger.warn("#DialogDetailJour.updateJour# " + ex.getMessage());
            ex.printStackTrace();
            return retour;
        }
    }

    private JButton getBtnAnnuler() {
        if (this.btnAnnuler == null) {
            this.btnAnnuler = new JButton();
            this.btnAnnuler.setText(LanguageTranslator.getString("button.quit"));
            this.btnAnnuler.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogDetailJournee.this.dispose();
                }
            });
        }
        return this.btnAnnuler;
    }

    private PnlFraisConducteur getPnlFrais() {
        if (this.pnlFrais == null) {
            this.pnlFrais = new PnlFraisConducteur(this.dateJour, this.detailConducteur);
            this.pnlFrais.setPreferredSize(new Dimension(350, 100));
        }
        return this.pnlFrais;
    }

    private PnlVehiculeConducteur getPnlVehiculeJour() {
        if (this.pnlVehiculeJour == null) {
            this.pnlVehiculeJour = new PnlVehiculeConducteur();
            this.pnlVehiculeJour.setPreferredSize(new Dimension(350, 100));
        }
        return this.pnlVehiculeJour;
    }

    private JPanel getPnlComm() {
        if (this.pnlComm == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 1;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.weighty = 1.0;
            gridBagConstraints7.insets = new Insets(10, 10, 10, 10);
            gridBagConstraints7.gridx = 0;
            this.pnlComm = new JPanel();
            this.pnlComm.setLayout(new GridBagLayout());
            this.pnlComm.add((Component)this.getTextComm(), gridBagConstraints7);
        }
        return this.pnlComm;
    }

    private JTextArea getTextComm() {
        if (this.textComm == null) {
            this.textComm = new JTextArea();
            this.textComm.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 3) {
                        String original;
                        DialogComment tmp = new DialogComment(DialogDetailJournee.this);
                        int nb = BddTransport.getInstance().getCommentCount(DialogDetailJournee.this.detailConducteur.getCleConducteur(), DialogDetailJournee.this.dateJourBDD, tmp.getSelected());
                        TimsLogger.debug("#DdetailJour# nb comment (" + tmp.getSelected() + ")" + nb);
                        if (nb > 5) {
                            TimsLogger.debug("#DdetailJour# nb comment >5 (" + tmp.getSelected() + ")" + nb);
                        }
                        if (!(original = DialogDetailJournee.this.getTextComm().getText()).equals("")) {
                            original = String.valueOf(original) + "\r\n";
                        }
                        DialogDetailJournee.this.getTextComm().setText(String.valueOf(original) + tmp.getSelected());
                        TimsLogger.debug(DialogDetailJournee.this.getTextComm().getText());
                    } else {
                        TimsLogger.debug("" + ((DialogDetailJournee)DialogDetailJournee.this).conn.user.getCleProfil());
                    }
                }
            });
        }
        return this.textComm;
    }

    private JPanel getPnlPresentation() {
        if (this.pnlPresentation == null) {
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.anchor = 13;
            gridBagConstraints8.fill = 1;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.weightx = 1.0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            this.pnlPresentation = new JPanel();
            this.pnlPresentation.setLayout(new GridBagLayout());
            this.pnlPresentation.setPreferredSize(new Dimension(750, 40));
            this.pnlPresentation.add((Component)this.getLblRight(), gridBagConstraints8);
            this.pnlPresentation.add((Component)this.getLblAuthor(), gridBagConstraints);
        }
        return this.pnlPresentation;
    }

    private JLabel getLblRight() {
        if (this.lblRight == null) {
            this.lblRight = new JLabel();
            this.lblRight.setHorizontalAlignment(4);
        }
        return this.lblRight;
    }

    private JLabel getLblAuthor() {
        if (this.lblAuthor == null) {
            this.lblAuthor = new JLabel();
        }
        return this.lblAuthor;
    }

    private JButton getBtnImprimer() {
        if (this.btnImprimer == null) {
            this.btnImprimer = new JButton();
            this.btnImprimer.setText(LanguageTranslator.getString("button.print"));
            this.btnImprimer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        if (!(DialogDetailJournee.this.getTblActivite().getModel() instanceof TMPrintable)) {
                            throw new Exception("Model is not a PrintableTM");
                        }
                        Vector<Color> conditionalColors = new Vector<Color>();
                        Vector<Integer> conditionalThresholds = new Vector<Integer>();
                        conditionalColors.add(Color.white);
                        conditionalThresholds.add(-1);
                        for (TypeActivite act : TypeActivite.getList()) {
                            conditionalColors.add(new Color(act.getColor()));
                            conditionalThresholds.add(act.getCle());
                        }
                        CustomReport cr = CustomReportFactory.getGeneric(LanguageTranslator.getString("generics.day.detail"));
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("NOM_CONDUCTEUR", DialogDetailJournee.this.detailConducteur.getNom());
                        params.put("PRENOM_CONDUCTEUR", DialogDetailJournee.this.detailConducteur.getPrenom());
                        params.put("DEBUT", ConversionTime.stringToDate(DialogDetailJournee.this.dateJour, "dd/MM/yyyy"));
                        params.put("FIN", ConversionTime.stringToDate(DialogDetailJournee.this.dateJour, "dd/MM/yyyy"));
                        params.put("GRAPH", DialogDetailJournee.this.getBufferedGraphic());
                        params.put("TEMPLATE", "report/templatePortraitJour.jrxml");
                        params.put("CONDUITE", DialogDetailJournee.this.day.getDriving());
                        params.put("TRAVAIL", DialogDetailJournee.this.day.getWork());
                        params.put("DISPO", DialogDetailJournee.this.day.getAvailability());
                        params.put("AUTRE", DialogDetailJournee.this.day.getOther());
                        params.put("DOUBLE_EQUIP", DialogDetailJournee.this.day.getCrew());
                        params.put("INCONNU", DialogDetailJournee.this.day.getUnk());
                        params.put("debut_jour", DialogDetailJournee.this.day.getBeginTime());
                        params.put("fin_jour", DialogDetailJournee.this.day.getEndTime());
                        params.put("DISTANCE", String.valueOf(DialogDetailJournee.this.day.getKm()));
                        cr.setProperties(params);
                        Vector<CustomReportColumn> columns = CustomReportFactory.getDefaultDriverDayDetailColumn();
                        cr.setColumn(columns);
                        Fonctions.tblToReport(cr, new DJGeneratorWithLineIdStyle(conditionalColors, conditionalThresholds), ((TMPrintable)((Object)DialogDetailJournee.this.getTblActivite().getModel())).getData(), "\u00e9cran");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        return this.btnImprimer;
    }

    private BufferedImage getBufferedGraphic() {
        int w = this.getGraphJour().getWidth();
        int h = this.getGraphJour().getHeight();
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics2D g = bi.createGraphics();
        this.getGraphJour().print(g);
        return bi;
    }
}

