/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.conducteur;

import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.DriverExpenses;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.conducteur.PnlFraisConducteur;

public class DialogDriverExpenses
extends JDialog {
    private JPanel jContentPane = null;
    private JPanel pnlExpenses = null;
    private JButton btnValid = null;
    private JPanel pnlBtn = null;
    private PnlFraisConducteur pnlDriverExpenses = null;
    private String date = null;
    private Conducteur driver = null;
    private JButton btnCancel = null;

    public DialogDriverExpenses(JDialog owner, String date, Conducteur driver) {
        super(owner);
        this.date = date;
        this.driver = driver;
        this.initialize();
    }

    private void initialize() {
        this.setModal(true);
        this.setUndecorated(true);
        this.setSize(400, 130);
        this.setLocation(this.getParent().getLocation().x, this.getParent().getLocation().y + this.getParent().getHeight());
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlExpenses(), gridBagConstraints1);
        }
        return this.jContentPane;
    }

    private JPanel getPnlExpenses() {
        if (this.pnlExpenses == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.fill = 1;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 0.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 1;
            this.pnlExpenses = new JPanel();
            this.pnlExpenses.setLayout(new GridBagLayout());
            this.pnlExpenses.add((Component)this.getPnlBtn(), gridBagConstraints2);
            this.pnlExpenses.add((Component)this.getPnlDriverExpenses(), gridBagConstraints11);
        }
        return this.pnlExpenses;
    }

    private JButton getBtnValid() {
        if (this.btnValid == null) {
            this.btnValid = new JButton();
            this.btnValid.setText(LanguageTranslator.getString("button.save"));
            this.btnValid.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogDriverExpenses.this.enregistrer();
                }
            });
        }
        return this.btnValid;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.add((Component)this.getBtnCancel(), null);
            this.pnlBtn.add((Component)this.getBtnValid(), null);
        }
        return this.pnlBtn;
    }

    public void enregistrer() {
        this.getPnlDriverExpenses().sauvegarde();
        this.dispose();
    }

    private PnlFraisConducteur getPnlDriverExpenses() {
        if (this.pnlDriverExpenses == null) {
            this.pnlDriverExpenses = new PnlFraisConducteur(this.date, this.driver);
        }
        return this.pnlDriverExpenses;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText(LanguageTranslator.getString("button.quit"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogDriverExpenses.this.dispose();
                }
            });
        }
        return this.btnCancel;
    }

    public Vector<DriverExpenses> getDriverExpenses() {
        return this.getPnlDriverExpenses().getListeFraisConducteur();
    }
}

