/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.conducteur;

import fr.pgh.component.JFittedComboBox;
import fr.pgh.component.JTextHour;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.connexion.TimsSession;
import fr.pgh.data.BddEvent;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.EmployeeObligationType;
import fr.pgh.data.bdd.EmployeeObligationTypeGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.LMEmployeeObligationType;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class DialogEmployeeObligationType
extends JDialog
implements DataListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlListe = null;
    private JPanel pnlDetail = null;
    private JScrollPane jpsListe = null;
    private JList listEmployeeObligation = null;
    private JButton btnCreer = null;
    private JPanel pnlBtn = null;
    private JButton btnQuitter = null;
    private JButton btnArchive = null;
    private JButton btnEnregistrer = null;
    private JTextField txtDesignation = null;
    private JLabel lblDesignation = null;
    private JTextField txtCode = null;
    private JLabel lblCode = null;
    private JCheckBox cbArchive = null;
    private JLabel lblCost = null;
    private JTextField txtCost = null;
    private JLabel lblHour = null;
    private JTextHour txtHour = null;
    private JLabel lblPeriod = null;
    private JTextField txtPeriod = null;
    private JLabel lblWarningThreshold = null;
    private JTextField txtWarningThreshold = null;
    private JLabel lblErrorThreshold = null;
    private JTextField txtErrorThreshold = null;
    private JLabel lblGroup = null;
    private JFittedComboBox cbGroup = null;
    private JCheckBox cbManualExpiration = null;
    private JPanel pnlAlert = null;
    private JPanel pnlExpirationDetail = null;
    private EmployeeObligationType current = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogEmployeeObligationType.dispose()#");
        super.dispose();
    }

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        BddEvent e;
        if (dataEvent instanceof BddEvent && (e = (BddEvent)dataEvent).getTable().equals("EMPLOYEE_OBLIGATION_TYPE_GROUP")) {
            this.getCbGroup().setModel(new ComboBoxModel(EmployeeObligationTypeGroup.getList(), false, LanguageTranslator.getString("generics.none")));
        }
    }

    public DialogEmployeeObligationType(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogEmployeeObligationType()#");
        this.initialize();
        TimsSession.getInstance().addVisit(this.getClass().getName());
        Transport.bdd.addDataListener(this);
    }

    private void initialize() {
        this.setSize(650, 350);
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(LanguageTranslator.getString("employee.obligation.type"));
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gcbList = Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 1, 11, new Insets(5, 5, 5, 5));
            GridBagConstraints gcbDetail = Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 2, 11, new Insets(5, 0, 5, 5));
            GridBagConstraints gcbBtn = Fonctions.getGridBagConstraints(0, 1, 1, 2, 1.0, 0.0, 1, -1, new Insets(5, 0, 5, 0));
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlListe(), gcbList);
            this.jContentPane.add((Component)this.getPnlDetail(), gcbDetail);
            this.jContentPane.add((Component)this.getPnlBtn(), gcbBtn);
        }
        return this.jContentPane;
    }

    private JPanel getPnlListe() {
        if (this.pnlListe == null) {
            GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
            gridBagConstraints32.gridx = 0;
            gridBagConstraints32.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints32.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints2.gridx = 0;
            this.pnlListe = new JPanel();
            this.pnlListe.setLayout(new GridBagLayout());
            this.pnlListe.setPreferredSize(new Dimension(180, 0));
            this.pnlListe.setMinimumSize(new Dimension(180, 0));
            this.pnlListe.add((Component)this.getJpsListe(), gridBagConstraints2);
            this.pnlListe.add((Component)this.getCbArchive(), gridBagConstraints32);
        }
        return this.pnlListe;
    }

    private JPanel getPnlDetail() {
        if (this.pnlDetail == null) {
            this.lblDesignation = new JLabel(LanguageTranslator.getString("generics.designation"));
            this.lblCode = new JLabel(LanguageTranslator.getString("generics.code"));
            this.lblGroup = new JLabel(LanguageTranslator.getString("generics.group"));
            this.lblCost = new JLabel(LanguageTranslator.getString("generics.default.cost"));
            this.lblHour = new JLabel(LanguageTranslator.getString("generics.default.length"));
            this.pnlDetail = new JPanel();
            this.pnlDetail.setLayout(new GridBagLayout());
            this.pnlDetail.add((Component)this.lblDesignation, Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 2, -1, new Insets(5, 5, 0, 5)));
            this.pnlDetail.add((Component)this.getTxtDesignation(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 1, -1, new Insets(5, 0, 0, 5)));
            this.pnlDetail.add((Component)this.lblCode, Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 2, -1, new Insets(5, 5, 0, 5)));
            this.pnlDetail.add((Component)this.getTxtCode(), Fonctions.getGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 0, 0, 5)));
            this.pnlDetail.add((Component)this.lblGroup, Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 2, -1, new Insets(5, 5, 0, 5)));
            this.pnlDetail.add((Component)this.getCbGroup(), Fonctions.getGridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 0, 0, 5)));
            JPanel pnl = new JPanel(new GridBagLayout());
            pnl.add((Component)this.lblHour, Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 1, 17, new Insets(5, 5, 0, 5)));
            pnl.add((Component)this.getTxtHour(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 1, 17, new Insets(5, 5, 0, 5)));
            pnl.add((Component)this.lblCost, Fonctions.getGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 1, 17, new Insets(5, 5, 0, 5)));
            pnl.add((Component)this.getTxtCost(), Fonctions.getGridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 1, 17, new Insets(5, 5, 0, 5)));
            this.pnlDetail.add((Component)pnl, Fonctions.getGridBagConstraints(0, 3, 1, 2, 1.0, 0.0, 1, 17, new Insets(5, 5, 0, 5)));
            this.pnlDetail.add((Component)this.getPnlExpirationDetail(), Fonctions.getGridBagConstraints(0, 4, 1, 2, 1.0, 1.0, 1, -1, new Insets(0, 5, 0, 5)));
            this.pnlDetail.add((Component)this.getPnlAlert(), Fonctions.getGridBagConstraints(0, 5, 1, 2, 0.0, 1.0, 2, -1, new Insets(0, 5, 0, 5)));
        }
        return this.pnlDetail;
    }

    private JPanel getPnlAlert() {
        if (this.pnlAlert == null) {
            this.pnlAlert = new JPanel();
            this.pnlAlert.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.alert.threshold"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.lblWarningThreshold = new JLabel(LanguageTranslator.getString("generics.alert.orange"));
            this.lblErrorThreshold = new JLabel(LanguageTranslator.getString("generics.alert.red"));
            this.pnlAlert.add((Component)this.lblWarningThreshold, Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, -1, -1, null));
            this.pnlAlert.add((Component)this.getTxtWarningThreshold(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, -1, -1, null));
            this.pnlAlert.add((Component)this.lblErrorThreshold, Fonctions.getGridBagConstraints(2, 0, 1, 1, 1.0, 1.0, -1, -1, null));
            this.pnlAlert.add((Component)this.getTxtErrorThreshold(), Fonctions.getGridBagConstraints(3, 0, 1, 1, 1.0, 1.0, -1, -1, null));
        }
        return this.pnlAlert;
    }

    private JPanel getPnlExpirationDetail() {
        if (this.pnlExpirationDetail == null) {
            this.pnlExpirationDetail = new JPanel(new GridBagLayout());
            this.pnlExpirationDetail.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.validity"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.lblPeriod = new JLabel(LanguageTranslator.getString("obligation.period"));
            this.pnlExpirationDetail.add((Component)this.getCbManualExpiration(), Fonctions.getGridBagConstraints(0, 0, 1, 2, 1.0, 1.0, -1, 17, null));
            this.pnlExpirationDetail.add((Component)this.lblPeriod, Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, -1, 17, null));
            this.pnlExpirationDetail.add((Component)this.getTxtPeriod(), Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, -1, 17, null));
        }
        return this.pnlExpirationDetail;
    }

    private JScrollPane getJpsListe() {
        if (this.jpsListe == null) {
            this.jpsListe = new JScrollPane();
            this.jpsListe.setPreferredSize(new Dimension(0, 0));
            this.jpsListe.setViewportView(this.getListEmployeeObligation());
        }
        return this.jpsListe;
    }

    private JList getListEmployeeObligation() {
        if (this.listEmployeeObligation == null) {
            this.listEmployeeObligation = new JList();
            this.listEmployeeObligation.setModel(new LMEmployeeObligationType(EmployeeObligationType.getList()));
            this.listEmployeeObligation.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && DialogEmployeeObligationType.this.getListEmployeeObligation().getSelectedIndex() != -1) {
                        LMEmployeeObligationType tmp = (LMEmployeeObligationType)DialogEmployeeObligationType.this.getListEmployeeObligation().getModel();
                        DialogEmployeeObligationType.this.load(tmp.getEmployeeObligationAt(DialogEmployeeObligationType.this.getListEmployeeObligation().getSelectedIndex()));
                    }
                }
            });
        }
        return this.listEmployeeObligation;
    }

    private JButton getBtnCreer() {
        if (this.btnCreer == null) {
            this.btnCreer = new JButton();
            this.btnCreer.setText(LanguageTranslator.getString("button.new"));
            this.btnCreer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogEmployeeObligationType.this.load(new EmployeeObligationType());
                }
            });
        }
        return this.btnCreer;
    }

    private JTextField getTxtPeriod() {
        if (this.txtPeriod == null) {
            this.txtPeriod = new JTextField();
            this.txtPeriod.setPreferredSize(new Dimension(70, 20));
        }
        return this.txtPeriod;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gcbAdd = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, -1, -1, null);
            GridBagConstraints gcbArchive = Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, -1, -1, null);
            GridBagConstraints gcbSave = Fonctions.getGridBagConstraints(2, 0, 1, 1, 1.0, 1.0, -1, -1, null);
            GridBagConstraints gcbQuit = Fonctions.getGridBagConstraints(3, 0, 1, 1, 1.0, 1.0, -1, -1, null);
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            if (ConnexionSettings.getInstance().isAjoutable("EMPLOYEE_OBLIGATION_TYPE")) {
                this.pnlBtn.add((Component)this.getBtnCreer(), gcbAdd);
            }
            if (ConnexionSettings.getInstance().isSupprimable("EMPLOYEE_OBLIGATION_TYPE")) {
                this.pnlBtn.add((Component)this.getBtnArchive(), gcbArchive);
            }
            if (ConnexionSettings.getInstance().isModifiable("EMPLOYEE_OBLIGATION_TYPE")) {
                this.pnlBtn.add((Component)this.getBtnEnregistrer(), gcbSave);
            }
            this.pnlBtn.add((Component)this.getBtnQuitter(), gcbQuit);
        }
        return this.pnlBtn;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogEmployeeObligationType.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JButton getBtnArchive() {
        if (this.btnArchive == null) {
            this.btnArchive = new JButton();
            this.btnArchive.setText(LanguageTranslator.getString("button.archive"));
            this.btnArchive.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogEmployeeObligationType.this.archive();
                }
            });
        }
        return this.btnArchive;
    }

    public void archive() {
        if (this.current != null && JOptionPane.showConfirmDialog(this, LanguageTranslator.getString("obligation.confirmArchive"), LanguageTranslator.getString("button.archive"), 0, 2) == 0) {
            this.current.setArchived(true);
            this.current.update();
            this.updateList();
        }
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogEmployeeObligationType.this.current != null) {
                        DialogEmployeeObligationType.this.save();
                        EmployeeObligationType.setList(null);
                        DialogEmployeeObligationType.this.updateList();
                    }
                }
            });
        }
        return this.btnEnregistrer;
    }

    private JTextField getTxtDesignation() {
        if (this.txtDesignation == null) {
            this.txtDesignation = new JTextField();
        }
        return this.txtDesignation;
    }

    private JTextField getTxtCode() {
        if (this.txtCode == null) {
            this.txtCode = new JTextField();
        }
        return this.txtCode;
    }

    private JCheckBox getCbArchive() {
        if (this.cbArchive == null) {
            this.cbArchive = new JCheckBox();
            this.cbArchive.setText(LanguageTranslator.getString("generics.seeArchive"));
            this.cbArchive.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean enable = DialogEmployeeObligationType.this.getCbArchive().isSelected();
                    if (enable) {
                        DialogEmployeeObligationType.this.getListEmployeeObligation().setModel(new LMEmployeeObligationType(EmployeeObligationType.loadList(true)));
                        DialogEmployeeObligationType.this.getBtnEnregistrer().setEnabled(false);
                        DialogEmployeeObligationType.this.getBtnArchive().setEnabled(false);
                        DialogEmployeeObligationType.this.getBtnCreer().setEnabled(false);
                    } else {
                        DialogEmployeeObligationType.this.getListEmployeeObligation().setModel(new LMEmployeeObligationType(EmployeeObligationType.getList()));
                        DialogEmployeeObligationType.this.getBtnEnregistrer().setEnabled(true);
                        DialogEmployeeObligationType.this.getBtnArchive().setEnabled(true);
                        DialogEmployeeObligationType.this.getBtnCreer().setEnabled(true);
                    }
                }
            });
        }
        return this.cbArchive;
    }

    private JTextField getTxtCost() {
        if (this.txtCost == null) {
            this.txtCost = new JTextField();
            this.txtCost.setPreferredSize(new Dimension(70, 20));
        }
        return this.txtCost;
    }

    private JTextHour getTxtHour() {
        if (this.txtHour == null) {
            this.txtHour = new JTextHour(false);
            this.txtHour.setPreferredSize(new Dimension(70, 20));
        }
        return this.txtHour;
    }

    private JCheckBox getCbManualExpiration() {
        if (this.cbManualExpiration == null) {
            this.cbManualExpiration = new JCheckBox(LanguageTranslator.getString("obligation.manual.expiration"));
            this.cbManualExpiration.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean select = e.getStateChange() == 1;
                    DialogEmployeeObligationType.this.getTxtPeriod().setEnabled(!select);
                    if (select) {
                        DialogEmployeeObligationType.this.getTxtPeriod().setText("");
                    } else {
                        DialogEmployeeObligationType.this.getTxtPeriod().setText(DialogEmployeeObligationType.this.current == null ? "" : String.valueOf(DialogEmployeeObligationType.this.current.getPeriodExpiration()));
                    }
                }
            });
        }
        return this.cbManualExpiration;
    }

    private JFittedComboBox getCbGroup() {
        if (this.cbGroup == null) {
            this.cbGroup = new JFittedComboBox();
            this.cbGroup.setModel(new ComboBoxModel(EmployeeObligationTypeGroup.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbGroup;
    }

    private void load(EmployeeObligationType toLoad) {
        this.current = toLoad;
        this.getTxtDesignation().setText(this.current.getName());
        this.getTxtHour().setHourMinute(this.current.getLength());
        this.getTxtCode().setText(this.current.getCode());
        this.getTxtCost().setText(String.valueOf(this.current.getDefaultCost()));
        this.getTxtWarningThreshold().setText(String.valueOf(this.current.getWarningThreshold()));
        this.getTxtErrorThreshold().setText(String.valueOf(this.current.getErrorThreshold()));
        this.getCbGroup().setSelectedItem(((ComboBoxModel)this.getCbGroup().getModel()).getLabel(this.current.getGroupId()));
        this.getCbManualExpiration().setSelected(this.current.isManualExpiration());
        this.getTxtPeriod().setText(String.valueOf(this.current.getPeriodExpiration()));
    }

    private void save() {
        if (!this.check()) {
            return;
        }
        if (this.current.compareAndUpdate(((ComboBoxModel)this.getCbGroup().getModel()).getSelectedCle(), this.getTxtDesignation().getText(), this.getTxtCode().getText(), this.getTxtHour().getMinuteHour(), this.getTxtPeriod().getText().equals("") ? 0 : Integer.parseInt(this.getTxtPeriod().getText()), this.getTxtCost().getText().equals("") ? 0.0f : Float.parseFloat(this.getTxtCost().getText()), this.getTxtWarningThreshold().getText().equals("") ? 0 : Integer.parseInt(this.getTxtWarningThreshold().getText()), this.getTxtErrorThreshold().getText().equals("") ? 0 : Integer.parseInt(this.getTxtErrorThreshold().getText()), this.current.getPermissionRequired(), this.current.isHabilitation(), this.getCbManualExpiration().isSelected(), this.current.getSubstitute(), this.current.isArchived())) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.saveSucceed"), LanguageTranslator.getString("message.done"), 1);
        }
        this.updateList();
    }

    private boolean check() {
        boolean toReturn = true;
        if (this.getTxtDesignation().getText().equals("")) {
            this.getTxtDesignation().setBackground(new Color(255, 192, 203));
            this.getTxtDesignation().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtDesignation().setBackground(Color.white);
        }
        if (this.getTxtCode().getText().equals("")) {
            this.getTxtCode().setBackground(new Color(255, 192, 203));
            this.getTxtCode().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtCode().setBackground(Color.white);
        }
        if (!this.getTxtHour().isValidHour()) {
            this.getTxtHour().setBackground(new Color(255, 192, 203));
            this.getTxtHour().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtHour().setBackground(Color.white);
        }
        if (this.getTxtCost().getText().equals("")) {
            this.getTxtCost().setBackground(new Color(255, 192, 203));
            this.getTxtCost().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtCost().setBackground(Color.white);
        }
        return toReturn;
    }

    public void updateList() {
        this.getListEmployeeObligation().setModel(new LMEmployeeObligationType(EmployeeObligationType.getList()));
        this.getListEmployeeObligation().setSelectedValue(this.current.getName(), true);
    }

    public JTextField getTxtWarningThreshold() {
        if (this.txtWarningThreshold == null) {
            this.txtWarningThreshold = new JTextField();
            this.txtWarningThreshold.setPreferredSize(new Dimension(70, 20));
        }
        return this.txtWarningThreshold;
    }

    public JTextField getTxtErrorThreshold() {
        if (this.txtErrorThreshold == null) {
            this.txtErrorThreshold = new JTextField();
            this.txtErrorThreshold.setPreferredSize(new Dimension(70, 20));
        }
        return this.txtErrorThreshold;
    }
}

