/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.conducteur;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.ExpensesType;
import fr.pgh.data.bdd.ExpensesValidation;
import fr.pgh.data.bdd.GlobalCalendarDay;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.TypeContrat;
import fr.pgh.exception.DayTypeNotFoundException;
import fr.pgh.exception.ExpensesNotFoundException;
import fr.pgh.exception.TypeContratNotFoundException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.Fmresources;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.conducteur.CalendarDayZoom;
import transpo.system.ui.views.conducteur.NewDialogCalendrier;
import transpo.ui.calendrier.Calendrier;

public class NewPnlCalendrier
extends JPanel
implements Observer {
    private static final String KEY_RIGHT = "icone_right";
    private static final String KEY_LEFT = "icone_left";
    private static final Fmresources res = new Fmresources();
    private String icon_right = res.getResourceString("icone_right");
    private String icon_left = res.getResourceString("icone_left");
    private ClassLoader cl = this.getClass().getClassLoader();
    protected Conducteur driver = null;
    protected int defaultDayLength = 0;
    private JLabel[] lblJour = new JLabel[7];
    private JLabel lblMois = null;
    private JLabel lblAnnee = null;
    private DayPicture[] jour = new DayPicture[42];
    private JButton btnPrecedent = null;
    private JButton btnSuivant = null;
    private JButton btnPrecedentAnnee = null;
    private JButton btnSuivantAnnee = null;
    public Calendrier cal = new Calendrier();
    private JPanel pnlJour = null;
    private JPanel pnlDate = null;
    NewDialogCalendrier pere = null;

    @Override
    public void update(Observable o, Object arg) {
        TimsLogger.verbose("#" + this.getClass() + ".update# a faire");
        LanguageTranslator.getInstance().addObserver(this);
    }

    public NewPnlCalendrier(NewDialogCalendrier pere) {
        this.pere = pere;
        LanguageTranslator.getInstance().addObserver(this);
        this.initialize();
    }

    private void initialize() {
        ToolTipManager.sharedInstance().registerComponent(this);
        ToolTipManager.sharedInstance().setInitialDelay(10);
        ToolTipManager.sharedInstance().setReshowDelay(10);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        this.setLayout(new BorderLayout());
        int x = 0;
        while (x < this.lblJour.length) {
            this.lblJour[x] = new JLabel(Calendrier.DAY_NAME[x].substring(0, 3));
            this.lblJour[x].setHorizontalAlignment(0);
            this.lblJour[x].setHorizontalTextPosition(0);
            ++x;
        }
        int i = 0;
        while (i < this.jour.length) {
            this.jour[i] = new DayPicture(this);
            this.jour[i].setBorder(BorderFactory.createEtchedBorder());
            ++i;
        }
        int x2 = 0;
        while (x2 < this.lblJour.length) {
            this.getPnlJour().add(this.lblJour[x2]);
            ++x2;
        }
        x2 = 0;
        while (x2 < this.jour.length / 7) {
            i = 7 * x2;
            while (i < 7 * (x2 + 1)) {
                this.getPnlJour().add(this.jour[i]);
                ++i;
            }
            ++x2;
        }
        this.getPnlDate().add(this.getBtnPrecedent());
        this.getPnlDate().add(this.getLblMois());
        this.getPnlDate().add(this.getBtnSuivant());
        this.getPnlDate().add(this.getBtnPrecedentAnnee());
        this.getPnlDate().add(this.getLblAnnee());
        this.getPnlDate().add(this.getBtnSuivantAnnee());
        this.add((Component)this.getPnlJour(), "Center");
        this.add((Component)this.getPnlDate(), "South");
    }

    public JPanel getPnlJour() {
        if (this.pnlJour == null) {
            this.pnlJour = new JPanel(new GridLayout(7, 7));
            this.pnlJour.setSize(200, 100);
        }
        return this.pnlJour;
    }

    public JPanel getPnlDate() {
        if (this.pnlDate == null) {
            this.pnlDate = new JPanel(new FlowLayout());
        }
        return this.pnlDate;
    }

    public JButton getBtnPrecedent() {
        if (this.btnPrecedent == null) {
            this.btnPrecedent = new JButton();
            this.btnPrecedent.setBorder(null);
            this.btnPrecedent.setToolTipText(LanguageTranslator.getString("calendar.previousMonth"));
            this.btnPrecedent.setBorderPainted(false);
            this.btnPrecedent.setContentAreaFilled(false);
            this.btnPrecedent.setFocusPainted(false);
            this.btnPrecedent.setHorizontalTextPosition(0);
            this.btnPrecedent.setIcon(new ImageIcon(this.cl.getResource(this.icon_left)));
            this.btnPrecedent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewPnlCalendrier.this.addMonth(-1);
                }
            });
        }
        return this.btnPrecedent;
    }

    public JButton getBtnSuivant() {
        if (this.btnSuivant == null) {
            this.btnSuivant = new JButton();
            this.btnSuivant.setBorder(null);
            this.btnSuivant.setToolTipText(LanguageTranslator.getString("calendar.nextMonth"));
            this.btnSuivant.setBorderPainted(false);
            this.btnSuivant.setContentAreaFilled(false);
            this.btnSuivant.setFocusPainted(false);
            this.btnSuivant.setHorizontalTextPosition(0);
            this.btnSuivant.setIcon(new ImageIcon(this.cl.getResource(this.icon_right)));
            this.btnSuivant.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewPnlCalendrier.this.addMonth(1);
                }
            });
        }
        return this.btnSuivant;
    }

    public JButton getBtnPrecedentAnnee() {
        if (this.btnPrecedentAnnee == null) {
            this.btnPrecedentAnnee = new JButton();
            this.btnPrecedentAnnee.setBorder(null);
            this.btnPrecedentAnnee.setToolTipText(LanguageTranslator.getString("calendar.previousYear"));
            this.btnPrecedentAnnee.setBorderPainted(false);
            this.btnPrecedentAnnee.setContentAreaFilled(false);
            this.btnPrecedentAnnee.setFocusPainted(false);
            this.btnPrecedentAnnee.setHorizontalTextPosition(0);
            this.btnPrecedentAnnee.setIcon(new ImageIcon(this.cl.getResource(this.icon_left)));
            this.btnPrecedentAnnee.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewPnlCalendrier.this.addMonth(-12);
                }
            });
        }
        return this.btnPrecedentAnnee;
    }

    public JButton getBtnSuivantAnnee() {
        if (this.btnSuivantAnnee == null) {
            this.btnSuivantAnnee = new JButton();
            this.btnSuivantAnnee.setBorder(null);
            this.btnSuivantAnnee.setToolTipText(LanguageTranslator.getString("calendar.nextYear"));
            this.btnSuivantAnnee.setBorderPainted(false);
            this.btnSuivantAnnee.setContentAreaFilled(false);
            this.btnSuivantAnnee.setFocusPainted(false);
            this.btnSuivantAnnee.setHorizontalTextPosition(0);
            this.btnSuivantAnnee.setIcon(new ImageIcon(this.cl.getResource(this.icon_right)));
            this.btnSuivantAnnee.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewPnlCalendrier.this.addMonth(12);
                }
            });
        }
        return this.btnSuivantAnnee;
    }

    public JLabel getLblMois() {
        if (this.lblMois == null) {
            this.lblMois = new JLabel();
            this.lblMois.setBackground(SystemColor.inactiveCaptionBorder);
            this.lblMois.setFont(new Font("Dialog", 1, 16));
            this.lblMois.setForeground(SystemColor.inactiveCaption);
            this.lblMois.setBorder(BorderFactory.createLineBorder(Color.black));
            this.lblMois.setHorizontalAlignment(0);
            this.lblMois.setHorizontalTextPosition(0);
            this.lblMois.setPreferredSize(new Dimension(130, 30));
            this.lblMois.setMaximumSize(new Dimension(130, 30));
        }
        return this.lblMois;
    }

    public JLabel getLblAnnee() {
        if (this.lblAnnee == null) {
            this.lblAnnee = new JLabel();
            this.lblAnnee.setBackground(SystemColor.inactiveCaptionBorder);
            this.lblAnnee.setFont(new Font("Dialog", 1, 16));
            this.lblAnnee.setForeground(SystemColor.inactiveCaption);
            this.lblAnnee.setBorder(BorderFactory.createLineBorder(Color.black));
            this.lblAnnee.setHorizontalAlignment(0);
            this.lblAnnee.setHorizontalTextPosition(0);
        }
        return this.lblAnnee;
    }

    void addMonth(int amount) {
        this.cal.addMonth(amount);
        this.updateCalendar();
    }

    public void update(Conducteur driver) {
        this.driver = driver;
        if (System.getProperty("contract_day_length_reference", "0").equals("1")) {
            try {
                TypeContrat driverContract = TypeContrat.getTypeContrat(driver.getCleTypeContrat());
                this.defaultDayLength = driverContract.getDailyValue();
            }
            catch (TypeContratNotFoundException ex) {
                TimsLogger.warn("Contrat " + driver.getCleTypeContrat() + " introuvable pour " + driver.getNom());
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewPnlCalendrier.this.updateCalendar();
            }
        });
    }

    public void updateCalendar() {
        Transport.ps.startOperation();
        int a = 1;
        this.getLblMois().setText(Calendrier.MONTH_NAME[this.cal.getMonth()]);
        this.getLblAnnee().setText(String.valueOf(this.cal.getYear()));
        int pjdm = this.cal.premierJour - 1;
        if (pjdm == 0) {
            pjdm = 7;
        }
        while (a != pjdm) {
            this.jour[a - 1].setData(null, null, null, null, null);
            ++a;
        }
        String firstDay = String.valueOf(this.getLblAnnee().getText()) + "-" + this.getMoisInt(this.getLblMois().getText()) + "-01";
        String lastDay = String.valueOf(this.getLblAnnee().getText()) + "-" + this.getMoisInt(this.getLblMois().getText()) + "-" + this.cal.nbDayInMonth;
        Date firstDate = ConversionTime.stringToDate(firstDay, "yyyy-MM-dd");
        Date lastDate = ConversionTime.stringToDate(lastDay, "yyyy-MM-dd");
        Vector<Service> services = Service.getService(0, this.driver.getCleConducteur(), firstDate, lastDate);
        Vector<LienJourConducteur> others = LienJourConducteur.loadList(0, this.driver.getCleConducteur(), firstDate, lastDate);
        Vector<DriverExpenses> driverExpenses = DriverExpenses.loadList(0, this.driver.getCleConducteur(), firstDate, lastDate);
        Vector<ExpensesValidation> expValids = null;
        if (ConnexionSettings.getInstance().isConsultable("EXPENSES_VALIDATION")) {
            expValids = ExpensesValidation.loadList(this.driver.getCleConducteur(), firstDate, lastDate);
        }
        Vector<GlobalCalendarDay> fromCalendar = null;
        if (this.driver.getCalendarId() != 0) {
            fromCalendar = GlobalCalendarDay.loadList(this.driver.getCalendarId(), firstDate, lastDate);
            TimsLogger.debug("fromCalendar : " + fromCalendar.size());
        }
        TimsLogger.debug(firstDay + ", " + lastDay + ", " + this.driver.getNom() + " nb service " + services.size() + " nb other " + others.size());
        int numJour = 1;
        while (numJour < this.cal.nbDayInMonth + 1) {
            String sJour = String.valueOf(this.getLblAnnee().getText()) + "-" + this.getMoisInt(this.getLblMois().getText()) + "-" + this.getJourInt(numJour);
            Date dJour = ConversionTime.stringToDate(sJour, "yyyy-MM-dd");
            Vector<Service> s = new Vector<Service>();
            Vector<LienJourConducteur> ljc = new Vector<LienJourConducteur>();
            Vector<DriverExpenses> des = new Vector<DriverExpenses>();
            for (Service service : services) {
                if (!service.getBeginDate().startsWith(sJour) && !service.getEndDate().startsWith(sJour) && (ConversionTime.stringToDate(service.getBeginDate(), "yyyy-MM-dd HH:mm:ss").compareTo(dJour) >= 0 || ConversionTime.stringToDate(service.getEndDate(), "yyyy-MM-dd HH:mm:ss").compareTo(dJour) <= 0)) continue;
                s.add(service);
            }
            for (LienJourConducteur other : others) {
                if (!other.getDateJour().equals(dJour)) continue;
                ljc.add(other);
            }
            if (fromCalendar != null) {
                for (GlobalCalendarDay calendar : fromCalendar) {
                    if (!calendar.getDate().equals(dJour)) continue;
                    LienJourConducteur toAdd = new LienJourConducteur();
                    toAdd.setValues(-1, this.driver.getCleConducteur(), calendar.getDayTypeId(), 0, calendar.getDate(), 0, 0, 2);
                    ljc.add(toAdd);
                }
            }
            for (DriverExpenses de : driverExpenses) {
                if (!de.getDate().equals(dJour)) continue;
                des.add(de);
            }
            ExpensesValidation valid = null;
            try {
                valid = ExpensesValidation.find(expValids, this.driver.getCleConducteur(), dJour).get(0);
                TimsLogger.debug("#NewPnklCalendrier.updateCalendar# validation de frais le " + dJour);
            }
            catch (Exception ex) {
                TimsLogger.debug("#NewPnlCalendrier.updateCalendar# pas de validation de frais le " + dJour);
            }
            this.jour[a - 1].setData(sJour, s, ljc, des, valid);
            ++a;
            ++numJour;
        }
        while (a <= this.jour.length) {
            this.jour[a - 1].setData(null, null, null, null, null);
            ++a;
        }
        this.repaint();
        Transport.ps.endOperation(PerformanceScanner.READING, "complementary day");
    }

    String getMoisInt(String jour) {
        String retour = "";
        if (jour.equals(Calendrier.MONTH_NAME[0])) {
            retour = "01";
        } else if (jour.equals(Calendrier.MONTH_NAME[1])) {
            retour = "02";
        } else if (jour.equals(Calendrier.MONTH_NAME[2])) {
            retour = "03";
        } else if (jour.equals(Calendrier.MONTH_NAME[3])) {
            retour = "04";
        } else if (jour.equals(Calendrier.MONTH_NAME[4])) {
            retour = "05";
        } else if (jour.equals(Calendrier.MONTH_NAME[5])) {
            retour = "06";
        } else if (jour.equals(Calendrier.MONTH_NAME[6])) {
            retour = "07";
        } else if (jour.equals(Calendrier.MONTH_NAME[7])) {
            retour = "08";
        } else if (jour.equals(Calendrier.MONTH_NAME[8])) {
            retour = "09";
        } else if (jour.equals(Calendrier.MONTH_NAME[9])) {
            retour = "10";
        } else if (jour.equals(Calendrier.MONTH_NAME[10])) {
            retour = "11";
        } else if (jour.equals(Calendrier.MONTH_NAME[11])) {
            retour = "12";
        }
        return retour;
    }

    String getJourInt(String jour) {
        if (Integer.parseInt(jour) < 10) {
            return "0" + jour;
        }
        return jour;
    }

    String getJourInt(int jour) {
        if (jour < 10) {
            return "0" + jour;
        }
        return String.valueOf(jour);
    }

    public class DayPicture
    extends JPanel {
        private String date = "";
        private Vector<DriverExpenses> expenses = null;
        private Vector<LienJourConducteur> otherTime = null;
        private Vector<Service> days = null;
        private NewPnlCalendrier pere = null;
        private JInternalFrame zoom = null;
        private ExpensesValidation expValid = null;

        public DayPicture(NewPnlCalendrier pere) {
            this.pere = pere;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    DayPicture.this.doAction(e);
                }
            });
        }

        private void doAction(MouseEvent e) {
            if (this.expensesValidationZone(e.getX(), e.getY()) && this.canDoExpensesValidationAction()) {
                if (this.expValid == null || this.expValid.getUserUnvalid() != -1) {
                    TimsLogger.debug("on cloture le " + this.date + " " + NewPnlCalendrier.this.driver.getCleConducteur());
                    this.expValid = new ExpensesValidation(0, NewPnlCalendrier.this.driver.getCleConducteur(), ConversionTime.stringToDate(this.date, "yyyy-MM-dd"), new Date(), ConnexionSettings.getInstance().getUserCle(), new Date(), -1);
                    this.expValid.update();
                } else {
                    TimsLogger.debug("on decloture le " + this.date + " " + NewPnlCalendrier.this.driver.getCleConducteur());
                    this.expValid.unlock();
                }
                this.paintAll(this.getGraphics());
            } else {
                this.setJour();
            }
        }

        private boolean expensesValidationZone(int x, int y) {
            return this.getWidth() / 2 + 8 < x && x < this.getWidth() / 2 + 19 && 1 < y && y < 12;
        }

        private boolean canDoExpensesValidationAction() {
            if (this.expValid != null && this.expValid.getUserUnvalid() == -1) {
                return ConnexionSettings.getInstance().isSupprimable("EXPENSES_VALIDATION");
            }
            return ConnexionSettings.getInstance().isAjoutable("EXPENSES_VALIDATION");
        }

        public void setData(String date, Vector<Service> days, Vector<LienJourConducteur> otherTime, Vector<DriverExpenses> expenses, ExpensesValidation expValid) {
            this.date = date;
            this.days = days;
            this.otherTime = otherTime;
            this.expenses = expenses;
            this.expValid = expValid;
            this.paintAll(this.getGraphics());
        }

        public void setJour() {
            if (this.pere.pere.isQuickDay()) {
                TimsLogger.debug("quick day on " + this.date);
            } else if (this.pere.pere.isQuickExpense()) {
                TimsLogger.debug("quick expense on " + this.date);
            } else {
                TimsLogger.debug("Open " + this.date + " for " + this.pere.driver.getNom());
                CalendarDayZoom day = new CalendarDayZoom(this, this.date, this.otherTime, this.days, this.expenses, NewPnlCalendrier.this.driver, NewPnlCalendrier.this.defaultDayLength, this.expValid);
                day.setVisible(true);
            }
        }

        public void updateValues(CalendarDayZoom source) {
            this.otherTime = source.getOtherTime();
            this.expenses = source.getDriverExpenses();
            this.paintAll(this.getGraphics());
        }

        @Override
        public void paint(Graphics g) {
            Color original = g.getColor();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.setToolTipText("<html>" + LanguageTranslator.getString("activity.calendar.noData") + "</html>");
            String toolTip = "";
            if (this.date != null) {
                int duree;
                int horizontalPosition;
                int height;
                int h;
                int heightString = 14;
                float horizontalStep = (float)(this.getHeight() - heightString) / 3.0f;
                float verticalStep = (float)this.getWidth() / 24.0f;
                if (ConnexionSettings.getInstance().isConsultable("EXPENSES_VALIDATION")) {
                    String image = null;
                    if (ConnexionSettings.getInstance().isAjoutable("EXPENSES_VALIDATION") && (this.expValid == null || this.expValid.getUserUnvalid() != -1)) {
                        image = "images/opadlock.png";
                    } else {
                        g.setColor(new Color(160, 160, 160));
                        if (ConnexionSettings.getInstance().isSupprimable("EXPENSES_VALIDATION")) {
                            image = "images/padlock.png";
                        }
                        h = (int)(2.0f * horizontalStep);
                        g.fillRect(0, h + heightString, this.getWidth(), (int)horizontalStep);
                    }
                    if (image != null) {
                        BufferedImage img = null;
                        try {
                            img = ImageIO.read(this.getClass().getClassLoader().getResource(image));
                            g.drawImage(img, this.getWidth() / 2 + 8, 1, 11, 11, null);
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                int i = 0;
                while (i < 24) {
                    if (i == 0) {
                        g.setColor(Color.BLACK);
                    }
                    int v = (int)((float)i * verticalStep);
                    g.drawLine(v, heightString, v, this.getHeight());
                    if (i == 0) {
                        g.setColor(Color.LIGHT_GRAY);
                    }
                    ++i;
                }
                i = 0;
                while (i < 3) {
                    h = (int)((float)i * horizontalStep);
                    g.drawLine(0, h + heightString - 1, this.getWidth(), h + heightString - 1);
                    ++i;
                }
                g.setColor(Color.BLACK);
                g.drawString(ConversionTime.dateStringToFormat(this.date, "yyyy-MM-dd", "dd"), this.getWidth() / 2 - 8, heightString - 3);
                if (this.days != null && this.days.size() != 0) {
                    Color c = g.getColor();
                    g.setColor(Color.RED);
                    for (Service day : this.days) {
                        height = (int)horizontalStep - 4;
                        horizontalPosition = heightString + 2;
                        int debut = day.getBeginTime() * this.getSize().width / 1440;
                        if (!day.getBeginDate().startsWith(this.date)) {
                            debut = 0;
                        }
                        int fin = day.getEndTime() * this.getSize().width / 1440;
                        if (!day.getEndDate().startsWith(this.date)) {
                            fin = this.getSize().width;
                        }
                        duree = fin - debut;
                        g.fillRect(debut, horizontalPosition, duree, height);
                        toolTip = String.valueOf(toolTip) + "<br>" + ConversionTime.heureIntToString(day.getService(), "h") + " de service de " + ConversionTime.heureIntToString(day.getBeginTime(), "h") + " \u00e0 " + ConversionTime.heureIntToString(day.getEndTime(), "h");
                    }
                    g.setColor(c);
                }
                if (this.otherTime != null && this.otherTime.size() != 0) {
                    Color c = g.getColor();
                    for (LienJourConducteur ljc : this.otherTime) {
                        height = (int)horizontalStep - 4;
                        horizontalPosition = heightString + (int)horizontalStep + 2;
                        try {
                            JourType tmp = JourType.getDayType(ljc.getCleJourType());
                            g.setColor(new Color(tmp.getColor()));
                            int debut = ljc.getHeureDebut() * this.getSize().width / 1440;
                            duree = ljc.getPrintLength(NewPnlCalendrier.this.defaultDayLength) * this.getSize().width / 1440;
                            g.fillRect(debut, horizontalPosition, duree, height);
                            toolTip = String.valueOf(toolTip) + "<br>" + tmp.getDesignation() + " (" + ConversionTime.heureIntToString(ljc.getDuree(NewPnlCalendrier.this.defaultDayLength), "h") + ")";
                        }
                        catch (DayTypeNotFoundException ex) {
                            TimsLogger.warn("Unable to find a day for idDayType " + ljc.getCleJourType());
                        }
                    }
                    g.setColor(c);
                }
                if (this.expenses != null) {
                    Color c = g.getColor();
                    g.setColor(Color.BLUE);
                    int unhoured = 0;
                    int x = 0;
                    while (x < this.expenses.size()) {
                        DriverExpenses de = this.expenses.get(x);
                        int height2 = (int)horizontalStep - 4;
                        if (height2 <= 0) {
                            height2 = 1;
                        }
                        int horizontalPosition2 = heightString + (int)horizontalStep * 2 + 2;
                        try {
                            ExpensesType tmp = ExpensesType.getExpenses(de.getExpensesId());
                            if (tmp.getHour() == 0) {
                                g.fillRect(15 * unhoured, horizontalPosition2, 10, height2);
                                ++unhoured;
                            } else {
                                int hour = tmp.getHour() * this.getSize().width / 1440;
                                g.fillRect(hour, horizontalPosition2, 5, height2);
                            }
                            toolTip = String.valueOf(toolTip) + "<br>" + tmp.getDesignation() + " : " + de.getAmount();
                        }
                        catch (ExpensesNotFoundException ex) {
                            TimsLogger.warn("Unable to find a day for idDayType " + de.getExpensesId());
                        }
                        ++x;
                    }
                    g.setColor(c);
                }
            }
            if (toolTip.equals("")) {
                this.setToolTipText("<html>" + LanguageTranslator.getString("activity.calendar.noData") + "</html>");
            } else {
                this.setToolTipText("<html>" + toolTip.substring(4) + "</html>");
            }
            g.setColor(original);
        }
    }
}

