/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.conducteur;

import fr.pgh.component.ButtonFactory;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.ExpensesType;
import fr.pgh.data.bdd.ExpensesValidation;
import fr.pgh.exception.ExpensesNotFoundException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class PnlFraisConducteur
extends JPanel
implements Observer {
    private static final long serialVersionUID = 1L;
    private String dateJour = null;
    private Conducteur driver = null;
    private Vector<ExpensesType> listeTypeFrais = null;
    private JButton btnAdd = null;
    private JButton btnDel = null;
    private JScrollPane jspTable = null;
    private JTable tableFrais = null;
    private TableModel modeleTableFrais = null;
    private JComboBox cbTypeFrais = null;
    private Vector<DriverExpenses> rowToDel = null;
    private Vector<DriverExpenses> rowToUpdate = null;
    private boolean validated = false;
    JLabel lblValidated = new JLabel(LanguageTranslator.getString("expenses.validated"));

    @Override
    public void update(Observable o, Object arg) {
        TimsLogger.verbose("#" + this.getClass() + ".update# a faire");
        LanguageTranslator.getInstance().addObserver(this);
    }

    public PnlFraisConducteur() {
        LanguageTranslator.getInstance().addObserver(this);
        this.initialize();
    }

    public PnlFraisConducteur(String dateJour, Conducteur driver) {
        this.dateJour = dateJour;
        this.driver = driver;
        if (ConnexionSettings.getInstance().isConsultable("EXPENSES_VALIDATION")) {
            this.validated = ExpensesValidation.checkLocked(ConversionTime.stringToDate(dateJour, "dd/MM/yyyy"), driver.getCleConducteur());
        }
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.gridwidth = 2;
        gridBagConstraints3.gridx = 0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = new Insets(2, 0, 5, 0);
        gridBagConstraints2.gridy = 1;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(2, 0, 5, 0);
        gridBagConstraints1.gridy = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        this.setSize(400, 150);
        this.setLayout(new GridBagLayout());
        if (ConnexionSettings.getInstance().isAjoutable("FRAIS") && !this.validated) {
            this.add((Component)this.getBtnAdd(), gridBagConstraints2);
        }
        if (ConnexionSettings.getInstance().isSupprimable("FRAIS") && !this.validated) {
            this.add((Component)this.getBtnDel(), gridBagConstraints1);
        }
        this.add((Component)this.lblValidated, gridBagConstraints);
        if (!this.validated) {
            this.lblValidated.setVisible(false);
        } else {
            this.lblValidated.setVisible(true);
        }
        this.add((Component)this.getJspTable(), gridBagConstraints3);
    }

    private JButton getBtnAdd() {
        if (this.btnAdd == null) {
            this.btnAdd = ButtonFactory.getBtnAdd(true);
            this.btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlFraisConducteur.this.newLine();
                }
            });
        }
        return this.btnAdd;
    }

    public void newLine() {
        DriverExpenses toAdd = new DriverExpenses(0, this.driver.getCleConducteur(), ConversionTime.stringToDate(this.dateJour, "dd/MM/yyyy"), 0, "1".equals(System.getProperty("price-fixed_default")), 0.0f, "1".equals(System.getProperty("price-fixed_default")) ? 0.0f : this.driver.getTaux(), 0.0f, false, 0);
        this.getRowToUpdate().add(toAdd);
        this.getModeleTableFrais().addRow(toAdd);
    }

    private JButton getBtnDel() {
        if (this.btnDel == null) {
            this.btnDel = ButtonFactory.getBtnDelete(true);
            this.btnDel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlFraisConducteur.this.commit();
                    int row = PnlFraisConducteur.this.getTableFrais().getSelectedRow();
                    DriverExpenses toDel = PnlFraisConducteur.this.getModeleTableFrais().removeRow(row);
                    toDel.affiche();
                    if (toDel.getId() != 0) {
                        PnlFraisConducteur.this.getRowToDel().add(toDel);
                    } else {
                        PnlFraisConducteur.this.getRowToUpdate().remove(toDel);
                    }
                }
            });
        }
        return this.btnDel;
    }

    private JScrollPane getJspTable() {
        if (this.jspTable == null) {
            this.jspTable = new JScrollPane();
            this.jspTable.setViewportView(this.getTableFrais());
        }
        return this.jspTable;
    }

    private JTable getTableFrais() {
        if (this.tableFrais == null) {
            this.tableFrais = new JTable();
            this.tableFrais.setModel(this.getModeleTableFrais());
            this.tableFrais.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "none");
            this.cbEditor(this.tableFrais.getColumnModel().getColumn(0));
        }
        return this.tableFrais;
    }

    private void cbEditor(TableColumn col) {
        DefaultCellEditor dce = new DefaultCellEditor(this.getCbTypeFrais());
        dce.setClickCountToStart(2);
        col.setCellEditor(dce);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText(LanguageTranslator.getString("generics.doubleClick"));
        col.setCellRenderer(renderer);
    }

    private TableModel getModeleTableFrais() {
        if (this.modeleTableFrais == null) {
            Vector<DriverExpenses> tmp = null;
            tmp = this.driver != null && this.driver.getCleConducteur() != 0 && this.dateJour != null ? DriverExpenses.loadList(0, this.driver.getCleConducteur(), ConversionTime.stringToDate(this.dateJour, "dd/MM/yyyy"), null) : new Vector<DriverExpenses>();
            this.modeleTableFrais = new TableModel(tmp);
        }
        return this.modeleTableFrais;
    }

    private void setModeleTableFrais(TableModel modelTableFrais) {
        this.modeleTableFrais = modelTableFrais;
    }

    public void commit() {
        TimsLogger.verbose("#PnlFraisConducteur# commit");
        int row = this.getTableFrais().getSelectedRow();
        int column = this.getTableFrais().getSelectedColumn();
        if (!this.getTableFrais().isEditing()) {
            TimsLogger.verbose("no editing a cell");
        } else {
            TimsLogger.verbose("STOP EDITING " + row + " : " + column);
            this.getTableFrais().getCellEditor(row, column).stopCellEditing();
            TimsLogger.verbose("=> " + this.getTableFrais().getValueAt(row, column));
        }
    }

    private JComboBox getCbTypeFrais() {
        if (this.cbTypeFrais == null) {
            this.cbTypeFrais = new JComboBox(){
                private boolean layingOut;

                @Override
                public void doLayout() {
                    this.layingOut = true;
                    super.doLayout();
                    this.layingOut = false;
                }

                @Override
                public Dimension getSize() {
                    Dimension dim = super.getSize();
                    if (!this.layingOut) {
                        dim.width = Math.max(dim.width, this.getPreferredSize().width);
                    }
                    return dim;
                }
            };
            this.cbTypeFrais.setModel(new ComboBoxModel((Vector<?>)ExpensesType.getList()));
        }
        return this.cbTypeFrais;
    }

    private Vector<DriverExpenses> getRowToDel() {
        if (this.rowToDel == null) {
            this.rowToDel = new Vector();
        }
        return this.rowToDel;
    }

    private Vector<DriverExpenses> getRowToUpdate() {
        if (this.rowToUpdate == null) {
            this.rowToUpdate = new Vector();
        }
        return this.rowToUpdate;
    }

    public boolean sauvegarde() {
        this.commit();
        Iterator<DriverExpenses> iter = this.getRowToDel().iterator();
        while (iter.hasNext()) {
            if (iter.next().delete()) continue;
            return false;
        }
        iter = this.getRowToUpdate().iterator();
        while (iter.hasNext()) {
            if (iter.next().update()) continue;
            return false;
        }
        return true;
    }

    public void initialise(Vector<DriverExpenses> tmp, Conducteur driver, String dateJour) {
        this.driver = driver;
        this.dateJour = dateJour;
        if (ConnexionSettings.getInstance().isConsultable("EXPENSES_VALIDATION")) {
            this.validated = ExpensesValidation.checkLocked(ConversionTime.stringToDate(dateJour, "dd/MM/yyyy"), driver.getCleConducteur());
            if (this.validated) {
                this.getBtnAdd().setEnabled(false);
                this.getBtnDel().setEnabled(false);
                this.lblValidated.setVisible(true);
            } else {
                this.getBtnAdd().setEnabled(true);
                this.getBtnDel().setEnabled(true);
                this.lblValidated.setVisible(false);
            }
        }
        this.setModeleTableFrais(new TableModel(tmp));
        this.getTableFrais().setModel(this.getModeleTableFrais());
        this.cbEditor(this.tableFrais.getColumnModel().getColumn(0));
    }

    public Vector<DriverExpenses> getListeFraisConducteur() {
        return this.getModeleTableFrais().getData();
    }

    class TableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private String[] columnNames = new String[]{LanguageTranslator.getString("generics.expenses"), LanguageTranslator.getString("generics.fixed-price"), LanguageTranslator.getString("generics.base"), LanguageTranslator.getString("generics.rate"), LanguageTranslator.getString("expenses.frenchRate"), LanguageTranslator.getString("expenses.foreignRate")};
        private Vector<DriverExpenses> data = null;

        public TableModel(Vector<DriverExpenses> data) {
            this.data = data;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Vector<DriverExpenses> getData() {
            return this.data;
        }

        @Override
        public Object getValueAt(int row, int col) {
            DriverExpenses tmp = this.data.get(row);
            switch (col) {
                case 0: {
                    try {
                        return ExpensesType.getExpenses(tmp.getExpensesId()).getDesignation();
                    }
                    catch (ExpensesNotFoundException ex) {
                        return "";
                    }
                }
                case 1: {
                    return tmp.isForfait();
                }
                case 2: {
                    return Float.valueOf(tmp.getBase());
                }
                case 3: {
                    return Float.valueOf(tmp.getRate());
                }
                case 4: {
                    return Float.valueOf(tmp.getAmount());
                }
                case 5: {
                    return tmp.isOutside();
                }
            }
            return "?";
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (PnlFraisConducteur.this.validated) {
                return false;
            }
            if (col == 2 || col == 3) {
                return !this.data.get(row).isForfait();
            }
            if (col == 4) {
                return this.data.get(row).isForfait();
            }
            return true;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            TimsLogger.debug("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
            DriverExpenses tmp = this.data.get(row);
            ExpensesType tmpF = new ExpensesType();
            boolean change = false;
            switch (col) {
                case 0: {
                    tmpF.loadByName((String)value);
                    if (tmp.getExpensesId() == tmpF.getCle()) break;
                    change = true;
                    tmp.setExpensesId(tmpF.getCle());
                    if (tmp.isForfait()) {
                        float amount = tmpF.getMontant(tmp.getDate(), tmp.isOutside() ? 1 : 0);
                        tmp.setAmount(amount);
                    } else {
                        tmp.setAmount(tmp.getBase() * tmp.getRate());
                    }
                    tmp.setAutomatic(0);
                    this.setValueAt(Float.valueOf(tmp.getAmount()), row, 4);
                    break;
                }
                case 1: {
                    if (tmp.isForfait() == new Boolean(value.toString()).booleanValue()) break;
                    change = true;
                    tmp.setForfait(new Boolean(value.toString()));
                    if (tmp.isForfait()) {
                        tmpF.loadById(tmp.getExpensesId());
                        tmp.setBase(0.0f);
                        tmp.setRate(0.0f);
                        float amount = tmpF.getMontant(tmp.getDate(), tmp.isOutside() ? 1 : 0);
                        this.setValueAt(Float.valueOf(amount), row, 4);
                        break;
                    }
                    this.setValueAt(Float.valueOf(tmp.getBase() * tmp.getRate()), row, 4);
                    break;
                }
                case 2: {
                    if (tmp.getBase() == Float.parseFloat(value.toString())) break;
                    change = true;
                    tmp.setBase(Float.parseFloat(value.toString()));
                    tmp.setAmount(tmp.getBase() * tmp.getRate());
                    this.setValueAt(Float.valueOf(tmp.getAmount()), row, 4);
                    break;
                }
                case 3: {
                    if (tmp.getRate() == Float.parseFloat(value.toString())) break;
                    change = true;
                    tmp.setRate(Float.parseFloat(value.toString()));
                    if (tmp.isForfait()) break;
                    tmp.setAmount(tmp.getBase() * tmp.getRate());
                    this.setValueAt(Float.valueOf(tmp.getAmount()), row, 4);
                    break;
                }
                case 4: {
                    if (tmp.getAmount() == Float.parseFloat(value.toString())) break;
                    change = true;
                    tmp.setAmount(Float.parseFloat(value.toString()));
                    break;
                }
                case 5: {
                    if (tmp.isOutside() == new Boolean(value.toString()).booleanValue()) break;
                    change = true;
                    tmp.setOutside(new Boolean(value.toString()));
                    tmpF = new ExpensesType();
                    tmpF.loadById(tmp.getExpensesId());
                    if (!tmp.isForfait()) break;
                    float amount = tmpF.getMontant(tmp.getDate(), tmp.isOutside() ? 1 : 0);
                    this.setValueAt(Float.valueOf(amount), row, 4);
                }
            }
            tmp.affiche();
            this.fireTableRowsUpdated(row, row);
            if (tmp.getId() != 0 && change) {
                tmp.setAutomatic(0);
                PnlFraisConducteur.this.getRowToUpdate().remove(tmp);
                PnlFraisConducteur.this.getRowToUpdate().addElement(tmp);
            }
        }

        public void addRow(DriverExpenses tmp) {
            this.insertRow(this.getRowCount(), tmp);
        }

        private void insertRow(int row, DriverExpenses tmp) {
            this.data.insertElementAt(tmp, row);
            this.fireTableRowsInserted(row, row);
        }

        public DriverExpenses removeRow(int row) {
            DriverExpenses tmp = this.data.get(row);
            this.data.removeElementAt(row);
            this.fireTableRowsDeleted(row, row);
            return tmp;
        }
    }
}

