/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.conducteur;

import fr.pgh.connexion.TimsSession;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Offence;
import fr.pgh.data.bdd.OffencePart;
import fr.pgh.data.bdd.OffenceType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.ViewPanel;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.TMDriverOffence;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.user.UserPreferences;
import transpo.system.util.Fonctions;

public class PnlInfractionCond
extends ViewPanel
implements Observer {
    private static final long serialVersionUID = 1L;
    private JScrollPane jspInfraction = null;
    private JTable tableInfraction = null;
    private JLabel lblFrom = null;
    private JLabel lblTo = null;
    private JTextField txtBegin = null;
    private JTextField txtEnd = null;
    private JLabel lblDesign = null;
    private JComboBox cbDesign = null;
    TMDriverOffence modeleTable = null;
    TMOffenceSynthesis tmSynthesis = null;
    ArrayList<Offence> donnees = null;
    ArrayList<Offence> filtered = null;
    private Conducteur detailConducteur;
    private boolean reloadNeeded = false;
    private JCheckBox cbBrute = null;
    private JCheckBox cbHideInfo = null;
    private JPanel pnlFilter = null;
    private JPanel pnlStatistics = null;
    private JScrollPane jspStat = null;
    private JTable tblStat = null;

    @Override
    public void update(Observable o, Object arg) {
        TimsLogger.verbose("#" + this.getClass() + ".update# a faire");
        LanguageTranslator.getInstance().addObserver(this);
    }

    public PnlInfractionCond() {
        LanguageTranslator.getInstance().addObserver(this);
        this.initialize();
        TimsSession.getInstance().addVisit(this.getClass().getName());
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getJspInfraction(), Fonctions.getGridBagConstraints(0, 2, 1, 2, 1.0, 1.0, 1, -1, new Insets(10, 10, 10, 10)));
        this.add((Component)this.getPnlFilter(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 10, 5, 5)));
        this.add((Component)this.getPnlStatistics(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 2, -1, new Insets(5, 5, 5, 10)));
    }

    @Override
    public void close() {
    }

    @Override
    public String getMnemo() {
        return "I";
    }

    @Override
    public String getViewName() {
        return LanguageTranslator.getString("offence.title");
    }

    @Override
    public void refresh() {
    }

    private JScrollPane getJspInfraction() {
        if (this.jspInfraction == null) {
            this.jspInfraction = new JScrollPane();
            this.jspInfraction.setViewportView(this.getTableInfraction());
        }
        return this.jspInfraction;
    }

    private JTable getTableInfraction() {
        if (this.tableInfraction == null) {
            this.tableInfraction = new JTable();
            this.tableInfraction.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    String selectedDate = PnlInfractionCond.this.modeleTable.getValueAt(PnlInfractionCond.this.getTableInfraction().getSelectedRow(), 0).toString();
                    MainFrameTransport.getInstance().setActiviteConducteur(selectedDate, "dd/MM/yyyy");
                }
            });
        }
        return this.tableInfraction;
    }

    private JTextField getTxtBegin() {
        if (this.txtBegin == null) {
            this.txtBegin = new JTextField();
            this.txtBegin.setMinimumSize(new Dimension(70, 20));
            this.txtBegin.setPreferredSize(new Dimension(70, 20));
            this.txtBegin.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!Fonctions.afficheCalendrier(PnlInfractionCond.this.getTxtBegin())) {
                        PnlInfractionCond.this.getTxtBegin().setText("");
                    }
                    PnlInfractionCond.this.reloadData();
                }
            });
        }
        return this.txtBegin;
    }

    private JTextField getTxtEnd() {
        if (this.txtEnd == null) {
            this.txtEnd = new JTextField();
            this.txtEnd.setMinimumSize(new Dimension(70, 20));
            this.txtEnd.setPreferredSize(new Dimension(70, 20));
            this.txtEnd.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!Fonctions.afficheCalendrier(PnlInfractionCond.this.getTxtEnd())) {
                        PnlInfractionCond.this.getTxtEnd().setText("");
                    }
                    PnlInfractionCond.this.reloadData();
                }
            });
        }
        return this.txtEnd;
    }

    private JComboBox getCbDesign() {
        if (this.cbDesign == null) {
            this.cbDesign = new JComboBox();
            this.cbDesign.setEditable(false);
            this.cbDesign.setModel(new ComboBoxModel(OffenceType.getList(), true, LanguageTranslator.getString("generics.all")));
            this.cbDesign.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PnlInfractionCond.this.reloadData();
                }
            });
        }
        return this.cbDesign;
    }

    @Override
    public void loadData() {
        if (!this.load) {
            this.reloadData();
            this.load = true;
        }
    }

    public void setConducteur(Conducteur current) {
        this.detailConducteur = current;
        this.load = false;
        this.reloadNeeded = true;
    }

    private void reloadData() {
        if (this.donnees == null || this.reloadNeeded) {
            this.donnees = new ArrayList<Offence>(Offence.loadList(0, this.detailConducteur.getCleConducteur(), null, null, this.getCbBrute().isSelected(), false));
            Collections.reverse(this.donnees);
        }
        TimsLogger.debug("#PnlInfractionCond.reloadData# nb infractions = " + this.donnees.size() + " (raw = " + this.getCbBrute().isSelected() + ")");
        String begin = "";
        String end = "";
        if (!this.getTxtBegin().getText().equals("")) {
            begin = ConversionTime.dateFromFranceToBDD(this.getTxtBegin().getText(), false);
        }
        if (!this.getTxtEnd().getText().equals("")) {
            end = ConversionTime.dateFromFranceToBDD(this.getTxtEnd().getText(), false);
        }
        int designation = ((ComboBoxModel)this.getCbDesign().getModel()).getSelectedCle();
        this.filtered = this.filtrerDonnees(begin, end, designation, this.getCbBrute().isSelected(), this.getCbHideInfo().isSelected());
        this.modeleTable = new TMDriverOffence(this.filtered);
        this.getTableInfraction().setModel(this.modeleTable);
        this.getTblStat().setModel(new TMOffenceSynthesis(this.filtered));
        Fonctions.centrerTable(this.getTableInfraction());
        Fonctions.centrerTable(this.getTblStat());
        this.reloadNeeded = false;
    }

    private ArrayList<Offence> filtrerDonnees(String filtreDateDebut, String filtreDateFin, int filteredOffenceType, boolean raw, boolean hideInformation) {
        boolean debut = true;
        boolean fin = true;
        boolean offence = true;
        ArrayList<Offence> retour = new ArrayList<Offence>();
        for (Offence inf : this.donnees) {
            if (inf.getType() == 0 && hideInformation) continue;
            offence = filteredOffenceType == 0 || filteredOffenceType == OffencePart.getOffencePart(inf.getOffencePartId()).getOffenceTypeId();
            debut = filtreDateDebut.equals("") || filtreDateDebut.compareTo(ConversionTime.dateToString(inf.getDate(), "yyyy-MM-dd")) < 0;
            boolean bl = fin = filtreDateFin.equals("") || filtreDateFin.compareTo(ConversionTime.dateToString(inf.getDate(), "yyyy-MM-dd")) > 0;
            if (!offence || !debut || !fin) continue;
            retour.add(inf);
        }
        TimsLogger.debug("#PnlInfractionCond.filtrerDonnees# retour = " + retour.size());
        return retour;
    }

    private JCheckBox getCbBrute() {
        if (this.cbBrute == null) {
            this.cbBrute = new JCheckBox();
            this.cbBrute.setText(LanguageTranslator.getString("generics.original"));
            String modified = UserPreferences.getPreferences("preference.offence.type");
            if (modified != null && Integer.valueOf(modified) == 1) {
                this.cbBrute.setSelected(true);
            }
            this.cbBrute.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    int pref = e.getStateChange() == 1 ? 1 : 0;
                    UserPreferences.setPreferences("preference.offence.type", String.valueOf(pref));
                    PnlInfractionCond.this.reloadNeeded = true;
                    PnlInfractionCond.this.reloadData();
                }
            });
        }
        return this.cbBrute;
    }

    private JCheckBox getCbHideInfo() {
        if (this.cbHideInfo == null) {
            this.cbHideInfo = new JCheckBox();
            this.cbHideInfo.setText(LanguageTranslator.getString("offence.hideInfo"));
            this.cbHideInfo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PnlInfractionCond.this.reloadData();
                }
            });
        }
        return this.cbHideInfo;
    }

    private JPanel getPnlFilter() {
        if (this.pnlFilter == null) {
            this.lblDesign = new JLabel();
            this.lblDesign.setText(LanguageTranslator.getString("generics.designation"));
            this.lblFrom = new JLabel();
            this.lblFrom.setText(LanguageTranslator.getString("generics.from"));
            this.lblTo = new JLabel();
            this.lblTo.setText(LanguageTranslator.getString("generics.to"));
            this.pnlFilter = new JPanel();
            this.pnlFilter.setLayout(new GridBagLayout());
            this.pnlFilter.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.filter"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlFilter.add((Component)this.lblFrom, Fonctions.getGridBagConstraints(0, 0));
            this.pnlFilter.add((Component)this.getTxtBegin(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 3, -1, null));
            this.pnlFilter.add((Component)this.lblTo, Fonctions.getGridBagConstraints(2, 0));
            this.pnlFilter.add((Component)this.getTxtEnd(), Fonctions.getGridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 3, -1, null));
            this.pnlFilter.add((Component)this.lblDesign, Fonctions.getGridBagConstraints(0, 2, 1, 4, 1.0, 0.0, 3, -1, null));
            this.pnlFilter.add((Component)this.getCbDesign(), Fonctions.getGridBagConstraints(0, 3, 1, 4, 1.0, 0.0, 1, -1, new Insets(5, 0, 5, 0)));
            this.pnlFilter.add((Component)this.getCbBrute(), Fonctions.getGridBagConstraints(0, 4, 1, 2, 1.0, 0.0, 1, -1, new Insets(5, 0, 5, 0)));
            this.pnlFilter.add((Component)this.getCbHideInfo(), Fonctions.getGridBagConstraints(2, 4, 1, 2, 1.0, 0.0, 1, -1, new Insets(5, 0, 5, 0)));
        }
        return this.pnlFilter;
    }

    private JPanel getPnlStatistics() {
        if (this.pnlStatistics == null) {
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 1;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.weighty = 1.0;
            gridBagConstraints8.gridx = 0;
            this.pnlStatistics = new JPanel();
            this.pnlStatistics.setMinimumSize(new Dimension(0, 150));
            this.pnlStatistics.setPreferredSize(new Dimension(0, 150));
            this.pnlStatistics.setMaximumSize(new Dimension(0, 150));
            this.pnlStatistics.setLayout(new GridBagLayout());
            this.pnlStatistics.setBorder(BorderFactory.createTitledBorder(null, "synth\u00e8se", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlStatistics.add((Component)this.getJspStat(), gridBagConstraints8);
        }
        return this.pnlStatistics;
    }

    private JScrollPane getJspStat() {
        if (this.jspStat == null) {
            this.jspStat = new JScrollPane();
            this.jspStat.setViewportView(this.getTblStat());
        }
        return this.jspStat;
    }

    private JTable getTblStat() {
        if (this.tblStat == null) {
            this.tblStat = new JTable();
        }
        return this.tblStat;
    }

    class TMOffenceSynthesis
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        int cost = 0;
        int minor = 0;
        int serious = 0;
        int verySerious = 0;
        String[] titres = new String[]{LanguageTranslator.getString("offence.minor"), LanguageTranslator.getString("offence.serious"), LanguageTranslator.getString("offence.verySerious"), LanguageTranslator.getString("generics.total"), LanguageTranslator.getString("offence.maxCost")};

        public TMOffenceSynthesis(ArrayList<Offence> offences) {
            this.sum(offences);
        }

        public void sum(ArrayList<Offence> offences) {
            this.cost = 0;
            this.minor = 0;
            this.serious = 0;
            this.verySerious = 0;
            for (Offence off : offences) {
                this.cost += off.getCost();
                switch (off.getType()) {
                    case 1: {
                        ++this.minor;
                        break;
                    }
                    case 2: {
                        ++this.serious;
                        break;
                    }
                    case 3: {
                        ++this.verySerious;
                    }
                }
            }
        }

        @Override
        public int getColumnCount() {
            return this.titres.length;
        }

        @Override
        public Object getValueAt(int parm1, int parm2) {
            switch (parm2) {
                case 0: {
                    return this.minor;
                }
                case 1: {
                    return this.serious;
                }
                case 2: {
                    return this.verySerious;
                }
                case 3: {
                    return this.minor + this.serious + this.verySerious;
                }
                case 4: {
                    return String.valueOf(this.cost) + " \u20ac";
                }
            }
            return LanguageTranslator.getString("generics.unknown");
        }

        @Override
        public int getRowCount() {
            return 1;
        }

        @Override
        public String getColumnName(int col) {
            return this.titres[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

