/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.explorer;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.HeadlessException;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import transpo.system.ui.views.explorer.ExplorerExpansionListener;
import transpo.system.ui.views.explorer.ExplorerMouseListener;
import transpo.system.ui.views.explorer.ExplorerMutableTreeNode;

public class Explorer
extends JFrame {
    protected DefaultMutableTreeNode racine;
    protected JTree tree = new JTree();
    protected JScrollPane scrollpane;
    private int MAX_LEVEL = 1;

    public static void main(String[] args) {
        new Explorer();
    }

    public Explorer() throws HeadlessException {
        this.racine = new DefaultMutableTreeNode("Poste de travail");
        File[] drive = File.listRoots();
        int i = 0;
        while (i < drive.length) {
            ExplorerMutableTreeNode node = new ExplorerMutableTreeNode((Object)drive[i], drive[i]);
            this.addFolder(node);
            this.racine.add(node);
            ++i;
        }
        this.tree.addTreeExpansionListener(new ExplorerExpansionListener());
        this.tree.addMouseListener(new ExplorerMouseListener());
        DefaultTreeModel model = new DefaultTreeModel(this.racine);
        this.tree.setModel(model);
        this.scrollpane = new JScrollPane();
        this.getContentPane().add((Component)this.scrollpane, "Center");
        this.scrollpane.getViewport().add((Component)this.tree, null);
        this.setDefaultCloseOperation(3);
    }

    public void addFolder(File driveOrDir, DefaultMutableTreeNode node) {
        this.setCursor(new Cursor(3));
        this.addFolder(driveOrDir, node, 0);
        this.setCursor(new Cursor(0));
    }

    private void addFolder(File driveOrDir, DefaultMutableTreeNode node, int level) {
        File[] fileList = driveOrDir.listFiles();
        if (fileList != null) {
            this.sortFiles(fileList);
        }
        if (level > this.MAX_LEVEL - 1) {
            return;
        }
        try {
            int i = 0;
            while (i < fileList.length) {
                if (fileList[i].isDirectory()) {
                    ExplorerMutableTreeNode dir = new ExplorerMutableTreeNode((Object)fileList[i].getName(), fileList[i]);
                    node.add(dir);
                    this.addFolder(fileList[i], dir, ++level);
                }
                ++i;
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public void addFolder(ExplorerMutableTreeNode node) {
        this.setCursor(new Cursor(3));
        int i = 0;
        while (i < node.getChildCount()) {
            ExplorerMutableTreeNode subNode = (ExplorerMutableTreeNode)node.getChildAt(i);
            this.addFolder(subNode.getFile(), subNode);
            ++i;
        }
        this.setCursor(new Cursor(0));
    }

    public void sortFiles(File[] listFile) {
        this.triRapide(listFile, 0, listFile.length - 1);
    }

    private int partition(File[] listFile, int deb, int fin) {
        int compt = deb;
        File pivot = listFile[deb];
        int i = deb - 1;
        int j = fin + 1;
        while (true) {
            if (listFile[--j].getName().compareToIgnoreCase(pivot.getName()) > 0) {
                continue;
            }
            while (listFile[++i].getName().compareToIgnoreCase(pivot.getName()) < 0) {
            }
            if (i >= j) break;
            this.echanger(listFile, i, j);
        }
        return j;
    }

    private void triRapide(File[] listFile, int deb, int fin) {
        if (deb < fin) {
            int positionPivot = this.partition(listFile, deb, fin);
            this.triRapide(listFile, deb, positionPivot);
            this.triRapide(listFile, positionPivot + 1, fin);
        }
    }

    private void echanger(File[] listFile, int posa, int posb) {
        File tmpFile = listFile[posa];
        listFile[posa] = listFile[posb];
        listFile[posb] = tmpFile;
    }
}

