/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.export;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import transpo.system.PerformanceScanner;
import transpo.system.Transport;
import transpo.system.exp.DriverExport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.LMDriver;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class DialogExportConducteur
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JList listeConducteur = null;
    private JComboBox cbAgence = null;
    private JPanel pnlDetail = null;
    private JScrollPane jspListe = null;
    private JTextField txtDebut = null;
    private JTextField txtFin = null;
    private JLabel lblFin = null;
    private JLabel lblDebut = null;
    private JCheckBox cbSuppression = null;
    private JButton btnEnvoyer = null;
    private JButton btnQuitter = null;
    private BddTransport database = null;
    private JCheckBox cbArchive = null;
    private JPanel pnlBtn = null;
    private JPanel pnlPpl = null;
    private JPanel pnlListe = null;

    public DialogExportConducteur(Frame owner, BddTransport database) {
        super(owner);
        this.database = database;
        this.load();
        this.initialize();
    }

    private void initialize() {
        this.setSize(400, 250);
        this.setTitle(LanguageTranslator.getString("export.driver.title"));
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.weighty = 1.0;
            gridBagConstraints10.fill = 1;
            gridBagConstraints10.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlPpl(), gridBagConstraints10);
        }
        return this.jContentPane;
    }

    private JList getListeConducteur() {
        if (this.listeConducteur == null) {
            this.listeConducteur = new JList();
        }
        return this.listeConducteur;
    }

    private JComboBox getCbAgence() {
        if (this.cbAgence == null) {
            this.cbAgence = new JComboBox();
            this.cbAgence.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DialogExportConducteur.this.reloadListe();
                }
            });
        }
        return this.cbAgence;
    }

    private JPanel getPnlDetail() {
        if (this.pnlDetail == null) {
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.fill = 2;
            gridBagConstraints12.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints12.gridwidth = 2;
            gridBagConstraints12.anchor = 10;
            gridBagConstraints12.gridy = 5;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.gridwidth = 4;
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.gridy = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridwidth = 4;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.gridy = 0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 2;
            this.lblDebut = new JLabel();
            this.lblDebut.setText(LanguageTranslator.getString("generics.begin"));
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.gridy = 3;
            this.lblFin = new JLabel();
            this.lblFin.setText(LanguageTranslator.getString("generics.end"));
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 3;
            gridBagConstraints4.gridy = 3;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 3;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            this.pnlDetail = new JPanel();
            this.pnlDetail.setLayout(new GridBagLayout());
            this.pnlDetail.add((Component)this.getTxtDebut(), gridBagConstraints);
            this.pnlDetail.add((Component)this.getTxtFin(), gridBagConstraints4);
            this.pnlDetail.add((Component)this.lblFin, gridBagConstraints5);
            this.pnlDetail.add((Component)this.lblDebut, gridBagConstraints6);
            this.pnlDetail.add((Component)this.getCbSuppression(), gridBagConstraints7);
            this.pnlDetail.add((Component)this.getCbArchive(), gridBagConstraints11);
            this.pnlDetail.add((Component)this.getPnlBtn(), gridBagConstraints12);
        }
        return this.pnlDetail;
    }

    private JScrollPane getJspListe() {
        if (this.jspListe == null) {
            this.jspListe = new JScrollPane();
            this.jspListe.setViewportView(this.getListeConducteur());
        }
        return this.jspListe;
    }

    private JTextField getTxtDebut() {
        if (this.txtDebut == null) {
            this.txtDebut = new JTextField();
            this.txtDebut.setPreferredSize(new Dimension(70, 20));
            this.txtDebut.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogExportConducteur.this.getTxtDebut());
                }
            });
        }
        return this.txtDebut;
    }

    private JTextField getTxtFin() {
        if (this.txtFin == null) {
            this.txtFin = new JTextField();
            this.txtFin.setPreferredSize(new Dimension(70, 20));
            this.txtFin.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogExportConducteur.this.getTxtFin());
                }
            });
        }
        return this.txtFin;
    }

    private JCheckBox getCbSuppression() {
        if (this.cbSuppression == null) {
            this.cbSuppression = new JCheckBox();
            this.cbSuppression.setText(LanguageTranslator.getString("export.full"));
            this.cbSuppression.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (DialogExportConducteur.this.getCbSuppression().isSelected()) {
                        DialogExportConducteur.this.getTxtDebut().setText("");
                        DialogExportConducteur.this.getTxtDebut().setEnabled(false);
                        DialogExportConducteur.this.getTxtFin().setText("");
                        DialogExportConducteur.this.getTxtFin().setEnabled(false);
                        DialogExportConducteur.this.getCbArchive().setEnabled(false);
                        DialogExportConducteur.this.getCbArchive().setSelected(true);
                    } else {
                        DialogExportConducteur.this.getTxtDebut().setEnabled(true);
                        DialogExportConducteur.this.getTxtFin().setEnabled(true);
                        DialogExportConducteur.this.getCbArchive().setEnabled(true);
                        DialogExportConducteur.this.getCbArchive().setSelected(false);
                    }
                }
            });
        }
        return this.cbSuppression;
    }

    private JButton getBtnEnvoyer() {
        if (this.btnEnvoyer == null) {
            this.btnEnvoyer = new JButton();
            this.btnEnvoyer.setText(LanguageTranslator.getString("button.export"));
            this.btnEnvoyer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Transport.ps.startOperation();
                    DialogExportConducteur.this.runExport();
                    Transport.ps.endOperation(PerformanceScanner.READING, "driver export");
                }
            });
        }
        return this.btnEnvoyer;
    }

    public void runExport() {
        DriverExport tmp = new DriverExport(this.database);
        Date debut = this.getTxtDebut().getText().equals("") ? null : ConversionTime.stringToDate(this.getTxtDebut().getText(), "dd/MM/yyyy");
        Date fin = this.getTxtFin().getText().equals("") ? null : ConversionTime.stringToDate(this.getTxtFin().getText(), "dd/MM/yyyy");
        Vector<Conducteur> tmpC = ((LMDriver)this.getListeConducteur().getModel()).get(this.getListeConducteur().getSelectedIndices());
        tmp.setParameters(tmpC, debut, fin, this.getCbSuppression().isSelected(), this.getCbArchive().isSelected());
        tmp.run();
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogExportConducteur.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private void load() {
        ComboBoxModel tmp = new ComboBoxModel(Agence.getList(), false, LanguageTranslator.getString("generics.all"));
        this.getCbAgence().setModel(tmp);
        LMDriver mlv = new LMDriver(Conducteur.loadList(tmp.getSelectedCle()));
        this.getListeConducteur().setModel(mlv);
    }

    private void reloadListe() {
        int selectedCle = ((ComboBoxModel)this.getCbAgence().getModel()).getSelectedCle();
        ((LMDriver)this.getListeConducteur().getModel()).setVector(Conducteur.loadList(selectedCle));
    }

    private JCheckBox getCbArchive() {
        if (this.cbArchive == null) {
            this.cbArchive = new JCheckBox();
            this.cbArchive.setText(LanguageTranslator.getString("export.archive"));
        }
        return this.cbArchive;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridwidth = 1;
            gridBagConstraints9.gridy = -1;
            gridBagConstraints9.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints9.gridx = -1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridwidth = 1;
            gridBagConstraints8.gridy = -1;
            gridBagConstraints8.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints8.gridx = -1;
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.add((Component)this.getBtnEnvoyer(), gridBagConstraints8);
            this.pnlBtn.add((Component)this.getBtnQuitter(), gridBagConstraints9);
        }
        return this.pnlBtn;
    }

    private JPanel getPnlPpl() {
        if (this.pnlPpl == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridheight = 2;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.gridx = -1;
            gridBagConstraints2.gridy = -1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.fill = 1;
            gridBagConstraints13.weighty = 1.0;
            gridBagConstraints13.weightx = 1.0;
            this.pnlPpl = new JPanel();
            this.pnlPpl.setLayout(new GridBagLayout());
            this.pnlPpl.add((Component)this.getPnlListe(), gridBagConstraints13);
            this.pnlPpl.add((Component)this.getPnlDetail(), gridBagConstraints2);
        }
        return this.pnlPpl;
    }

    private JPanel getPnlListe() {
        if (this.pnlListe == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.weightx = 0.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.insets = new Insets(0, 5, 5, 0);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridx = -1;
            gridBagConstraints1.gridy = -1;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.insets = new Insets(5, 5, 5, 0);
            this.pnlListe = new JPanel();
            this.pnlListe.setLayout(new GridBagLayout());
            this.pnlListe.add((Component)this.getCbAgence(), gridBagConstraints1);
            this.pnlListe.add((Component)this.getJspListe(), gridBagConstraints3);
        }
        return this.pnlListe;
    }
}

