/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.hardness;

import fr.pgh.component.JMultiListBox;
import fr.pgh.component.JNotificationFrame;
import fr.pgh.component.model.MultiListBoxModel;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.Hardness;
import fr.pgh.data.bdd.HardnessAttribution;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.core.hardness.GlobalHardnessCalculator;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.TMHardnessAttribution;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transpo.system.ui.views.sync.SynchronizedOptionDialog;
import transpo.system.util.Fonctions;
import transport.report.CustomReportFactory;
import transport.report.generator.DJGenerator;
import transport.report.generator.DJHardnessCounter;

public class DialogHardnessAttribution
extends JDialog
implements TableModelListener {
    private JPanel jContentPane = null;
    private JScrollPane jspTable = null;
    private JTable tblHardnessAttribution = null;
    private JPanel pnlDate = null;
    private JButton btnPreviousYear = null;
    private JLabel lblYear = null;
    private JButton btnNextYear = null;
    private JPanel pnlBtn = null;
    private JButton btnQuit = null;
    private JButton btnSave = null;
    private JButton btnCalculation = null;
    private JMultiListBox mbDriver = null;
    private JMultiListBox mbAgency = null;
    Vector<Hardness> hardnessList = null;
    Vector<Conducteur> drivers = null;
    private ArrayList<Map<String, ?>> data = null;

    public DialogHardnessAttribution(JFrame frame) {
        super(frame);
        this.initialize();
        this.reloadTable();
        this.setVisible(true);
    }

    private void initialize() {
        this.setSize(850, 500);
        this.setLocationRelativeTo(this.getParent());
        this.setContentPane(this.getJContentPane());
        this.setTitle(LanguageTranslator.getString("hardness.attribution.title"));
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getPnlDate(), "North");
            this.jContentPane.add((Component)this.getJspTable(), "Center");
            this.jContentPane.add((Component)this.getPnlBtn(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getPnlDate() {
        if (this.pnlDate == null) {
            this.pnlDate = new JPanel();
            this.pnlDate.add((Component)this.getMbAgency(), null);
            this.pnlDate.add((Component)this.getMbDriver(), null);
            this.pnlDate.add((Component)this.getBtnPreviousYear(), null);
            this.pnlDate.add((Component)this.getLblYear(), null);
            this.pnlDate.add((Component)this.getBtnNextYear(), null);
        }
        return this.pnlDate;
    }

    private JButton getBtnPreviousYear() {
        if (this.btnPreviousYear == null) {
            this.btnPreviousYear = new JButton();
            this.btnPreviousYear.setPreferredSize(new Dimension(32, 32));
            this.btnPreviousYear.setFocusable(false);
            this.btnPreviousYear.setIcon(Fonctions.getIcon(Transport.res.getResourceString("icone_left")));
            this.btnPreviousYear.addActionListener(new ChangeYear(-1));
        }
        return this.btnPreviousYear;
    }

    private JButton getBtnNextYear() {
        if (this.btnNextYear == null) {
            this.btnNextYear = new JButton();
            this.btnNextYear.setPreferredSize(new Dimension(32, 32));
            this.btnNextYear.setFocusable(false);
            this.btnNextYear.setIcon(Fonctions.getIcon(Transport.res.getResourceString("icone_right")));
            this.btnNextYear.addActionListener(new ChangeYear(1));
        }
        return this.btnNextYear;
    }

    private JLabel getLblYear() {
        if (this.lblYear == null) {
            this.lblYear = new JLabel();
            this.lblYear.setBackground(SystemColor.inactiveCaptionBorder);
            if (!System.getProperty("screen.contrast", "0").equals("1")) {
                this.lblYear.setForeground(SystemColor.inactiveCaption);
            }
            this.lblYear.setBorder(BorderFactory.createLineBorder(Color.black));
            this.lblYear.setHorizontalAlignment(0);
            this.lblYear.setHorizontalTextPosition(0);
            this.lblYear.setPreferredSize(new Dimension(70, 32));
            this.lblYear.setText(ConversionTime.dateToString(new Date(), "yyyy"));
        }
        return this.lblYear;
    }

    private JScrollPane getJspTable() {
        if (this.jspTable == null) {
            this.jspTable = new JScrollPane();
        }
        return this.jspTable;
    }

    private JMultiListBox getMbAgency() {
        if (this.mbAgency == null) {
            this.mbAgency = new JMultiListBox();
            this.mbAgency.setPreferredSize(new Dimension(150, 25));
            this.mbAgency.setModel(new MultiListBoxModel<Agence>(Agence.getList(), true));
            this.mbAgency.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    TimsLogger.verbose("#DHardnessAttribution.getMbAgency()# popup will be shadowed");
                    DialogHardnessAttribution.this.setConducteur();
                    DialogHardnessAttribution.this.reloadTable();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
        return this.mbAgency;
    }

    private JMultiListBox getMbDriver() {
        if (this.mbDriver == null) {
            this.mbDriver = new JMultiListBox();
            this.mbDriver.setPreferredSize(new Dimension(150, 25));
            this.mbDriver.setModel(new MultiListBoxModel<Conducteur>(Conducteur.getList(), true));
            this.mbDriver.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    TimsLogger.verbose("#DHardnessAttribution.getMbDriver()# popup will be shadowed");
                    DialogHardnessAttribution.this.reloadTable();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
        return this.mbDriver;
    }

    public void setConducteur() {
        Vector filters = this.getMbAgency().getSelectedItems();
        Integer[] agenciesId = new Integer[filters.size()];
        int x = 0;
        TimsLogger.debug("#DHardnessAttribution.setConducteur# charge les conducteurs de " + filters.size() + " agences : ");
        for (Object agency : filters) {
            TimsLogger.debug(" ..." + ((Agence)agency).getDescription());
            agenciesId[x++] = ((Agence)agency).getCleAgence();
        }
        MultiListBoxModel<Conducteur> modeleConducteur = new MultiListBoxModel<Conducteur>(Conducteur.loadList(agenciesId), true);
        this.getMbDriver().setModel(modeleConducteur);
    }

    private JTable getTblHardnessAttribution() {
        if (this.tblHardnessAttribution == null) {
            this.tblHardnessAttribution = new JTable();
            this.tblHardnessAttribution.setAutoResizeMode(0);
        }
        return this.tblHardnessAttribution;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.add((Component)this.getBtnQuit(), null);
            this.pnlBtn.add((Component)this.getBtnSave(), null);
            this.pnlBtn.add((Component)this.getBtnCalculation(), null);
        }
        return this.pnlBtn;
    }

    private JButton getBtnQuit() {
        if (this.btnQuit == null) {
            this.btnQuit = new JButton();
            this.btnQuit.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogHardnessAttribution.this.dispose();
                }
            });
        }
        return this.btnQuit;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton();
            this.btnSave.setText(LanguageTranslator.getString("button.save"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
        }
        return this.btnSave;
    }

    private JButton getBtnCalculation() {
        if (this.btnCalculation == null) {
            this.btnCalculation = new JButton();
            this.btnCalculation.setText(LanguageTranslator.getString("button.calculation"));
            this.btnCalculation.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogHardnessAttribution.this.doCalculation();
                }
            });
        }
        return this.btnCalculation;
    }

    private void doCalculation() {
        SynchronizedOptionDialog tmp = new SynchronizedOptionDialog(LanguageTranslator.getString("hardness.recalculate.confirm"), LanguageTranslator.getString("hardness.recalculate"));
        tmp.run();
        if (tmp.option == 0) {
            Thread reader = new Thread(){

                @Override
                public void run() {
                    ProgressBar pg = new ProgressBar(MainFrameTransport.getInstance(), LanguageTranslator.getString("hardness.calculation"));
                    pg.setVisible(true);
                    GlobalHardnessCalculator ghc = new GlobalHardnessCalculator(pg, Conducteur.loadListWithArchive(new Integer[0]), ConversionTime.stringToDate(String.valueOf(DialogHardnessAttribution.this.getLblYear().getText()) + "-01-01", "yyyy-MM-dd"));
                    ghc.launch();
                    JNotificationFrame frame = JNotificationFrame.getFrame(JNotificationFrame.Corner.BOTTOM_RIGHT);
                    frame.addMessage(LanguageTranslator.getString("hardness.calculation"), new JLabel(LanguageTranslator.getString("hardness.calculation.finised", DialogHardnessAttribution.this.getLblYear().getText())), Fonctions.getIcon(Transport.res.getResourceString("icone_valid")));
                    frame.showNotification(6);
                }
            };
            reader.start();
        }
        this.reloadTable();
    }

    private void afficheTable() {
        if (this.getTblHardnessAttribution().getModel() == null || !(this.getTblHardnessAttribution().getModel() instanceof TMHardnessAttribution)) {
            this.getTblHardnessAttribution().setModel(new TMHardnessAttribution(this.hardnessList, this.data));
            this.getTblHardnessAttribution().getModel().addTableModelListener(this);
        } else {
            ((TMHardnessAttribution)this.getTblHardnessAttribution().getModel()).setValue(this.hardnessList, this.data);
        }
        TableColumn column = null;
        int x = 0;
        while (x < this.getTblHardnessAttribution().getModel().getColumnCount()) {
            column = this.getTblHardnessAttribution().getColumnModel().getColumn(x);
            column.setPreferredWidth(50);
            ++x;
        }
        JList list = new JList(new ComboBoxModel((Vector<?>)this.drivers));
        list.setFixedCellWidth(150);
        list.setFixedCellHeight(this.getTblHardnessAttribution().getRowHeight());
        list.setCellRenderer(new RowHeader(this.getTblHardnessAttribution()));
        list.setBackground(this.getTblHardnessAttribution().getTableHeader().getBackground());
        this.getJspTable().setRowHeaderView(list);
        this.getJspTable().setViewportView(this.getTblHardnessAttribution());
    }

    private void printTbl(String out) {
        CustomReport cr = CustomReportFactory.getDefaultHardnessReport();
        cr.updateProperty("OUT", out);
        cr.updateProperty("TEMPLATE", DJGenerator.LANDSCAPE_TEMPLATE);
        if (out.equals("xls")) {
            cr.updateProperty("RESOLUTION", String.valueOf(0));
        } else {
            cr.updateProperty("RESOLUTION", String.valueOf(1));
        }
        Fonctions.tblToReport(cr, new DJHardnessCounter(), ((TMHardnessAttribution)this.getTblHardnessAttribution().getModel()).getData(), out);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int row = e.getFirstRow();
        int column = e.getColumn();
        TimsLogger.verbose("row " + row + " column " + column + " value " + this.getTblHardnessAttribution().getValueAt(row, column));
        TimsLogger.verbose("driverId " + this.drivers.get(row).getCleConducteur() + " hardnessId " + this.hardnessList.get(column).getId());
        Boolean attributed = (Boolean)this.getTblHardnessAttribution().getValueAt(row, column);
        HardnessAttribution.disable(this.drivers.get(row).getCleConducteur(), this.hardnessList.get(column).getId(), this.getLblYear().getText());
        Hardness hardness = this.hardnessList.get(column);
        int counter = 0;
        if (attributed.booleanValue()) {
            counter = hardness.getAttributionThreshold();
        }
        HardnessAttribution ha = new HardnessAttribution(0, hardness.getId(), this.drivers.get(row).getCleConducteur(), ConversionTime.stringToDate(String.valueOf(this.getLblYear().getText()) + "-01-01", "yyyy-MM-dd"), attributed, ConnexionSettings.getInstance().getUserCle(), new Date(), true, counter);
        ha.insert();
    }

    private void reloadTable() {
        this.loadTable();
        this.afficheTable();
    }

    private void loadTable() {
        HashMap<String, Boolean> driverMap;
        this.hardnessList = Hardness.loadList();
        MultiListBoxModel mbDriverModel = this.getMbDriver().getModel();
        this.drivers = mbDriverModel.getSelectedItems();
        Vector<HardnessAttribution> hardnessAttributions = HardnessAttribution.loadList(this.getLblYear().getText());
        this.data = new ArrayList();
        HashMap<Integer, HashMap<String, Boolean>> driversLink = new HashMap<Integer, HashMap<String, Boolean>>();
        for (HardnessAttribution hardnessAttribution : hardnessAttributions) {
            driverMap = (HashMap<String, Boolean>)driversLink.get(hardnessAttribution.getDriverId());
            if (driverMap == null) {
                driverMap = new HashMap<String, Boolean>();
                driversLink.put(hardnessAttribution.getDriverId(), driverMap);
            }
            driverMap.put(Hardness.find(this.hardnessList, hardnessAttribution.getHardnessId()).getCode(), hardnessAttribution.isAttribution());
        }
        for (Conducteur driver : this.drivers) {
            driverMap = (HashMap<String, Boolean>)driversLink.get(driver.getId());
            if (driverMap == null) {
                driverMap = new HashMap<String, Boolean>();
            }
            this.data.add(driverMap);
        }
    }

    class ChangeYear
    implements ActionListener {
        private int year = 0;

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                int currentYear = Integer.parseInt(DialogHardnessAttribution.this.getLblYear().getText()) + this.year;
                DialogHardnessAttribution.this.getLblYear().setText(String.valueOf(currentYear));
                DialogHardnessAttribution.this.reloadTable();
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }

        public ChangeYear(int year) {
            this.year = year;
        }
    }

    public class RowHeader
    extends JLabel
    implements ListCellRenderer {
        public RowHeader(JTable table) {
            JTableHeader header = table.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            return this;
        }
    }
}

