/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.layout;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.ListIterator;
import transpo.system.ui.views.layout.TableLayoutConstants;
import transpo.system.ui.views.layout.TableLayoutConstraints;

public class TableLayout
implements LayoutManager2,
Serializable,
TableLayoutConstants {
    protected static final double[][] defaultSize = new double[][]{new double[0], new double[0]};
    protected double[] columnSpec;
    protected double[] rowSpec;
    protected int[] columnSize;
    protected int[] rowSize;
    protected int[] columnOffset;
    protected int[] rowOffset;
    protected LinkedList list;
    protected boolean dirty;
    protected int oldWidth;
    protected int oldHeight;

    public TableLayout() {
        this(defaultSize);
    }

    public TableLayout(double[][] size) {
        if (size != null && size.length == 2) {
            double[] tempCol = size[0];
            double[] tempRow = size[1];
            this.columnSpec = new double[tempCol.length];
            this.rowSpec = new double[tempRow.length];
            System.arraycopy(tempCol, 0, this.columnSpec, 0, this.columnSpec.length);
            System.arraycopy(tempRow, 0, this.rowSpec, 0, this.rowSpec.length);
            int counter = 0;
            while (counter < this.columnSpec.length) {
                if (this.columnSpec[counter] < 0.0 && this.columnSpec[counter] != -1.0 && this.columnSpec[counter] != -2.0 && this.columnSpec[counter] != -3.0) {
                    this.columnSpec[counter] = 0.0;
                }
                ++counter;
            }
            counter = 0;
            while (counter < this.rowSpec.length) {
                if (this.rowSpec[counter] < 0.0 && this.rowSpec[counter] != -1.0 && this.rowSpec[counter] != -2.0 && this.rowSpec[counter] != -3.0) {
                    this.rowSpec[counter] = 0.0;
                }
                ++counter;
            }
        } else {
            double[] tempCol = new double[]{-1.0};
            double[] tempRow = new double[]{-1.0};
            this.setColumn(tempCol);
            this.setRow(tempRow);
        }
        this.list = new LinkedList();
        this.dirty = true;
    }

    public TableLayoutConstraints getConstraints(Component component) {
        ListIterator iterator = this.list.listIterator(0);
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry.component != component) continue;
            return new TableLayoutConstraints(entry.col1, entry.row1, entry.col2, entry.row2, entry.hAlign, entry.vAlign);
        }
        return null;
    }

    public void setConstraints(Component component, TableLayoutConstraints constraint) {
        if (component == null) {
            throw new IllegalArgumentException("Parameter component cannot be null.");
        }
        if (constraint == null) {
            throw new IllegalArgumentException("Parameter constraint cannot be null.");
        }
        ListIterator<Entry> iterator = this.list.listIterator(0);
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry.component != component) continue;
            iterator.set(new Entry(component, constraint));
        }
    }

    public void setColumn(double[] column) {
        this.columnSpec = new double[column.length];
        System.arraycopy(column, 0, this.columnSpec, 0, this.columnSpec.length);
        int counter = 0;
        while (counter < this.columnSpec.length) {
            if (this.columnSpec[counter] < 0.0 && this.columnSpec[counter] != -1.0 && this.columnSpec[counter] != -2.0 && this.columnSpec[counter] != -3.0) {
                this.columnSpec[counter] = 0.0;
            }
            ++counter;
        }
        this.dirty = true;
    }

    public void setRow(double[] row) {
        this.rowSpec = new double[row.length];
        System.arraycopy(row, 0, this.rowSpec, 0, this.rowSpec.length);
        int counter = 0;
        while (counter < this.rowSpec.length) {
            if (this.rowSpec[counter] < 0.0 && this.rowSpec[counter] != -1.0 && this.rowSpec[counter] != -2.0 && this.rowSpec[counter] != -3.0) {
                this.rowSpec[counter] = 0.0;
            }
            ++counter;
        }
        this.dirty = true;
    }

    public void setColumn(int i, double size) {
        if (size < 0.0 && size != -1.0 && size != -2.0 && size != -3.0) {
            size = 0.0;
        }
        this.columnSpec[i] = size;
        this.dirty = true;
    }

    public void setRow(int i, double size) {
        if (size < 0.0 && size != -1.0 && size != -2.0 && size != -3.0) {
            size = 0.0;
        }
        this.rowSpec[i] = size;
        this.dirty = true;
    }

    public double[] getColumn() {
        double[] column = new double[this.columnSpec.length];
        System.arraycopy(this.columnSpec, 0, column, 0, column.length);
        return column;
    }

    public double[] getRow() {
        double[] row = new double[this.rowSpec.length];
        System.arraycopy(this.rowSpec, 0, row, 0, row.length);
        return row;
    }

    public double getColumn(int i) {
        return this.columnSpec[i];
    }

    public double getRow(int i) {
        return this.rowSpec[i];
    }

    public int getNumColumn() {
        return this.columnSpec.length;
    }

    public int getNumRow() {
        return this.rowSpec.length;
    }

    public void insertColumn(int i, double size) {
        if (i < 0 || i > this.columnSpec.length) {
            throw new IllegalArgumentException("Parameter i is invalid.  i = " + i + ".  Valid range is [0, " + this.columnSpec.length + "].");
        }
        if (size < 0.0 && size != -1.0 && size != -2.0 && size != -3.0) {
            size = 0.0;
        }
        double[] column = new double[this.columnSpec.length + 1];
        System.arraycopy(this.columnSpec, 0, column, 0, i);
        System.arraycopy(this.columnSpec, i, column, i + 1, this.columnSpec.length - i);
        column[i] = size;
        this.columnSpec = column;
        ListIterator iterator = this.list.listIterator(0);
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry.col1 >= i) {
                entry.col1 = entry.col1 + 1;
            }
            if (entry.col2 < i) continue;
            entry.col2 = entry.col2 + 1;
        }
        this.dirty = true;
    }

    public void insertRow(int i, double size) {
        if (i < 0 || i > this.rowSpec.length) {
            throw new IllegalArgumentException("Parameter i is invalid.  i = " + i + ".  Valid range is [0, " + this.rowSpec.length + "].");
        }
        if (size < 0.0 && size != -1.0 && size != -2.0 && size != -3.0) {
            size = 0.0;
        }
        double[] row = new double[this.rowSpec.length + 1];
        System.arraycopy(this.rowSpec, 0, row, 0, i);
        System.arraycopy(this.rowSpec, i, row, i + 1, this.rowSpec.length - i);
        row[i] = size;
        this.rowSpec = row;
        ListIterator iterator = this.list.listIterator(0);
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry.row1 >= i) {
                entry.row1 = entry.row1 + 1;
            }
            if (entry.row2 < i) continue;
            entry.row2 = entry.row2 + 1;
        }
        this.dirty = true;
    }

    public void deleteColumn(int i) {
        if (i < 0 || i >= this.columnSpec.length) {
            throw new IllegalArgumentException("Parameter i is invalid.  i = " + i + ".  Valid range is [0, " + (this.columnSpec.length - 1) + "].");
        }
        double[] column = new double[this.columnSpec.length - 1];
        System.arraycopy(this.columnSpec, 0, column, 0, i);
        System.arraycopy(this.columnSpec, i + 1, column, i, this.columnSpec.length - i - 1);
        this.columnSpec = column;
        ListIterator iterator = this.list.listIterator(0);
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry.col1 >= i) {
                entry.col1 = entry.col1 - 1;
            }
            if (entry.col2 < i) continue;
            entry.col2 = entry.col2 - 1;
        }
        this.dirty = true;
    }

    public void deleteRow(int i) {
        if (i < 0 || i >= this.rowSpec.length) {
            throw new IllegalArgumentException("Parameter i is invalid.  i = " + i + ".  Valid range is [0, " + (this.rowSpec.length - 1) + "].");
        }
        double[] row = new double[this.rowSpec.length - 1];
        System.arraycopy(this.rowSpec, 0, row, 0, i);
        System.arraycopy(this.rowSpec, i + 1, row, i, this.rowSpec.length - i - 1);
        this.rowSpec = row;
        ListIterator iterator = this.list.listIterator(0);
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry.row1 >= i) {
                entry.row1 = entry.row1 - 1;
            }
            if (entry.row2 < i) continue;
            entry.row2 = entry.row2 - 1;
        }
        this.dirty = true;
    }

    public String toString() {
        int counter;
        String value = "TableLayout {{";
        if (this.columnSpec.length > 0) {
            counter = 0;
            while (counter < this.columnSpec.length - 1) {
                value = String.valueOf(value) + this.columnSpec[counter] + ", ";
                ++counter;
            }
            value = String.valueOf(value) + this.columnSpec[this.columnSpec.length - 1] + "}, {";
        } else {
            value = String.valueOf(value) + "}, {";
        }
        if (this.rowSpec.length > 0) {
            counter = 0;
            while (counter < this.rowSpec.length - 1) {
                value = String.valueOf(value) + this.rowSpec[counter] + ", ";
                ++counter;
            }
            value = String.valueOf(value) + this.rowSpec[this.rowSpec.length - 1] + "}}";
        } else {
            value = String.valueOf(value) + "}}";
        }
        return value;
    }

    public void drawGrid(Container container, Graphics g) {
        Dimension d = container.getSize();
        if (this.dirty || d.width != this.oldWidth || d.height != this.oldHeight) {
            this.calculateSize(container);
        }
        int y = 0;
        int row = 0;
        while (row < this.rowSize.length) {
            int x = 0;
            int column = 0;
            while (column < this.columnSize.length) {
                Color color = new Color((int)(Math.random() * 1.6777215E7));
                g.setColor(color);
                g.fillRect(x, y, this.columnSize[column], this.rowSize[row]);
                x += this.columnSize[column];
                ++column;
            }
            y += this.rowSize[row];
            ++row;
        }
    }

    public boolean hidden() {
        boolean hidden = false;
        ListIterator iterator = this.list.listIterator(0);
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry.row1 >= 0 && entry.col1 >= 0 && entry.row2 <= this.rowSpec.length && entry.col2 <= this.columnSpec.length) continue;
            hidden = true;
            break;
        }
        return hidden;
    }

    public boolean overlapping() {
        int numEntry = this.list.size();
        if (numEntry == 0) {
            return false;
        }
        boolean overlapping = false;
        Entry[] entry = this.list.toArray(new Entry[numEntry]);
        int knowUnique = 1;
        while (knowUnique < numEntry) {
            int checking = knowUnique - 1;
            while (checking >= 0) {
                if (entry[checking].col1 >= entry[knowUnique].col1 && entry[checking].col1 <= entry[knowUnique].col2 && entry[checking].row1 >= entry[knowUnique].row1 && entry[checking].row1 <= entry[knowUnique].row2 || entry[checking].col2 >= entry[knowUnique].col1 && entry[checking].col2 <= entry[knowUnique].col2 && entry[checking].row2 >= entry[knowUnique].row1 && entry[checking].row2 <= entry[knowUnique].row2) {
                    overlapping = true;
                    break;
                }
                --checking;
            }
            ++knowUnique;
        }
        return overlapping;
    }

    protected void calculateSize(Container container) {
        Dimension p;
        Entry entry;
        ListIterator iterator;
        int numColumn = this.columnSpec.length;
        int numRow = this.rowSpec.length;
        this.columnSize = new int[numColumn];
        this.rowSize = new int[numRow];
        Insets inset = container.getInsets();
        Dimension d = container.getSize();
        int totalWidth = d.width - inset.left - inset.right;
        int totalHeight = d.height - inset.top - inset.bottom;
        int availableWidth = totalWidth;
        int availableHeight = totalHeight;
        int counter = 0;
        while (counter < numColumn) {
            if (this.columnSpec[counter] >= 1.0 || this.columnSpec[counter] == 0.0) {
                this.columnSize[counter] = (int)(this.columnSpec[counter] + 0.5);
                availableWidth -= this.columnSize[counter];
            }
            ++counter;
        }
        counter = 0;
        while (counter < numRow) {
            if (this.rowSpec[counter] >= 1.0 || this.rowSpec[counter] == 0.0) {
                this.rowSize[counter] = (int)(this.rowSpec[counter] + 0.5);
                availableHeight -= this.rowSize[counter];
            }
            ++counter;
        }
        counter = 0;
        while (counter < numColumn) {
            if (this.columnSpec[counter] == -2.0 || this.columnSpec[counter] == -3.0) {
                int maxWidth = 0;
                iterator = this.list.listIterator(0);
                while (iterator.hasNext()) {
                    int width;
                    entry = (Entry)iterator.next();
                    if (entry.col1 != counter || entry.col2 != counter) continue;
                    p = this.columnSpec[counter] == -2.0 ? entry.component.getPreferredSize() : entry.component.getMinimumSize();
                    int n = width = p == null ? 0 : p.width;
                    if (maxWidth >= width) continue;
                    maxWidth = width;
                }
                this.columnSize[counter] = maxWidth;
                availableWidth -= maxWidth;
            }
            ++counter;
        }
        counter = 0;
        while (counter < numRow) {
            if (this.rowSpec[counter] == -2.0 || this.rowSpec[counter] == -3.0) {
                int maxHeight = 0;
                iterator = this.list.listIterator(0);
                while (iterator.hasNext()) {
                    int height;
                    entry = (Entry)iterator.next();
                    if (entry.row1 != counter || entry.row2 != counter) continue;
                    p = this.rowSpec[counter] == -2.0 ? entry.component.getPreferredSize() : entry.component.getMinimumSize();
                    int n = height = p == null ? 0 : p.height;
                    if (maxHeight >= height) continue;
                    maxHeight = height;
                }
                this.rowSize[counter] = maxHeight;
                availableHeight -= maxHeight;
            }
            ++counter;
        }
        int relativeWidth = availableWidth;
        int relativeHeight = availableHeight;
        if (relativeWidth < 0) {
            relativeWidth = 0;
        }
        if (relativeHeight < 0) {
            relativeHeight = 0;
        }
        counter = 0;
        while (counter < numColumn) {
            if (this.columnSpec[counter] > 0.0 && this.columnSpec[counter] < 1.0) {
                this.columnSize[counter] = (int)(this.columnSpec[counter] * (double)relativeWidth + 0.5);
                availableWidth -= this.columnSize[counter];
            }
            ++counter;
        }
        counter = 0;
        while (counter < numRow) {
            if (this.rowSpec[counter] > 0.0 && this.rowSpec[counter] < 1.0) {
                this.rowSize[counter] = (int)(this.rowSpec[counter] * (double)relativeHeight + 0.5);
                availableHeight -= this.rowSize[counter];
            }
            ++counter;
        }
        if (availableWidth < 0) {
            availableWidth = 0;
        }
        if (availableHeight < 0) {
            availableHeight = 0;
        }
        int numFillWidth = 0;
        int numFillHeight = 0;
        counter = 0;
        while (counter < numColumn) {
            if (this.columnSpec[counter] == -1.0) {
                ++numFillWidth;
            }
            ++counter;
        }
        counter = 0;
        while (counter < numRow) {
            if (this.rowSpec[counter] == -1.0) {
                ++numFillHeight;
            }
            ++counter;
        }
        int slackWidth = availableWidth;
        int slackHeight = availableHeight;
        counter = 0;
        while (counter < numColumn) {
            if (this.columnSpec[counter] == -1.0) {
                this.columnSize[counter] = availableWidth / numFillWidth;
                slackWidth -= this.columnSize[counter];
            }
            ++counter;
        }
        counter = 0;
        while (counter < numRow) {
            if (this.rowSpec[counter] == -1.0) {
                this.rowSize[counter] = availableHeight / numFillHeight;
                slackHeight -= this.rowSize[counter];
            }
            ++counter;
        }
        counter = numColumn - 1;
        while (counter >= 0) {
            if (this.columnSpec[counter] == -1.0) {
                int n = counter;
                this.columnSize[n] = this.columnSize[n] + slackWidth;
                break;
            }
            --counter;
        }
        counter = numRow - 1;
        while (counter >= 0) {
            if (this.rowSpec[counter] == -1.0) {
                int n = counter;
                this.rowSize[n] = this.rowSize[n] + slackHeight;
                break;
            }
            --counter;
        }
        this.columnOffset = new int[numColumn + 1];
        this.columnOffset[0] = inset.left;
        counter = 0;
        while (counter < numColumn) {
            this.columnOffset[counter + 1] = this.columnOffset[counter] + this.columnSize[counter];
            ++counter;
        }
        this.rowOffset = new int[numRow + 1];
        this.rowOffset[0] = inset.top;
        counter = 0;
        while (counter < numRow) {
            this.rowOffset[counter + 1] = this.rowOffset[counter] + this.rowSize[counter];
            ++counter;
        }
        this.dirty = false;
        this.oldWidth = totalWidth;
        this.oldHeight = totalHeight;
    }

    @Override
    public void layoutContainer(Container container) {
        Dimension d = container.getSize();
        if (this.dirty || d.width != this.oldWidth || d.height != this.oldHeight) {
            this.calculateSize(container);
        }
        Component[] component = container.getComponents();
        int counter = 0;
        while (counter < component.length) {
            try {
                int y;
                int h;
                int x;
                int w;
                ListIterator iterator = this.list.listIterator(0);
                Entry entry = null;
                while (iterator.hasNext()) {
                    entry = (Entry)iterator.next();
                    if (entry.component == component[counter]) break;
                    entry = null;
                }
                if (entry == null) break;
                if (entry.singleCell) {
                    int preferredWidth = 0;
                    int preferredHeight = 0;
                    if (entry.hAlign != 2 || entry.vAlign != 2) {
                        Dimension preferredSize = component[counter].getPreferredSize();
                        preferredWidth = preferredSize.width;
                        preferredHeight = preferredSize.height;
                    }
                    int cellWidth = this.columnSize[entry.col1];
                    int cellHeight = this.rowSize[entry.row1];
                    w = entry.hAlign == 2 || cellWidth < preferredWidth ? cellWidth : preferredWidth;
                    switch (entry.hAlign) {
                        case 0: {
                            x = this.columnOffset[entry.col1];
                            break;
                        }
                        case 3: {
                            x = this.columnOffset[entry.col1 + 1] - w;
                            break;
                        }
                        case 1: {
                            x = this.columnOffset[entry.col1] + (cellWidth - w >> 1);
                            break;
                        }
                        case 2: {
                            x = this.columnOffset[entry.col1];
                            break;
                        }
                        default: {
                            x = 0;
                        }
                    }
                    h = entry.vAlign == 2 || cellHeight < preferredHeight ? cellHeight : preferredHeight;
                    switch (entry.vAlign) {
                        case 0: {
                            y = this.rowOffset[entry.row1];
                            break;
                        }
                        case 3: {
                            y = this.rowOffset[entry.row1 + 1] - h;
                            break;
                        }
                        case 1: {
                            y = this.rowOffset[entry.row1] + (cellHeight - h >> 1);
                            break;
                        }
                        case 2: {
                            y = this.rowOffset[entry.row1];
                            break;
                        }
                        default: {
                            y = 0;
                            break;
                        }
                    }
                } else {
                    x = this.columnOffset[entry.col1];
                    y = this.rowOffset[entry.row1];
                    w = this.columnOffset[entry.col2 + 1] - this.columnOffset[entry.col1];
                    h = this.rowOffset[entry.row2 + 1] - this.rowOffset[entry.row1];
                }
                component[counter].setBounds(x, y, w, h);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++counter;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Entry entry;
        ListIterator iterator;
        int scaledWidth = 0;
        int scaledHeight = 0;
        double fillWidthRatio = 1.0;
        double fillHeightRatio = 1.0;
        int numFillWidth = 0;
        int numFillHeight = 0;
        int counter = 0;
        while (counter < this.columnSpec.length) {
            if (this.columnSpec[counter] > 0.0 && this.columnSpec[counter] < 1.0) {
                fillWidthRatio -= this.columnSpec[counter];
            } else if (this.columnSpec[counter] == -1.0) {
                ++numFillWidth;
            }
            ++counter;
        }
        counter = 0;
        while (counter < this.rowSpec.length) {
            if (this.rowSpec[counter] > 0.0 && this.rowSpec[counter] < 1.0) {
                fillHeightRatio -= this.rowSpec[counter];
            } else if (this.rowSpec[counter] == -1.0) {
                ++numFillHeight;
            }
            ++counter;
        }
        if (numFillWidth > 1) {
            fillWidthRatio /= (double)numFillWidth;
        }
        if (numFillHeight > 1) {
            fillHeightRatio /= (double)numFillHeight;
        }
        if (fillWidthRatio < 0.0) {
            fillWidthRatio = 0.0;
        }
        if (fillHeightRatio < 0.0) {
            fillHeightRatio = 0.0;
        }
        int[] columnPrefMin = new int[this.columnSpec.length];
        counter = 0;
        while (counter < this.columnSpec.length) {
            if (this.columnSpec[counter] == -2.0 || this.columnSpec[counter] == -3.0) {
                int maxWidth = 0;
                iterator = this.list.listIterator(0);
                while (iterator.hasNext()) {
                    int width;
                    entry = (Entry)iterator.next();
                    if (entry.col1 != counter || entry.col2 != counter) continue;
                    Dimension p = this.columnSpec[counter] == -2.0 ? entry.component.getPreferredSize() : entry.component.getMinimumSize();
                    int n = width = p == null ? 0 : p.width;
                    if (maxWidth >= width) continue;
                    maxWidth = width;
                }
                columnPrefMin[counter] = maxWidth;
            }
            ++counter;
        }
        int[] rowPrefMin = new int[this.rowSpec.length];
        counter = 0;
        while (counter < this.rowSpec.length) {
            if (this.rowSpec[counter] == -2.0 || this.rowSpec[counter] == -3.0) {
                int maxHeight = 0;
                ListIterator iterator2 = this.list.listIterator(0);
                while (iterator2.hasNext()) {
                    int height;
                    Entry entry2 = (Entry)iterator2.next();
                    if (entry2.row1 != counter || entry2.row1 != counter) continue;
                    Dimension p = this.rowSpec[counter] == -2.0 ? entry2.component.getPreferredSize() : entry2.component.getMinimumSize();
                    int n = height = p == null ? 0 : p.height;
                    if (maxHeight >= height) continue;
                    maxHeight = height;
                }
                int n = counter;
                rowPrefMin[n] = rowPrefMin[n] + maxHeight;
            }
            ++counter;
        }
        iterator = this.list.listIterator(0);
        while (iterator.hasNext()) {
            entry = (Entry)iterator.next();
            if (entry.col1 < 0 || entry.col1 >= this.columnSpec.length || entry.col2 >= this.columnSpec.length || entry.row1 < 0 || entry.row1 >= this.rowSpec.length || entry.row2 >= this.rowSpec.length) continue;
            Dimension size = entry.component.getPreferredSize();
            int scalableWidth = size.width;
            int scalableHeight = size.height;
            counter = entry.col1;
            while (counter <= entry.col2) {
                if (this.columnSpec[counter] >= 1.0) {
                    scalableWidth = (int)((double)scalableWidth - this.columnSpec[counter]);
                } else if (this.columnSpec[counter] == -2.0 || this.columnSpec[counter] == -3.0) {
                    scalableWidth -= columnPrefMin[counter];
                }
                ++counter;
            }
            counter = entry.row1;
            while (counter <= entry.row2) {
                if (this.rowSpec[counter] >= 1.0) {
                    scalableHeight = (int)((double)scalableHeight - this.rowSpec[counter]);
                } else if (this.rowSpec[counter] == -2.0 || this.rowSpec[counter] == -3.0) {
                    scalableHeight -= rowPrefMin[counter];
                }
                ++counter;
            }
            double relativeWidth = 0.0;
            counter = entry.col1;
            while (counter <= entry.col2) {
                if (this.columnSpec[counter] > 0.0 && this.columnSpec[counter] < 1.0) {
                    relativeWidth += this.columnSpec[counter];
                } else if (this.columnSpec[counter] == -1.0 && fillWidthRatio != 0.0) {
                    relativeWidth += fillWidthRatio;
                }
                ++counter;
            }
            int temp = relativeWidth == 0.0 ? 0 : (int)((double)scalableWidth / relativeWidth + 0.5);
            if (scaledWidth < temp) {
                scaledWidth = temp;
            }
            double relativeHeight = 0.0;
            counter = entry.row1;
            while (counter <= entry.row2) {
                if (this.rowSpec[counter] > 0.0 && this.rowSpec[counter] < 1.0) {
                    relativeHeight += this.rowSpec[counter];
                } else if (this.rowSpec[counter] == -1.0 && fillHeightRatio != 0.0) {
                    relativeHeight += fillHeightRatio;
                }
                ++counter;
            }
            temp = relativeHeight == 0.0 ? 0 : (int)((double)scalableHeight / relativeHeight + 0.5);
            if (scaledHeight >= temp) continue;
            scaledHeight = temp;
        }
        int totalWidth = scaledWidth;
        counter = 0;
        while (counter < this.columnSpec.length) {
            if (this.columnSpec[counter] >= 1.0) {
                totalWidth += (int)(this.columnSpec[counter] + 0.5);
            } else if (this.columnSpec[counter] == -2.0 || this.columnSpec[counter] == -3.0) {
                totalWidth += columnPrefMin[counter];
            }
            ++counter;
        }
        int totalHeight = scaledHeight;
        counter = 0;
        while (counter < this.rowSpec.length) {
            if (this.rowSpec[counter] >= 1.0) {
                totalHeight += (int)(this.rowSpec[counter] + 0.5);
            } else if (this.rowSpec[counter] == -2.0 || this.rowSpec[counter] == -3.0) {
                totalHeight += rowPrefMin[counter];
            }
            ++counter;
        }
        Insets inset = container.getInsets();
        return new Dimension(totalWidth += inset.left + inset.right, totalHeight += inset.top + inset.bottom);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        int scaledWidth = 0;
        int scaledHeight = 0;
        boolean fillWidth = false;
        boolean fillHeight = false;
        double fillWidthRatio = 1.0;
        double fillHeightRatio = 1.0;
        int numFillWidth = 0;
        int numFillHeight = 0;
        int counter = 0;
        while (counter < this.columnSpec.length) {
            if (this.columnSpec[counter] > 0.0 && this.columnSpec[counter] < 1.0) {
                fillWidthRatio -= this.columnSpec[counter];
            } else if (this.columnSpec[counter] == -1.0) {
                ++numFillWidth;
            }
            ++counter;
        }
        counter = 0;
        while (counter < this.rowSpec.length) {
            if (this.rowSpec[counter] > 0.0 && this.rowSpec[counter] < 1.0) {
                fillHeightRatio -= this.rowSpec[counter];
            } else if (this.rowSpec[counter] == -1.0) {
                ++numFillHeight;
            }
            ++counter;
        }
        if (numFillWidth > 1) {
            fillWidthRatio /= (double)numFillWidth;
        }
        if (numFillHeight > 1) {
            fillHeightRatio /= (double)numFillHeight;
        }
        if (fillWidthRatio < 0.0) {
            fillWidthRatio = 0.0;
        }
        if (fillHeightRatio < 0.0) {
            fillHeightRatio = 0.0;
        }
        ListIterator iterator = this.list.listIterator(0);
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry.col1 < 0 || entry.col1 >= this.columnSpec.length || entry.col2 >= this.columnSpec.length || entry.row1 < 0 || entry.row1 >= this.rowSpec.length || entry.row2 >= this.rowSpec.length) continue;
            Dimension size = entry.component.getMinimumSize();
            int scalableWidth = size.width;
            int scalableHeight = size.height;
            counter = entry.col1;
            while (counter <= entry.col2) {
                if (this.columnSpec[counter] >= 1.0) {
                    scalableWidth = (int)((double)scalableWidth - this.columnSpec[counter]);
                }
                ++counter;
            }
            counter = entry.row1;
            while (counter <= entry.row2) {
                if (this.rowSpec[counter] >= 1.0) {
                    scalableHeight = (int)((double)scalableHeight - this.rowSpec[counter]);
                }
                ++counter;
            }
            double relativeWidth = 0.0;
            counter = entry.col1;
            while (counter <= entry.col2) {
                if (this.columnSpec[counter] > 0.0 && this.columnSpec[counter] < 1.0) {
                    relativeWidth += this.columnSpec[counter];
                } else if (this.columnSpec[counter] == -1.0 && fillWidthRatio != 0.0) {
                    relativeWidth += fillWidthRatio;
                }
                ++counter;
            }
            int temp = relativeWidth == 0.0 ? 0 : (int)((double)scalableWidth / relativeWidth + 0.5);
            if (scaledWidth < temp) {
                scaledWidth = temp;
            }
            double relativeHeight = 0.0;
            counter = entry.row1;
            while (counter <= entry.row2) {
                if (this.rowSpec[counter] > 0.0 && this.rowSpec[counter] < 1.0) {
                    relativeHeight += this.rowSpec[counter];
                } else if (this.rowSpec[counter] == -1.0 && fillHeightRatio != 0.0) {
                    relativeHeight += fillHeightRatio;
                }
                ++counter;
            }
            temp = relativeHeight == 0.0 ? 0 : (int)((double)scalableHeight / relativeHeight + 0.5);
            if (scaledHeight >= temp) continue;
            scaledHeight = temp;
        }
        int totalWidth = scaledWidth;
        counter = 0;
        while (counter < this.columnSpec.length) {
            if (this.columnSpec[counter] >= 1.0) {
                totalWidth += (int)(this.columnSpec[counter] + 0.5);
            } else if (this.columnSpec[counter] == -2.0 || this.columnSpec[counter] == -3.0) {
                int maxWidth = 0;
                iterator = this.list.listIterator(0);
                while (iterator.hasNext()) {
                    int width;
                    Entry entry = (Entry)iterator.next();
                    if (entry.col1 != counter || entry.col2 != counter) continue;
                    Dimension p = this.columnSpec[counter] == -2.0 ? entry.component.getPreferredSize() : entry.component.getMinimumSize();
                    int n = width = p == null ? 0 : p.width;
                    if (maxWidth >= width) continue;
                    maxWidth = width;
                }
                totalWidth += maxWidth;
            }
            ++counter;
        }
        int totalHeight = scaledHeight;
        counter = 0;
        while (counter < this.rowSpec.length) {
            if (this.rowSpec[counter] >= 1.0) {
                totalHeight += (int)(this.rowSpec[counter] + 0.5);
            } else if (this.rowSpec[counter] == -2.0 || this.rowSpec[counter] == -3.0) {
                int maxHeight = 0;
                iterator = this.list.listIterator(0);
                while (iterator.hasNext()) {
                    int height;
                    Entry entry = (Entry)iterator.next();
                    if (entry.row1 != counter || entry.row1 != counter) continue;
                    Dimension p = this.rowSpec[counter] == -2.0 ? entry.component.getPreferredSize() : entry.component.getMinimumSize();
                    int n = height = p == null ? 0 : p.height;
                    if (maxHeight >= height) continue;
                    maxHeight = height;
                }
                totalHeight += maxHeight;
            }
            ++counter;
        }
        Insets inset = container.getInsets();
        return new Dimension(totalWidth += inset.left + inset.right, totalHeight += inset.top + inset.bottom);
    }

    @Override
    public void addLayoutComponent(String name, Component component) {
        this.addLayoutComponent(component, name);
    }

    @Override
    public void addLayoutComponent(Component component, Object constraint) {
        if (constraint instanceof String) {
            constraint = new TableLayoutConstraints((String)constraint);
            this.list.add(new Entry(component, (TableLayoutConstraints)constraint));
        } else if (constraint instanceof TableLayoutConstraints) {
            this.list.add(new Entry(component, (TableLayoutConstraints)constraint));
        } else {
            if (constraint == null) {
                throw new IllegalArgumentException("No constraint for the component");
            }
            throw new IllegalArgumentException("Cannot accept a constraint of class " + constraint.getClass());
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.list.remove(component);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.dirty = true;
    }

    protected class Entry
    extends TableLayoutConstraints {
        protected Component component;
        protected boolean singleCell;

        public Entry(Component component, TableLayoutConstraints constraint) {
            super(constraint.col1, constraint.row1, constraint.col2, constraint.row2, constraint.hAlign, constraint.vAlign);
            this.singleCell = this.row1 == this.row2 && this.col1 == this.col2;
            this.component = component;
        }

        public boolean equals(Object object) {
            boolean equal = false;
            if (object instanceof Component) {
                Component component = (Component)object;
                equal = this.component == component;
            }
            return equal;
        }
    }
}

