/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.scan;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.scan.DialogScan;
import transpo.system.util.Fonctions;

public class DialogCalibration
extends JDialog
implements MouseMotionListener {
    private boolean speedEnabled = System.getProperty("scan.speed", "0").equals("1");
    private Image backGround = null;
    private JScrollPane jsp = null;
    private JMarkedLabel picture = null;
    private Vector<Point> pt = null;
    private Vector<Integer> speed = null;
    private JButton btnEnregistrer;
    private JButton btnValider;
    private JButton btnQuitter;
    private JButton btnAnnuler;
    private int[][] position = null;
    Point lastDraggingPoint = null;

    public DialogCalibration(JDialog pere, Image backGround) {
        super(pere);
        this.backGround = backGround;
        this.setTitle(LanguageTranslator.getString("calibration.title"));
        if (this.speedEnabled) {
            this.setSize(755, 810);
        } else {
            this.setSize(530, 585);
        }
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getJsp(), "Center");
        this.getContentPane().add((Component)this.getPnlBtn(), "South");
        this.setVisible(true);
        this.position = this.loadLastPosition();
        this.setPosition(0);
        JOptionPane.showMessageDialog(this, LanguageTranslator.getString("calibration.position", String.valueOf(this.getPt().size() + 1)));
    }

    public JPanel getPnlBtn() {
        JPanel btn = new JPanel();
        btn.add(this.getBtnEnregistrer());
        btn.add(this.getBtnValider());
        btn.add(this.getBtnAnnuler());
        btn.add(this.getBtnQuitter());
        return btn;
    }

    public JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DialogCalibration.this.next(DialogCalibration.this.getJsp().getViewport().getViewPosition(), DialogCalibration.this.getPicture().getAdjustSpeedCircleSize());
                }
            });
        }
        return this.btnEnregistrer;
    }

    public JButton getBtnValider() {
        if (this.btnValider == null) {
            this.btnValider = new JButton(LanguageTranslator.getString("button.valid"));
            this.btnValider.setEnabled(false);
            this.btnValider.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DialogCalibration.this.savePosition();
                    DialogCalibration.this.dispose();
                }
            });
        }
        return this.btnValider;
    }

    public JButton getBtnAnnuler() {
        if (this.btnAnnuler == null) {
            this.btnAnnuler = new JButton(LanguageTranslator.getString("button.erase"));
            this.btnAnnuler.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DialogCalibration.this.back();
                }
            });
        }
        return this.btnAnnuler;
    }

    public JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DialogCalibration.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    public JScrollPane getJsp() {
        if (this.jsp == null) {
            this.jsp = new JScrollPane();
            this.jsp.setViewportView(this.getPicture());
            this.jsp.setMaximumSize(new Dimension(500, 500));
            this.jsp.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    DialogCalibration.this.getPicture().setOval(DialogCalibration.this.jsp.getViewport().getViewPosition());
                }
            });
            this.jsp.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    DialogCalibration.this.getPicture().setOval(DialogCalibration.this.jsp.getViewport().getViewPosition());
                }
            });
        }
        return this.jsp;
    }

    public JMarkedLabel getPicture() {
        if (this.picture == null && this.backGround != null) {
            this.picture = new JMarkedLabel();
            this.picture.setAutoscrolls(true);
            this.picture.setIcon(new ImageIcon(this.backGround));
            this.picture.addMouseMotionListener(this);
        }
        return this.picture;
    }

    public Vector<Point> getPt() {
        if (this.pt == null) {
            this.pt = new Vector();
        }
        return this.pt;
    }

    public Vector<Integer> getSpeed() {
        if (this.speed == null) {
            this.speed = new Vector();
        }
        return this.speed;
    }

    public void back() {
        if (this.getPt().size() != 0) {
            this.getPt().remove(this.getPt().size() - 1);
        }
        if (this.speedEnabled && this.getSpeed().size() != 0) {
            this.getSpeed().remove(this.getSpeed().size() - 1);
        }
        JOptionPane.showMessageDialog(this, LanguageTranslator.getString("calibration.position", String.valueOf(this.getPt().size() + 1)));
    }

    public void next(Point clicked, int speedValue) {
        this.getPt().add(clicked);
        if (this.speedEnabled) {
            this.getSpeed().add(speedValue);
        }
        if (!this.speedEnabled && this.getPt().size() == 6 || this.speedEnabled && this.getPt().size() == 3) {
            this.getBtnEnregistrer().setEnabled(false);
            this.getBtnValider().setEnabled(true);
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("calibration.validate"));
        } else {
            this.setPosition(this.getPt().size());
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("calibration.position", String.valueOf(this.getPt().size() + 1)));
        }
    }

    public void savePosition() {
        String toWrite = "";
        int x = 0;
        while (x < this.getPt().size()) {
            toWrite = String.valueOf(toWrite) + ";" + (int)this.getPt().get(x).getX() + "," + (int)this.getPt().get(x).getY();
            ++x;
        }
        if (this.speedEnabled) {
            String sp = "";
            int x2 = 0;
            while (x2 < this.getSpeed().size()) {
                sp = String.valueOf(sp) + ";" + this.getSpeed().get(x2);
                ++x2;
            }
            Preferences.userRoot().node("TIMS").put("IPS", toWrite.substring(1));
            Preferences.userRoot().node("TIMS").put("SP", sp.substring(1));
        } else {
            Preferences.userRoot().node("TIMS").put("IP", toWrite.substring(1));
        }
    }

    public int[][] loadLastPosition() {
        return Fonctions.getCroppingParameters(Preferences.userRoot().node("TIMS").get("IP" + (this.speedEnabled ? "S" : ""), this.speedEnabled ? "60,20;640,20;60,610" : "60,20;640,20;60,610;640,610;60,1220;640,1220"));
    }

    public void setPosition(int disc) {
        TimsLogger.debug("#dialogCalibration.setPosition#" + this.position[disc][0] + " " + this.position[disc][1]);
        this.getJsp().getViewport().setViewPosition(new Point(this.position[disc][0], this.position[disc][1]));
    }

    public int getRayonFromXY(int x, int y) {
        int rayon = 0;
        int xCenter = (int)this.getPicture().center.getX();
        int yCenter = (int)this.getPicture().center.getY();
        double angle = Math.atan2(xCenter - y, x - xCenter);
        rayon = x == xCenter ? yCenter - y : (int)Math.abs(Math.round((double)(x - xCenter) / Math.cos(angle)));
        return rayon;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.speedEnabled) {
            if (this.lastDraggingPoint == null) {
                this.lastDraggingPoint = e.getPoint();
            } else {
                int beginRayon = this.getRayonFromXY((int)this.lastDraggingPoint.getX(), (int)this.lastDraggingPoint.getY());
                int rayon = this.getRayonFromXY(e.getX(), e.getY());
                TimsLogger.debug("begin " + beginRayon + ", end " + rayon);
                if (beginRayon > rayon) {
                    this.getPicture().decreaseCircleSize(1);
                } else {
                    this.getPicture().increaseCircleSize(1);
                }
                this.lastDraggingPoint = e.getPoint();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.lastDraggingPoint = null;
    }

    public class JMarkedLabel
    extends JLabel {
        int x = 0;
        int y = 0;
        int xSpeed = 0;
        int ySpeed = 0;
        Point center = new Point(237, 237);
        int adjustSpeedCircleSize = 0;

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(Color.RED);
            g.drawOval(this.x, this.y, 475, 475);
            if (DialogCalibration.this.speedEnabled) {
                g.setColor(Color.GREEN);
                g.drawOval(this.xSpeed, this.ySpeed, 640 + this.adjustSpeedCircleSize, 640 + this.adjustSpeedCircleSize);
            }
        }

        public void setOval(Point point) {
            this.center.setLocation(point);
            this.center.translate(DialogScan.OPTIMIZED_IMAGE_SIZE / 2, DialogScan.OPTIMIZED_IMAGE_SIZE / 2);
            this.x = (int)this.center.getX() - 237;
            this.y = (int)this.center.getY() - 237;
            this.xSpeed = (int)this.center.getX() - 320;
            this.ySpeed = (int)this.center.getY() - 320;
            this.repaint();
        }

        public void decreaseCircleSize(int factor) {
            this.adjustSpeedCircleSize -= 2 * factor;
            this.xSpeed += factor;
            this.ySpeed += factor;
            this.repaint();
            TimsLogger.debug("adjust = " + this.adjustSpeedCircleSize + " " + this.xSpeed + " " + this.ySpeed + " " + this.x + " " + this.x);
        }

        public void increaseCircleSize(int factor) {
            this.adjustSpeedCircleSize += 2 * factor;
            this.xSpeed -= factor;
            this.ySpeed -= factor;
            this.repaint();
            TimsLogger.debug("adjust = " + this.adjustSpeedCircleSize + " " + this.xSpeed + " " + this.ySpeed + " " + this.x + " " + this.x);
        }

        public int getAdjustSpeedCircleSize() {
            return this.adjustSpeedCircleSize;
        }
    }
}

