/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.scan;

import fr.pgh.data.bdd.ActiviteConducteur;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.GraphJour;

public class DialogShowExistingActivity
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private int chosenOption = 1;
    private JPanel pnlGraphe = null;
    private JPanel pnlBtn = null;
    private JButton btnKeepOn = null;
    private JButton btnQuit = null;
    private GraphJour graphJour = null;
    private Vector<ActiviteConducteur> activite = null;
    private JPanel pnlTxt = null;
    private JLabel lblWarning = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogShowExistingActivity.dispose()#");
        super.dispose();
    }

    public DialogShowExistingActivity(JDialog owner, Vector<ActiviteConducteur> activite) {
        super(owner);
        TimsLogger.verbose("#DialogShowExistingActivity()#");
        this.activite = activite;
        this.initialize();
    }

    private void initialize() {
        this.setSize(600, 150);
        this.setUndecorated(true);
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getPnlGraphe(), "Center");
            this.jContentPane.add((Component)this.getPnlBtn(), "South");
            this.jContentPane.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        }
        return this.jContentPane;
    }

    private JPanel getPnlGraphe() {
        if (this.pnlGraphe == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 0.2;
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints1.gridy = 0;
            this.pnlGraphe = new JPanel();
            this.pnlGraphe.setLayout(new GridBagLayout());
            this.pnlGraphe.add((Component)this.getGraphJour(), gridBagConstraints1);
            this.pnlGraphe.add((Component)this.getPnlTxt(), new GridBagConstraints());
            this.pnlGraphe.add((Component)this.lblWarning, gridBagConstraints2);
        }
        return this.pnlGraphe;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.insets = new Insets(5, 5, 5, 5);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridy = 0;
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.add((Component)this.getBtnKeepOn(), gridBagConstraints11);
            this.pnlBtn.add((Component)this.getBtnQuit(), gridBagConstraints);
        }
        return this.pnlBtn;
    }

    private JButton getBtnKeepOn() {
        if (this.btnKeepOn == null) {
            this.btnKeepOn = new JButton();
            this.btnKeepOn.setText(LanguageTranslator.getString("button.yes"));
            this.btnKeepOn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogShowExistingActivity.this.chosenOption = 0;
                    DialogShowExistingActivity.this.dispose();
                }
            });
        }
        return this.btnKeepOn;
    }

    private JButton getBtnQuit() {
        if (this.btnQuit == null) {
            this.btnQuit = new JButton();
            this.btnQuit.setText(LanguageTranslator.getString("button.no"));
            this.btnQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogShowExistingActivity.this.chosenOption = 1;
                    DialogShowExistingActivity.this.dispose();
                }
            });
        }
        return this.btnQuit;
    }

    private GraphJour getGraphJour() {
        if (this.graphJour == null) {
            this.graphJour = new GraphJour();
            this.graphJour.initialiser(this.activite, 0, 0);
        }
        return this.graphJour;
    }

    private JPanel getPnlTxt() {
        if (this.pnlTxt == null) {
            this.lblWarning = new JLabel();
            this.lblWarning.setText(LanguageTranslator.getString("scan.existingActivity"));
            this.pnlTxt = new JPanel();
            this.pnlTxt.setLayout(new GridBagLayout());
        }
        return this.pnlTxt;
    }

    public static int showExistingActivity(JDialog pere, Vector<ActiviteConducteur> activite) {
        DialogShowExistingActivity tmp = new DialogShowExistingActivity(pere, activite);
        tmp.setVisible(true);
        return tmp.chosenOption;
    }
}

