/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.user;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.user.UserPreferences;

public class DialogPreferences
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JButton btnQuit = null;

    public DialogPreferences(Frame owner) {
        super(owner);
        this.setTitle(LanguageTranslator.getString("generics.preferences"));
        this.initialize();
    }

    private void initialize() {
        this.setSize(450, 500);
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel(new GridLayout(0, 1));
            UserPreferences.PREFERENCE[] pREFERENCEArray = UserPreferences.PREFERENCE.values();
            int n = pREFERENCEArray.length;
            int n2 = 0;
            while (n2 < n) {
                UserPreferences.PREFERENCE pref = pREFERENCEArray[n2];
                if (pref.updatable) {
                    this.jContentPane.add(this.preferencePanel(pref));
                }
                ++n2;
            }
            this.jContentPane.add(this.getBtnQuit());
        }
        return this.jContentPane;
    }

    public JPanel preferencePanel(final UserPreferences.PREFERENCE preference) {
        JPanel toReturn = new JPanel(new GridBagLayout());
        GridBagConstraints a = new GridBagConstraints();
        a.insets = new Insets(2, 5, 2, 5);
        GridBagConstraints b = new GridBagConstraints();
        b.gridx = 1;
        b.weightx = 1.0;
        b.insets = new Insets(2, 5, 2, 5);
        b.fill = 2;
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 2;
        c.insets = new Insets(2, 5, 2, 5);
        GridBagConstraints d = new GridBagConstraints();
        c.gridx = 3;
        c.insets = new Insets(2, 5, 2, 5);
        toReturn.add((Component)new JLabel(this.getLibelle(preference.libelle)), a);
        TimsLogger.debug(String.valueOf(preference.libelle) + " =>" + this.getValue(preference.libelle));
        if (preference.type.equals("boolean")) {
            JCheckBox relatedField = new JCheckBox("", (boolean)new Boolean("1".equals(this.getValue(preference.libelle))));
            relatedField.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        Preferences.userRoot().node("TIMS").remove(preference.libelle);
                    } else {
                        Preferences.userRoot().node("TIMS").put(preference.libelle, "1");
                    }
                }
            });
            toReturn.add((Component)relatedField, b);
        } else {
            final JTextField relatedField = new JTextField(this.getValue(preference.libelle));
            relatedField.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    String val = ((JTextField)e.getComponent()).getText();
                    if (val.equals("")) {
                        Preferences.userRoot().node("TIMS").remove(preference.libelle);
                    } else {
                        Preferences.userRoot().node("TIMS").put(preference.libelle, !preference.type.equals("boolean") ? ((JTextField)relatedField).getText() : (((JCheckBox)relatedField).isSelected() ? "1" : "0"));
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            toReturn.add((Component)relatedField, b);
            JButton delete = this.getBtnDelete();
            delete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimsLogger.verbose("removing preference " + preference.libelle);
                    Preferences.userRoot().node("TIMS").remove(preference.libelle);
                    if (preference.type.equals("boolean")) {
                        ((JCheckBox)relatedField).setSelected(false);
                    } else {
                        ((JTextField)relatedField).setText("");
                    }
                }
            });
            toReturn.add((Component)delete, d);
        }
        return toReturn;
    }

    private String getLibelle(String pnlType) {
        return LanguageTranslator.getString(pnlType);
    }

    private String getValue(String pnlType) {
        return Preferences.userRoot().node("TIMS").get(pnlType, null);
    }

    private JButton getBtnDelete() {
        JButton toReturn = new JButton();
        toReturn.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_sup"))));
        toReturn.setToolTipText(LanguageTranslator.getString("button.delete"));
        return toReturn;
    }

    private JButton getBtnQuit() {
        if (this.btnQuit == null) {
            this.btnQuit = new JButton(LanguageTranslator.getString("button.quit"));
            this.btnQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogPreferences.this.dispose();
                }
            });
        }
        return this.btnQuit;
    }
}

