/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.vehicule;

import fr.pgh.component.JNotificationFrame;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.JourUEV;
import fr.pgh.data.bdd.TypeActivite;
import fr.pgh.data.bdd.UevActivity;
import fr.pgh.data.bdd.VehicleComment;
import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.ViewPanel;
import transpo.system.ui.resources.Fmresources;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.CommentPopup;
import transpo.system.ui.views.PopupCaller;
import transpo.system.ui.views.vehicule.DriverActivitySelection;
import transpo.system.ui.views.vehicule.GrapheUEV;
import transpo.system.util.Fonctions;

public class PnlActiviteUEV
extends ViewPanel {
    private static final long serialVersionUID = 1L;
    private Vehicule vehicle = null;
    private ClassLoader cl = this.getClass().getClassLoader();
    private final Fmresources res = Transport.res;
    DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    GregorianCalendar calendar = new GregorianCalendar();
    private JScrollPane jspGraphe = null;
    private GrapheUEV grapheActivite = null;
    private JButton btnMoinsJour = null;
    private JButton btnJourPlus = null;
    private JTextField txtDate = null;
    private JButton btnAddSemaine = null;
    private JButton btnSupSemaine = null;
    private JPanel pnlGraphique = null;
    private JPanel pnlDate = null;
    private JPanel pnlBtn = null;
    private JLabel[] lblJour = new JLabel[7];
    private JButton[] btnCopy = new JButton[7];
    private CommentButton[] btnComment = new CommentButton[7];
    private JPanel pnlLegende = null;
    private JPanel pnlConduite = null;
    private JPanel pnlRepos = null;
    private JPanel pnlDispo = null;
    private JPanel pnlTravail = null;
    private JLabel lblConduite = null;
    private JLabel lblRepos = null;
    private JLabel lblDispo = null;
    private JLabel lblTravail = null;
    private CommentPopup commentPopup = null;

    public PnlActiviteUEV() {
        this.initialize();
    }

    public PnlActiviteUEV(Vehicule vehicle) {
        TimsLogger.verbose("#PnlActiviteUEV.PnlActiviteUEV#" + vehicle.getCleVehicule());
        this.vehicle = vehicle;
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.fill = 1;
        gridBagConstraints12.gridwidth = 5;
        gridBagConstraints12.insets = new Insets(5, 15, 0, 15);
        gridBagConstraints12.gridy = 3;
        GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
        gridBagConstraints22.gridx = 0;
        gridBagConstraints22.weightx = 0.0;
        gridBagConstraints22.weighty = 0.0;
        gridBagConstraints22.fill = 2;
        gridBagConstraints22.gridheight = 1;
        gridBagConstraints22.gridwidth = 5;
        gridBagConstraints22.insets = new Insets(10, 15, 0, 15);
        gridBagConstraints22.gridy = 2;
        GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
        gridBagConstraints31.gridx = 1;
        gridBagConstraints31.weightx = 1.0;
        gridBagConstraints31.gridy = 1;
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 3;
        gridBagConstraints21.weighty = 0.0;
        gridBagConstraints21.weightx = 1.0;
        gridBagConstraints21.gridy = 1;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.weightx = 2.0;
        gridBagConstraints3.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints3.gridx = 2;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 4;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridy = 1;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.gridy = 1;
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(750, 500));
        this.setBounds(new Rectangle(0, 0, 750, 525));
        this.add((Component)this.getBtnMoinsJour(), gridBagConstraints1);
        this.add((Component)this.getBtnJourPlus(), gridBagConstraints2);
        this.add((Component)this.getTxtDate(), gridBagConstraints3);
        this.add((Component)this.getBtnAddSemaine(), gridBagConstraints21);
        this.add((Component)this.getBtnSupSemaine(), gridBagConstraints31);
        this.add((Component)this.getPnlGraphique(), gridBagConstraints22);
        this.add((Component)this.getPnlLegende(), gridBagConstraints12);
    }

    @Override
    public void close() {
    }

    @Override
    public String getMnemo() {
        return null;
    }

    @Override
    public String getViewName() {
        return LanguageTranslator.getString("generics.activity");
    }

    @Override
    public void refresh() {
    }

    private GrapheUEV getGrapheActivite() {
        if (this.grapheActivite == null) {
            this.grapheActivite = new GrapheUEV();
        }
        return this.grapheActivite;
    }

    private JButton getBtnMoinsJour() {
        if (this.btnMoinsJour == null) {
            this.btnMoinsJour = new JButton();
            this.btnMoinsJour.setPreferredSize(new Dimension(32, 32));
            this.btnMoinsJour.setFocusable(false);
            this.btnMoinsJour.setIcon(new ImageIcon(this.cl.getResource(this.res.getResourceString("icone_left"))));
            this.btnMoinsJour.addActionListener(new ActionAddJour(-1));
        }
        return this.btnMoinsJour;
    }

    private JButton getBtnJourPlus() {
        if (this.btnJourPlus == null) {
            this.btnJourPlus = new JButton();
            this.btnJourPlus.setPreferredSize(new Dimension(32, 32));
            this.btnJourPlus.setFocusable(false);
            this.btnJourPlus.setIcon(new ImageIcon(this.cl.getResource(this.res.getResourceString("icone_right"))));
            this.btnJourPlus.addActionListener(new ActionAddJour(1));
        }
        return this.btnJourPlus;
    }

    private JTextField getTxtDate() {
        if (this.txtDate == null) {
            this.txtDate = new JTextField();
            this.txtDate.setText(this.dateFormat.format(new Date()));
            this.txtDate.setEditable(false);
            this.txtDate.setPreferredSize(new Dimension(70, 32));
            this.txtDate.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    PnlActiviteUEV.this.getDate();
                }
            });
        }
        return this.txtDate;
    }

    private void getDate() {
        if (Fonctions.afficheCalendrier(this.getTxtDate())) {
            this.affichageGraphe();
        }
    }

    public void setAffichage(Date date) {
        this.setAffichage(ConversionTime.dateToString(date, "dd/MM/yyyy"));
    }

    public void setAffichage(String sDate) {
        this.getTxtDate().setText(sDate);
        this.affichageGraphe();
    }

    @Override
    public void loadData() {
        if (!this.load) {
            this.affichageGraphe();
            this.load = true;
        }
    }

    public void affichageGraphe() {
        try {
            String dateCourante = this.getTxtDate().getText();
            this.setLabelDate(dateCourante);
            this.setComment(dateCourante);
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy", Locale.FRENCH);
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            Date dateField = df.parse(dateCourante);
            Vector<JourUEV> days = JourUEV.getJourUEV(dateField, ConversionTime.addDay(dateField, 7), 0, this.vehicle.getCleVehicule(), true);
            Vector[] act = new Vector[7];
            int x = 0;
            while (x < 7) {
                act[x] = new Vector();
                ++x;
            }
            for (JourUEV day : days) {
                int dayN = ConversionTime.getDaysBetween(dateField, day.getDay());
                dayN = ConversionTime.getDaysBetween(ConversionTime.dateTruncate(dateField), day.getDay());
                if (dayN > 6) break;
                TimsLogger.debug("\r\n#PnlActiviteUev# " + dayN + " => " + day.getActivities().size() + " (" + dateField + " - " + day.getDay() + "=> " + ConversionTime.dateTruncate(day.getDay()) + ")");
                act[dayN] = day.getActivities();
            }
            Vector<VehicleUsed>[] ins = Transport.bdd.getCycleInsertionCarteSemaine(this.vehicle.getCleVehicule(), ConversionTime.dateTruncate(dateField), 30);
            int x2 = 0;
            while (x2 < ins.length) {
                TimsLogger.debug("affichageGraphe " + x2 + " line => " + ins[x2].size() + " date " + dateField);
                ++x2;
            }
            this.getGrapheActivite().initialiser(act, ins, dateField);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    private void setLabelDate(String dateJour) {
        try {
            Date date_field = this.dateFormat.parse(dateJour);
            this.calendar.setTime(date_field);
            int x = 0;
            while (x < 7) {
                this.lblJour[x].setText(this.dateFormat.format(this.calendar.getTime()));
                this.calendar.add(5, 1);
                ++x;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setComment(String dateJour) {
        try {
            Date begin = this.dateFormat.parse(dateJour);
            Date end = ConversionTime.addDay(begin, 7);
            Vector<VehicleComment> list = VehicleComment.loadList(0, this.vehicle.getCleVehicule(), begin, end);
            Date current = begin;
            int x = 0;
            while (x < 7) {
                this.btnComment[x].setComment(null);
                for (VehicleComment comm : list) {
                    if (!comm.getDate().equals(current)) continue;
                    this.btnComment[x].setComment(comm);
                    break;
                }
                current = ConversionTime.addDay(current, 1);
                ++x;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JButton getBtnAddSemaine() {
        if (this.btnAddSemaine == null) {
            this.btnAddSemaine = new JButton();
            this.btnAddSemaine.setPreferredSize(new Dimension(32, 32));
            this.btnAddSemaine.setFocusable(false);
            this.btnAddSemaine.setIcon(new ImageIcon(this.cl.getResource(this.res.getResourceString("icone_dright"))));
            this.btnAddSemaine.addActionListener(new ActionAddJour(7));
        }
        return this.btnAddSemaine;
    }

    private JButton getBtnSupSemaine() {
        if (this.btnSupSemaine == null) {
            this.btnSupSemaine = new JButton();
            this.btnSupSemaine.setPreferredSize(new Dimension(32, 32));
            this.btnSupSemaine.setFocusable(false);
            this.btnSupSemaine.setIcon(new ImageIcon(this.cl.getResource(this.res.getResourceString("icone_dleft"))));
            this.btnSupSemaine.addActionListener(new ActionAddJour(-7));
        }
        return this.btnSupSemaine;
    }

    private JPanel getPnlGraphique() {
        if (this.pnlGraphique == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.weightx = 0.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.insets = new Insets(30, 0, 0, 0);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 2;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.weightx = 0.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.insets = new Insets(25, 0, 0, 0);
            this.pnlGraphique = new JPanel();
            this.pnlGraphique.setLayout(new GridBagLayout());
            this.pnlGraphique.setPreferredSize(new Dimension(700, 450));
            this.pnlGraphique.add((Component)this.getPnlDate(), gridBagConstraints4);
            this.pnlGraphique.add((Component)this.getJspGraphe(), gridBagConstraints);
            this.pnlGraphique.add((Component)this.getPnlBtn(), gridBagConstraints5);
        }
        return this.pnlGraphique;
    }

    private JScrollPane getJspGraphe() {
        if (this.jspGraphe == null) {
            this.jspGraphe = new JScrollPane();
            this.jspGraphe.setPreferredSize(new Dimension(0, 0));
            this.jspGraphe.setHorizontalScrollBarPolicy(32);
            this.jspGraphe.setVerticalScrollBarPolicy(21);
            this.jspGraphe.setViewportView(this.getGrapheActivite());
        }
        return this.jspGraphe;
    }

    private JPanel getPnlDate() {
        if (this.pnlDate == null) {
            int x = 0;
            while (x < 7) {
                this.lblJour[x] = new JLabel();
                ++x;
            }
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.anchor = 10;
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.gridy = 6;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.anchor = 10;
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.weighty = 1.0;
            gridBagConstraints10.gridy = 5;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.anchor = 10;
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.weighty = 1.0;
            gridBagConstraints9.gridy = 4;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.anchor = 10;
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.weighty = 1.0;
            gridBagConstraints8.gridy = 3;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.anchor = 10;
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.weighty = 1.0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.gridy = 2;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.weighty = 1.0;
            gridBagConstraints6.anchor = 10;
            gridBagConstraints6.gridy = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.anchor = 10;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.insets = new Insets(0, 0, 0, 0);
            this.pnlDate = new JPanel();
            this.pnlDate.setLayout(new GridBagLayout());
            this.pnlDate.add((Component)this.lblJour[0], gridBagConstraints5);
            this.pnlDate.add((Component)this.lblJour[1], gridBagConstraints6);
            this.pnlDate.add((Component)this.lblJour[2], gridBagConstraints7);
            this.pnlDate.add((Component)this.lblJour[3], gridBagConstraints8);
            this.pnlDate.add((Component)this.lblJour[4], gridBagConstraints9);
            this.pnlDate.add((Component)this.lblJour[5], gridBagConstraints10);
            this.pnlDate.add((Component)this.lblJour[6], gridBagConstraints11);
        }
        return this.pnlDate;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            int x = 0;
            while (x < 7) {
                this.btnCopy[x] = new JButton();
                this.btnCopy[x].setIcon(new ImageIcon(this.cl.getResource(this.res.getResourceString("uevCopy"))));
                this.btnCopy[x].setPreferredSize(new Dimension(42, 42));
                this.btnCopy[x].setToolTipText(LanguageTranslator.getString("generics.transfer"));
                this.btnCopy[x].addActionListener(new DayAffectation(x));
                ++x;
            }
            x = 0;
            while (x < 7) {
                this.btnComment[x] = new CommentButton(x);
                this.btnComment[x].setPreferredSize(new Dimension(42, 42));
                ++x;
            }
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            int gridx = 0;
            if (ConnexionSettings.getInstance().isAjoutable("ACTIVITE")) {
                GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
                gridBagConstraints11.anchor = 10;
                gridBagConstraints11.gridx = gridx;
                gridBagConstraints11.weightx = 1.0;
                gridBagConstraints11.weighty = 1.0;
                gridBagConstraints11.gridy = 6;
                GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
                gridBagConstraints10.anchor = 10;
                gridBagConstraints10.gridx = gridx;
                gridBagConstraints10.weightx = 1.0;
                gridBagConstraints10.weighty = 1.0;
                gridBagConstraints10.gridy = 5;
                GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
                gridBagConstraints9.anchor = 10;
                gridBagConstraints9.gridx = gridx;
                gridBagConstraints9.weightx = 1.0;
                gridBagConstraints9.weighty = 1.0;
                gridBagConstraints9.gridy = 4;
                GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
                gridBagConstraints8.anchor = 10;
                gridBagConstraints8.gridx = gridx;
                gridBagConstraints8.weightx = 1.0;
                gridBagConstraints8.weighty = 1.0;
                gridBagConstraints8.gridy = 3;
                GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
                gridBagConstraints7.anchor = 10;
                gridBagConstraints7.gridx = gridx;
                gridBagConstraints7.weighty = 1.0;
                gridBagConstraints7.weightx = 1.0;
                gridBagConstraints7.gridy = 2;
                GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
                gridBagConstraints6.gridx = gridx;
                gridBagConstraints6.weightx = 1.0;
                gridBagConstraints6.weighty = 1.0;
                gridBagConstraints6.anchor = 10;
                gridBagConstraints6.gridy = 1;
                GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
                gridBagConstraints5.gridx = gridx++;
                gridBagConstraints5.weightx = 1.0;
                gridBagConstraints5.anchor = 10;
                gridBagConstraints5.weighty = 1.0;
                gridBagConstraints5.insets = new Insets(0, 0, 0, 0);
                this.pnlBtn.add((Component)this.btnCopy[0], gridBagConstraints5);
                this.pnlBtn.add((Component)this.btnCopy[1], gridBagConstraints6);
                this.pnlBtn.add((Component)this.btnCopy[2], gridBagConstraints7);
                this.pnlBtn.add((Component)this.btnCopy[3], gridBagConstraints8);
                this.pnlBtn.add((Component)this.btnCopy[4], gridBagConstraints9);
                this.pnlBtn.add((Component)this.btnCopy[5], gridBagConstraints10);
                this.pnlBtn.add((Component)this.btnCopy[6], gridBagConstraints11);
            }
            if (ConnexionSettings.getInstance().isConsultable("COMMENTAIRE")) {
                GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
                gridBagConstraints18.anchor = 10;
                gridBagConstraints18.gridx = gridx;
                gridBagConstraints18.weightx = 1.0;
                gridBagConstraints18.weighty = 1.0;
                gridBagConstraints18.gridy = 6;
                gridBagConstraints18.insets = new Insets(0, 1, 0, 0);
                GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
                gridBagConstraints17.anchor = 10;
                gridBagConstraints17.gridx = gridx;
                gridBagConstraints17.weightx = 1.0;
                gridBagConstraints17.weighty = 1.0;
                gridBagConstraints17.gridy = 5;
                gridBagConstraints17.insets = new Insets(0, 1, 0, 0);
                GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
                gridBagConstraints16.anchor = 10;
                gridBagConstraints16.gridx = gridx;
                gridBagConstraints16.weightx = 1.0;
                gridBagConstraints16.weighty = 1.0;
                gridBagConstraints16.gridy = 4;
                gridBagConstraints16.insets = new Insets(0, 1, 0, 0);
                GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
                gridBagConstraints15.anchor = 10;
                gridBagConstraints15.gridx = gridx;
                gridBagConstraints15.weightx = 1.0;
                gridBagConstraints15.weighty = 1.0;
                gridBagConstraints15.gridy = 3;
                gridBagConstraints15.insets = new Insets(0, 1, 0, 0);
                GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
                gridBagConstraints14.anchor = 10;
                gridBagConstraints14.gridx = gridx;
                gridBagConstraints14.weighty = 1.0;
                gridBagConstraints14.weightx = 1.0;
                gridBagConstraints14.gridy = 2;
                gridBagConstraints14.insets = new Insets(0, 1, 0, 0);
                GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
                gridBagConstraints13.gridx = gridx;
                gridBagConstraints13.weightx = 1.0;
                gridBagConstraints13.weighty = 1.0;
                gridBagConstraints13.anchor = 10;
                gridBagConstraints13.gridy = 1;
                gridBagConstraints13.insets = new Insets(0, 1, 0, 0);
                GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
                gridBagConstraints12.gridx = gridx;
                gridBagConstraints12.weightx = 1.0;
                gridBagConstraints12.anchor = 10;
                gridBagConstraints12.weighty = 1.0;
                gridBagConstraints12.insets = new Insets(0, 1, 0, 0);
                this.pnlBtn.add((Component)this.btnComment[0], gridBagConstraints12);
                this.pnlBtn.add((Component)this.btnComment[1], gridBagConstraints13);
                this.pnlBtn.add((Component)this.btnComment[2], gridBagConstraints14);
                this.pnlBtn.add((Component)this.btnComment[3], gridBagConstraints15);
                this.pnlBtn.add((Component)this.btnComment[4], gridBagConstraints16);
                this.pnlBtn.add((Component)this.btnComment[5], gridBagConstraints17);
                this.pnlBtn.add((Component)this.btnComment[6], gridBagConstraints18);
            }
        }
        return this.pnlBtn;
    }

    private JPanel getPnlLegende() {
        if (this.pnlLegende == null) {
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.gridx = 7;
            gridBagConstraints20.insets = new Insets(0, 0, 0, 20);
            gridBagConstraints20.weightx = 1.0;
            gridBagConstraints20.anchor = 17;
            gridBagConstraints20.gridy = 0;
            this.lblTravail = new JLabel();
            this.lblTravail.setText(LanguageTranslator.getString("activity.work"));
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.gridx = 5;
            gridBagConstraints19.insets = new Insets(0, 0, 0, 20);
            gridBagConstraints19.weightx = 1.0;
            gridBagConstraints19.anchor = 17;
            gridBagConstraints19.gridy = 0;
            this.lblDispo = new JLabel();
            this.lblDispo.setText(LanguageTranslator.getString("activity.availability"));
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.gridx = 3;
            gridBagConstraints18.insets = new Insets(0, 0, 0, 20);
            gridBagConstraints18.weightx = 1.0;
            gridBagConstraints18.anchor = 17;
            gridBagConstraints18.gridy = 0;
            this.lblRepos = new JLabel();
            this.lblRepos.setText(LanguageTranslator.getString("activity.rest"));
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.gridx = 1;
            gridBagConstraints17.insets = new Insets(0, 0, 0, 20);
            gridBagConstraints17.weightx = 1.0;
            gridBagConstraints17.anchor = 17;
            gridBagConstraints17.gridy = 0;
            this.lblConduite = new JLabel();
            this.lblConduite.setText(LanguageTranslator.getString("activity.driving"));
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridx = 6;
            gridBagConstraints16.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints16.gridy = 0;
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.gridx = 4;
            gridBagConstraints15.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints15.gridy = 0;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 2;
            gridBagConstraints14.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints14.gridy = 0;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints13.gridy = 0;
            this.pnlLegende = new JPanel();
            this.pnlLegende.setLayout(new GridBagLayout());
            this.pnlLegende.setPreferredSize(new Dimension(0, 25));
            this.pnlLegende.add((Component)this.getPnlConduite(), gridBagConstraints13);
            this.pnlLegende.add((Component)this.getPnlRepos(), gridBagConstraints14);
            this.pnlLegende.add((Component)this.getPnlDispo(), gridBagConstraints15);
            this.pnlLegende.add((Component)this.getPnlTravail(), gridBagConstraints16);
            this.pnlLegende.add((Component)this.lblConduite, gridBagConstraints17);
            this.pnlLegende.add((Component)this.lblRepos, gridBagConstraints18);
            this.pnlLegende.add((Component)this.lblDispo, gridBagConstraints19);
            this.pnlLegende.add((Component)this.lblTravail, gridBagConstraints20);
        }
        return this.pnlLegende;
    }

    private JPanel getPnlConduite() {
        if (this.pnlConduite == null) {
            this.pnlConduite = new JPanel();
            this.pnlConduite.setLayout(new GridBagLayout());
            this.pnlConduite.setPreferredSize(new Dimension(15, 15));
            this.pnlConduite.setBorder(BorderFactory.createLineBorder(Color.black));
            try {
                this.pnlConduite.setBackground(new Color(TypeActivite.getActivityType(1).getColor()));
            }
            catch (Exception ex) {
                TimsLogger.warn("#PnlActivityUEV.getPnlConduite()# unable to load color for activity");
            }
        }
        return this.pnlConduite;
    }

    private JPanel getPnlRepos() {
        if (this.pnlRepos == null) {
            this.pnlRepos = new JPanel();
            this.pnlRepos.setLayout(new GridBagLayout());
            this.pnlRepos.setPreferredSize(new Dimension(15, 15));
            this.pnlRepos.setBorder(BorderFactory.createLineBorder(Color.black));
            try {
                this.pnlRepos.setBackground(new Color(TypeActivite.getActivityType(4).getColor()));
            }
            catch (Exception ex) {
                TimsLogger.warn("#PnlActivityUEV.getPnlRepos()# unable to load color for activity");
            }
        }
        return this.pnlRepos;
    }

    private JPanel getPnlDispo() {
        if (this.pnlDispo == null) {
            this.pnlDispo = new JPanel();
            this.pnlDispo.setLayout(new GridBagLayout());
            this.pnlDispo.setPreferredSize(new Dimension(15, 15));
            this.pnlDispo.setBorder(BorderFactory.createLineBorder(Color.black));
            try {
                this.pnlDispo.setBackground(new Color(TypeActivite.getActivityType(3).getColor()));
            }
            catch (Exception ex) {
                TimsLogger.warn("#PnlActivityUEV.getPnlDispo()# unable to load color for activity");
            }
        }
        return this.pnlDispo;
    }

    private JPanel getPnlTravail() {
        if (this.pnlTravail == null) {
            this.pnlTravail = new JPanel();
            this.pnlTravail.setLayout(new GridBagLayout());
            this.pnlTravail.setPreferredSize(new Dimension(15, 15));
            this.pnlTravail.setBorder(BorderFactory.createLineBorder(Color.black));
            try {
                this.pnlTravail.setBackground(new Color(TypeActivite.getActivityType(2).getColor()));
            }
            catch (Exception ex) {
                TimsLogger.warn("#PnlActivityUEV.getPnlTravail()# unable to load color for activity");
            }
        }
        return this.pnlTravail;
    }

    public void setVehicle(Vehicule vehicle) {
        this.vehicle = vehicle;
    }

    private CommentPopup getCommentPopup() {
        if (this.commentPopup == null) {
            this.commentPopup = new CommentPopup();
        }
        return this.commentPopup;
    }

    class ActionAddJour
    implements ActionListener {
        private int nbJour = 0;

        public ActionAddJour(int nb) {
            this.nbJour = nb;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String date_courante = PnlActiviteUEV.this.getTxtDate().getText();
                Date date_field = PnlActiviteUEV.this.dateFormat.parse(date_courante);
                PnlActiviteUEV.this.calendar.setTime(date_field);
                PnlActiviteUEV.this.calendar.add(5, this.nbJour);
                PnlActiviteUEV.this.getTxtDate().setText(PnlActiviteUEV.this.dateFormat.format(PnlActiviteUEV.this.calendar.getTime()));
                PnlActiviteUEV.this.affichageGraphe();
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
    }

    class CommentButton
    extends JButton
    implements PopupCaller,
    MouseListener {
        int x = 0;
        VehicleComment comment = null;

        public CommentButton(int x) {
            this.setToolTipText(LanguageTranslator.getString("generics.comment"));
            this.setIcon(new ImageIcon(PnlActiviteUEV.this.cl.getResource(PnlActiviteUEV.this.res.getResourceString("comment"))));
            this.x = x;
            if (ConnexionSettings.getInstance().isAjoutable("COMMENTAIRE")) {
                this.addMouseListener(this);
            }
        }

        public void setComment(VehicleComment comment) {
            this.comment = comment;
            this.reload();
        }

        public void reload() {
            if (this.comment != null) {
                this.setIcon(new ImageIcon(PnlActiviteUEV.this.cl.getResource(PnlActiviteUEV.this.res.getResourceString("redComment"))));
            } else {
                this.setIcon(new ImageIcon(PnlActiviteUEV.this.cl.getResource(PnlActiviteUEV.this.res.getResourceString("comment"))));
            }
            this.setToolTipText("<html>" + LanguageTranslator.getString("generics.comment") + (this.comment != null ? "<br>" + this.comment.getComment() : "") + "</html>");
        }

        @Override
        public void callPopup(MouseEvent e) {
            PnlActiviteUEV.this.getCommentPopup().setText(this.comment != null ? this.comment.getComment() : "");
            PnlActiviteUEV.this.getCommentPopup().show(this, 0, 0);
        }

        @Override
        public void submitPopup() {
            String inputComment = PnlActiviteUEV.this.getCommentPopup().getComment().getText();
            if (inputComment.equals("")) {
                if (this.comment != null) {
                    this.comment.delete();
                    this.comment = null;
                }
            } else {
                if (this.comment != null && inputComment.equals(this.comment.getComment())) {
                    return;
                }
                if (this.comment == null) {
                    this.comment = new VehicleComment(0, PnlActiviteUEV.this.vehicle.getCleVehicule(), ConversionTime.stringToDate(PnlActiviteUEV.this.lblJour[this.x].getText(), "dd/MM/yyyy"), inputComment, false);
                } else {
                    this.comment.setComment(inputComment);
                }
                this.comment.update();
            }
            this.reload();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.callPopup(e);
        }
    }

    class DayAffectation
    implements ActionListener {
        private int numJour;

        @Override
        public void actionPerformed(ActionEvent e) {
            DriverActivitySelection select = new DriverActivitySelection(MainFrameTransport.getInstance());
            select.setVisible(true);
            if (select.enregistrer) {
                Vector<ActiviteConducteur> toInsert = new Vector<ActiviteConducteur>();
                Vector<UevActivity> tmp = PnlActiviteUEV.this.getGrapheActivite().getActivityAt(this.numJour);
                for (UevActivity activite : tmp) {
                    toInsert.add(activite.toDriverActivity(select.getSelected()));
                }
                if (Fonctions.saveDriverActivities(toInsert, select.getSelected(), 0, PnlActiviteUEV.this.vehicle.getRegistrationNumber()) == 2) {
                    JNotificationFrame statusFrame = JNotificationFrame.getFrame(JNotificationFrame.Corner.BOTTOM_RIGHT);
                    statusFrame.addMessage(LanguageTranslator.getString("message.done"), new JLabel(LanguageTranslator.getString("activity.transfer.done", ConversionTime.dateToString(toInsert.get(0).getDate(), "dd/MM/yyyy"), String.valueOf(toInsert.size()), select.getSelected().toString())), new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_valid"))));
                    statusFrame.showNotification(6);
                } else {
                    JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("activity.insert.error"), LanguageTranslator.getString("message.saveError"), 0);
                }
            }
        }

        public DayAffectation(int nb) {
            this.numJour = nb;
        }
    }
}

