/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.vehicule;

import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.ViewPanel;
import transpo.system.ui.modele.TMIO;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class PnlInputOutput
extends ViewPanel {
    private static final long serialVersionUID = 1L;
    private TMIO modeleIO = null;
    private Vehicule vehicle = null;
    private JScrollPane jspTableIO = null;
    private JTable tableIO = null;
    private Vector<VehicleUsed> ioList = null;

    public PnlInputOutput() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(600, 300));
        this.add((Component)this.getJspTableIO(), gridBagConstraints);
    }

    @Override
    public void close() {
    }

    @Override
    public String getMnemo() {
        return null;
    }

    @Override
    public String getViewName() {
        return LanguageTranslator.getString("vehicle.io");
    }

    @Override
    public void refresh() {
    }

    private JScrollPane getJspTableIO() {
        if (this.jspTableIO == null) {
            this.jspTableIO = new JScrollPane();
            this.jspTableIO.setViewportView(this.getTableIO());
        }
        return this.jspTableIO;
    }

    private JTable getTableIO() {
        if (this.tableIO == null) {
            this.tableIO = new JTable();
            this.tableIO.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (PnlInputOutput.this.modeleIO == null) {
                        return;
                    }
                    String selectedDate = PnlInputOutput.this.modeleIO.getValueAt(PnlInputOutput.this.tableIO.getSelectedRow(), 0).toString();
                    MainFrameTransport.getInstance().setActiviteVehicule(selectedDate);
                }
            });
        }
        return this.tableIO;
    }

    @Override
    public void loadData() {
        if (!this.load) {
            this.loadTable();
            this.load = true;
        }
    }

    public void setVehicle(Vehicule current) {
        this.vehicle = current;
        this.load = false;
    }

    private void loadTable() {
        if (this.vehicle == null) {
            return;
        }
        this.ioList = VehicleUsed.loadListVehicle(0, this.vehicle.getCleVehicule(), null, null);
        this.modeleIO = new TMIO(this.ioList);
        this.getTableIO().setModel(this.modeleIO);
        Fonctions.centrerTable(this.tableIO);
    }

    public Vector<VehicleUsed> getIOList() {
        return this.ioList;
    }
}

