/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.vehicule;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.UevSpeed;
import fr.pgh.data.bdd.Vehicule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import transpo.system.TimsLogger;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.ViewPanel;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.TMSpeed;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class PnlSpeedUEV
extends ViewPanel {
    TMSpeed listeModele = null;
    private Vehicule current = null;
    JTable jTable = new JTable();
    JPanel pnlFilter = null;
    JTextField txtBegin = null;
    JTextField txtEnd = null;
    JCheckBox cbAccuracy = null;
    JPanel jPanel3 = new JPanel();
    JScrollPane jScrollPane2 = new JScrollPane();
    private JComboBox cbDriver = null;

    @Override
    public String getViewName() {
        return LanguageTranslator.getString("vehicle.speed");
    }

    @Override
    public void refresh() {
        this.loadTable();
    }

    @Override
    public void close() {
    }

    @Override
    public String getMnemo() {
        return "";
    }

    public PnlSpeedUEV() throws HeadlessException {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPnlFilter(), "North");
        this.add((Component)this.jPanel3, "Center");
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.add((Component)this.jScrollPane2, "Center");
        this.jScrollPane2.setPreferredSize(new Dimension(800, 500));
        this.jScrollPane2.getViewport().add((Component)this.jTable, null);
        this.jTable.setSelectionMode(0);
        this.jTable.setRowHeight(21);
    }

    private JPanel getPnlFilter() {
        if (this.pnlFilter == null) {
            this.pnlFilter = new JPanel();
            this.pnlFilter.setLayout(new GridBagLayout());
            this.pnlFilter.add((Component)this.getTxtBegin(), Fonctions.getGridBagConstraints(0, 0));
            this.pnlFilter.add((Component)this.getTxtEnd(), Fonctions.getGridBagConstraints(1, 0));
            this.pnlFilter.add((Component)this.getCbAccuracy(), Fonctions.getGridBagConstraints(2, 0));
        }
        return this.pnlFilter;
    }

    private JTextField getTxtBegin() {
        if (this.txtBegin == null) {
            this.txtBegin = new JTextField();
            this.txtBegin.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (Fonctions.afficheCalendrier(PnlSpeedUEV.this.txtBegin)) {
                        TimsLogger.debug("what");
                        PnlSpeedUEV.this.refresh();
                    } else {
                        TimsLogger.debug("hein");
                    }
                }
            });
        }
        return this.txtBegin;
    }

    private JTextField getTxtEnd() {
        if (this.txtEnd == null) {
            this.txtEnd = new JTextField();
            this.txtEnd.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (Fonctions.afficheCalendrier(PnlSpeedUEV.this.txtEnd)) {
                        PnlSpeedUEV.this.refresh();
                    }
                }
            });
        }
        return this.txtEnd;
    }

    private JCheckBox getCbAccuracy() {
        if (this.cbAccuracy == null) {
            this.cbAccuracy = new JCheckBox("voir les survitesses issues de l'analyse des vitesses instantan\u00e9es");
            this.cbAccuracy.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PnlSpeedUEV.this.refresh();
                }
            });
        }
        return this.cbAccuracy;
    }

    @Override
    public void loadData() {
        if (!this.load) {
            this.loadTable();
            this.load = true;
        }
    }

    public void setVehicle(Vehicule current) {
        this.current = current;
        this.load = false;
    }

    public void loadTable() {
        TimsLogger.debug("load");
        String begin = this.getTxtBegin().getText().equals("") ? "" : ConversionTime.dateFromFranceToBDD(this.getTxtBegin().getText(), false);
        String end = this.getTxtEnd().getText().equals("") ? "" : ConversionTime.dateFromFranceToBDD(this.getTxtEnd().getText(), false);
        ArrayList<UevSpeed> listeAnomalie = UevSpeed.load(this.current.getCleVehicule(), begin, end, this.getCbAccuracy().isSelected() ? 0 : 1);
        this.listeModele = new TMSpeed(listeAnomalie);
        this.jTable.setModel(this.listeModele);
        this.jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PnlSpeedUEV.this.jTable.getSelectedColumn() < 4) {
                    String selectedDate = PnlSpeedUEV.this.listeModele.getValueAt(PnlSpeedUEV.this.jTable.getSelectedRow(), 0).toString();
                    MainFrameTransport.getInstance().setActiviteVehicule(selectedDate);
                }
            }
        });
        this.cbModificationEditor(this.jTable.getColumnModel().getColumn(5));
    }

    private void cbModificationEditor(TableColumn col) {
        col.setCellEditor(new DefaultCellEditor(this.getCbDriver()){

            @Override
            public Object getCellEditorValue() {
                ComboBoxModel cbModel = (ComboBoxModel)((JComboBox)this.editorComponent).getModel();
                return cbModel.getObjectAt(PnlSpeedUEV.this.getCbDriver().getSelectedIndex());
            }
        });
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText("Selection");
        col.setCellRenderer(renderer);
    }

    private JComboBox getCbDriver() {
        if (this.cbDriver == null) {
            this.cbDriver = Fonctions.getCustomizedCB();
            this.cbDriver.setModel(new ComboBoxModel(Conducteur.getList(), true, LanguageTranslator.getString("generics.none")));
        }
        return this.cbDriver;
    }
}

