/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.vehicule;

import fr.pgh.component.JTextDate;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.FuelConsumption;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Ellipse2D;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleInsets;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.ViewPanel;
import transpo.system.ui.modele.TMConsumption;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.DialogConsumption;
import transpo.system.util.Fonctions;

public class PnlVehicleConsumption
extends ViewPanel
implements Observer,
DataListener {
    private static final long serialVersionUID = 1L;
    private static final String MONTH_FORMAT = "MMM yyyy";
    private static final String WEEK_FORMAT = "w yy";
    private static final String DAY_FORMAT = "dd/MM/yy";
    private JPanel pnlConsumption = null;
    private Vehicule current = null;
    private JLabel lblTarget = null;
    private JTextField txtTarget = null;
    private JButton btnUpdate = null;
    private ChartPanel pnlConso = null;
    private ChartPanel pnlStop = null;
    private JFreeChart chartConso = null;
    private JFreeChart chartStop = null;
    private DefaultCategoryDataset chartData;
    private JPanel pnlTbl = null;
    private JScrollPane jspTbl = null;
    private JTable tblConso = null;
    private JPanel pnlBtn = null;
    private JButton btnUpdateCons = null;
    private JButton btnAddCons = null;
    private JPanel pnlFilter = null;
    private JTextDate txtBegin = null;
    private JTextDate txtEnd = null;
    private JComboBox cbGroup = null;
    private JButton btnRefresh = null;
    private Vector<FuelConsumption> fullList = null;
    DefaultCategoryDataset chartDataKm = null;
    DefaultCategoryDataset cdBrake = null;
    DefaultCategoryDataset cdLoad = null;
    DefaultCategoryDataset cdDenivele = null;
    DefaultCategoryDataset cdStop = null;

    @Override
    public String getViewName() {
        return LanguageTranslator.getString("generics.consumption");
    }

    @Override
    public void refresh() {
    }

    @Override
    public void close() {
    }

    @Override
    public String getMnemo() {
        return "";
    }

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        if (dataEvent instanceof BddEvent) {
            BddEvent e = (BddEvent)dataEvent;
            e.getTable().equals("t_conducteur");
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        TimsLogger.verbose("#" + this.getClass() + ".update# a faire");
    }

    public PnlVehicleConsumption() {
        LanguageTranslator.getInstance().addObserver(this);
        this.initialize();
        Transport.bdd.addDataListener(this);
    }

    private void initialize() {
        this.setMaximumSize(new Dimension(600, 341));
        this.setMinimumSize(new Dimension(600, 341));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getPnlConsumption(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 2, 18, null));
    }

    private JPanel getPnlConsumption() {
        if (this.pnlConsumption == null) {
            this.lblTarget = new JLabel(LanguageTranslator.getString("consumption.target"));
            GridBagConstraints l0c0 = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 2, 18, new Insets(0, 3, 0, 3));
            GridBagConstraints l0c1 = Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 2, 17, new Insets(0, 5, 0, 0));
            this.pnlConsumption = new JPanel();
            this.pnlConsumption.setLayout(new GridBagLayout());
            this.pnlConsumption.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("consumption.synthesis"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlConsumption.add((Component)this.getPnlLeft(), l0c0);
            this.pnlConsumption.add((Component)this.getPnlRight(), l0c1);
        }
        return this.pnlConsumption;
    }

    private JPanel getPnlLeft() {
        JPanel toReturn = new JPanel();
        toReturn.setLayout(new GridBagLayout());
        GridBagConstraints l0c0 = Fonctions.getGridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 2, 17, new Insets(0, 3, 0, 3));
        GridBagConstraints l1c0 = Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 0, 17, new Insets(0, 3, 0, 3));
        GridBagConstraints l1c1 = Fonctions.getGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 0, 17, new Insets(0, 5, 0, 0));
        GridBagConstraints l1c2 = Fonctions.getGridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 0, 17, new Insets(5, 5, 5, 0));
        GridBagConstraints l2c0 = Fonctions.getGridBagConstraints(0, 2, 1, 3, 0.0, 0.0, 2, 17, new Insets(0, 3, 0, 3));
        toReturn.add((Component)this.getPnlFilter(), l0c0);
        toReturn.add((Component)this.lblTarget, l1c0);
        toReturn.add((Component)this.getTxtTarget(), l1c1);
        toReturn.add((Component)this.getBtnUpdate(), l1c2);
        toReturn.add((Component)this.getPnlTbl(), l2c0);
        return toReturn;
    }

    private JPanel getPnlRight() {
        JPanel toReturn = new JPanel();
        toReturn.setLayout(new GridBagLayout());
        GridBagConstraints l0c0 = Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 2, 18, new Insets(0, 3, 0, 3));
        GridBagConstraints l1c0 = Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 2, 18, new Insets(0, 3, 0, 3));
        toReturn.add((Component)this.getPnlConso(), l0c0);
        toReturn.add((Component)this.getPnlStop(), l1c0);
        return toReturn;
    }

    private JPanel getPnlTbl() {
        if (this.pnlTbl == null) {
            this.pnlTbl = new JPanel();
            this.pnlTbl.setLayout(new GridBagLayout());
            this.pnlTbl.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("consumption.details"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlTbl.add((Component)this.getJspList(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(0, 3, 0, 3)));
            this.pnlTbl.add((Component)this.getPnlBtn(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 0, 17, new Insets(0, 3, 0, 3)));
        }
        return this.pnlTbl;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            if (ConnexionSettings.getInstance().isModifiable("CONSOMMATION")) {
                this.pnlBtn.add(this.getBtnUpdateCons());
            }
            if (ConnexionSettings.getInstance().isAjoutable("CONSOMMATION")) {
                this.pnlBtn.add(this.getBtnAdd());
            }
        }
        return this.pnlBtn;
    }

    private JButton getBtnUpdateCons() {
        if (this.btnUpdateCons == null) {
            this.btnUpdateCons = new JButton();
            this.btnUpdateCons.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_loupe"))));
            this.btnUpdateCons.setPreferredSize(new Dimension(25, 25));
            this.btnUpdateCons.setToolTipText(LanguageTranslator.getString("button.update"));
            this.btnUpdateCons.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FuelConsumption toShow = ((TMConsumption)PnlVehicleConsumption.this.getTblConso().getModel()).getRow(PnlVehicleConsumption.this.getTblConso().getSelectedRow());
                    PnlVehicleConsumption.this.seeCons(toShow);
                }
            });
        }
        return this.btnUpdateCons;
    }

    private JButton getBtnAdd() {
        if (this.btnAddCons == null) {
            this.btnAddCons = new JButton();
            this.btnAddCons.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_cliq"))));
            this.btnAddCons.setPreferredSize(new Dimension(25, 25));
            this.btnAddCons.setToolTipText(LanguageTranslator.getString("button.add"));
            this.btnAddCons.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlVehicleConsumption.this.seeCons(null);
                }
            });
        }
        return this.btnAddCons;
    }

    public void seeCons(FuelConsumption toShow) {
        DialogConsumption tmp = new DialogConsumption(MainFrameTransport.getInstance());
        if (toShow != null) {
            tmp.setConsumption(toShow);
        } else {
            tmp.setVehicle(this.current);
        }
        tmp.setVisible(true);
        this.reloadConso();
    }

    private JScrollPane getJspList() {
        if (this.jspTbl == null) {
            this.jspTbl = new JScrollPane();
            this.jspTbl.setViewportView(this.getTblConso());
        }
        return this.jspTbl;
    }

    private JTable getTblConso() {
        if (this.tblConso == null) {
            this.tblConso = new JTable();
        }
        return this.tblConso;
    }

    private JTextField getTxtTarget() {
        if (this.txtTarget == null) {
            this.txtTarget = new JTextField();
            this.txtTarget.setMinimumSize(new Dimension(70, 20));
            this.txtTarget.setPreferredSize(new Dimension(80, 20));
        }
        return this.txtTarget;
    }

    private JButton getBtnUpdate() {
        if (this.btnUpdate == null) {
            this.btnUpdate = new JButton();
            this.btnUpdate.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_save"))));
            this.btnUpdate.setPreferredSize(new Dimension(25, 25));
            this.btnUpdate.setToolTipText(LanguageTranslator.getString("button.update"));
            this.btnUpdate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlVehicleConsumption.this.save();
                }
            });
        }
        return this.btnUpdate;
    }

    public void save() {
        if (!this.check()) {
            return;
        }
        if (!this.current.compareAndUpdateConsumption(Float.parseFloat(this.getTxtTarget().getText()))) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.saveError"), LanguageTranslator.getString("message.error"), 0);
        }
    }

    public boolean check() {
        boolean toReturn = true;
        if (!Fonctions.isFloat(this.getTxtTarget().getText())) {
            this.getTxtTarget().setBackground(new Color(255, 192, 203));
            this.getTxtTarget().setToolTipText(LanguageTranslator.getString("generics.incorrectValue"));
            toReturn = false;
        }
        return toReturn;
    }

    private ChartPanel getPnlConso() {
        if (this.pnlConso == null) {
            this.pnlConso = new ChartPanel(this.getChartConso());
            this.pnlConso.setPopupMenu(null);
            this.pnlConso.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    ChartEntity tmp = PnlVehicleConsumption.this.getPnlConso().getEntityForPoint(e.getPoint().x, e.getPoint().y);
                    if (tmp instanceof CategoryItemEntity) {
                        String clickedPeriod = ((CategoryItemEntity)tmp).getColumnKey().toString();
                        if (SwingUtilities.isLeftMouseButton(e)) {
                            TimsLogger.debug("#PnlVehicleConsumption# on zoom dans la p\u00e9riode " + clickedPeriod + " (" + PnlVehicleConsumption.this.getCbGroup().getSelectedItem() + ")");
                            if (PnlVehicleConsumption.this.getCbGroup().getSelectedItem().equals(LanguageTranslator.getString("generics.month"))) {
                                Date day = ConversionTime.stringToDate(clickedPeriod, PnlVehicleConsumption.MONTH_FORMAT);
                                PnlVehicleConsumption.this.getTxtBegin().setText(ConversionTime.getFirstDayOfMonth(day, ConversionTime.STRING).toString());
                                PnlVehicleConsumption.this.getTxtEnd().setText(ConversionTime.getLastDayOfMonth(day, ConversionTime.STRING).toString());
                                PnlVehicleConsumption.this.getCbGroup().setSelectedItem(LanguageTranslator.getString("generics.week"));
                                PnlVehicleConsumption.this.reloadConso();
                            } else if (PnlVehicleConsumption.this.getCbGroup().getSelectedItem().equals(LanguageTranslator.getString("generics.week"))) {
                                int idx = clickedPeriod.indexOf(" ");
                                clickedPeriod = clickedPeriod.substring(idx);
                                Date day = ConversionTime.stringToDate(clickedPeriod, PnlVehicleConsumption.WEEK_FORMAT);
                                PnlVehicleConsumption.this.getTxtBegin().setText(ConversionTime.getFirstDayOfWeek(day, ConversionTime.STRING).toString());
                                PnlVehicleConsumption.this.getTxtEnd().setText(ConversionTime.getLastDayOfWeek(day, ConversionTime.STRING).toString());
                                PnlVehicleConsumption.this.getCbGroup().setSelectedItem(LanguageTranslator.getString("generics.day"));
                                PnlVehicleConsumption.this.reloadConso();
                            }
                        } else if (SwingUtilities.isRightMouseButton(e)) {
                            TimsLogger.debug("#PnlVehicleConsumption# on dezoom dans la p\u00e9riode " + clickedPeriod + " (" + PnlVehicleConsumption.this.getCbGroup().getSelectedItem() + ")");
                            if (PnlVehicleConsumption.this.getCbGroup().getSelectedItem().equals(LanguageTranslator.getString("generics.week"))) {
                                int idx = clickedPeriod.indexOf(" ");
                                clickedPeriod = clickedPeriod.substring(idx);
                                Date day = ConversionTime.stringToDate(clickedPeriod, PnlVehicleConsumption.WEEK_FORMAT);
                                PnlVehicleConsumption.this.getTxtBegin().setText(ConversionTime.getFirstDayOfYear(day, ConversionTime.STRING).toString());
                                PnlVehicleConsumption.this.getTxtEnd().setText(ConversionTime.getLastDayOfYear(day, ConversionTime.STRING).toString());
                                PnlVehicleConsumption.this.getCbGroup().setSelectedItem(LanguageTranslator.getString("generics.month"));
                                PnlVehicleConsumption.this.reloadConso();
                            } else if (PnlVehicleConsumption.this.getCbGroup().getSelectedItem().equals(LanguageTranslator.getString("generics.day"))) {
                                Date day = ConversionTime.stringToDate(clickedPeriod, PnlVehicleConsumption.DAY_FORMAT);
                                PnlVehicleConsumption.this.getTxtBegin().setText(ConversionTime.getFirstDayOfMonth(day, ConversionTime.STRING).toString());
                                PnlVehicleConsumption.this.getTxtEnd().setText(ConversionTime.getLastDayOfMonth(day, ConversionTime.STRING).toString());
                                PnlVehicleConsumption.this.getCbGroup().setSelectedItem(LanguageTranslator.getString("generics.week"));
                                PnlVehicleConsumption.this.reloadConso();
                            }
                        }
                    }
                }
            });
        }
        return this.pnlConso;
    }

    private JPanel getPnlStop() {
        if (this.pnlStop == null) {
            this.pnlStop = new ChartPanel(this.getChartStop());
            this.pnlStop.setPreferredSize(new Dimension(0, 200));
        }
        return this.pnlStop;
    }

    private JFreeChart getChartConso() {
        if (this.chartConso == null) {
            ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
            this.chartConso = ChartFactory.createStackedBarChart((String)LanguageTranslator.getString("fuel.consumption"), (String)"", (String)LanguageTranslator.getString("fuel.consumptionPer100"), (CategoryDataset)this.getChartData(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        }
        return this.chartConso;
    }

    private JFreeChart getChartStop() {
        if (this.chartStop == null) {
            ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
            this.chartStop = ChartFactory.createStackedBarChart((String)LanguageTranslator.getString("generics.stop"), (String)"", (String)LanguageTranslator.getString("generics.percent"), (CategoryDataset)this.getCdStop(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        }
        return this.chartStop;
    }

    private JPanel getPnlFilter() {
        if (this.pnlFilter == null) {
            GridBagConstraints l0c0 = Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(0, 3, 0, 3));
            GridBagConstraints l0c1 = Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(0, 3, 0, 3));
            GridBagConstraints l0c2 = Fonctions.getGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(0, 3, 0, 3));
            GridBagConstraints l0c3 = Fonctions.getGridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(0, 5, 0, 0));
            GridBagConstraints l0c4 = Fonctions.getGridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(0, 5, 0, 0));
            GridBagConstraints l0c5 = Fonctions.getGridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(0, 3, 0, 3));
            this.pnlFilter = new JPanel();
            this.pnlFilter.setLayout(new GridBagLayout());
            this.pnlFilter.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.filter"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlFilter.add((Component)new JLabel(LanguageTranslator.getString("generics.from")), l0c0);
            this.pnlFilter.add((Component)this.getTxtBegin(), l0c1);
            this.pnlFilter.add((Component)new JLabel(LanguageTranslator.getString("generics.to")), l0c2);
            this.pnlFilter.add((Component)this.getTxtEnd(), l0c3);
            this.pnlFilter.add((Component)this.getCbGroup(), l0c4);
            this.pnlFilter.add((Component)this.getBtnRefresh(), l0c5);
        }
        return this.pnlFilter;
    }

    private JTextDate getTxtBegin() {
        if (this.txtBegin == null) {
            this.txtBegin = new JTextDate();
            this.txtBegin.setText(ConversionTime.getFirstDayOfMonth(new Date(), ConversionTime.STRING).toString());
            this.txtBegin.setMinimumSize(new Dimension(70, 20));
            this.txtBegin.setPreferredSize(new Dimension(80, 20));
        }
        return this.txtBegin;
    }

    private JTextDate getTxtEnd() {
        if (this.txtEnd == null) {
            this.txtEnd = new JTextDate();
            this.txtEnd.setText(ConversionTime.dateToString(new Date(), "dd/MM/yyyy"));
            this.txtEnd.setMinimumSize(new Dimension(70, 20));
            this.txtEnd.setPreferredSize(new Dimension(80, 20));
        }
        return this.txtEnd;
    }

    private JComboBox getCbGroup() {
        if (this.cbGroup == null) {
            this.cbGroup = Fonctions.getCustomizedCB();
            this.cbGroup.addItem(LanguageTranslator.getString("generics.month"));
            this.cbGroup.addItem(LanguageTranslator.getString("generics.week"));
            this.cbGroup.addItem(LanguageTranslator.getString("generics.day"));
        }
        return this.cbGroup;
    }

    private JButton getBtnRefresh() {
        if (this.btnRefresh == null) {
            this.btnRefresh = new JButton();
            this.btnRefresh.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_refresh"))));
            this.btnRefresh.setPreferredSize(new Dimension(25, 25));
            this.btnRefresh.setToolTipText(LanguageTranslator.getString("button.update"));
            this.btnRefresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlVehicleConsumption.this.reloadConso();
                }
            });
        }
        return this.btnRefresh;
    }

    private DefaultCategoryDataset getChartData() {
        if (this.chartData == null) {
            this.chartData = new DefaultCategoryDataset();
        }
        return this.chartData;
    }

    private DefaultCategoryDataset getChartDataKm() {
        if (this.chartDataKm == null) {
            this.chartDataKm = new DefaultCategoryDataset();
        }
        return this.chartDataKm;
    }

    private DefaultCategoryDataset getCdBrake() {
        if (this.cdBrake == null) {
            this.cdBrake = new DefaultCategoryDataset();
        }
        return this.cdBrake;
    }

    private DefaultCategoryDataset getCdLoad() {
        if (this.cdLoad == null) {
            this.cdLoad = new DefaultCategoryDataset();
        }
        return this.cdLoad;
    }

    private DefaultCategoryDataset getCdDenivele() {
        if (this.cdDenivele == null) {
            this.cdDenivele = new DefaultCategoryDataset();
        }
        return this.cdDenivele;
    }

    private DefaultCategoryDataset getCdStop() {
        if (this.cdStop == null) {
            this.cdStop = new DefaultCategoryDataset();
        }
        return this.cdStop;
    }

    @Override
    public void loadData() {
        if (!this.load) {
            this.reloadConso();
            this.load = true;
        }
    }

    public void setVehicle(Vehicule current) {
        this.current = current;
        this.load = false;
        this.getTxtTarget().setText(String.valueOf(current.getTargetConsumption()));
    }

    private void reloadConso() {
        this.getChartData().clear();
        this.getChartDataKm().clear();
        this.getCdBrake().clear();
        this.getCdLoad().clear();
        this.getCdDenivele().clear();
        this.getCdStop().clear();
        Date day = this.getTxtEnd().getDate();
        Date old = this.getTxtBegin().getDate();
        this.fullList = FuelConsumption.loadList(0, 0, this.current.getId(), old, day);
        String selected = this.getCbGroup().getSelectedItem().toString();
        int type = 3;
        if (selected.equals(LanguageTranslator.getString("generics.month"))) {
            type = 2;
        } else if (selected.equals(LanguageTranslator.getString("generics.day"))) {
            type = 5;
        }
        Vector<FuelConsumption> list = FuelConsumption.loadTotal(this.fullList, 2, type);
        this.getTblConso().setModel(new TMConsumption(this.fullList, null));
        Fonctions.centrerTable(this.getTblConso());
        if (list != null) {
            String format = type == 3 ? WEEK_FORMAT : (type == 2 ? MONTH_FORMAT : DAY_FORMAT);
            String adding = type == 3 ? String.valueOf(LanguageTranslator.getString("generics.w")) + " " : "";
            for (FuelConsumption tmp : list) {
                String period = String.valueOf(adding) + ConversionTime.dateToString(tmp.getDate(), format);
                if (this.current.getTargetConsumption() != 0.0f && tmp.getConsumption() > this.current.getTargetConsumption()) {
                    this.getChartData().addValue((double)this.current.getTargetConsumption(), (Comparable)((Object)LanguageTranslator.getString("fuel.consumption")), (Comparable)((Object)period));
                    this.getChartData().addValue((double)(tmp.getConsumption() - this.current.getTargetConsumption()), (Comparable)((Object)LanguageTranslator.getString("fuel.overconsumption")), (Comparable)((Object)period));
                } else {
                    this.getChartData().addValue((double)tmp.getConsumption(), (Comparable)((Object)LanguageTranslator.getString("fuel.consumption")), (Comparable)((Object)period));
                }
                this.getChartDataKm().addValue((double)tmp.getKm(), (Comparable)((Object)LanguageTranslator.getString("generics.km")), (Comparable)((Object)period));
                this.getCdBrake().addValue((double)(tmp.getLengthBrake() / tmp.getKm() * 100.0f), (Comparable)((Object)LanguageTranslator.getString("generics.brakePercent")), (Comparable)((Object)period));
                this.getCdLoad().addValue(20.0, (Comparable)((Object)LanguageTranslator.getString("generics.load")), (Comparable)((Object)period));
                this.getCdDenivele().addValue(5.0, (Comparable)((Object)LanguageTranslator.getString("generics.denivele")), (Comparable)((Object)period));
                float strengthPercent = 0.0f;
                float strengthInTraffic = 0.0f;
                float abnormalStop = 0.0f;
                if (tmp.getStopLength() != 0) {
                    strengthPercent = (float)tmp.getStopLengthStrength() / (float)tmp.getStopLength() * 100.0f;
                    strengthInTraffic = (float)tmp.getStopLengthInTraffic() / (float)tmp.getStopLength() * 100.0f;
                    int timeStop = tmp.getStopLength() - (tmp.getStopLengthStrength() + tmp.getStopLengthInTraffic());
                    abnormalStop = (float)timeStop / (float)tmp.getStopLength() * 100.0f;
                }
                this.getCdStop().addValue((double)strengthPercent, (Comparable)((Object)LanguageTranslator.getString("generics.stopStrength")), (Comparable)((Object)period));
                this.getCdStop().addValue((double)strengthInTraffic, (Comparable)((Object)LanguageTranslator.getString("generics.stopInTraffic")), (Comparable)((Object)period));
                this.getCdStop().addValue((double)abnormalStop, (Comparable)((Object)LanguageTranslator.getString("generics.stop")), (Comparable)((Object)period));
            }
        }
        CategoryPlot plotStop = this.getChartStop().getCategoryPlot();
        plotStop.getRenderer(0).setSeriesPaint(0, (Paint)new Color(97, 170, 78));
        plotStop.getRenderer(0).setSeriesPaint(1, (Paint)new Color(177, 150, 68));
        plotStop.getRenderer(0).setSeriesPaint(2, (Paint)new Color(255, 70, 78));
        plotStop.getRangeAxis(0).setRange(0.0, 100.0);
        CategoryPlot plot = this.getChartConso().getCategoryPlot();
        plot.getRenderer(0).setSeriesPaint(0, (Paint)new Color(97, 170, 78));
        plot.getRenderer(0).setSeriesPaint(1, (Paint)new Color(255, 70, 78));
        plot.getRenderer(0).setSeriesVisibleInLegend(0, Boolean.valueOf(false));
        plot.getRenderer(0).setSeriesVisibleInLegend(1, Boolean.valueOf(false));
        plot.getRangeAxis(0).setRange(0.0, 55.0);
        ValueMarker marker = new ValueMarker((double)this.current.getTargetConsumption());
        marker.setLabel(LanguageTranslator.getString("consumption.target"));
        marker.setAlpha(0.9f);
        marker.setLabelAnchor(RectangleAnchor.LEFT);
        marker.setLabelOffset(new RectangleInsets(10.0, 45.0, 0.0, 0.0));
        plot.clearRangeMarkers();
        plot.addRangeMarker((Marker)marker);
        NumberAxis axis2 = new NumberAxis(LanguageTranslator.getString("generics.km"));
        LineAndShapeRenderer kmRenderer = new LineAndShapeRenderer();
        kmRenderer.setToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        kmRenderer.setSeriesPaint(0, (Paint)Color.black);
        kmRenderer.setSeriesShape(0, (Shape)new Ellipse2D.Float(-2.0f, -2.0f, 4.0f, 4.0f));
        plot.setDataset(1, (CategoryDataset)this.getChartDataKm());
        plot.mapDatasetToRangeAxis(1, 1);
        plot.setRangeAxis(1, (ValueAxis)axis2);
        plot.setRenderer(1, (CategoryItemRenderer)kmRenderer);
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        NumberAxis axis3 = new NumberAxis(LanguageTranslator.getString("generics.brake"));
        axis3.setRange(0.0, 30.0);
        axis3.setVisible(false);
        axis3.setAxisLineVisible(false);
        LineAndShapeRenderer brakeR = new LineAndShapeRenderer();
        brakeR.setToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        brakeR.setSeriesPaint(0, (Paint)Color.green);
        brakeR.setSeriesShape(0, (Shape)new Ellipse2D.Float(-2.0f, -2.0f, 4.0f, 4.0f));
        plot.setDataset(2, (CategoryDataset)this.getCdBrake());
        plot.mapDatasetToRangeAxis(2, 2);
        plot.setRangeAxis(2, (ValueAxis)axis3);
        plot.setRenderer(2, (CategoryItemRenderer)brakeR);
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        NumberAxis axis4 = new NumberAxis(LanguageTranslator.getString("generics.load"));
        axis4.setVisible(false);
        axis4.setAxisLineVisible(false);
        LineAndShapeRenderer loadR = new LineAndShapeRenderer();
        loadR.setToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        loadR.setSeriesPaint(0, (Paint)Color.blue);
        loadR.setSeriesShape(0, (Shape)new Ellipse2D.Float(-2.0f, -2.0f, 4.0f, 4.0f));
        plot.setDataset(3, (CategoryDataset)this.getCdLoad());
        plot.mapDatasetToRangeAxis(3, 3);
        plot.setRangeAxis(3, (ValueAxis)axis4);
        plot.setRenderer(3, (CategoryItemRenderer)loadR);
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        NumberAxis axis5 = new NumberAxis(LanguageTranslator.getString("generics.denivele"));
        axis5.setRange(0.0, 10.0);
        axis5.setVisible(false);
        axis5.setAxisLineVisible(false);
        LineAndShapeRenderer deniveleR = new LineAndShapeRenderer();
        deniveleR.setToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        deniveleR.setSeriesPaint(0, (Paint)Color.orange);
        deniveleR.setSeriesShape(0, (Shape)new Ellipse2D.Float(-2.0f, -2.0f, 4.0f, 4.0f));
        plot.setDataset(4, (CategoryDataset)this.getCdDenivele());
        plot.mapDatasetToRangeAxis(4, 4);
        plot.setRangeAxis(4, (ValueAxis)axis5);
        plot.setRenderer(4, (CategoryItemRenderer)deniveleR);
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
    }
}

