/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.vehicule;

import fr.pgh.component.JFittedComboBox;
import fr.pgh.component.JNotificationFrame;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Intervention;
import fr.pgh.data.bdd.UevSession;
import fr.pgh.data.bdd.VehicleAffectation;
import fr.pgh.data.bdd.VehicleAnalyticCode;
import fr.pgh.data.bdd.VehicleAttachment;
import fr.pgh.data.bdd.VehicleBody;
import fr.pgh.data.bdd.VehicleModel;
import fr.pgh.data.bdd.VehicleType;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.CheckBoxBorder;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.ViewPanel;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.LMSavableFile;
import transpo.system.ui.modele.LMVehicleAttachment;
import transpo.system.ui.modele.TMInterv;
import transpo.system.ui.modele.TMSession;
import transpo.system.ui.renderer.InterventionTableRenderer;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.PnlAttachment;
import transpo.system.ui.views.sync.SynchronizedMessage;
import transpo.system.ui.views.sync.SynchronizedOptionDialog;
import transpo.system.util.FileManager;
import transpo.system.util.Fonctions;
import transpo.system.util.messaging.MessageSystemManager;
import transpo.system.util.messaging.StringMessage;

public class PnlVehicule
extends ViewPanel
implements DataListener {
    private static final long serialVersionUID = 1L;
    private Vehicule vehicle = null;
    private JLabel lblDesignation = null;
    private JTextField txtDesignation = null;
    private JLabel lblImmatriculation = null;
    private JTextField txtImmatriculation = null;
    private JLabel lblMarque = null;
    private JTextField txtMarque = null;
    private JLabel lblFamille = null;
    private JTextField txtFamille = null;
    private JButton btnEnregistrer = null;
    private JPanel pnlDescription = null;
    private JLabel lblAgence = null;
    private JComboBox cbAgence = null;
    private JTextField txtDateEntree = null;
    private JLabel lblAchat = null;
    private JTextField txtDateSortie = null;
    private JLabel lblDateSortie = null;
    private JTextArea txtComm = null;
    private JLabel lblIdentification;
    private JTextField txtIdentification;
    private JTextField txtGuarantee = null;
    private JLabel lblGuarantee = null;
    private JScrollPane jspSession = null;
    private JTable tblSession = null;
    private JPanel pnlIntervention = null;
    private JScrollPane jspTbl = null;
    private JTable tblInterv = null;
    private JButton btnAdd = null;
    private JPanel pnlBtnInterv = null;
    private JButton btnDeleteIntervention = null;
    private JCheckBox cbLast = null;
    private JPanel pnlComm = null;
    private JButton btnUpdate = null;
    private JPanel pnlSession = null;
    private JPanel pnlLocation = null;
    private JCheckBox cbLocation = null;
    private JLabel lblLocationPrice = null;
    private JTextField txtLocationPrice = null;
    private JLabel lblOwner = null;
    private JTextField txtOwner = null;
    private JLabel lblLength = null;
    private JTextField txtLocationLimit = null;
    private JLabel lblKmMaxi = null;
    private JTextField txtKm = null;
    private JLabel lblType = null;
    private JFittedComboBox cbType = null;
    private JButton btnAddType = null;
    private JLabel lblBody = null;
    private JFittedComboBox cbBody = null;
    private JButton btnAddBody = null;
    private JLabel lblAffectation = null;
    private JFittedComboBox cbAffectation = null;
    private JButton btnAddAffectation = null;
    private JLabel lblModel = null;
    private JFittedComboBox cbModel = null;
    private JButton btnAddModel = null;
    private JLabel lblAnalyticCode = null;
    private JFittedComboBox cbAnalyticCode = null;
    private JButton btnAddAnalyticCode = null;
    private ImageIcon imgAdd = null;
    private JLabel lblVuBrand = null;
    private JTextField txtVuBrand = null;
    private JLabel lblVuVersion = null;
    private JTextField txtVuVersion = null;
    private PnlAttachment pnlAttachment;

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        if (dataEvent instanceof BddEvent) {
            BddEvent e = (BddEvent)dataEvent;
            if (e.getTable().equals("t_agence") || e.getTable().equals("t_societe")) {
                this.getCbAgence().setModel(new ComboBoxModel(Agence.getList(), false, LanguageTranslator.getString("generics.none")));
                this.getCbAgence().setSelectedItem(((ComboBoxModel)this.getCbAgence().getModel()).getLabel(this.vehicle.getAgencyId()));
            }
            if (e.getTable().equals("VEHICLE_TYPE") || e.getTable().equals("t_societe")) {
                this.getCbType().setModel(new ComboBoxModel(VehicleType.getList(), false, LanguageTranslator.getString("generics.none")));
                this.getCbType().setSelectedItem(((ComboBoxModel)this.getCbType().getModel()).getLabel(this.vehicle.getTypeId()));
            }
            if (e.getTable().equals("VEHICLE_AFFECTATION") || e.getTable().equals("t_societe")) {
                this.getCbAffectation().setModel(new ComboBoxModel(VehicleAffectation.getList(), false, LanguageTranslator.getString("generics.none")));
                this.getCbAffectation().setSelectedItem(((ComboBoxModel)this.getCbAffectation().getModel()).getLabel(this.vehicle.getAffectationId()));
            }
            if (e.getTable().equals("BODY_TYPE") || e.getTable().equals("t_societe")) {
                this.getCbBody().setModel(new ComboBoxModel(VehicleBody.getList(), false, LanguageTranslator.getString("generics.none")));
                this.getCbBody().setSelectedItem(((ComboBoxModel)this.getCbBody().getModel()).getLabel(this.vehicle.getBodyId()));
            }
            if (e.getTable().equals("VEHICLE_MODEL") || e.getTable().equals("t_societe")) {
                TimsLogger.debug("on recharge la liste mod\u00e8le");
                this.getCbModel().setModel(new ComboBoxModel(VehicleModel.getList(), false, LanguageTranslator.getString("generics.none")));
                this.getCbModel().setSelectedItem(((ComboBoxModel)this.getCbModel().getModel()).getLabel(this.vehicle.getModelId()));
            }
        }
    }

    public PnlVehicule() {
        this.initialize();
        Transport.bdd.addDataListener(this);
    }

    private void initialize() {
        GridBagConstraints gcbAttachment = Fonctions.getGridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 1, -1, null);
        GridBagConstraints gcbSession = Fonctions.getGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 1, -1, null);
        GridBagConstraints gcbComm = Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
        GridBagConstraints gcbBtnSave = Fonctions.getGridBagConstraints(0, 5, 1, 4, 0.0, 0.0, -1, -1, new Insets(5, 0, 5, 0));
        GridBagConstraints gcbIntervention = Fonctions.getGridBagConstraints(0, 4, 1, 2, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 5));
        GridBagConstraints gcbLocation = Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 1, -1, new Insets(5, 5, 5, 5));
        GridBagConstraints gcbDescription = Fonctions.getGridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 1, 18, new Insets(0, 0, 5, 0));
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(250, 450));
        this.setSize(new Dimension(750, 500));
        this.add((Component)this.getPnlDescription(), gcbDescription);
        this.add((Component)this.getPnlLocation(), gcbLocation);
        if (ConnexionSettings.getInstance().isConsultable("INTERVENTION")) {
            this.add((Component)this.getPnlIntervention(), gcbIntervention);
        }
        if (ConnexionSettings.getInstance().isModifiable("VEHICULE")) {
            this.add((Component)this.getBtnEnregistrer(), gcbBtnSave);
        }
        this.add((Component)this.getPnlComm(), gcbComm);
        if (ConnexionSettings.getInstance().isConsultable("VEHICLE_ATTACHMENT")) {
            this.add((Component)this.getPnlAttachment(), gcbAttachment);
        }
        this.add((Component)this.getPnlSession(), gcbSession);
    }

    @Override
    public void loadData() {
        if (!this.load) {
            this.update();
            this.load = true;
        }
    }

    public void setVehicle(Vehicule current) {
        this.vehicle = current;
        this.load = false;
    }

    private void update() {
        this.getTxtDesignation().setText(this.vehicle.getDesignation());
        this.getTxtImmatriculation().setText(this.vehicle.getRegistrationNumber());
        this.getTxtMarque().setText(this.vehicle.getBrand());
        this.getTxtFamille().setText(this.vehicle.getCategory());
        this.getCbAgence().setSelectedItem(((ComboBoxModel)this.getCbAgence().getModel()).getLabel(this.vehicle.getAgencyId()));
        this.getTxtDateEntree().setText(ConversionTime.dateFromBDDToFrance(this.vehicle.getDateEntree(), false, true));
        this.getTxtDateSortie().setText(ConversionTime.dateFromBDDToFrance(this.vehicle.getDateSortie(), false, true));
        this.getTxtComm().setText(this.vehicle.getComment());
        this.getTxtIdentification().setText(this.vehicle.getIdentificationNumber());
        this.getTxtGuarantee().setText(ConversionTime.dateToString(this.vehicle.getGuarantee(), "dd/MM/yyyy", ""));
        this.getTblSession().setModel(new TMSession(UevSession.getUevSession(this.vehicle.getCleVehicule(), null, null)));
        this.getCbAffectation().setSelectedItem(((ComboBoxModel)this.getCbAffectation().getModel()).getLabel(this.vehicle.getAffectationId()));
        this.getCbBody().setSelectedItem(((ComboBoxModel)this.getCbBody().getModel()).getLabel(this.vehicle.getBodyId()));
        this.getCbType().setSelectedItem(((ComboBoxModel)this.getCbType().getModel()).getLabel(this.vehicle.getTypeId()));
        this.getCbModel().setSelectedItem(((ComboBoxModel)this.getCbModel().getModel()).getLabel(this.vehicle.getModelId()));
        this.getCbAnalyticCode().setSelectedItem(((ComboBoxModel)this.getCbAnalyticCode().getModel()).getLabel(this.vehicle.getAnalyticCodeId()));
        if (this.vehicle.getLocationLimit() != null) {
            this.getCbLocation().setSelected(true);
            this.getTxtLocationLimit().setText(ConversionTime.dateToString(this.vehicle.getLocationLimit(), "dd/MM/yyyy"));
            this.getTxtKm().setText(String.valueOf(this.vehicle.getLocationKm()));
            this.getTxtLocationPrice().setText(String.valueOf(this.vehicle.getLocationPrice()));
        } else {
            this.getCbLocation().setSelected(false);
        }
        this.getTxtOwner().setText(this.vehicle.getOwner());
        if (ConnexionSettings.getInstance().isConsultable("INTERVENTION")) {
            this.reloadIntervList();
        }
        this.getPnlAttachment().loadAttachment();
        this.getTxtVuBrand().setText(this.vehicle.getVuBrand());
        this.getTxtVuVersion().setText(this.vehicle.getVuVersion() != null ? String.valueOf(this.vehicle.getVuVersion()) + " (generation " + Fonctions.getGeneration(this.vehicle) + ")" : "");
    }

    @Override
    public void close() {
    }

    @Override
    public String getMnemo() {
        return null;
    }

    @Override
    public String getViewName() {
        return "V\u00e9hicule";
    }

    @Override
    public void refresh() {
    }

    private ImageIcon getImgAdd() {
        if (this.imgAdd == null) {
            ClassLoader cl = this.getClass().getClassLoader();
            this.imgAdd = new ImageIcon(cl.getResource(Transport.res.getResourceString("icone_cliq")));
        }
        return this.imgAdd;
    }

    private JTextField getTxtDesignation() {
        if (this.txtDesignation == null) {
            this.txtDesignation = new JTextField();
        }
        return this.txtDesignation;
    }

    private JTextField getTxtImmatriculation() {
        if (this.txtImmatriculation == null) {
            this.txtImmatriculation = new JTextField();
        }
        return this.txtImmatriculation;
    }

    private JTextField getTxtMarque() {
        if (this.txtMarque == null) {
            this.txtMarque = new JTextField();
        }
        return this.txtMarque;
    }

    private JTextField getTxtFamille() {
        if (this.txtFamille == null) {
            this.txtFamille = new JTextField();
        }
        return this.txtFamille;
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PnlVehicule.this.check()) {
                        PnlVehicule.this.save();
                    }
                }
            });
        }
        return this.btnEnregistrer;
    }

    public boolean check() {
        boolean toReturn = true;
        if (this.getTxtImmatriculation().getText().equals("")) {
            this.getTxtImmatriculation().setBackground(new Color(255, 192, 203));
            this.getTxtImmatriculation().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtImmatriculation().setBackground(Color.white);
        }
        if (this.getTxtDesignation().getText().contains(" - ")) {
            this.getTxtDesignation().setBackground(new Color(255, 192, 203));
            this.getTxtDesignation().setToolTipText(LanguageTranslator.getString("vehicle.errorCode"));
            toReturn = false;
        } else {
            this.getTxtDesignation().setBackground(Color.white);
        }
        return toReturn;
    }

    public void save() {
        if (this.vehicle.compareAndUpdate(((ComboBoxModel)this.getCbAgence().getModel()).getSelectedCle(), this.getTxtDesignation().getText(), this.getTxtMarque().getText(), this.getTxtFamille().getText(), this.getTxtImmatriculation().getText(), this.getTxtIdentification().getText(), ConversionTime.dateFromFranceToBDD(this.getTxtDateEntree().getText(), false), ConversionTime.dateFromFranceToBDD(this.getTxtDateSortie().getText(), false), this.getTxtComm().getText(), ConversionTime.stringToDate(this.getTxtGuarantee().getText(), "dd/MM/yyyy"), this.getTxtOwner().getText(), ConversionTime.stringToDate2(this.getTxtLocationLimit().getText(), "dd/MM/yyyy"), !this.getTxtKm().getText().equals("") ? Integer.parseInt(this.getTxtKm().getText()) : 0, !this.getTxtLocationPrice().getText().equals("") ? Float.parseFloat(this.getTxtLocationPrice().getText()) : 0.0f, this.vehicle.getAverageDailyKm(), ((ComboBoxModel)this.getCbType().getModel()).getSelectedCle(), ((ComboBoxModel)this.getCbAffectation().getModel()).getSelectedCle(), ((ComboBoxModel)this.getCbBody().getModel()).getSelectedCle(), ((ComboBoxModel)this.getCbModel().getModel()).getSelectedCle(), ((ComboBoxModel)this.getCbAnalyticCode().getModel()).getSelectedCle())) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.saveSucceed"), LanguageTranslator.getString("message.done"), 1);
        } else {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.saveError"), LanguageTranslator.getString("message.error"), 0);
        }
    }

    private JPanel getPnlDescription() {
        if (this.pnlDescription == null) {
            boolean affectation = ConnexionSettings.getInstance().isAjoutable("VEHICLE_AFFECTATION");
            boolean body = ConnexionSettings.getInstance().isAjoutable("BODY");
            boolean model = ConnexionSettings.getInstance().isAjoutable("VEHICLE_MODEL");
            boolean type = ConnexionSettings.getInstance().isAjoutable("VEHICLE_TYPE");
            boolean analyticCode = ConnexionSettings.getInstance().isAjoutable("VEHICLE_ANALYTIC_CODE");
            this.lblFamille = new JLabel(LanguageTranslator.getString("vehicle.category"));
            this.lblMarque = new JLabel(LanguageTranslator.getString("vehicle.brand"));
            this.lblImmatriculation = new JLabel(LanguageTranslator.getString("vehicle.registrationNumber"));
            this.lblDesignation = new JLabel(LanguageTranslator.getString("generics.designation"));
            this.lblGuarantee = new JLabel(LanguageTranslator.getString("generics.guarantee"));
            this.lblIdentification = new JLabel(LanguageTranslator.getString("vehicle.identificationNumber"));
            this.lblDateSortie = new JLabel(LanguageTranslator.getString("user.exitDate"));
            this.lblAchat = new JLabel(LanguageTranslator.getString("user.enterDate"));
            this.lblAgence = new JLabel(LanguageTranslator.getString("generics.agency"));
            this.lblBody = new JLabel(LanguageTranslator.getString("generics.body"));
            this.lblAffectation = new JLabel(LanguageTranslator.getString("generics.affectation"));
            this.lblType = new JLabel(LanguageTranslator.getString("generics.type"));
            this.lblModel = new JLabel(LanguageTranslator.getString("vehicle.model"));
            this.lblAnalyticCode = new JLabel(LanguageTranslator.getString("generics.analyticCode"));
            this.lblVuBrand = new JLabel(LanguageTranslator.getString("vehicle.vuBrand"));
            this.lblVuVersion = new JLabel(LanguageTranslator.getString("vehicle.vuVersion"));
            this.pnlDescription = new JPanel();
            this.pnlDescription.setLayout(new GridBagLayout());
            this.pnlDescription.add((Component)this.lblDesignation, Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.2, 0.0, -1, -1, null));
            this.pnlDescription.add((Component)this.getTxtDesignation(), Fonctions.getGridBagConstraints(1, 0, 1, 2, 1.0, 0.2, 2, -1, null));
            this.pnlDescription.add((Component)this.lblImmatriculation, Fonctions.getGridBagConstraints(3, 0, 1, 1, 0.2, 0.0, -1, -1, null));
            this.pnlDescription.add((Component)this.getTxtImmatriculation(), Fonctions.getGridBagConstraints(4, 0, 1, 2, 0.0, 0.0, 2, -1, null));
            this.pnlDescription.add((Component)this.lblIdentification, Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, -1, -1, null));
            this.pnlDescription.add((Component)this.getTxtIdentification(), Fonctions.getGridBagConstraints(1, 1, 1, 2, 1.0, 0.2, 2, -1, null));
            this.pnlDescription.add((Component)this.lblGuarantee, Fonctions.getGridBagConstraints(3, 1, 1, 1, 0.0, 0.0, -1, -1, null));
            this.pnlDescription.add((Component)this.getTxtGuarantee(), Fonctions.getGridBagConstraints(4, 1, 1, 2, 0.0, 0.0, 2, -1, null));
            this.pnlDescription.add((Component)this.lblAchat, Fonctions.getGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, -1, -1, null));
            this.pnlDescription.add((Component)this.getTxtDateEntree(), Fonctions.getGridBagConstraints(1, 3, 1, 2, 1.0, 0.2, 2, -1, null));
            this.pnlDescription.add((Component)this.lblDateSortie, Fonctions.getGridBagConstraints(3, 3, 1, 1, 0.0, 0.0, -1, -1, null));
            this.pnlDescription.add((Component)this.getTxtDateSortie(), Fonctions.getGridBagConstraints(4, 3, 1, 2, 1.0, 0.0, 2, -1, null));
            this.pnlDescription.add((Component)this.lblMarque, Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.2, 0.0, -1, -1, null));
            this.pnlDescription.add((Component)this.getTxtMarque(), Fonctions.getGridBagConstraints(1, 2, 1, 2, 1.0, 0.2, 2, -1, null));
            this.pnlDescription.add((Component)this.lblFamille, Fonctions.getGridBagConstraints(3, 2, 1, 1, 0.0, 0.2, -1, -1, null));
            this.pnlDescription.add((Component)this.getTxtFamille(), Fonctions.getGridBagConstraints(4, 2, 1, 2, 1.0, 0.0, 2, -1, null));
            this.pnlDescription.add((Component)this.lblAgence, Fonctions.getGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, -1, -1, null));
            this.pnlDescription.add((Component)this.getCbAgence(), Fonctions.getGridBagConstraints(1, 4, 1, 2, 1.0, 0.0, 2, -1, null));
            this.pnlDescription.add((Component)this.lblAffectation, Fonctions.getGridBagConstraints(3, 4, 1, 1, 0.0, 0.2, -1, -1, null));
            this.pnlDescription.add((Component)this.getCbAffectation(), Fonctions.getGridBagConstraints(4, 4, 1, 1, 1.0, 0.0, 2, -1, null));
            if (affectation) {
                this.pnlDescription.add((Component)this.getBtnAddAffectation(), Fonctions.getGridBagConstraints(5, 4, 1, 1, 0.0, 0.0, 0, -1, null));
            }
            this.pnlDescription.add((Component)this.lblModel, Fonctions.getGridBagConstraints(0, 5, 1, 1, 0.0, 0.2, -1, -1, null));
            this.pnlDescription.add((Component)this.getCbModel(), Fonctions.getGridBagConstraints(1, 5, 1, model ? 1 : 2, 1.0, 0.0, 2, -1, null));
            if (model) {
                this.pnlDescription.add((Component)this.getBtnAddModel(), Fonctions.getGridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 0, -1, null));
            }
            this.pnlDescription.add((Component)this.lblType, Fonctions.getGridBagConstraints(3, 5, 1, 1, 0.0, 0.2, -1, -1, null));
            this.pnlDescription.add((Component)this.getCbType(), Fonctions.getGridBagConstraints(4, 5, 1, 1, 1.0, 0.0, 2, -1, null));
            if (type) {
                this.pnlDescription.add((Component)this.getBtnAddType(), Fonctions.getGridBagConstraints(5, 5, 1, 1, 0.0, 0.0, 0, -1, null));
            }
            this.pnlDescription.add((Component)this.lblVuBrand, Fonctions.getGridBagConstraints(0, 6, 1, 1, 0.0, 0.2, -1, -1, null));
            this.pnlDescription.add((Component)this.getTxtVuBrand(), Fonctions.getGridBagConstraints(1, 6, 1, 2, 1.0, 0.0, 2, -1, null));
            this.pnlDescription.add((Component)this.lblBody, Fonctions.getGridBagConstraints(3, 6, 1, 1, 0.2, 0.0, -1, -1, null));
            this.pnlDescription.add((Component)this.getCbBody(), Fonctions.getGridBagConstraints(4, 6, 1, 1, 1.0, 0.2, 2, -1, null));
            if (body) {
                this.pnlDescription.add((Component)this.getBtnAddBody(), Fonctions.getGridBagConstraints(5, 6, 1, 1, 0.0, 0.0, 0, -1, null));
            }
            this.pnlDescription.add((Component)this.lblVuVersion, Fonctions.getGridBagConstraints(0, 7, 1, 1, 0.0, 0.2, -1, -1, null));
            this.pnlDescription.add((Component)this.getTxtVuVersion(), Fonctions.getGridBagConstraints(1, 7, 1, 2, 1.0, 0.0, 2, -1, null));
            this.pnlDescription.add((Component)this.lblAnalyticCode, Fonctions.getGridBagConstraints(3, 7, 1, 1, 0.0, 0.2, -1, -1, null));
            this.pnlDescription.add((Component)this.getCbAnalyticCode(), Fonctions.getGridBagConstraints(4, 7, 1, model ? 1 : 2, 1.0, 0.0, 2, -1, null));
            if (analyticCode) {
                this.pnlDescription.add((Component)this.getBtnAddAnalyticCode(), Fonctions.getGridBagConstraints(5, 7, 1, 1, 0.0, 0.0, 0, -1, null));
            }
        }
        return this.pnlDescription;
    }

    private JFittedComboBox getCbBody() {
        if (this.cbBody == null) {
            this.cbBody = new JFittedComboBox();
            this.cbBody.setModel(new ComboBoxModel(VehicleBody.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbBody;
    }

    private JButton getBtnAddBody() {
        if (this.btnAddBody == null) {
            this.btnAddBody = new JButton();
            this.btnAddBody.setIcon(this.getImgAdd());
            this.btnAddBody.setPreferredSize(new Dimension(25, 25));
            this.btnAddBody.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Fonctions.define(VehicleBody.class);
                }
            });
        }
        return this.btnAddBody;
    }

    private JFittedComboBox getCbAffectation() {
        if (this.cbAffectation == null) {
            this.cbAffectation = new JFittedComboBox();
            this.cbAffectation.setModel(new ComboBoxModel(VehicleAffectation.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbAffectation;
    }

    private JButton getBtnAddAffectation() {
        if (this.btnAddAffectation == null) {
            this.btnAddAffectation = new JButton();
            this.btnAddAffectation.setIcon(this.getImgAdd());
            this.btnAddAffectation.setPreferredSize(new Dimension(25, 25));
            this.btnAddAffectation.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Fonctions.define(VehicleAffectation.class);
                }
            });
        }
        return this.btnAddAffectation;
    }

    private JFittedComboBox getCbType() {
        if (this.cbType == null) {
            this.cbType = new JFittedComboBox();
            this.cbType.setModel(new ComboBoxModel(VehicleType.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbType;
    }

    private JButton getBtnAddType() {
        if (this.btnAddType == null) {
            this.btnAddType = new JButton();
            this.btnAddType.setIcon(this.getImgAdd());
            this.btnAddType.setPreferredSize(new Dimension(25, 25));
            this.btnAddType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Fonctions.define(VehicleType.class);
                }
            });
        }
        return this.btnAddType;
    }

    private JFittedComboBox getCbModel() {
        if (this.cbModel == null) {
            this.cbModel = new JFittedComboBox();
            this.cbModel.setModel(new ComboBoxModel(VehicleModel.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbModel;
    }

    private JFittedComboBox getCbAnalyticCode() {
        if (this.cbAnalyticCode == null) {
            this.cbAnalyticCode = new JFittedComboBox();
            this.cbAnalyticCode.setModel(new ComboBoxModel(VehicleAnalyticCode.getList(), false, LanguageTranslator.getString("generics.none")));
        }
        return this.cbAnalyticCode;
    }

    private JButton getBtnAddModel() {
        if (this.btnAddModel == null) {
            this.btnAddModel = new JButton();
            this.btnAddModel.setIcon(this.getImgAdd());
            this.btnAddModel.setPreferredSize(new Dimension(25, 25));
            this.btnAddModel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Fonctions.define(VehicleModel.class);
                }
            });
        }
        return this.btnAddModel;
    }

    private JButton getBtnAddAnalyticCode() {
        if (this.btnAddAnalyticCode == null) {
            this.btnAddAnalyticCode = new JButton();
            this.btnAddAnalyticCode.setIcon(this.getImgAdd());
            this.btnAddAnalyticCode.setPreferredSize(new Dimension(25, 25));
            this.btnAddAnalyticCode.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Fonctions.define(VehicleAnalyticCode.class);
                }
            });
        }
        return this.btnAddAnalyticCode;
    }

    private JComboBox getCbAgence() {
        if (this.cbAgence == null) {
            this.cbAgence = new JComboBox();
            this.cbAgence.setModel(new ComboBoxModel(Agence.getList(), false, null));
        }
        return this.cbAgence;
    }

    private JTextField getTxtDateEntree() {
        if (this.txtDateEntree == null) {
            this.txtDateEntree = new JTextField();
            this.txtDateEntree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(PnlVehicule.this.getTxtDateEntree());
                }
            });
        }
        return this.txtDateEntree;
    }

    private JTextField getTxtDateSortie() {
        if (this.txtDateSortie == null) {
            this.txtDateSortie = new JTextField();
            this.txtDateSortie.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(PnlVehicule.this.getTxtDateSortie());
                }
            });
        }
        return this.txtDateSortie;
    }

    private JTextArea getTxtComm() {
        if (this.txtComm == null) {
            this.txtComm = new JTextArea();
            this.txtComm.setMinimumSize(new Dimension(0, 50));
        }
        return this.txtComm;
    }

    private JTextField getTxtIdentification() {
        if (this.txtIdentification == null) {
            this.txtIdentification = new JTextField();
        }
        return this.txtIdentification;
    }

    private JTextField getTxtGuarantee() {
        if (this.txtGuarantee == null) {
            this.txtGuarantee = new JTextField();
            this.txtGuarantee.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(PnlVehicule.this.getTxtGuarantee());
                }
            });
        }
        return this.txtGuarantee;
    }

    private JScrollPane getJspSession() {
        if (this.jspSession == null) {
            this.jspSession = new JScrollPane();
            this.jspSession.setViewportView(this.getTblSession());
        }
        return this.jspSession;
    }

    private JTable getTblSession() {
        if (this.tblSession == null) {
            this.tblSession = new JTable();
            this.tblSession.setRowHeight(18);
        }
        return this.tblSession;
    }

    private JTextField getTxtVuBrand() {
        if (this.txtVuBrand == null) {
            this.txtVuBrand = new JTextField();
            this.txtVuBrand.setEnabled(false);
        }
        return this.txtVuBrand;
    }

    private JTextField getTxtVuVersion() {
        if (this.txtVuVersion == null) {
            this.txtVuVersion = new JTextField();
            this.txtVuVersion.setEnabled(false);
        }
        return this.txtVuVersion;
    }

    private PnlAttachment getPnlAttachment() {
        if (this.pnlAttachment == null) {
            this.pnlAttachment = new PnlAttachment(){

                @Override
                public void loadAttachment() {
                    Vector<VehicleAttachment> dl = VehicleAttachment.loadList(PnlVehicule.this.vehicle.getCleVehicule());
                    this.getListAttachment().setModel(new LMVehicleAttachment(dl));
                }

                @Override
                public void deleteAttachment() {
                    int[] selected = this.getListAttachment().getSelectedIndices();
                    if (selected.length == 0) {
                        SynchronizedMessage error = new SynchronizedMessage(null, new StringMessage(LanguageTranslator.getString("message.noFileSelected")), LanguageTranslator.getString("generics.error"), 0, null);
                        error.run();
                        return;
                    }
                    SynchronizedOptionDialog tmp = new SynchronizedOptionDialog(LanguageTranslator.getString("message.delete.confirm"), LanguageTranslator.getString("generics.warning"));
                    tmp.run();
                    if (tmp.option == 0) {
                        String file = selected.length == 1 ? ((LMVehicleAttachment)this.getListAttachment().getModel()).getName(selected[0]) : LanguageTranslator.getString("generics.files");
                        boolean detached = true;
                        int x = 0;
                        while (x < selected.length) {
                            VehicleAttachment toDelete = (VehicleAttachment)((LMVehicleAttachment)this.getListAttachment().getModel()).elementAt(selected[x]);
                            if (toDelete.delete()) {
                                TimsLogger.debug("#PnlVehicle.deleteAttachment# deleted " + toDelete.getDocumentName());
                            } else {
                                detached = false;
                            }
                            ((LMVehicleAttachment)this.getListAttachment().getModel()).remove(x);
                            ++x;
                        }
                        JNotificationFrame frame = JNotificationFrame.getFrame(JNotificationFrame.Corner.BOTTOM_RIGHT);
                        if (detached) {
                            frame.addMessage(LanguageTranslator.getString("attachment.title"), new JLabel(LanguageTranslator.getString("attachment.deleted.content", file)), Fonctions.getSuccessStatusIcon());
                        } else {
                            frame.addMessage(LanguageTranslator.getString("attachment.title"), new JLabel(LanguageTranslator.getString("message.detailedError", LanguageTranslator.getString("message.copyError"))), Fonctions.getErrorStatusIcon());
                        }
                        this.loadAttachment();
                        frame.showNotification(6);
                    }
                }

                @Override
                public void addAttachment() {
                    new Thread(){

                        @Override
                        public void run() {
                            JFileChooser choix = new JFileChooser(".");
                            choix.setApproveButtonText(LanguageTranslator.getString("button.add"));
                            if (choix.showOpenDialog(MainFrameTransport.getInstance()) == 0) {
                                String attached = null;
                                boolean saved = false;
                                if (!Fonctions.checkFileSize(choix.getSelectedFile())) {
                                    return;
                                }
                                Transport.bdd.startTransaction();
                                VehicleAttachment toAdd = new VehicleAttachment(0, PnlVehicule.this.vehicle.getCleVehicule(), attached);
                                attached = FileManager.moveFile(PnlVehicule.this.vehicle, choix.getSelectedFile());
                                toAdd.setDocumentName(attached);
                                saved = toAdd.insert();
                                JNotificationFrame frame = JNotificationFrame.getFrame(JNotificationFrame.Corner.BOTTOM_RIGHT);
                                if (attached != null && saved) {
                                    Transport.bdd.commit();
                                    frame.addMessage(LanguageTranslator.getString("attachment.title"), new JLabel(LanguageTranslator.getString("attachment.added.content.vehicle", choix.getSelectedFile().getName())), Fonctions.getSuccessStatusIcon());
                                    this.loadAttachment();
                                } else {
                                    Transport.bdd.rollback();
                                    frame.addMessage(LanguageTranslator.getString("attachment.title"), new JLabel(LanguageTranslator.getString("message.detailedError", LanguageTranslator.getString("message.copyError"))), Fonctions.getErrorStatusIcon());
                                }
                                frame.showNotification(6);
                            }
                        }
                    }.start();
                }
            };
            this.pnlAttachment.getBtnExportAttachment().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlVehicule.this.saveFile(PnlVehicule.this.pnlAttachment.getListAttachment(), true);
                }
            });
            this.pnlAttachment.getBtnShowAttachment().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlVehicule.this.showFile(PnlVehicule.this.pnlAttachment.getListAttachment());
                }
            });
        }
        return this.pnlAttachment;
    }

    private void saveFile(JList toSave, boolean open) {
        int[] selected = toSave.getSelectedIndices();
        JFileChooser choix = new JFileChooser(".");
        choix.setApproveButtonText("Sauvegarder les fichiers dans");
        choix.setFileSelectionMode(1);
        if (choix.showOpenDialog(MainFrameTransport.getInstance()) == 0) {
            String cheminSave = choix.getSelectedFile().getAbsolutePath();
            String error = "";
            int nbErrors = 0;
            int x = 0;
            while (x < selected.length) {
                String nomFichier = ((LMSavableFile)((Object)toSave.getModel())).getName(selected[x]);
                File fichier = FileManager.getFile(this.vehicle, nomFichier);
                if (fichier == null) {
                    error = String.valueOf(error) + ", " + nomFichier;
                    ++nbErrors;
                } else {
                    File destination = new File(cheminSave, nomFichier);
                    boolean transfered = Fonctions.copyLocalFile(fichier, destination, System.getProperty("URL") != null);
                    if (open && transfered && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
                        try {
                            Desktop.getDesktop().open(destination);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++x;
            }
            JNotificationFrame frame = JNotificationFrame.getFrame(JNotificationFrame.Corner.BOTTOM_RIGHT);
            if (error.equals("")) {
                frame.addMessage(LanguageTranslator.getString("download.export.succeed"), new JLabel(LanguageTranslator.getString("message.done")), Fonctions.getSuccessStatusIcon());
                frame.showNotification(6);
            } else {
                frame.addMessage(LanguageTranslator.getString("download.export.mising", String.valueOf(nbErrors)), new JLabel(error.substring(1)), Fonctions.getErrorStatusIcon());
                frame.showNotification(6);
            }
        }
    }

    private void showFile(JList toShow) {
        int[] selected = toShow.getSelectedIndices();
        if (selected.length == 0) {
            return;
        }
        int x = 0;
        while (x < selected.length) {
            String nomFichier = ((LMSavableFile)((Object)toShow.getModel())).getName(selected[x]);
            File fichier = FileManager.getFile(this.vehicle, nomFichier);
            if (fichier == null) {
                MessageSystemManager.error(null, LanguageTranslator.getString("generics.fileNotFound", nomFichier), LanguageTranslator.getString("generics.error"));
            } else if (Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
                try {
                    Desktop.getDesktop().open(fichier);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++x;
        }
    }

    private JPanel getPnlIntervention() {
        if (this.pnlIntervention == null) {
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.gridx = 0;
            gridBagConstraints18.anchor = 13;
            gridBagConstraints18.gridy = 0;
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridx = 0;
            gridBagConstraints16.fill = 3;
            gridBagConstraints16.weightx = 1.0;
            gridBagConstraints16.anchor = 13;
            gridBagConstraints16.gridy = 2;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 1;
            gridBagConstraints9.gridy = 1;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.weighty = 1.0;
            gridBagConstraints9.insets = new Insets(2, 0, 2, 0);
            gridBagConstraints9.gridx = 0;
            this.pnlIntervention = new JPanel();
            this.pnlIntervention.setLayout(new GridBagLayout());
            this.pnlIntervention.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("intervention.done"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlIntervention.add((Component)this.getJspTbl(), gridBagConstraints9);
            this.pnlIntervention.add((Component)this.getPnlBtnInterv(), gridBagConstraints16);
            this.pnlIntervention.add((Component)this.getCbLast(), gridBagConstraints18);
        }
        return this.pnlIntervention;
    }

    private JScrollPane getJspTbl() {
        if (this.jspTbl == null) {
            this.jspTbl = new JScrollPane();
            this.jspTbl.setViewportView(this.getTblInterv());
        }
        return this.jspTbl;
    }

    private JTable getTblInterv() {
        if (this.tblInterv == null) {
            this.tblInterv = new JTable();
            this.tblInterv.getSelectionModel().addListSelectionListener(new ListIntervListener());
            this.tblInterv.setDefaultRenderer(Object.class, new InterventionTableRenderer());
            this.tblInterv.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        Intervention toShow = ((TMInterv)PnlVehicule.this.getTblInterv().getModel()).getIntervAt(PnlVehicule.this.getTblInterv().getSelectedRow());
                        Fonctions.showDialogInterv(toShow, null);
                    }
                }
            });
        }
        return this.tblInterv;
    }

    private JButton getBtnAdd() {
        if (this.btnAdd == null) {
            this.btnAdd = new JButton();
            this.btnAdd.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_cliq"))));
            this.btnAdd.setPreferredSize(new Dimension(25, 25));
            this.btnAdd.setToolTipText(LanguageTranslator.getString("button.add"));
            this.btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Fonctions.showDialogInterv(null, PnlVehicule.this.vehicle);
                    PnlVehicule.this.reloadIntervList();
                }
            });
        }
        return this.btnAdd;
    }

    private JButton getBtnDeleteIntervention() {
        if (this.btnDeleteIntervention == null) {
            this.btnDeleteIntervention = new JButton();
            this.btnDeleteIntervention.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_sup"))));
            this.btnDeleteIntervention.setPreferredSize(new Dimension(25, 25));
            this.btnDeleteIntervention.setToolTipText(LanguageTranslator.getString("button.delete"));
            this.btnDeleteIntervention.setEnabled(false);
            this.btnDeleteIntervention.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Intervention toDel = ((TMInterv)PnlVehicule.this.getTblInterv().getModel()).getIntervAt(PnlVehicule.this.getTblInterv().getSelectedRow());
                    SynchronizedOptionDialog tmp = new SynchronizedOptionDialog(LanguageTranslator.getString("message.delete.confirm"), LanguageTranslator.getString("generics.warning"));
                    tmp.run();
                    if (tmp.option == 0) {
                        JNotificationFrame frame = JNotificationFrame.getFrame(JNotificationFrame.Corner.BOTTOM_RIGHT);
                        if (toDel.delete()) {
                            frame.addMessage(LanguageTranslator.getString("attachment.title"), new JLabel(LanguageTranslator.getString("message.deleteSucceed")), Fonctions.getSuccessStatusIcon());
                        } else {
                            frame.addMessage(LanguageTranslator.getString("attachment.title"), new JLabel(LanguageTranslator.getString("message.detailedError", LanguageTranslator.getString("message.copyError"))), Fonctions.getErrorStatusIcon());
                        }
                        frame.showNotification(6);
                        PnlVehicule.this.reloadIntervList();
                    }
                }
            });
        }
        return this.btnDeleteIntervention;
    }

    private JPanel getPnlBtnInterv() {
        if (this.pnlBtnInterv == null) {
            GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
            gridBagConstraints28.gridx = 0;
            gridBagConstraints28.gridy = 0;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 2;
            gridBagConstraints10.gridy = 0;
            GridBagConstraints gcbDel = new GridBagConstraints();
            gcbDel.gridx = 1;
            gcbDel.gridy = 0;
            this.pnlBtnInterv = new JPanel();
            this.pnlBtnInterv.setLayout(new GridBagLayout());
            if (ConnexionSettings.getInstance().isAjoutable("INTERVENTION")) {
                this.pnlBtnInterv.add((Component)this.getBtnAdd(), gridBagConstraints10);
            }
            if (ConnexionSettings.getInstance().isSupprimable("INTERVENTION")) {
                this.pnlBtnInterv.add((Component)this.getBtnDeleteIntervention(), gcbDel);
            }
            if (ConnexionSettings.getInstance().isModifiable("INTERVENTION")) {
                this.pnlBtnInterv.add((Component)this.getBtnUpdate(), gridBagConstraints28);
            }
        }
        return this.pnlBtnInterv;
    }

    private JCheckBox getCbLast() {
        if (this.cbLast == null) {
            this.cbLast = new JCheckBox();
            this.cbLast.setSelected(true);
            this.cbLast.setText(LanguageTranslator.getString("intervention.lastPerType"));
            this.cbLast.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PnlVehicule.this.reloadIntervList();
                }
            });
        }
        return this.cbLast;
    }

    public void reloadIntervList() {
        Vector<Intervention> liste = null;
        liste = this.getCbLast().isSelected() ? Intervention.loadLastList(0, this.vehicle.getCleVehicule()) : Intervention.loadList(0, this.vehicle.getCleVehicule(), null, null);
        if (!(this.getTblInterv().getModel() instanceof TMInterv)) {
            this.getTblInterv().setModel(new TMInterv(liste));
        } else {
            ((TMInterv)this.getTblInterv().getModel()).setInterv(liste);
        }
    }

    private JPanel getPnlLocation() {
        if (this.pnlLocation == null) {
            GridBagConstraints gcLblOwner = Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 2, 17, new Insets(0, 5, 0, 5));
            GridBagConstraints gcTxtOwner = Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 2, 10, new Insets(3, 0, 3, 5));
            GridBagConstraints gcLblLength = Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 2, 17, new Insets(0, 5, 0, 5));
            GridBagConstraints gcTxtLength = Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 2, 10, new Insets(3, 0, 3, 5));
            GridBagConstraints gcLblKmMaxi = Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 2, 17, new Insets(0, 5, 0, 5));
            GridBagConstraints gcTxtKmMaxi = Fonctions.getGridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 2, 10, new Insets(3, 0, 3, 5));
            GridBagConstraints gcLblLocPrice = Fonctions.getGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 2, 17, new Insets(0, 5, 0, 5));
            GridBagConstraints gcTxtLocPrice = Fonctions.getGridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 2, 10, new Insets(3, 0, 3, 5));
            this.lblKmMaxi = new JLabel();
            this.lblKmMaxi.setText(LanguageTranslator.getString("vehicle.locationKm"));
            this.lblKmMaxi.setEnabled(false);
            this.lblOwner = new JLabel();
            this.lblOwner.setText(LanguageTranslator.getString("generics.owner"));
            this.lblOwner.setEnabled(false);
            this.lblLength = new JLabel();
            this.lblLength.setText(LanguageTranslator.getString("vehicle.locationLimit"));
            this.lblLength.setEnabled(false);
            this.lblLocationPrice = new JLabel();
            this.lblLocationPrice.setText(LanguageTranslator.getString("vehicle.locationPrice"));
            this.lblLocationPrice.setEnabled(false);
            this.pnlLocation = new JPanel();
            this.pnlLocation.setLayout(new GridBagLayout());
            this.pnlLocation.setBorder(new CheckBoxBorder(this.getCbLocation(), this.pnlLocation, BorderFactory.createLineBorder(SystemColor.activeCaption, 1)));
            this.pnlLocation.add((Component)this.lblOwner, gcLblOwner);
            this.pnlLocation.add((Component)this.getTxtOwner(), gcTxtOwner);
            this.pnlLocation.add((Component)this.lblLength, gcLblLength);
            this.pnlLocation.add((Component)this.getTxtLocationLimit(), gcTxtLength);
            this.pnlLocation.add((Component)this.lblKmMaxi, gcLblKmMaxi);
            this.pnlLocation.add((Component)this.getTxtKm(), gcTxtKmMaxi);
            this.pnlLocation.add((Component)this.lblLocationPrice, gcLblLocPrice);
            this.pnlLocation.add((Component)this.getTxtLocationPrice(), gcTxtLocPrice);
        }
        return this.pnlLocation;
    }

    private JPanel getPnlComm() {
        if (this.pnlComm == null) {
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.fill = 1;
            gridBagConstraints23.gridwidth = 3;
            gridBagConstraints23.gridx = 0;
            gridBagConstraints23.gridy = 0;
            gridBagConstraints23.weightx = 1.0;
            gridBagConstraints23.weighty = 1.0;
            gridBagConstraints23.insets = new Insets(2, 2, 2, 2);
            this.pnlComm = new JPanel();
            this.pnlComm.setLayout(new GridBagLayout());
            this.pnlComm.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.comment"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlComm.add((Component)this.getTxtComm(), gridBagConstraints23);
        }
        return this.pnlComm;
    }

    private JCheckBox getCbLocation() {
        if (this.cbLocation == null) {
            this.cbLocation = new JCheckBox();
            this.cbLocation.setText(LanguageTranslator.getString("generics.location"));
            this.cbLocation.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean enable = PnlVehicule.this.getCbLocation().isSelected();
                    Fonctions.setEnabled(PnlVehicule.this.getPnlLocation(), enable);
                    PnlVehicule.this.getPnlLocation().repaint();
                }
            });
        }
        return this.cbLocation;
    }

    private JTextField getTxtLocationPrice() {
        if (this.txtLocationPrice == null) {
            this.txtLocationPrice = new JTextField();
            this.txtLocationPrice.setEnabled(false);
        }
        return this.txtLocationPrice;
    }

    private JTextField getTxtOwner() {
        if (this.txtOwner == null) {
            this.txtOwner = new JTextField();
            this.txtOwner.setEnabled(false);
        }
        return this.txtOwner;
    }

    private JTextField getTxtLocationLimit() {
        if (this.txtLocationLimit == null) {
            this.txtLocationLimit = new JTextField();
            this.txtLocationLimit.setEnabled(false);
            this.txtLocationLimit.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(PnlVehicule.this.getTxtLocationLimit());
                }
            });
        }
        return this.txtLocationLimit;
    }

    private JTextField getTxtKm() {
        if (this.txtKm == null) {
            this.txtKm = new JTextField();
            this.txtKm.setEnabled(false);
        }
        return this.txtKm;
    }

    private JButton getBtnUpdate() {
        if (this.btnUpdate == null) {
            this.btnUpdate = new JButton();
            this.btnUpdate.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_loupe"))));
            this.btnUpdate.setPreferredSize(new Dimension(25, 25));
            this.btnUpdate.setToolTipText(LanguageTranslator.getString("button.update"));
            this.btnUpdate.setEnabled(false);
            this.btnUpdate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Intervention toShow = ((TMInterv)PnlVehicule.this.getTblInterv().getModel()).getIntervAt(PnlVehicule.this.getTblInterv().getSelectedRow());
                    Fonctions.showDialogInterv(toShow, null);
                }
            });
        }
        return this.btnUpdate;
    }

    private JPanel getPnlSession() {
        if (this.pnlSession == null) {
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.fill = 1;
            gridBagConstraints14.gridwidth = 4;
            gridBagConstraints14.gridx = -1;
            gridBagConstraints14.gridy = -1;
            gridBagConstraints14.weightx = 1.0;
            gridBagConstraints14.weighty = 1.0;
            gridBagConstraints14.insets = new Insets(0, 5, 0, 5);
            this.pnlSession = new JPanel();
            this.pnlSession.setMinimumSize(new Dimension(0, 120));
            this.pnlSession.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("vehicle.session"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlSession.setLayout(new GridBagLayout());
            this.pnlSession.add((Component)this.getJspSession(), gridBagConstraints14);
        }
        return this.pnlSession;
    }

    public class ListIntervListener
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)listSelectionEvent.getSource();
            if (lsm.isSelectionEmpty()) {
                PnlVehicule.this.getBtnUpdate().setEnabled(false);
                PnlVehicule.this.getBtnDeleteIntervention().setEnabled(false);
            } else {
                PnlVehicule.this.getBtnUpdate().setEnabled(true);
                PnlVehicule.this.getBtnDeleteIntervention().setEnabled(true);
            }
        }
    }
}

