/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.widget;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.Conflit;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.DialogDetailConflit;
import transpo.system.ui.views.DialogGestionConflit;
import transpo.system.ui.views.widget.TimsWidget;
import transpo.system.util.Fonctions;

public class ConflictWidget
extends TimsWidget
implements DataListener {
    private static final long serialVersionUID = -4875064886154105474L;
    private JScrollPane jScrollPane = null;
    private JTable tableConflit = null;
    private JButton btnGestionConflit = null;
    private TableConflitModele modeleTable = null;

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        TimsLogger.debug("DriverDownloadWidget # reload from " + dataEvent.getTable());
        dataEvent.getTable().equals("t_conducteur");
    }

    @Override
    public TimsWidget build() {
        this.initialize();
        BddTransport.getInstance().addDataListener(this);
        this.load();
        return this;
    }

    @Override
    public void print() {
    }

    private void initialize() {
        this.setBorder(this.getBorder("dashboard.conflictManagement"));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getJScrollPane(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(0, 10, 0, 10)));
        this.add((Component)this.getBtnGestionConflit(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 0, 5, 0)));
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setPreferredSize(new Dimension(0, 0));
            this.jScrollPane.setViewportView(this.getTableConflit());
        }
        return this.jScrollPane;
    }

    private JTable getTableConflit() {
        if (this.tableConflit == null) {
            this.modeleTable = new TableConflitModele(Transport.bdd.getConflitList(0, null, 0, true));
            this.tableConflit = new JTable(this.modeleTable);
            this.centrerTable(this.tableConflit);
            this.tableConflit.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int index = ConflictWidget.this.getTableConflit().rowAtPoint(e.getPoint());
                    ConflictWidget.this.detailConflit(index);
                }
            });
        }
        return this.tableConflit;
    }

    private void centrerTable(JTable table) {
        DefaultTableCellRenderer custom = new DefaultTableCellRenderer();
        custom.setHorizontalAlignment(0);
        int i = 0;
        while (i < table.getColumnCount() - 1) {
            table.getColumnModel().getColumn(i).setCellRenderer(custom);
            ++i;
        }
    }

    private JButton getBtnGestionConflit() {
        if (this.btnGestionConflit == null) {
            this.btnGestionConflit = new JButton();
            this.btnGestionConflit.setText(LanguageTranslator.getString("dashboard.conflictManagement"));
            this.btnGestionConflit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new DialogGestionConflit(MainFrameTransport.getInstance()).setVisible(true);
                }
            });
        }
        return this.btnGestionConflit;
    }

    private void detailConflit(int index) {
        Conflit conflit = this.modeleTable.getSelected(index);
        new DialogDetailConflit(MainFrameTransport.getInstance(), conflit);
    }

    @Override
    public void load() {
        this.modeleTable = new TableConflitModele(Transport.bdd.getConflitList(0, null, 0, true));
        this.getTableConflit().setModel(this.modeleTable);
    }

    public class TableConflitModele
    extends AbstractTableModel {
        Vector<Conflit> donnees;
        String[] titres = new String[]{LanguageTranslator.getString("generics.driver"), LanguageTranslator.getString("generics.agency"), LanguageTranslator.getString("generics.date")};

        public TableConflitModele(Vector<Conflit> donnees) {
            this.donnees = donnees;
        }

        @Override
        public int getColumnCount() {
            return this.titres.length;
        }

        @Override
        public Object getValueAt(int parm1, int parm2) {
            Conflit tmp = this.donnees.get(parm1);
            switch (parm2) {
                case 0: {
                    return String.valueOf(tmp.getNomConducteur()) + "   " + tmp.getPrenomConducteur();
                }
                case 1: {
                    return tmp.getAgence();
                }
                case 2: {
                    return ConversionTime.dateFromBDDToFrance(tmp.getDateConflit(), false, false);
                }
            }
            return LanguageTranslator.getString("generics.notFound");
        }

        @Override
        public int getRowCount() {
            return this.donnees.size();
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public String getColumnName(int col) {
            return this.titres[col];
        }

        public Conflit getSelected(int index) {
            Conflit tmp = this.donnees.get(index);
            return tmp;
        }
    }
}

