/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views.widget;

import fr.pgh.component.JPanelButton;
import fr.pgh.component.TableSorter;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.CustomReportColumn;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.modele.TMDriverCardExpiration;
import transpo.system.ui.renderer.DriverStateRenderer;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.widget.TimsWidget;
import transpo.system.util.Fonctions;
import transport.report.CustomReportFactory;
import transport.report.generator.DJGeneratorWithDateStyle;

public class DriverCardExpirationWidget
extends TimsWidget
implements DataListener {
    private static final long serialVersionUID = -4875064886154105474L;
    private static String STRING_NO_DL = "1970-01-01 00:00:00.0";
    private JScrollPane jspDriver = null;
    private JTable tblDriver = null;
    private JButton btnPrint = null;
    private JButton btnExport = null;
    private JPanelButton pnlBtn = null;

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        TimsLogger.debug("DriverValidityStateWidget # reload from " + dataEvent.getTable());
        dataEvent.getTable().equals("t_conducteur");
    }

    @Override
    public TimsWidget build() {
        this.initialize();
        BddTransport.getInstance().addDataListener(this);
        this.load();
        return this;
    }

    private void initialize() {
        this.setBorder(this.getBorder("dashboard.driverExpiration"));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getJspDriver(), Fonctions.getGridBagConstraints(0, 0));
        this.add((Component)this.getPnlBtn(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 0, -1, null));
    }

    private JPanelButton getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanelButton(this.getBtnExport(), this.getBtnPrint());
        }
        return this.pnlBtn;
    }

    private JScrollPane getJspDriver() {
        if (this.jspDriver == null) {
            this.jspDriver = new JScrollPane();
            this.jspDriver.setViewportView(this.getTblDriver());
        }
        return this.jspDriver;
    }

    private JTable getTblDriver() {
        if (this.tblDriver == null) {
            this.tblDriver = new JTable();
        }
        return this.tblDriver;
    }

    private JButton getBtnExport() {
        if (this.btnExport == null) {
            this.btnExport = new JButton();
            this.btnExport.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_xls"))));
            this.btnExport.setPreferredSize(new Dimension(35, 35));
            this.btnExport.setToolTipText(LanguageTranslator.getString("dashboard.driverDownloadMonitoring"));
            this.btnExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DriverCardExpirationWidget.this.export("xls");
                }
            });
        }
        return this.btnExport;
    }

    private JButton getBtnPrint() {
        if (this.btnPrint == null) {
            this.btnPrint = new JButton();
            this.btnPrint.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_print"))));
            this.btnPrint.setPreferredSize(new Dimension(35, 35));
            this.btnPrint.setToolTipText(LanguageTranslator.getString("button.driver.print"));
            this.btnPrint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DriverCardExpirationWidget.this.print();
                }
            });
        }
        return this.btnPrint;
    }

    @Override
    public void load() {
        Transport.ps.startOperation();
        TableSorter sorter = new TableSorter(new TMDriverCardExpiration(this.driverFilter(Conducteur.getList())));
        this.getTblDriver().setModel(sorter);
        sorter.setTableHeader(this.getTblDriver().getTableHeader());
        DriverStateRenderer.initialize(this.getTblDriver());
        sorter.setSortingStatus(2, 1);
        Transport.ps.endOperation(PerformanceScanner.PROCESS, LanguageTranslator.getString("driver.expirationBoard"), String.valueOf(LanguageTranslator.getString("driver.expirationBoard")) + " => %s ");
    }

    private Vector<Conducteur> driverFilter(Vector<Conducteur> loadList) {
        Vector<Conducteur> toReturn = new Vector<Conducteur>();
        Date old = ConversionTime.stringToDate("01/01/2000", "dd/MM/yyyy");
        Date today = new Date();
        int x = 0;
        while (x < loadList.size()) {
            Date renew = ConversionTime.stringToDate(loadList.get(x).getDateFinValiditeCarte(), "yyyy-MM-dd");
            int days = ConversionTime.getDaysBetween(today, renew);
            if (days < Integer.parseInt(System.getProperty("driver_warning", "60")) && !renew.before(old) && !loadList.get(x).isRenewalPending()) {
                toReturn.add(loadList.get(x));
            }
            ++x;
        }
        return toReturn;
    }

    @Override
    public void print() {
        this.export("\u00e9cran");
    }

    private void export(String out) {
        Vector<Color> conditionalColors = new Vector<Color>();
        Vector<Integer> conditionalThresholds = new Vector<Integer>();
        conditionalColors.add(MainFrameTransport.BG_COLOR_TOO_LATE_DEFAULT);
        conditionalThresholds.add(-1);
        conditionalColors.add(MainFrameTransport.BG_COLOR_ALERTE_DEFAULT);
        conditionalThresholds.add(Integer.parseInt(System.getProperty("driver_error", "10")));
        conditionalColors.add(MainFrameTransport.BG_COLOR_OK_DEFAULT);
        conditionalThresholds.add(Integer.parseInt(System.getProperty("driver_warning", "60")));
        conditionalThresholds.add(-1);
        CustomReport cr = CustomReportFactory.getGeneric(LanguageTranslator.getString("generics.cardRenewal"));
        Vector<CustomReportColumn> columns = CustomReportFactory.getDefaultDriverExpirationStateColumn(false, true, false, false, false, false);
        cr.setColumn(columns);
        Fonctions.tblToReport(cr, new DJGeneratorWithDateStyle(conditionalColors, conditionalThresholds), ((TableSorter)this.getTblDriver().getModel()).getData(), out);
    }
}

