/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.util;

import java.math.BigInteger;
import java.util.Locale;

public final class BytesUtils {
    private static final int MAX_BIT_INTEGER = 31;
    private static final int HEXA = 16;
    private static final String FORMAT_NOSPACE = "%02x";
    private static final String FORMAT_SPACE = "%02x ";
    private static final int DEFAULT_MASK = 255;

    public static int byteArrayToInt(byte[] byteArray) {
        if (byteArray == null) {
            throw new IllegalArgumentException("Parameter 'byteArray' cannot be null");
        }
        return BytesUtils.byteArrayToInt(byteArray, 0, byteArray.length);
    }

    public static int byteArrayToInt(byte[] byteArray, int startPos, int length) {
        if (byteArray == null) {
            throw new IllegalArgumentException("Parameter 'byteArray' cannot be null");
        }
        if (length > 0 && length <= 4) {
            if (startPos >= 0 && byteArray.length >= startPos + length) {
                int value = 0;
                int i = 0;
                while (i < length) {
                    value += (byteArray[startPos + i] & 0xFF) << 8 * (length - i - 1);
                    ++i;
                }
                return value;
            }
            throw new IllegalArgumentException("Length or startPos not valid");
        }
        throw new IllegalArgumentException("Length must be between 1 and 4. Length = " + length);
    }

    public static String bytesToString(byte[] pBytes) {
        return BytesUtils.formatByte(pBytes, FORMAT_SPACE, false);
    }

    public static String bytesToString(byte[] pBytes, boolean pTruncate) {
        return BytesUtils.formatByte(pBytes, FORMAT_SPACE, pTruncate);
    }

    public static String bytesToStringNoSpace(byte pByte) {
        return BytesUtils.formatByte(new byte[]{pByte}, FORMAT_NOSPACE, false);
    }

    public static String bytesToStringNoSpace(byte[] pBytes) {
        return BytesUtils.formatByte(pBytes, FORMAT_NOSPACE, false);
    }

    public static String bytesToStringNoSpace(byte[] pBytes, boolean pTruncate) {
        return BytesUtils.formatByte(pBytes, FORMAT_NOSPACE, pTruncate);
    }

    private static String formatByte(byte[] pByte, String pFormat, boolean pTruncate) {
        StringBuffer sb = new StringBuffer();
        if (pByte == null) {
            sb.append("");
        } else {
            boolean t = false;
            byte[] arr$ = pByte;
            int len$ = pByte.length;
            int i$ = 0;
            while (i$ < len$) {
                byte b = arr$[i$];
                if (b != 0 || !pTruncate || t) {
                    t = true;
                    sb.append(String.format(pFormat, b & 0xFF));
                }
                ++i$;
            }
        }
        return sb.toString().toUpperCase(Locale.getDefault()).trim();
    }

    public static byte[] fromString(String pData) {
        if (pData == null) {
            throw new IllegalArgumentException("Argument can't be null");
        }
        String text = pData.replace(" ", "");
        if (text.length() % 2 != 0) {
            throw new IllegalArgumentException("Hex binary needs to be even-length :" + pData);
        }
        byte[] commandByte = new byte[Math.round((float)text.length() / 2.0f)];
        int j = 0;
        int i = 0;
        while (i < text.length()) {
            Integer val = Integer.parseInt(text.substring(i, i + 2), 16);
            commandByte[j++] = val.byteValue();
            i += 2;
        }
        return commandByte;
    }

    public static boolean matchBitByBitIndex(int pVal, int pBitIndex) {
        if (pBitIndex >= 0 && pBitIndex <= 31) {
            return (pVal & 1 << pBitIndex) != 0;
        }
        throw new IllegalArgumentException("parameter 'pBitIndex' must be between 0 and 31. pBitIndex=" + pBitIndex);
    }

    public static byte setBit(byte pData, int pBitIndex, boolean pOn) {
        if (pBitIndex >= 0 && pBitIndex <= 7) {
            byte ret = pOn ? (byte)(pData | 1 << pBitIndex) : (byte)(pData & ~(1 << pBitIndex));
            return ret;
        }
        throw new IllegalArgumentException("parameter 'pBitIndex' must be between 0 and 7. pBitIndex=" + pBitIndex);
    }

    public static String toBinary(byte[] pBytes) {
        String ret = null;
        if (pBytes != null && pBytes.length > 0) {
            BigInteger val = new BigInteger(BytesUtils.bytesToStringNoSpace(pBytes), 16);
            StringBuilder build = new StringBuilder(val.toString(2));
            int i = build.length();
            while (i < pBytes.length * 8) {
                build.insert(0, 0);
                ++i;
            }
            ret = build.toString();
        }
        return ret;
    }

    public static byte[] toByteArray(int value) {
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    private BytesUtils() {
    }
}

