/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.util;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class CopyFileServeur
extends Thread {
    private File file;
    private String finalName;
    private URL uploadURL;
    private long totalFilesLength;
    private long uploadedLength;
    private boolean success = false;
    private boolean done = false;

    public CopyFileServeur(File file, String finalName, URL uploadURL) {
        this.file = file;
        this.finalName = finalName == null && file != null ? file.getName() : finalName;
        this.uploadURL = uploadURL;
        this.totalFilesLength = 0L;
        if (file != null) {
            this.totalFilesLength += this.file.length();
        }
    }

    private StringBuffer getRandomString() {
        StringBuffer sbRan = new StringBuffer(11);
        StringBuffer alphaNum = new StringBuffer();
        alphaNum.append("1234567890abcdefghijklmnopqrstuvwxyz");
        int i = 0;
        while (i < 11) {
            int num = (int)(Math.random() * (double)(alphaNum.length() - 1));
            sbRan.append(alphaNum.charAt(num));
            ++i;
        }
        return sbRan;
    }

    public int processed() {
        return (int)(this.uploadedLength / this.totalFilesLength * 100L);
    }

    private void uploadFileStream(File f, DataOutputStream dOut) throws FileNotFoundException, IOException {
        byte[] byteBuff = null;
        FileInputStream fis = null;
        try {
            int numBytes = 0;
            byteBuff = new byte[1024];
            fis = new FileInputStream(f);
            while (-1 != (numBytes = fis.read(byteBuff))) {
                dOut.write(byteBuff, 0, numBytes);
                this.uploadedLength += (long)numBytes;
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception e) {
                TimsLogger.warn(e.getMessage());
                e.printStackTrace();
            }
            byteBuff = null;
        }
    }

    private String getHead() throws UnsupportedEncodingException {
        TimsLogger.debug("#Cfs.getHeader" + Fonctions.hexify(this.finalName.getBytes()) + " => " + this.finalName);
        return "Content-Type: application/octet-stream; charset=utf-8\"\r\nContent-Disposition: form-data; name=\"File\"; filename=\"" + URLEncoder.encode(this.finalName, "UTF-8") + "\r\n\r\n";
    }

    @Override
    public void run() {
        long start = Transport.ps.startAbsoluteTime();
        ++MainFrameTransport.copying;
        try {
            String line;
            StringBuffer random = this.getRandomString();
            URLConnection c = this.uploadURL.openConnection();
            c.setReadTimeout(0);
            if (this.file != null) {
                TimsLogger.debug("Cfs# add file" + this.file.getAbsolutePath());
                c.setDoOutput(true);
                c.setDoInput(true);
                c.setUseCaches(false);
                c.setRequestProperty("Connection", "Keep-Alive");
                c.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + random);
                DataOutputStream toServer = new DataOutputStream(c.getOutputStream());
                toServer.writeBytes("--" + random + "\r\n");
                toServer.writeBytes(this.getHead());
                this.uploadFileStream(this.file, toServer);
                toServer.writeBytes("\r\n--" + random + "--\r\n\r\n");
                toServer.flush();
                toServer.close();
                TimsLogger.debug("Cfs# end transfer " + this.file.getAbsolutePath());
            }
            BufferedReader fromServer = new BufferedReader(new InputStreamReader(c.getInputStream()));
            String lastLine = "";
            while ((line = fromServer.readLine()) != null) {
                lastLine = line;
                TimsLogger.debug(String.valueOf(line) + "\n");
            }
            this.done = true;
            if (lastLine.startsWith("ok")) {
                boolean delete;
                this.success = true;
                TimsLogger.debug("#Cfs.run()# Le script PHP \u00e0 l'adresse " + this.uploadURL + " s'est execut\u00e9 avec succ\u00e8s");
                boolean bl = delete = System.getProperty("URL") != null;
                if (System.getProperty("file.deleteAfterTransfer") != null) {
                    delete = System.getProperty("file.deleteAfterTransfer").equals("1");
                }
                if (this.file != null && delete) {
                    if (Transport.debug > 1) {
                        TimsLogger.debug("#Cfs.run()# On doit supprimer le fichier " + this.file.getAbsolutePath() + " mais version debug>1, on le laisse");
                    } else {
                        TimsLogger.debug("#Cfs.run()# delete " + this.file.getAbsolutePath());
                        if (!this.file.delete()) {
                            TimsLogger.warn("#Cfs.run()# delete returns false " + this.file.getAbsolutePath());
                        }
                    }
                }
            } else {
                TimsLogger.warn("#Cfs.run()# Le script PHP \u00e0 l'adresse " + this.uploadURL + " a \u00e9chou\u00e9");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("transfer.serverUnreachable"), LanguageTranslator.getString("message.numberedError", "311"), 0);
                    }
                });
            }
        }
        catch (Exception e) {
            TimsLogger.error("#Cfs# exception in run " + e.getMessage());
            e.printStackTrace();
            this.done = true;
        }
        Transport.ps.endAbsoluteTime(PerformanceScanner.PROCESS, "download done", start);
        --MainFrameTransport.copying;
        TimsLogger.verbose("CPS.run()", "Fin du transfert.");
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isSuccess() {
        return this.success;
    }
}

