/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.util;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.HeadlessException;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import transpo.system.TimsLogger;

public class Eplorer
extends JFrame {
    protected DefaultMutableTreeNode racine;
    protected JTree tree = new JTree();
    protected JScrollPane scrollpane;
    static final int MAX_LEVEL = 1;

    public Eplorer() throws HeadlessException {
        this.racine = new DefaultMutableTreeNode("Poste de travail");
        File[] drive = File.listRoots();
        int i = 0;
        while (i < drive.length) {
            FSNode node = new FSNode(drive[i]);
            node.setFile(drive[i]);
            this.addNode(drive[i], node);
            this.racine.add(node);
            ++i;
        }
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
                TreePath path = e.getPath();
                FSNode node = (FSNode)path.getLastPathComponent();
                Eplorer.this.deploy(node);
                ((DefaultTreeModel)Eplorer.this.tree.getModel()).reload(node);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
            }
        });
        this.tree.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TreePath selPath = Eplorer.this.tree.getPathForLocation(e.getX(), e.getY());
                if (selPath != null) {
                    TimsLogger.verbose(selPath.toString());
                }
            }
        });
        DefaultTreeModel model = new DefaultTreeModel(this.racine);
        this.tree.setModel(model);
        this.scrollpane = new JScrollPane();
        this.getContentPane().add((Component)this.scrollpane, "Center");
        this.scrollpane.getViewport().add((Component)this.tree, null);
        this.setDefaultCloseOperation(3);
    }

    public static void main(String[] arg) {
        Eplorer Arbre = new Eplorer();
        Arbre.setTitle("Arborescence");
        Arbre.setSize(300, 400);
        Arbre.setVisible(true);
    }

    public void addNode(File driveOrDir, DefaultMutableTreeNode node) {
        this.setCursor(new Cursor(3));
        this.addNode(driveOrDir, node, 0);
        this.setCursor(new Cursor(0));
    }

    private void addNode(File driveOrDir, DefaultMutableTreeNode node, int level) {
        File[] fileList = driveOrDir.listFiles();
        if (fileList != null) {
            this.sortFiles(fileList);
        }
        if (level > 0) {
            TimsLogger.debug("Stop at " + ((FSNode)node).getFile().getAbsolutePath());
            return;
        }
        TimsLogger.debug("Look into " + ((FSNode)node).getFile().getAbsolutePath());
        try {
            int i = 0;
            while (i < fileList.length) {
                TimsLogger.debug("add " + fileList[i].getAbsolutePath());
                if (fileList[i].isDirectory()) {
                    FSNode dir = new FSNode(fileList[i].getAbsolutePath());
                    dir.setFile(fileList[i]);
                    node.add(dir);
                    this.addNode(fileList[i], dir, ++level);
                }
                ++i;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void deploy(FSNode node) {
        int i = 0;
        while (i < node.getChildCount()) {
            FSNode toDeploy = (FSNode)node.getChildAt(i);
            TimsLogger.debug(((FSNode)node.getChildAt(i)).getFile().getAbsolutePath());
            this.addNode(toDeploy.getFile(), toDeploy);
            ++i;
        }
    }

    public void sortFiles(File[] listFile) {
        this.triRapide(listFile, 0, listFile.length - 1);
    }

    private int partition(File[] listFile, int deb, int fin) {
        File pivot = listFile[deb];
        int i = deb - 1;
        int j = fin + 1;
        while (true) {
            if (listFile[--j].getName().compareToIgnoreCase(pivot.getName()) > 0) {
                continue;
            }
            while (listFile[++i].getName().compareToIgnoreCase(pivot.getName()) < 0) {
            }
            if (i >= j) break;
            this.echanger(listFile, i, j);
        }
        return j;
    }

    private void triRapide(File[] listFile, int deb, int fin) {
        if (deb < fin) {
            int positionPivot = this.partition(listFile, deb, fin);
            this.triRapide(listFile, deb, positionPivot);
            this.triRapide(listFile, positionPivot + 1, fin);
        }
    }

    private void echanger(File[] listFile, int posa, int posb) {
        File tmpFile = listFile[posa];
        listFile[posa] = listFile[posb];
        listFile[posb] = tmpFile;
    }

    private class FSNode
    extends DefaultMutableTreeNode {
        File file;

        private FSNode() {
        }

        FSNode(Object userObject) {
            super(userObject);
        }

        public void setFile(File newFile) {
            this.file = newFile;
        }

        public File getFile() {
            return this.file;
        }
    }
}

